/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.generation.ui;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.dsml.validation.generation.ui.Activator;
import org.eclipse.papyrus.dsml.validation.generation.ui.Messages;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.ConstraintManagerImpl;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintsManager;
import org.eclipse.papyrus.dsml.validation.model.profilenames.Utils;
import org.eclipse.papyrus.dsml.validation.wizard.CreateEMFValidationProject;
import org.eclipse.papyrus.dsml.validation.wizard.JavaContentGenerator;
import org.eclipse.papyrus.dsml.validation.wizard.ValidationPluginGenerator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.uml2.uml.Profile;

public class CreateJavaValidationPluginHandler
extends AbstractHandler {
    private IConstraintsManager constraintsManager;

    protected EObject getSelectedElement() {
        EObject eObject = null;
        Object selection = null;
        selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selection = structuredSelection.getFirstElement();
        }
        if (selection != null) {
            eObject = EMFHelper.getEObject((Object)selection);
        }
        return eObject;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selection = this.getSelectedElement();
        if (selection instanceof Profile) {
            MessageDialog dialog;
            Profile profileSelection = (Profile)selection;
            this.constraintsManager = new ConstraintManagerImpl(profileSelection);
            EPackage definition = null;
            IProject hostingProject = null;
            URI uri = profileSelection.eResource().getURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (uri.segmentCount() >= 2) {
                hostingProject = root.getProject(uri.segment(1));
            }
            IProject targetProject = null;
            Shell shell = Display.getDefault().getActiveShell();
            boolean isPlugin = false;
            try {
                boolean bl = isPlugin = hostingProject.getNature("org.eclipse.pde.PluginNature") != null;
                if (!isPlugin) {
                    MessageDialog.openWarning((Shell)shell, (String)Messages.CreateJavaValidationPluginHandler_ProfileIsNotAPlugin, (String)String.format(Messages.CreateJavaValidationPluginHandler_ProfileIsNotAPluginExplication, hostingProject.getName()));
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            int question = 0;
            if (hostingProject != null && hostingProject.exists() && isPlugin) {
                dialog = new MessageDialog(shell, Messages.CreateJavaValidationPluginHandler_ChoosePluginGeneration, null, Messages.CreateJavaValidationPluginHandler_HowtoGeneratePlugin, 3, new String[]{Messages.CreateJavaValidationPluginHandler_CreateNewPlugin, Messages.CreateJavaValidationPluginHandler_SelectExisting, Messages.CreateJavaValidationPluginHandler_HostCurrent}, 2);
                question = dialog.open();
            } else if (root.getProjects().length > 0) {
                dialog = new MessageDialog(shell, Messages.CreateJavaValidationPluginHandler_ChoosePluginGeneration, null, Messages.CreateJavaValidationPluginHandler_HowtoGeneratePlugin, 3, new String[]{Messages.CreateJavaValidationPluginHandler_CreateNewPlugin, Messages.CreateJavaValidationPluginHandler_SelectExisting}, 1);
                question = dialog.open();
            }
            boolean verboseDependency = true;
            if (question == 1 || question == 2) {
                if (question == 1) {
                    ResourceListSelectionDialog dialog2 = new ResourceListSelectionDialog(shell, (IContainer)root, 4);
                    dialog2.setTitle(Messages.CreateJavaValidationPluginHandler_SelectExisting);
                    if (dialog2.open() == 0) {
                        targetProject = (IProject)dialog2.getResult()[0];
                    }
                } else {
                    targetProject = hostingProject;
                }
            } else if (question == 0) {
                CreateEMFValidationProject wizard = new CreateEMFValidationProject(profileSelection, this.constraintsManager, definition);
                if (wizard.openDialog() == 0) {
                    targetProject = wizard.getProject();
                }
                verboseDependency = false;
            }
            if (targetProject != null) {
                JavaContentGenerator generateAllJava = new JavaContentGenerator(targetProject, profileSelection);
                try {
                    generateAllJava.run();
                    ValidationPluginGenerator.instance.generate(targetProject, this.constraintsManager, definition);
                    this.addDependencyToProject(shell, hostingProject, "org.eclipse.papyrus.dsml.validation", true);
                    if (Utils.isStaticProfile()) {
                        this.addDependencyToProject(shell, targetProject, hostingProject.getName(), verboseDependency);
                    }
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    MessageDialog.openInformation((Shell)shell, (String)Messages.CreateJavaValidationPluginHandler_ExceptionDuringPluginGeneration, (String)Messages.CreateJavaValidationPluginHandler_CheckErrorLog);
                }
            }
        }
        return null;
    }

    public void addDependencyToProject(Shell shell, IProject dependingProject, String dependsOnPlugin, boolean verbose) throws CoreException, IOException {
        if (ValidationPluginGenerator.instance.addDependency(dependingProject, dependsOnPlugin) && verbose) {
            String message = Messages.CreateJavaValidationPluginHandler_DependencyAddedMsg;
            if (dependsOnPlugin.equals("org.eclipse.papyrus.dsml.validation")) {
                message = String.valueOf(message) + " " + Messages.CreateJavaValidationPluginHandler_DSMLDependencyAddedMsg;
            }
            MessageDialog.openInformation((Shell)shell, (String)Messages.CreateJavaValidationPluginHandler_DependencyAdded, (String)String.format(message, dependsOnPlugin, dependingProject.getName()));
        }
    }

    public boolean isEnabled() {
        EObject eObject = this.getSelectedElement();
        return eObject instanceof Profile;
    }
}

