/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.LayerOperatorImpl;

public abstract class AbstractLayerOperatorImpl
extends LayerOperatorImpl
implements AbstractLayerOperator {
    protected LayerOperatorDescriptor layerOperatorDescriptor;
    protected static final String LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT = null;
    protected String layerOperatorDescriptorName = LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT;

    protected AbstractLayerOperatorImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return LayersPackage.Literals.ABSTRACT_LAYER_OPERATOR;
    }

    @Override
    public LayerOperatorDescriptor getLayerOperatorDescriptor() {
        if (this.layerOperatorDescriptor != null && this.layerOperatorDescriptor.eIsProxy()) {
            InternalEObject oldLayerOperatorDescriptor = (InternalEObject)this.layerOperatorDescriptor;
            this.layerOperatorDescriptor = (LayerOperatorDescriptor)this.eResolveProxy(oldLayerOperatorDescriptor);
            if (this.layerOperatorDescriptor != oldLayerOperatorDescriptor && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldLayerOperatorDescriptor, (Object)this.layerOperatorDescriptor));
            }
        }
        return this.layerOperatorDescriptor;
    }

    public LayerOperatorDescriptor basicGetLayerOperatorDescriptor() {
        return this.layerOperatorDescriptor;
    }

    @Override
    public void setLayerOperatorDescriptor(LayerOperatorDescriptor newLayerOperatorDescriptor) {
        LayerOperatorDescriptor oldLayerOperatorDescriptor = this.layerOperatorDescriptor;
        this.layerOperatorDescriptor = newLayerOperatorDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldLayerOperatorDescriptor, (Object)this.layerOperatorDescriptor));
        }
    }

    @Override
    public String getLayerOperatorDescriptorName() {
        return this.layerOperatorDescriptorName;
    }

    @Override
    public void setLayerOperatorDescriptorName(String newLayerOperatorDescriptorName) {
        if (newLayerOperatorDescriptorName.equals(this.layerOperatorDescriptorName)) {
            return;
        }
        String oldLayerOperatorDescriptorName = this.layerOperatorDescriptorName;
        this.layerOperatorDescriptorName = newLayerOperatorDescriptorName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLayerOperatorDescriptorName, (Object)this.layerOperatorDescriptorName));
        }
    }

    @Override
    public boolean isDescriptorSet() {
        return this.getLayerOperatorDescriptor() != null;
    }

    @Override
    public void resetDescriptor() {
        if (this.getApplication() == null) {
            return;
        }
        if (this.getLayerOperatorDescriptorName() == null) {
            return;
        }
        try {
            LayerOperatorDescriptor descriptor = this.application.getLayerOperatorDescriptorRegistry().getLayerOperatorDescriptor(this.getLayerOperatorDescriptorName());
            this.setLayerOperatorDescriptor(descriptor);
        }
        catch (NotFoundException e) {
            Activator.log.error("LOG - " + this.getClass().getName() + " - " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isLayerEnabledInternal() {
        return this.isLayerEnabled() && this.isDescriptorSet();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (resolve) {
                    return this.getLayerOperatorDescriptor();
                }
                return this.basicGetLayerOperatorDescriptor();
            }
            case 10: {
                return this.getLayerOperatorDescriptorName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setLayerOperatorDescriptor((LayerOperatorDescriptor)newValue);
                return;
            }
            case 10: {
                this.setLayerOperatorDescriptorName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setLayerOperatorDescriptor(null);
                return;
            }
            case 10: {
                this.setLayerOperatorDescriptorName(LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.layerOperatorDescriptor != null;
            }
            case 10: {
                return LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT == null ? this.layerOperatorDescriptorName != null : !LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT.equals(this.layerOperatorDescriptorName);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 10: {
                return this.isDescriptorSet();
            }
            case 11: {
                this.resetDescriptor();
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (layerOperatorDescriptorName: ");
        result.append(this.layerOperatorDescriptorName);
        result.append(')');
        return result.toString();
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(View view, Property property) throws LayersException {
        ComputePropertyValueCommand res;
        if (!this.isLayerEnabled()) {
            return null;
        }
        BasicEList collectedCmds = new BasicEList(this.getLayers().size());
        for (LayerExpression layer : this.getLayers()) {
            ComputePropertyValueCommand cmd = layer.getComputePropertyValueCommand(view, property);
            if (cmd == null) continue;
            collectedCmds.add((Object)cmd);
        }
        if (collectedCmds.size() == 0) {
            return null;
        }
        try {
            res = this.getLayerOperatorDescriptor().getPropertyOperator(property).getComputePropertyValueCommand((EList<ComputePropertyValueCommand>)collectedCmds);
        }
        catch (UnsupportedOperationException e) {
            Activator.log.error(String.valueOf(this.getClass().getSimpleName()) + "WARNING - Operator not implemened for LayerOperator '" + this.getClass().getSimpleName() + "' and property '" + property.getName() + "'.", (Throwable)e);
            return null;
        }
        return res;
    }

    @Override
    public EList<ComputePropertyValueCommand> getPropertiesComputePropertyValueCommand(View view, List<Property> properties) throws LayersException {
        if (!this.isLayerEnabled()) {
            return null;
        }
        BasicEList resCmds = new BasicEList(properties.size());
        boolean isCmdFound = false;
        for (Property property : properties) {
            if (property == null) {
                resCmds.add(null);
                continue;
            }
            ComputePropertyValueCommand cmd = this.getComputePropertyValueCommand(view, property);
            if (cmd != null) {
                isCmdFound = true;
            }
            resCmds.add((Object)cmd);
        }
        if (isCmdFound) {
            return resCmds;
        }
        return null;
    }

    @Override
    public EList<ComputePropertyValueCommand> getViewsComputePropertyValueCommand(List<View> views, Property property) throws LayersException {
        if (!this.isLayerEnabled()) {
            return null;
        }
        BasicEList resCmds = new BasicEList(views.size());
        boolean isCmdFound = false;
        for (View view : views) {
            if (view == null) {
                resCmds.add(null);
                continue;
            }
            ComputePropertyValueCommand cmd = this.getComputePropertyValueCommand(view, property);
            if (cmd != null) {
                isCmdFound = true;
            }
            resCmds.add((Object)cmd);
        }
        if (isCmdFound) {
            return resCmds;
        }
        return null;
    }
}

