/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.custom;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.PropertyOperatorImpl;
import org.osgi.framework.Bundle;

public class CustomPropertyOperatorImpl
extends PropertyOperatorImpl {
    @Override
    public void setClassname(String newClassname) {
        String oldClassname = this.classname;
        this.classname = newClassname;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldClassname, (Object)this.classname));
        }
        this.setOperatorInstance(null);
    }

    @Override
    public PropertyOperator getOperatorInstance() {
        if (this.operatorInstance == null) {
            try {
                this.resetOperatorInstance();
            }
            catch (LayersException e) {
                Activator.log.error("LOG-" + this.getClass().getName() + "- Can't set custom operator instance '" + e.getMessage() + "'.", (Throwable)e);
            }
        }
        return this.operatorInstance;
    }

    @Override
    public void resetOperatorInstance() throws LayersException {
        if (this.getClassname() == null) {
            return;
        }
        Class<?> opClass = this.loadClass();
        try {
            this.setOperatorInstance((PropertyOperator)opClass.newInstance());
        }
        catch (Exception e) {
            throw new LayersException("Can't create instance for CustomOperator " + this.getName(), e);
        }
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(List<ComputePropertyValueCommand> property) throws LayersException {
        return this.getOperatorInstance().getComputePropertyValueCommand(property);
    }

    private Class<?> loadClass() throws LayersException {
        Class classDesc;
        String classname = this.getClassname();
        try {
            classDesc = Class.forName(classname);
        }
        catch (ClassNotFoundException e1) {
            try {
                String bundleID = this.getClassBundleID();
                Bundle bundle = Platform.getBundle((String)bundleID);
                classDesc = bundle.loadClass(classname);
            }
            catch (ClassNotFoundException e2) {
                throw new LayersException("Can't find class for the name '" + classname + "'.", e2);
            }
            catch (NullPointerException e) {
                throw new LayersException("Can't find bundle '" + this.getClassBundleID() + "' for class for the name '" + classname + "'.", e);
            }
        }
        return classDesc;
    }
}

