/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryPackage;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rpy Shape</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl#getTransform <em>Transform</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl#getRectangle <em>Rectangle</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl#getRpyMetamodelObject <em>Rpy Metamodel Object</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl#getParentRelativePosition <em>Parent Relative Position</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl#getHeight <em>Height</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl#getWidth <em>Width</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.impl.RpyShapeImpl#getAbsolutePosition <em>Absolute Position</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RpyShapeImpl extends MinimalEObjectImpl.Container implements RpyShape {
	/**
	 * The cached value of the '{@link #getTransform() <em>Transform</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransform()
	 * @generated
	 * @ordered
	 */
	protected TransformMatrix transform;

	/**
	 * The cached value of the '{@link #getRectangle() <em>Rectangle</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRectangle()
	 * @generated
	 * @ordered
	 */
	protected Rectangle rectangle;

	/**
	 * The cached value of the '{@link #getParent() <em>Parent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParent()
	 * @generated
	 * @ordered
	 */
	protected RpyShape parent;

	/**
	 * The cached value of the '{@link #getRpyMetamodelObject() <em>Rpy Metamodel Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRpyMetamodelObject()
	 * @generated
	 * @ordered
	 */
	protected EObject rpyMetamodelObject;

	/**
	 * The cached value of the '{@link #getParentRelativePosition() <em>Parent Relative Position</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParentRelativePosition()
	 * @generated
	 * @ordered
	 */
	protected Point parentRelativePosition;

	/**
	 * The default value of the '{@link #getHeight() <em>Height</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeight()
	 * @generated
	 * @ordered
	 */
	protected static final Integer HEIGHT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHeight() <em>Height</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeight()
	 * @generated
	 * @ordered
	 */
	protected Integer height = HEIGHT_EDEFAULT;

	/**
	 * The default value of the '{@link #getWidth() <em>Width</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWidth()
	 * @generated
	 * @ordered
	 */
	protected static final Integer WIDTH_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getWidth() <em>Width</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWidth()
	 * @generated
	 * @ordered
	 */
	protected Integer width = WIDTH_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAbsolutePosition() <em>Absolute Position</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbsolutePosition()
	 * @generated
	 * @ordered
	 */
	protected Point absolutePosition;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RpyShapeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RpyGeometryPackage.Literals.RPY_SHAPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransformMatrix getTransform() {
		return transform;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTransform(TransformMatrix newTransform, NotificationChain msgs) {
		TransformMatrix oldTransform = transform;
		transform = newTransform;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__TRANSFORM, oldTransform, newTransform);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTransform(TransformMatrix newTransform) {
		if (newTransform != transform) {
			NotificationChain msgs = null;
			if (transform != null)
				msgs = ((InternalEObject)transform).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RpyGeometryPackage.RPY_SHAPE__TRANSFORM, null, msgs);
			if (newTransform != null)
				msgs = ((InternalEObject)newTransform).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RpyGeometryPackage.RPY_SHAPE__TRANSFORM, null, msgs);
			msgs = basicSetTransform(newTransform, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__TRANSFORM, newTransform, newTransform));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Rectangle getRectangle() {
		return rectangle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRectangle(Rectangle newRectangle, NotificationChain msgs) {
		Rectangle oldRectangle = rectangle;
		rectangle = newRectangle;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__RECTANGLE, oldRectangle, newRectangle);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRectangle(Rectangle newRectangle) {
		if (newRectangle != rectangle) {
			NotificationChain msgs = null;
			if (rectangle != null)
				msgs = ((InternalEObject)rectangle).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RpyGeometryPackage.RPY_SHAPE__RECTANGLE, null, msgs);
			if (newRectangle != null)
				msgs = ((InternalEObject)newRectangle).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RpyGeometryPackage.RPY_SHAPE__RECTANGLE, null, msgs);
			msgs = basicSetRectangle(newRectangle, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__RECTANGLE, newRectangle, newRectangle));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RpyShape getParent() {
		if (parent != null && parent.eIsProxy()) {
			InternalEObject oldParent = (InternalEObject)parent;
			parent = (RpyShape)eResolveProxy(oldParent);
			if (parent != oldParent) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RpyGeometryPackage.RPY_SHAPE__PARENT, oldParent, parent));
			}
		}
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RpyShape basicGetParent() {
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(RpyShape newParent) {
		RpyShape oldParent = parent;
		parent = newParent;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__PARENT, oldParent, parent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject getRpyMetamodelObject() {
		if (rpyMetamodelObject != null && rpyMetamodelObject.eIsProxy()) {
			InternalEObject oldRpyMetamodelObject = (InternalEObject)rpyMetamodelObject;
			rpyMetamodelObject = eResolveProxy(oldRpyMetamodelObject);
			if (rpyMetamodelObject != oldRpyMetamodelObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RpyGeometryPackage.RPY_SHAPE__RPY_METAMODEL_OBJECT, oldRpyMetamodelObject, rpyMetamodelObject));
			}
		}
		return rpyMetamodelObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject basicGetRpyMetamodelObject() {
		return rpyMetamodelObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRpyMetamodelObject(EObject newRpyMetamodelObject) {
		EObject oldRpyMetamodelObject = rpyMetamodelObject;
		rpyMetamodelObject = newRpyMetamodelObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__RPY_METAMODEL_OBJECT, oldRpyMetamodelObject, rpyMetamodelObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Point getParentRelativePosition() {
		return parentRelativePosition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParentRelativePosition(Point newParentRelativePosition, NotificationChain msgs) {
		Point oldParentRelativePosition = parentRelativePosition;
		parentRelativePosition = newParentRelativePosition;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__PARENT_RELATIVE_POSITION, oldParentRelativePosition, newParentRelativePosition);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentRelativePosition(Point newParentRelativePosition) {
		if (newParentRelativePosition != parentRelativePosition) {
			NotificationChain msgs = null;
			if (parentRelativePosition != null)
				msgs = ((InternalEObject)parentRelativePosition).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RpyGeometryPackage.RPY_SHAPE__PARENT_RELATIVE_POSITION, null, msgs);
			if (newParentRelativePosition != null)
				msgs = ((InternalEObject)newParentRelativePosition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RpyGeometryPackage.RPY_SHAPE__PARENT_RELATIVE_POSITION, null, msgs);
			msgs = basicSetParentRelativePosition(newParentRelativePosition, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__PARENT_RELATIVE_POSITION, newParentRelativePosition, newParentRelativePosition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Integer getHeight() {
		return height;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHeight(Integer newHeight) {
		Integer oldHeight = height;
		height = newHeight;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__HEIGHT, oldHeight, height));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Integer getWidth() {
		return width;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWidth(Integer newWidth) {
		Integer oldWidth = width;
		width = newWidth;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__WIDTH, oldWidth, width));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Point getAbsolutePosition() {
		return absolutePosition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAbsolutePosition(Point newAbsolutePosition, NotificationChain msgs) {
		Point oldAbsolutePosition = absolutePosition;
		absolutePosition = newAbsolutePosition;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__ABSOLUTE_POSITION, oldAbsolutePosition, newAbsolutePosition);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAbsolutePosition(Point newAbsolutePosition) {
		if (newAbsolutePosition != absolutePosition) {
			NotificationChain msgs = null;
			if (absolutePosition != null)
				msgs = ((InternalEObject)absolutePosition).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RpyGeometryPackage.RPY_SHAPE__ABSOLUTE_POSITION, null, msgs);
			if (newAbsolutePosition != null)
				msgs = ((InternalEObject)newAbsolutePosition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RpyGeometryPackage.RPY_SHAPE__ABSOLUTE_POSITION, null, msgs);
			msgs = basicSetAbsolutePosition(newAbsolutePosition, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RpyGeometryPackage.RPY_SHAPE__ABSOLUTE_POSITION, newAbsolutePosition, newAbsolutePosition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RpyGeometryPackage.RPY_SHAPE__TRANSFORM:
				return basicSetTransform(null, msgs);
			case RpyGeometryPackage.RPY_SHAPE__RECTANGLE:
				return basicSetRectangle(null, msgs);
			case RpyGeometryPackage.RPY_SHAPE__PARENT_RELATIVE_POSITION:
				return basicSetParentRelativePosition(null, msgs);
			case RpyGeometryPackage.RPY_SHAPE__ABSOLUTE_POSITION:
				return basicSetAbsolutePosition(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RpyGeometryPackage.RPY_SHAPE__TRANSFORM:
				return getTransform();
			case RpyGeometryPackage.RPY_SHAPE__RECTANGLE:
				return getRectangle();
			case RpyGeometryPackage.RPY_SHAPE__PARENT:
				if (resolve) return getParent();
				return basicGetParent();
			case RpyGeometryPackage.RPY_SHAPE__RPY_METAMODEL_OBJECT:
				if (resolve) return getRpyMetamodelObject();
				return basicGetRpyMetamodelObject();
			case RpyGeometryPackage.RPY_SHAPE__PARENT_RELATIVE_POSITION:
				return getParentRelativePosition();
			case RpyGeometryPackage.RPY_SHAPE__HEIGHT:
				return getHeight();
			case RpyGeometryPackage.RPY_SHAPE__WIDTH:
				return getWidth();
			case RpyGeometryPackage.RPY_SHAPE__ABSOLUTE_POSITION:
				return getAbsolutePosition();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RpyGeometryPackage.RPY_SHAPE__TRANSFORM:
				setTransform((TransformMatrix)newValue);
				return;
			case RpyGeometryPackage.RPY_SHAPE__RECTANGLE:
				setRectangle((Rectangle)newValue);
				return;
			case RpyGeometryPackage.RPY_SHAPE__PARENT:
				setParent((RpyShape)newValue);
				return;
			case RpyGeometryPackage.RPY_SHAPE__RPY_METAMODEL_OBJECT:
				setRpyMetamodelObject((EObject)newValue);
				return;
			case RpyGeometryPackage.RPY_SHAPE__PARENT_RELATIVE_POSITION:
				setParentRelativePosition((Point)newValue);
				return;
			case RpyGeometryPackage.RPY_SHAPE__HEIGHT:
				setHeight((Integer)newValue);
				return;
			case RpyGeometryPackage.RPY_SHAPE__WIDTH:
				setWidth((Integer)newValue);
				return;
			case RpyGeometryPackage.RPY_SHAPE__ABSOLUTE_POSITION:
				setAbsolutePosition((Point)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RpyGeometryPackage.RPY_SHAPE__TRANSFORM:
				setTransform((TransformMatrix)null);
				return;
			case RpyGeometryPackage.RPY_SHAPE__RECTANGLE:
				setRectangle((Rectangle)null);
				return;
			case RpyGeometryPackage.RPY_SHAPE__PARENT:
				setParent((RpyShape)null);
				return;
			case RpyGeometryPackage.RPY_SHAPE__RPY_METAMODEL_OBJECT:
				setRpyMetamodelObject((EObject)null);
				return;
			case RpyGeometryPackage.RPY_SHAPE__PARENT_RELATIVE_POSITION:
				setParentRelativePosition((Point)null);
				return;
			case RpyGeometryPackage.RPY_SHAPE__HEIGHT:
				setHeight(HEIGHT_EDEFAULT);
				return;
			case RpyGeometryPackage.RPY_SHAPE__WIDTH:
				setWidth(WIDTH_EDEFAULT);
				return;
			case RpyGeometryPackage.RPY_SHAPE__ABSOLUTE_POSITION:
				setAbsolutePosition((Point)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RpyGeometryPackage.RPY_SHAPE__TRANSFORM:
				return transform != null;
			case RpyGeometryPackage.RPY_SHAPE__RECTANGLE:
				return rectangle != null;
			case RpyGeometryPackage.RPY_SHAPE__PARENT:
				return parent != null;
			case RpyGeometryPackage.RPY_SHAPE__RPY_METAMODEL_OBJECT:
				return rpyMetamodelObject != null;
			case RpyGeometryPackage.RPY_SHAPE__PARENT_RELATIVE_POSITION:
				return parentRelativePosition != null;
			case RpyGeometryPackage.RPY_SHAPE__HEIGHT:
				return HEIGHT_EDEFAULT == null ? height != null : !HEIGHT_EDEFAULT.equals(height);
			case RpyGeometryPackage.RPY_SHAPE__WIDTH:
				return WIDTH_EDEFAULT == null ? width != null : !WIDTH_EDEFAULT.equals(width);
			case RpyGeometryPackage.RPY_SHAPE__ABSOLUTE_POSITION:
				return absolutePosition != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (height: "); //$NON-NLS-1$
		result.append(height);
		result.append(", width: "); //$NON-NLS-1$
		result.append(width);
		result.append(')');
		return result.toString();
	}

} //RpyShapeImpl
