/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyFactory
 * @model kind="package"
 * @generated
 */
public interface UMLRpyPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "rpymetamodel"; //$NON-NLS-1$

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/Papyrus/UMLRpy/1.0.0"; //$NON-NLS-1$

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "rhyuml"; //$NON-NLS-1$

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	UMLRpyPackage eINSTANCE = org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.InverseTypeImpl <em>Inverse Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.InverseTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getInverseType()
	 * @generated
	 */
	int INVERSE_TYPE = 216;

	/**
	 * The number of structural features of the '<em>Inverse Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVERSE_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Inverse Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVERSE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.AssociationsTypeImpl <em>Associations Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.AssociationsTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getAssociationsType()
	 * @generated
	 */
	int ASSOCIATIONS_TYPE = 0;

	/**
	 * The number of structural features of the '<em>Associations Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATIONS_TYPE_FEATURE_COUNT = INVERSE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Associations Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATIONS_TYPE_OPERATION_COUNT = INVERSE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.GraphicChartTypeImpl <em>Graphic Chart Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.GraphicChartTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getGraphicChartType()
	 * @generated
	 */
	int GRAPHIC_CHART_TYPE = 66;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__ID = 0;

	/**
	 * The feature id for the '<em><b>Maccess</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MACCESS = 1;

	/**
	 * The feature id for the '<em><b>Element List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__ELEMENT_LIST = 2;

	/**
	 * The feature id for the '<em><b>MnModify Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MNMODIFY_DATE = 3;

	/**
	 * The feature id for the '<em><b>Mcurrent Left Top</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MCURRENT_LEFT_TOP = 4;

	/**
	 * The feature id for the '<em><b>Mmodified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MMODIFIED = 5;

	/**
	 * The feature id for the '<em><b>MnCreate Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MNCREATE_DATE = 6;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MPPARENT = 7;

	/**
	 * The feature id for the '<em><b>Marrow Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MARROW_STYLE = 8;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MDRAW_BEHAVIOR = 9;

	/**
	 * The feature id for the '<em><b>Mcurrent Right Bottom</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MCURRENT_RIGHT_BOTTOM = 10;

	/**
	 * The feature id for the '<em><b>Mcreator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MCREATOR = 11;

	/**
	 * The feature id for the '<em><b>MbScale With Zoom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MBSCALE_WITH_ZOOM = 12;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MTYPE = 13;

	/**
	 * The feature id for the '<em><b>Graph Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__GRAPH_ELEMENTS = 14;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MNAME = 15;

	/**
	 * The feature id for the '<em><b>Mfile Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MFILE_VERSION = 16;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE__MBIS_PREFERENCES_INITIALIZED = 17;

	/**
	 * The number of structural features of the '<em>Graphic Chart Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE_FEATURE_COUNT = 18;

	/**
	 * The number of operations of the '<em>Graphic Chart Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPHIC_CHART_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CCollaborationChartImpl <em>CCollaboration Chart</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CCollaborationChartImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCCollaborationChart()
	 * @generated
	 */
	int CCOLLABORATION_CHART = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__ID = GRAPHIC_CHART_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Maccess</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MACCESS = GRAPHIC_CHART_TYPE__MACCESS;

	/**
	 * The feature id for the '<em><b>Element List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__ELEMENT_LIST = GRAPHIC_CHART_TYPE__ELEMENT_LIST;

	/**
	 * The feature id for the '<em><b>MnModify Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MNMODIFY_DATE = GRAPHIC_CHART_TYPE__MNMODIFY_DATE;

	/**
	 * The feature id for the '<em><b>Mcurrent Left Top</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MCURRENT_LEFT_TOP = GRAPHIC_CHART_TYPE__MCURRENT_LEFT_TOP;

	/**
	 * The feature id for the '<em><b>Mmodified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MMODIFIED = GRAPHIC_CHART_TYPE__MMODIFIED;

	/**
	 * The feature id for the '<em><b>MnCreate Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MNCREATE_DATE = GRAPHIC_CHART_TYPE__MNCREATE_DATE;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MPPARENT = GRAPHIC_CHART_TYPE__MPPARENT;

	/**
	 * The feature id for the '<em><b>Marrow Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MARROW_STYLE = GRAPHIC_CHART_TYPE__MARROW_STYLE;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MDRAW_BEHAVIOR = GRAPHIC_CHART_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mcurrent Right Bottom</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MCURRENT_RIGHT_BOTTOM = GRAPHIC_CHART_TYPE__MCURRENT_RIGHT_BOTTOM;

	/**
	 * The feature id for the '<em><b>Mcreator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MCREATOR = GRAPHIC_CHART_TYPE__MCREATOR;

	/**
	 * The feature id for the '<em><b>MbScale With Zoom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MBSCALE_WITH_ZOOM = GRAPHIC_CHART_TYPE__MBSCALE_WITH_ZOOM;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MTYPE = GRAPHIC_CHART_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Graph Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__GRAPH_ELEMENTS = GRAPHIC_CHART_TYPE__GRAPH_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MNAME = GRAPHIC_CHART_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>Mfile Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MFILE_VERSION = GRAPHIC_CHART_TYPE__MFILE_VERSION;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MBIS_PREFERENCES_INITIALIZED = GRAPHIC_CHART_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MPMODEL_OBJECT = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpRoot</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART__MPROOT = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>CCollaboration Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART_FEATURE_COUNT = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>CCollaboration Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CCOLLABORATION_CHART_OPERATION_COUNT = GRAPHIC_CHART_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_pRootTypeImpl <em>MpRoot Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_pRootTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getM_pRootType()
	 * @generated
	 */
	int MPROOT_TYPE = 227;

	/**
	 * The number of structural features of the '<em>MpRoot Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MPROOT_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>MpRoot Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MPROOT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.GraphElementsTypeImpl <em>Graph Elements Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.GraphElementsTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getGraphElementsType()
	 * @generated
	 */
	int GRAPH_ELEMENTS_TYPE = 65;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ELEMENTS_TYPE__ID = MPROOT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR = MPROOT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ELEMENTS_TYPE__MTYPE = MPROOT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ELEMENTS_TYPE__MNAME = MPROOT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED = MPROOT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Graph Elements Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ELEMENTS_TYPE_FEATURE_COUNT = MPROOT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Graph Elements Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ELEMENTS_TYPE_OPERATION_COUNT = MPROOT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIActionStateImpl <em>CGI Action State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIActionStateImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIActionState()
	 * @generated
	 */
	int CGI_ACTION_STATE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>NAnd Line Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__NAND_LINE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>MpInherits From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MPINHERITS_FROM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MnInheritance Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MNINHERITANCE_MASK = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MpDefault Component Relation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MPDEFAULT_COMPONENT_RELATION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MName Display Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MNAME_DISPLAY_MODE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>MAct Desc Labl Diaplay Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MACT_DESC_LABL_DIAPLAY_MODE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mmove And Line Time Stamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE__MMOVE_AND_LINE_TIME_STAMP = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The number of structural features of the '<em>CGI Action State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The number of operations of the '<em>CGI Action State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTION_STATE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIActiveXImpl <em>CGI Active X</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIActiveXImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIActiveX()
	 * @generated
	 */
	int CGI_ACTIVE_X = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mcs Model Obj Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MCS_MODEL_OBJ_PATH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mcs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MCS_NAME = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>MParts Array</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X__MPARTS_ARRAY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>CGI Active X</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of operations of the '<em>CGI Active X</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ACTIVE_X_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIAnchorImpl <em>CGI Anchor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIAnchorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIAnchor()
	 * @generated
	 */
	int CGI_ANCHOR = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Mcolor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MCOLOR = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mline Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MLINE_WIDTH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Marrow</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR__MARROW = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>CGI Anchor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The number of operations of the '<em>CGI Anchor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANCHOR_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIAnnotationImpl <em>CGI Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIAnnotationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIAnnotation()
	 * @generated
	 */
	int CGI_ANNOTATION = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>ITempdisplay Text Flag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__ITEMPDISPLAY_TEXT_FLAG = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>MbIs Box Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MBIS_BOX_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mcolor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MCOLOR = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Mline Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MLINE_WIDTH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>MbIs Structured</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MBIS_STRUCTURED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>MbFrameset Modified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION__MBFRAMESET_MODIFIED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The number of structural features of the '<em>CGI Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The number of operations of the '<em>CGI Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ANNOTATION_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIArrowImpl <em>CGI Arrow</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIArrowImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIArrow()
	 * @generated
	 */
	int CGI_ARROW = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>CGI Arrow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of operations of the '<em>CGI Arrow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ARROW_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIAssociationEndImpl <em>CGI Association End</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIAssociationEndImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIAssociationEnd()
	 * @generated
	 */
	int CGI_ASSOCIATION_END = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>MpInverse Model Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MPINVERSE_MODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>MpInstance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MPINSTANCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>MpInverse Instance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MPINVERSE_INSTANCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>MbShow Source Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBSHOW_SOURCE_MULTIPLICITY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>MbShow Source Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBSHOW_SOURCE_ROLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>MbShow Target Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBSHOW_TARGET_MULTIPLICITY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>MbShow Target Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBSHOW_TARGET_ROLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>MbShow Link Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBSHOW_LINK_NAME = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>MbShow Specific Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBSHOW_SPECIFIC_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>MbInstance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBINSTANCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>MbShow Qualifier1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBSHOW_QUALIFIER1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>MbShow Qualifier2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MBSHOW_QUALIFIER2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Msource Role</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MSOURCE_ROLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Mtarget Role</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MTARGET_ROLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Msource Multiplicity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MSOURCE_MULTIPLICITY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Mtarget Multiplicity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MTARGET_MULTIPLICITY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Msource Qualifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MSOURCE_QUALIFIER = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Mtarget Qualifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MTARGET_QUALIFIER = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Mspecific Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MSPECIFIC_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Marrow</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END__MARROW = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 33;

	/**
	 * The number of structural features of the '<em>CGI Association End</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 34;

	/**
	 * The number of operations of the '<em>CGI Association End</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_END_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIAssociationRoleImpl <em>CGI Association Role</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIAssociationRoleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIAssociationRole()
	 * @generated
	 */
	int CGI_ASSOCIATION_ROLE = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Marrow</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__MARROW = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The number of structural features of the '<em>CGI Association Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The number of operations of the '<em>CGI Association Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_ASSOCIATION_ROLE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIBasicClassImpl <em>CGI Basic Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIBasicClassImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIBasicClass()
	 * @generated
	 */
	int CGI_BASIC_CLASS = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>MpImage View Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS__MPIMAGE_VIEW_DATA = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>CGI Basic Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>CGI Basic Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BASIC_CLASS_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIBlockStateImpl <em>CGI Block State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIBlockStateImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIBlockState()
	 * @generated
	 */
	int CGI_BLOCK_STATE = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>NAnd Line Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__NAND_LINE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MpInherits From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MPINHERITS_FROM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>MnInheritance Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MNINHERITANCE_MASK = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>MpDefault Component Relation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MPDEFAULT_COMPONENT_RELATION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>MName Display Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MNAME_DISPLAY_MODE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MAct Desc Labl Diaplay Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MACT_DESC_LABL_DIAPLAY_MODE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Mmove And Line Time Stamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__MMOVE_AND_LINE_TIME_STAMP = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>CGI Block State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The number of operations of the '<em>CGI Block State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BLOCK_STATE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIBoxImpl <em>CGI Box</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIBoxImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIBox()
	 * @generated
	 */
	int CGI_BOX = 11;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>CGI Box</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>CGI Box</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BOX_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIButtonArrayImpl <em>CGI Button Array</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIButtonArrayImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIButtonArray()
	 * @generated
	 */
	int CGI_BUTTON_ARRAY = 12;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mcs Model Obj Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MCS_MODEL_OBJ_PATH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mcs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MCS_NAME = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MParts Array</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MPARTS_ARRAY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Mli Button Names</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MLI_BUTTON_NAMES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Mli Button Values</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY__MLI_BUTTON_VALUES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>CGI Button Array</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The number of operations of the '<em>CGI Button Array</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_BUTTON_ARRAY_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIClassImpl <em>CGI Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIClassImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIClass()
	 * @generated
	 */
	int CGI_CLASS = 13;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Attrs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__ATTRS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__OPERATIONS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Mcolor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MCOLOR = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Mline Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MLINE_WIDTH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>MdSeparator Position</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MDSEPARATOR_POSITION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>MbIs Misplaced</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MBIS_MISPLACED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>MpImage View Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MPIMAGE_VIEW_DATA = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>MbFrameset Modified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS__MBFRAMESET_MODIFIED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The number of structural features of the '<em>CGI Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The number of operations of the '<em>CGI Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIClassChartImpl <em>CGI Class Chart</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIClassChartImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIClassChart()
	 * @generated
	 */
	int CGI_CLASS_CHART = 14;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__ID = GRAPHIC_CHART_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Maccess</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MACCESS = GRAPHIC_CHART_TYPE__MACCESS;

	/**
	 * The feature id for the '<em><b>Element List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__ELEMENT_LIST = GRAPHIC_CHART_TYPE__ELEMENT_LIST;

	/**
	 * The feature id for the '<em><b>MnModify Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MNMODIFY_DATE = GRAPHIC_CHART_TYPE__MNMODIFY_DATE;

	/**
	 * The feature id for the '<em><b>Mcurrent Left Top</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MCURRENT_LEFT_TOP = GRAPHIC_CHART_TYPE__MCURRENT_LEFT_TOP;

	/**
	 * The feature id for the '<em><b>Mmodified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MMODIFIED = GRAPHIC_CHART_TYPE__MMODIFIED;

	/**
	 * The feature id for the '<em><b>MnCreate Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MNCREATE_DATE = GRAPHIC_CHART_TYPE__MNCREATE_DATE;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MPPARENT = GRAPHIC_CHART_TYPE__MPPARENT;

	/**
	 * The feature id for the '<em><b>Marrow Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MARROW_STYLE = GRAPHIC_CHART_TYPE__MARROW_STYLE;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MDRAW_BEHAVIOR = GRAPHIC_CHART_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mcurrent Right Bottom</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MCURRENT_RIGHT_BOTTOM = GRAPHIC_CHART_TYPE__MCURRENT_RIGHT_BOTTOM;

	/**
	 * The feature id for the '<em><b>Mcreator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MCREATOR = GRAPHIC_CHART_TYPE__MCREATOR;

	/**
	 * The feature id for the '<em><b>MbScale With Zoom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MBSCALE_WITH_ZOOM = GRAPHIC_CHART_TYPE__MBSCALE_WITH_ZOOM;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MTYPE = GRAPHIC_CHART_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Graph Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__GRAPH_ELEMENTS = GRAPHIC_CHART_TYPE__GRAPH_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MNAME = GRAPHIC_CHART_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>Mfile Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MFILE_VERSION = GRAPHIC_CHART_TYPE__MFILE_VERSION;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MBIS_PREFERENCES_INITIALIZED = GRAPHIC_CHART_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MPMODEL_OBJECT = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpRoot</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART__MPROOT = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>CGI Class Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART_FEATURE_COUNT = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>CGI Class Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASS_CHART_OPERATION_COUNT = GRAPHIC_CHART_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIClassifierRoleImpl <em>CGI Classifier Role</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIClassifierRoleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIClassifierRole()
	 * @generated
	 */
	int CGI_CLASSIFIER_ROLE = 15;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>CGI Classifier Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>CGI Classifier Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CLASSIFIER_ROLE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CompartmentsTypeImpl <em>Compartments Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CompartmentsTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCompartmentsType()
	 * @generated
	 */
	int COMPARTMENTS_TYPE = 51;

	/**
	 * The number of structural features of the '<em>Compartments Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARTMENTS_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Compartments Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARTMENTS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGICompartmentImpl <em>CGI Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGICompartmentImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGICompartment()
	 * @generated
	 */
	int CGI_COMPARTMENT = 16;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPARTMENT__ID = COMPARTMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPARTMENT__MNAME = COMPARTMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mdisplay Option</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPARTMENT__MDISPLAY_OPTION = COMPARTMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MbShow Inherited</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPARTMENT__MBSHOW_INHERITED = COMPARTMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MbOrdered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPARTMENT__MBORDERED = COMPARTMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Items</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPARTMENT__ITEMS = COMPARTMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>CGI Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPARTMENT_FEATURE_COUNT = COMPARTMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>CGI Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPARTMENT_OPERATION_COUNT = COMPARTMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIComponentImpl <em>CGI Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIComponentImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIComponent()
	 * @generated
	 */
	int CGI_COMPONENT = 17;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>CGI Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>CGI Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPONENT_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGICompositeClassImpl <em>CGI Composite Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGICompositeClassImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGICompositeClass()
	 * @generated
	 */
	int CGI_COMPOSITE_CLASS = 18;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mcolor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MCOLOR = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mline Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS__MLINE_WIDTH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>CGI Composite Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>CGI Composite Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_COMPOSITE_CLASS_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIConnectorImpl <em>CGI Connector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIConnectorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIConnector()
	 * @generated
	 */
	int CGI_CONNECTOR = 19;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mposition</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MPOSITION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnInheritance Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MNINHERITANCE_MASK = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MSub Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MSUB_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MY_STATE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>MpInherits From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR__MPINHERITS_FROM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>CGI Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>CGI Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONNECTOR_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIContainArrowImpl <em>CGI Contain Arrow</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIContainArrowImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIContainArrow()
	 * @generated
	 */
	int CGI_CONTAIN_ARROW = 20;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Marrow</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MARROW = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>CGI Contain Arrow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The number of operations of the '<em>CGI Contain Arrow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_CONTAIN_ARROW_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIDiagramFrameImpl <em>CGI Diagram Frame</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIDiagramFrameImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIDiagramFrame()
	 * @generated
	 */
	int CGI_DIAGRAM_FRAME = 21;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MbVisible</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__MBVISIBLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>CGI Diagram Frame</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>CGI Diagram Frame</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_DIAGRAM_FRAME_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIFreeShapeImpl <em>CGI Free Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIFreeShapeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIFreeShape()
	 * @generated
	 */
	int CGI_FREE_SHAPE = 22;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpoints</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE__MPOINTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>CGI Free Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>CGI Free Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_SHAPE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIFreeTextImpl <em>CGI Free Text</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIFreeTextImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIFreeText()
	 * @generated
	 */
	int CGI_FREE_TEXT = 23;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mpoints</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__MPOINTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mtext</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__MTEXT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>CGI Free Text</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>CGI Free Text</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_FREE_TEXT_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIGenericElementImpl <em>CGI Generic Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIGenericElementImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIGenericElement()
	 * @generated
	 */
	int CGI_GENERIC_ELEMENT = 24;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>MpImage View Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MPIMAGE_VIEW_DATA = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Mcs Context</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MCS_CONTEXT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Mcs Parts Array</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MCS_PARTS_ARRAY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MbIs Structured</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT__MBIS_STRUCTURED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>CGI Generic Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The number of operations of the '<em>CGI Generic Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_GENERIC_ELEMENT_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIImageImpl <em>CGI Image</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIImageImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIImage()
	 * @generated
	 */
	int CGI_IMAGE = 25;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MpImage View Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__MPIMAGE_VIEW_DATA = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpoints</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE__MPOINTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>CGI Image</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>CGI Image</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIImageDataImpl <em>CGI Image Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIImageDataImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIImageData()
	 * @generated
	 */
	int CGI_IMAGE_DATA = 26;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mdata Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MDATA_SIZE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mdata</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MDATA = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Msrc File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MSRC_FILE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mfile Modified Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA__MFILE_MODIFIED_TIME = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>CGI Image Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>CGI Image Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_IMAGE_DATA_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIInformationFlowImpl <em>CGI Information Flow</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIInformationFlowImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIInformationFlow()
	 * @generated
	 */
	int CGI_INFORMATION_FLOW = 27;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MbShow Keyword</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MBSHOW_KEYWORD = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Mshow Conveyed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MSHOW_CONVEYED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mkeyword</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MKEYWORD = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Mconveyed</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MCONVEYED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Marrow</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__MARROW = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>CGI Information Flow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The number of operations of the '<em>CGI Information Flow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INFORMATION_FLOW_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIInheritanceImpl <em>CGI Inheritance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIInheritanceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIInheritance()
	 * @generated
	 */
	int CGI_INHERITANCE = 28;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MShow Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MSHOW_NAME = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>MShow Stereotype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MSHOW_STEREOTYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Mcolor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MCOLOR = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Mline Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MLINE_WIDTH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Marrow</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE__MARROW = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>CGI Inheritance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The number of operations of the '<em>CGI Inheritance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_INHERITANCE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMFCCtrlImpl <em>CGIMFC Ctrl</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMFCCtrlImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMFCCtrl()
	 * @generated
	 */
	int CGIMFC_CTRL = 29;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mcs Model Obj Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MCS_MODEL_OBJ_PATH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mcs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MCS_NAME = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>MParts Array</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MPARTS_ARRAY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Mcs Button Caption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL__MCS_BUTTON_CAPTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>CGIMFC Ctrl</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of operations of the '<em>CGIMFC Ctrl</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGIMFC_CTRL_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMessageLabelImpl <em>CGI Message Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMessageLabelImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMessageLabel()
	 * @generated
	 */
	int CGI_MESSAGE_LABEL = 30;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpCommunication Connection</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL__MPCOMMUNICATION_CONNECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Percent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL__PERCENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>CGI Message Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>CGI Message Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MESSAGE_LABEL_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscChartImpl <em>CGI Msc Chart</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscChartImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMscChart()
	 * @generated
	 */
	int CGI_MSC_CHART = 31;

	/**
	 * The feature id for the '<em><b>VLadder Margin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__VLADDER_MARGIN = 0;

	/**
	 * The feature id for the '<em><b>Musing Activation Bar</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MUSING_ACTIVATION_BAR = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__ID = 2;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MTYPE = 3;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MPMODEL_OBJECT = 4;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MPPARENT = 5;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MNAME = 6;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MDRAW_BEHAVIOR = 7;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MBIS_PREFERENCES_INITIALIZED = 8;

	/**
	 * The feature id for the '<em><b>Element List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__ELEMENT_LIST = 9;

	/**
	 * The feature id for the '<em><b>Graph Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__GRAPH_ELEMENTS = 10;

	/**
	 * The feature id for the '<em><b>Maccess</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MACCESS = 11;

	/**
	 * The feature id for the '<em><b>Mmodified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MMODIFIED = 12;

	/**
	 * The feature id for the '<em><b>Mfile Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MFILE_VERSION = 13;

	/**
	 * The feature id for the '<em><b>MnModify Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MNMODIFY_DATE = 14;

	/**
	 * The feature id for the '<em><b>MnCreate Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MNCREATE_DATE = 15;

	/**
	 * The feature id for the '<em><b>Mcreator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MCREATOR = 16;

	/**
	 * The feature id for the '<em><b>MbScale With Zoom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MBSCALE_WITH_ZOOM = 17;

	/**
	 * The feature id for the '<em><b>Marrow Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MARROW_STYLE = 18;

	/**
	 * The feature id for the '<em><b>MpRoot</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MPROOT = 19;

	/**
	 * The feature id for the '<em><b>Mcurrent Left Top</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MCURRENT_LEFT_TOP = 20;

	/**
	 * The feature id for the '<em><b>Mcurrent Right Bottom</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART__MCURRENT_RIGHT_BOTTOM = 21;

	/**
	 * The number of structural features of the '<em>CGI Msc Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART_FEATURE_COUNT = 22;

	/**
	 * The number of operations of the '<em>CGI Msc Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CHART_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscColumnCRImpl <em>CGI Msc Column CR</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscColumnCRImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMscColumnCR()
	 * @generated
	 */
	int CGI_MSC_COLUMN_CR = 32;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mposition</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MPOSITION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MpInherits From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MPINHERITS_FROM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnInheritance Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MNINHERITANCE_MASK = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MSub Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__MSUB_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>CGI Msc Column CR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>CGI Msc Column CR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_COLUMN_CR_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscConditionMarkImpl <em>CGI Msc Condition Mark</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscConditionMarkImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMscConditionMark()
	 * @generated
	 */
	int CGI_MSC_CONDITION_MARK = 33;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>CGI Msc Condition Mark</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>CGI Msc Condition Mark</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_CONDITION_MARK_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscExecutionOccurrenceImpl <em>CGI Msc Execution Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscExecutionOccurrenceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMscExecutionOccurrence()
	 * @generated
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE = 34;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mposition</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MPOSITION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpInherits From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MPINHERITS_FROM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnInheritance Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MNINHERITANCE_MASK = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MSub Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MSUB_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MpStart Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE__MPSTART_MESSAGE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>CGI Msc Execution Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>CGI Msc Execution Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_EXECUTION_OCCURRENCE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscInteractionOccurrenceImpl <em>CGI Msc Interaction Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscInteractionOccurrenceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMscInteractionOccurrence()
	 * @generated
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE = 35;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>CGI Msc Interaction Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>CGI Msc Interaction Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OCCURRENCE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscInteractionOperandImpl <em>CGI Msc Interaction Operand</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscInteractionOperandImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMscInteractionOperand()
	 * @generated
	 */
	int CGI_MSC_INTERACTION_OPERAND = 36;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>CGI Msc Interaction Operand</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>CGI Msc Interaction Operand</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERAND_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscInteractionOperatorImpl <em>CGI Msc Interaction Operator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscInteractionOperatorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMscInteractionOperator()
	 * @generated
	 */
	int CGI_MSC_INTERACTION_OPERATOR = 37;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Moperator Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MOPERATOR_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>MbFrameset Modified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR__MBFRAMESET_MODIFIED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>CGI Msc Interaction Operator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of operations of the '<em>CGI Msc Interaction Operator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_INTERACTION_OPERATOR_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscMessageImpl <em>CGI Msc Message</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIMscMessageImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIMscMessage()
	 * @generated
	 */
	int CGI_MSC_MESSAGE = 38;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MbLeft</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MBLEFT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Marrow</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MARROW = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MY_STATE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>MpSource Exec</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MPSOURCE_EXEC = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>MpTarget Exec</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE__MPTARGET_EXEC = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>CGI Msc Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The number of operations of the '<em>CGI Msc Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_MSC_MESSAGE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIObjectInstanceImpl <em>CGI Object Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIObjectInstanceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIObjectInstance()
	 * @generated
	 */
	int CGI_OBJECT_INSTANCE = 39;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mmultiplicity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MMULTIPLICITY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__OPERATIONS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Attrs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__ATTRS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MbFrameset Modified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MBFRAMESET_MODIFIED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>MpImage View Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MPIMAGE_VIEW_DATA = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>MbIs Misplaced</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE__MBIS_MISPLACED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The number of structural features of the '<em>CGI Object Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The number of operations of the '<em>CGI Object Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_INSTANCE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIObjectLinkImpl <em>CGI Object Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIObjectLinkImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIObjectLink()
	 * @generated
	 */
	int CGI_OBJECT_LINK = 40;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Marrow</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MARROW = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>MbShow Source Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MBSHOW_SOURCE_MULTIPLICITY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>MbShow Source Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MBSHOW_SOURCE_ROLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>MbShow Target Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MBSHOW_TARGET_MULTIPLICITY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>MbShow Target Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MBSHOW_TARGET_ROLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>MbShow Link Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MBSHOW_LINK_NAME = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Msource Role</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MSOURCE_ROLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Mtarget Role</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MTARGET_ROLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Msource Multiplicity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MSOURCE_MULTIPLICITY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Mtarget Multiplicity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK__MTARGET_MULTIPLICITY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 23;

	/**
	 * The number of structural features of the '<em>CGI Object Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 24;

	/**
	 * The number of operations of the '<em>CGI Object Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_OBJECT_LINK_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIPackageImpl <em>CGI Package</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIPackageImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIPackage()
	 * @generated
	 */
	int CGI_PACKAGE = 41;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mcolor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MCOLOR = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mline Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MLINE_WIDTH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MbIs Structured</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE__MBIS_STRUCTURED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>CGI Package</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of operations of the '<em>CGI Package</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PACKAGE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIPartitionImpl <em>CGI Partition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIPartitionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIPartition()
	 * @generated
	 */
	int CGI_PARTITION = 42;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>CGI Partition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>CGI Partition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PARTITION_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIPortConnectorImpl <em>CGI Port Connector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIPortConnectorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIPortConnector()
	 * @generated
	 */
	int CGI_PORT_CONNECTOR = 43;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mposition</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MPOSITION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MpInherits From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MPINHERITS_FROM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnInheritance Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MNINHERITANCE_MASK = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MSub Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MSUB_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mprovided Interface Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MPROVIDED_INTERFACE_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mrequired Interface Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MREQUIRED_INTERFACE_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>MbVisible</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MBVISIBLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MnAngle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR__MNANGLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>CGI Port Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of operations of the '<em>CGI Port Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_PORT_CONNECTOR_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIStateImpl <em>CGI State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIStateImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIState()
	 * @generated
	 */
	int CGI_STATE = 44;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MAdditional Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MADDITIONAL_LABEL = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>NAnd Line Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__NAND_LINE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnInheritance Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MNINHERITANCE_MASK = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MpDefault Component Relation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MPDEFAULT_COMPONENT_RELATION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>And Line Poly</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__AND_LINE_POLY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MpVirtual Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MPVIRTUAL_PARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Mmove And Line Time Stamp</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MMOVE_AND_LINE_TIME_STAMP = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MY_STATE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>MpInherits From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MPINHERITS_FROM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>MbFrameset Modified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MBFRAMESET_MODIFIED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>MbIs Misplaced</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MBIS_MISPLACED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Mcolor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MCOLOR = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Mline Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__MLINE_WIDTH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 21;

	/**
	 * The number of structural features of the '<em>CGI State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 22;

	/**
	 * The number of operations of the '<em>CGI State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIStateChartImpl <em>CGI State Chart</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGIStateChartImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIStateChart()
	 * @generated
	 */
	int CGI_STATE_CHART = 45;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__ID = GRAPHIC_CHART_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Maccess</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MACCESS = GRAPHIC_CHART_TYPE__MACCESS;

	/**
	 * The feature id for the '<em><b>Element List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__ELEMENT_LIST = GRAPHIC_CHART_TYPE__ELEMENT_LIST;

	/**
	 * The feature id for the '<em><b>MnModify Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MNMODIFY_DATE = GRAPHIC_CHART_TYPE__MNMODIFY_DATE;

	/**
	 * The feature id for the '<em><b>Mcurrent Left Top</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MCURRENT_LEFT_TOP = GRAPHIC_CHART_TYPE__MCURRENT_LEFT_TOP;

	/**
	 * The feature id for the '<em><b>Mmodified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MMODIFIED = GRAPHIC_CHART_TYPE__MMODIFIED;

	/**
	 * The feature id for the '<em><b>MnCreate Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MNCREATE_DATE = GRAPHIC_CHART_TYPE__MNCREATE_DATE;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MPPARENT = GRAPHIC_CHART_TYPE__MPPARENT;

	/**
	 * The feature id for the '<em><b>Marrow Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MARROW_STYLE = GRAPHIC_CHART_TYPE__MARROW_STYLE;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MDRAW_BEHAVIOR = GRAPHIC_CHART_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mcurrent Right Bottom</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MCURRENT_RIGHT_BOTTOM = GRAPHIC_CHART_TYPE__MCURRENT_RIGHT_BOTTOM;

	/**
	 * The feature id for the '<em><b>Mcreator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MCREATOR = GRAPHIC_CHART_TYPE__MCREATOR;

	/**
	 * The feature id for the '<em><b>MbScale With Zoom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MBSCALE_WITH_ZOOM = GRAPHIC_CHART_TYPE__MBSCALE_WITH_ZOOM;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MTYPE = GRAPHIC_CHART_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Graph Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__GRAPH_ELEMENTS = GRAPHIC_CHART_TYPE__GRAPH_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MNAME = GRAPHIC_CHART_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>Mfile Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MFILE_VERSION = GRAPHIC_CHART_TYPE__MFILE_VERSION;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MBIS_PREFERENCES_INITIALIZED = GRAPHIC_CHART_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MPMODEL_OBJECT = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpRoot</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MPROOT = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MY_STATE = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MpInherits From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__MPINHERITS_FROM = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Diagram List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__DIAGRAM_LIST = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART__PROPERTIES = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>CGI State Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART_FEATURE_COUNT = GRAPHIC_CHART_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>CGI State Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_STATE_CHART_OPERATION_COUNT = GRAPHIC_CHART_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGISwimlaneFrameImpl <em>CGI Swimlane Frame</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGISwimlaneFrameImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGISwimlaneFrame()
	 * @generated
	 */
	int CGI_SWIMLANE_FRAME = 46;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Frameset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__FRAMESET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MbFrameset Modified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__MBFRAMESET_MODIFIED = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>CGI Swimlane Frame</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>CGI Swimlane Frame</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_SWIMLANE_FRAME_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGITextImpl <em>CGI Text</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGITextImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGIText()
	 * @generated
	 */
	int CGI_TEXT = 47;

	/**
	 * The feature id for the '<em><b>Mstr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MSTR = 0;

	/**
	 * The feature id for the '<em><b>Mstyle</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MSTYLE = 1;

	/**
	 * The feature id for the '<em><b>Mcolor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MCOLOR = 2;

	/**
	 * The feature id for the '<em><b>Mposition</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MPOSITION = 3;

	/**
	 * The feature id for the '<em><b>MnIdent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MNIDENT = 4;

	/**
	 * The feature id for the '<em><b>MbImplicit Set Rect Points</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MBIMPLICIT_SET_RECT_POINTS = 5;

	/**
	 * The feature id for the '<em><b>MnOrientation Ctrl Pt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MNORIENTATION_CTRL_PT = 6;

	/**
	 * The feature id for the '<em><b>MnVertical Spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MNVERTICAL_SPACING = 7;

	/**
	 * The feature id for the '<em><b>MnHorizontal Spacing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MNHORIZONTAL_SPACING = 8;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT__MTRANSFORM = 9;

	/**
	 * The number of structural features of the '<em>CGI Text</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>CGI Text</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGITextBoxImpl <em>CGI Text Box</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGITextBoxImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGITextBox()
	 * @generated
	 */
	int CGI_TEXT_BOX = 48;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mtransform</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MTRANSFORM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mpolygon</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MPOLYGON = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MnName Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MNNAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MnIs Name Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MNIS_NAME_FORMAT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Compartments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__COMPARTMENTS = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mcs Model Obj Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MCS_MODEL_OBJ_PATH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mcs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MCS_NAME = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>MParts Array</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX__MPARTS_ARRAY = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>CGI Text Box</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of operations of the '<em>CGI Text Box</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TEXT_BOX_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGITransImpl <em>CGI Trans</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CGITransImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCGITrans()
	 * @generated
	 */
	int CGI_TRANS = 49;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__ID = GRAPH_ELEMENTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Mdraw Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MDRAW_BEHAVIOR = GRAPH_ELEMENTS_TYPE__MDRAW_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MTYPE = GRAPH_ELEMENTS_TYPE__MTYPE;

	/**
	 * The feature id for the '<em><b>Mname</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MNAME = GRAPH_ELEMENTS_TYPE__MNAME;

	/**
	 * The feature id for the '<em><b>MbIs Preferences Initialized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MBIS_PREFERENCES_INITIALIZED = GRAPH_ELEMENTS_TYPE__MBIS_PREFERENCES_INITIALIZED;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__PROPERTIES = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MpModel Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MPMODEL_OBJECT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MpParent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MPPARENT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MPSOURCE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Msource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MSOURCE_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MPTARGET = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mtarget Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MTARGET_TYPE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mdirection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MDIRECTION = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mrpn</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MRPN = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mangle Point1</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MANGLE_POINT1 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Mangle Point2</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MANGLE_POINT2 = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Mline style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MLINE_STYLE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>MSource Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MSOURCE_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>MTarget Port</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MTARGET_PORT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>MnInheritance Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MNINHERITANCE_MASK = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>MbShow Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MBSHOW_NAME = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Marrow</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MARROW = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MY_STATE = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>MpInherits From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MPINHERITS_FROM = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Mcolor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MCOLOR = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Mline Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS__MLINE_WIDTH = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 20;

	/**
	 * The number of structural features of the '<em>CGI Trans</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS_FEATURE_COUNT = GRAPH_ELEMENTS_TYPE_FEATURE_COUNT + 21;

	/**
	 * The number of operations of the '<em>CGI Trans</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CGI_TRANS_OPERATION_COUNT = GRAPH_ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.P_MessageHandlerTypeImpl <em>PMessage Handler Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.P_MessageHandlerTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getP_MessageHandlerType()
	 * @generated
	 */
	int PMESSAGE_HANDLER_TYPE = 234;

	/**
	 * The number of structural features of the '<em>PMessage Handler Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PMESSAGE_HANDLER_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>PMessage Handler Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PMESSAGE_HANDLER_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CollEventImpl <em>Coll Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.CollEventImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getCollEvent()
	 * @generated
	 */
	int COLL_EVENT = 50;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLL_EVENT__ID = PMESSAGE_HANDLER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>First</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLL_EVENT__FIRST = PMESSAGE_HANDLER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Second</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLL_EVENT__SECOND = PMESSAGE_HANDLER_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLL_EVENT__OBJECT_CREATION = PMESSAGE_HANDLER_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLL_EVENT__UML_DEPENDENCY_ID = PMESSAGE_HANDLER_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Coll Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLL_EVENT_FEATURE_COUNT = PMESSAGE_HANDLER_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Coll Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLL_EVENT_OPERATION_COUNT = PMESSAGE_HANDLER_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ComponentsTypeImpl <em>Components Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ComponentsTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getComponentsType()
	 * @generated
	 */
	int COMPONENTS_TYPE = 52;

	/**
	 * The number of structural features of the '<em>Components Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Components Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ConveyedTypeImpl <em>Conveyed Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ConveyedTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getConveyedType()
	 * @generated
	 */
	int CONVEYED_TYPE = 53;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVEYED_TYPE__LAST_ID = 0;

	/**
	 * The number of structural features of the '<em>Conveyed Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVEYED_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Conveyed Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVEYED_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DeclarativesTypeImpl <em>Declaratives Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DeclarativesTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getDeclarativesType()
	 * @generated
	 */
	int DECLARATIVES_TYPE = 54;

	/**
	 * The number of structural features of the '<em>Declaratives Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATIVES_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Declaratives Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATIVES_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IModelElementImpl <em>IModel Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IModelElementImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIModelElement()
	 * @generated
	 */
	int IMODEL_ELEMENT = 157;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODEL_ELEMENT__EANNOTATIONS = EcorePackage.EMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODEL_ELEMENT__DISPLAY_NAME = EcorePackage.EMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>IModel Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODEL_ELEMENT_FEATURE_COUNT = EcorePackage.EMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODEL_ELEMENT___GET_EANNOTATION__STRING = EcorePackage.EMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IModel Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODEL_ELEMENT_OPERATION_COUNT = EcorePackage.EMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DefaultSubsystemTypeImpl <em>Default Subsystem Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DefaultSubsystemTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getDefaultSubsystemType()
	 * @generated
	 */
	int DEFAULT_SUBSYSTEM_TYPE = 55;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_SUBSYSTEM_TYPE__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_SUBSYSTEM_TYPE__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>Default Subsystem Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_SUBSYSTEM_TYPE_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_SUBSYSTEM_TYPE___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>Default Subsystem Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_SUBSYSTEM_TYPE_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DefaultTransTypeImpl <em>Default Trans Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DefaultTransTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getDefaultTransType()
	 * @generated
	 */
	int DEFAULT_TRANS_TYPE = 56;

	/**
	 * The number of structural features of the '<em>Default Trans Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_TRANS_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Default Trans Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_TRANS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ElementsTypeImpl <em>Elements Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ElementsTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getElementsType()
	 * @generated
	 */
	int ELEMENTS_TYPE = 59;

	/**
	 * The number of structural features of the '<em>Elements Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENTS_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Elements Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENTS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DependsOnTypeImpl <em>Depends On Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DependsOnTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getDependsOnType()
	 * @generated
	 */
	int DEPENDS_ON_TYPE = 57;

	/**
	 * The number of structural features of the '<em>Depends On Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDS_ON_TYPE_FEATURE_COUNT = ELEMENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Depends On Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDS_ON_TYPE_OPERATION_COUNT = ELEMENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DescriptionTypeImpl <em>Description Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.DescriptionTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getDescriptionType()
	 * @generated
	 */
	int DESCRIPTION_TYPE = 58;

	/**
	 * The number of structural features of the '<em>Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.EmbededFilesTypeImpl <em>Embeded Files Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.EmbededFilesTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getEmbededFilesType()
	 * @generated
	 */
	int EMBEDED_FILES_TYPE = 60;

	/**
	 * The number of structural features of the '<em>Embeded Files Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDED_FILES_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Embeded Files Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDED_FILES_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.End1_TypeImpl <em>End1 Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.End1_TypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getEnd1_Type()
	 * @generated
	 */
	int END1_TYPE = 61;

	/**
	 * The number of structural features of the '<em>End1 Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int END1_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>End1 Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int END1_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.End2_TypeImpl <em>End2 Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.End2_TypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getEnd2_Type()
	 * @generated
	 */
	int END2_TYPE = 62;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int END2_TYPE__MULTIPLICITY = END1_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>End2 Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int END2_TYPE_FEATURE_COUNT = END1_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>End2 Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int END2_TYPE_OPERATION_COUNT = END1_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.FilesTypeImpl <em>Files Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.FilesTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getFilesType()
	 * @generated
	 */
	int FILES_TYPE = 63;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE__MODIFIED_TIME_WEAK = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE__ID = 1;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE__UML_DEPENDENCY_ID = 2;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE__LAST_ID = 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE__MY_STATE = 4;

	/**
	 * The feature id for the '<em><b>Mpath</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE__MPATH = 5;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE__OBJECT_CREATION = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE__NAME = 7;

	/**
	 * The number of structural features of the '<em>Files Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Files Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILES_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.FromLinkTypeImpl <em>From Link Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.FromLinkTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getFromLinkType()
	 * @generated
	 */
	int FROM_LINK_TYPE = 64;

	/**
	 * The number of structural features of the '<em>From Link Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_LINK_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>From Link Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_LINK_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.HyperLinksTypeImpl <em>Hyper Links Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.HyperLinksTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getHyperLinksType()
	 * @generated
	 */
	int HYPER_LINKS_TYPE = 67;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HYPER_LINKS_TYPE__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HYPER_LINKS_TYPE__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>Hyper Links Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HYPER_LINKS_TYPE_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HYPER_LINKS_TYPE___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>Hyper Links Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HYPER_LINKS_TYPE_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStateVertexImpl <em>IState Vertex</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStateVertexImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIStateVertex()
	 * @generated
	 */
	int ISTATE_VERTEX = 188;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__ID = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__DESCRIPTION = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__MY_STATE = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__STEREOTYPES = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>IState Vertex</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IState Vertex</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_VERTEX_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStateImpl <em>IState</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStateImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIState()
	 * @generated
	 */
	int ISTATE = 185;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__EANNOTATIONS = ISTATE_VERTEX__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__DISPLAY_NAME = ISTATE_VERTEX__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__MODIFIED_TIME_WEAK = ISTATE_VERTEX__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__ID = ISTATE_VERTEX__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__DESCRIPTION = ISTATE_VERTEX__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__UML_DEPENDENCY_ID = ISTATE_VERTEX__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__MY_STATE = ISTATE_VERTEX__MY_STATE;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__STEREOTYPES = ISTATE_VERTEX__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__OBJECT_CREATION = ISTATE_VERTEX__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__NAME = ISTATE_VERTEX__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__PARENT = ISTATE_VERTEX_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>State Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__STATE_TYPE = ISTATE_VERTEX_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Default Trans</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__DEFAULT_TRANS = ISTATE_VERTEX_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Entry Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__ENTRY_ACTION = ISTATE_VERTEX_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__INHERITS_FROM_HANDLE = ISTATE_VERTEX_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Exit Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__EXIT_ACTION = ISTATE_VERTEX_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Nested State Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__NESTED_STATE_CHART = ISTATE_VERTEX_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__REQUIREMEN_TRACABILITY_HANDLE = ISTATE_VERTEX_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__ANNOTATIONS = ISTATE_VERTEX_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__DEPENDENCIES = ISTATE_VERTEX_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__THE_MAIN_DIAGRAM = ISTATE_VERTEX_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Swimlane</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__SWIMLANE = ISTATE_VERTEX_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE__CODE_UPDATE_CG_TIME = ISTATE_VERTEX_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>IState</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_FEATURE_COUNT = ISTATE_VERTEX_FEATURE_COUNT + 13;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE___GET_EANNOTATION__STRING = ISTATE_VERTEX___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IState</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_OPERATION_COUNT = ISTATE_VERTEX_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAcceptEventActionImpl <em>IAccept Event Action</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAcceptEventActionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAcceptEventAction()
	 * @generated
	 */
	int IACCEPT_EVENT_ACTION = 68;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__EANNOTATIONS = ISTATE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__DISPLAY_NAME = ISTATE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__MODIFIED_TIME_WEAK = ISTATE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__ID = ISTATE__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__DESCRIPTION = ISTATE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__UML_DEPENDENCY_ID = ISTATE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__MY_STATE = ISTATE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__STEREOTYPES = ISTATE__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__OBJECT_CREATION = ISTATE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__NAME = ISTATE__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__PARENT = ISTATE__PARENT;

	/**
	 * The feature id for the '<em><b>State Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__STATE_TYPE = ISTATE__STATE_TYPE;

	/**
	 * The feature id for the '<em><b>Default Trans</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__DEFAULT_TRANS = ISTATE__DEFAULT_TRANS;

	/**
	 * The feature id for the '<em><b>Entry Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__ENTRY_ACTION = ISTATE__ENTRY_ACTION;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__INHERITS_FROM_HANDLE = ISTATE__INHERITS_FROM_HANDLE;

	/**
	 * The feature id for the '<em><b>Exit Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__EXIT_ACTION = ISTATE__EXIT_ACTION;

	/**
	 * The feature id for the '<em><b>Nested State Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__NESTED_STATE_CHART = ISTATE__NESTED_STATE_CHART;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__REQUIREMEN_TRACABILITY_HANDLE = ISTATE__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__ANNOTATIONS = ISTATE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__DEPENDENCIES = ISTATE__DEPENDENCIES;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__THE_MAIN_DIAGRAM = ISTATE__THE_MAIN_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Swimlane</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__SWIMLANE = ISTATE__SWIMLANE;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__CODE_UPDATE_CG_TIME = ISTATE__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION__EVENT = ISTATE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>IAccept Event Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION_FEATURE_COUNT = ISTATE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION___GET_EANNOTATION__STRING = ISTATE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IAccept Event Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_EVENT_ACTION_OPERATION_COUNT = ISTATE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAcceptTimeEventImpl <em>IAccept Time Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAcceptTimeEventImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAcceptTimeEvent()
	 * @generated
	 */
	int IACCEPT_TIME_EVENT = 69;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__EANNOTATIONS = ISTATE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__DISPLAY_NAME = ISTATE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__MODIFIED_TIME_WEAK = ISTATE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__ID = ISTATE__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__DESCRIPTION = ISTATE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__UML_DEPENDENCY_ID = ISTATE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__MY_STATE = ISTATE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__STEREOTYPES = ISTATE__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__OBJECT_CREATION = ISTATE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__NAME = ISTATE__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__PARENT = ISTATE__PARENT;

	/**
	 * The feature id for the '<em><b>State Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__STATE_TYPE = ISTATE__STATE_TYPE;

	/**
	 * The feature id for the '<em><b>Default Trans</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__DEFAULT_TRANS = ISTATE__DEFAULT_TRANS;

	/**
	 * The feature id for the '<em><b>Entry Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__ENTRY_ACTION = ISTATE__ENTRY_ACTION;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__INHERITS_FROM_HANDLE = ISTATE__INHERITS_FROM_HANDLE;

	/**
	 * The feature id for the '<em><b>Exit Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__EXIT_ACTION = ISTATE__EXIT_ACTION;

	/**
	 * The feature id for the '<em><b>Nested State Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__NESTED_STATE_CHART = ISTATE__NESTED_STATE_CHART;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__REQUIREMEN_TRACABILITY_HANDLE = ISTATE__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__ANNOTATIONS = ISTATE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__DEPENDENCIES = ISTATE__DEPENDENCIES;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__THE_MAIN_DIAGRAM = ISTATE__THE_MAIN_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Swimlane</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__SWIMLANE = ISTATE__SWIMLANE;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT__CODE_UPDATE_CG_TIME = ISTATE__CODE_UPDATE_CG_TIME;

	/**
	 * The number of structural features of the '<em>IAccept Time Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT_FEATURE_COUNT = ISTATE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT___GET_EANNOTATION__STRING = ISTATE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IAccept Time Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACCEPT_TIME_EVENT_OPERATION_COUNT = ISTATE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IActionImpl <em>IAction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IActionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAction()
	 * @generated
	 */
	int IACTION = 70;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION__MY_STATE = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION__BODY = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>IAction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IAction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTION_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IActivityDiagramImpl <em>IActivity Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IActivityDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIActivityDiagram()
	 * @generated
	 */
	int IACTIVITY_DIAGRAM = 71;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_DIAGRAM__GRAPHIC_CHART = DEPENDS_ON_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_DIAGRAM__CODE_UPDATE_CG_TIME = DEPENDS_ON_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>IActivity Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_DIAGRAM_FEATURE_COUNT = DEPENDS_ON_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>IActivity Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_DIAGRAM_OPERATION_COUNT = DEPENDS_ON_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItsStateChartTypeImpl <em>Its State Chart Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItsStateChartTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getItsStateChartType()
	 * @generated
	 */
	int ITS_STATE_CHART_TYPE = 219;

	/**
	 * The number of structural features of the '<em>Its State Chart Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_STATE_CHART_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Its State Chart Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_STATE_CHART_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.NestedStateChartTypeImpl <em>Nested State Chart Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.NestedStateChartTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getNestedStateChartType()
	 * @generated
	 */
	int NESTED_STATE_CHART_TYPE = 230;

	/**
	 * The feature id for the '<em><b>Def Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NESTED_STATE_CHART_TYPE__DEF_NUMBER = ITS_STATE_CHART_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NESTED_STATE_CHART_TYPE__GRAPHIC_CHART = ITS_STATE_CHART_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NESTED_STATE_CHART_TYPE__LAST_MODIFIED_TIME = ITS_STATE_CHART_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Transitions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NESTED_STATE_CHART_TYPE__TRANSITIONS = ITS_STATE_CHART_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Connectors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NESTED_STATE_CHART_TYPE__CONNECTORS = ITS_STATE_CHART_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NESTED_STATE_CHART_TYPE__VERSION = ITS_STATE_CHART_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Nested State Chart Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NESTED_STATE_CHART_TYPE_FEATURE_COUNT = ITS_STATE_CHART_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Nested State Chart Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NESTED_STATE_CHART_TYPE_OPERATION_COUNT = ITS_STATE_CHART_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IActivityGraphImpl <em>IActivity Graph</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IActivityGraphImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIActivityGraph()
	 * @generated
	 */
	int IACTIVITY_GRAPH = 72;

	/**
	 * The feature id for the '<em><b>Def Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__DEF_NUMBER = NESTED_STATE_CHART_TYPE__DEF_NUMBER;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__GRAPHIC_CHART = NESTED_STATE_CHART_TYPE__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__LAST_MODIFIED_TIME = NESTED_STATE_CHART_TYPE__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Transitions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__TRANSITIONS = NESTED_STATE_CHART_TYPE__TRANSITIONS;

	/**
	 * The feature id for the '<em><b>Connectors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__CONNECTORS = NESTED_STATE_CHART_TYPE__CONNECTORS;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__VERSION = NESTED_STATE_CHART_TYPE__VERSION;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__MODIFIED_TIME_WEAK = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__ID = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__MY_STATE = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__NAME = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__EANNOTATIONS = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__DISPLAY_NAME = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__LAST_ID = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__WEAK_CG_TIME = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__STRONG_CG_TIME = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__MULTIPLICITY = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Its State Chart</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__ITS_STATE_CHART = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Class Modifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__CLASS_MODIFIER = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>States</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__STATES = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Base Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__BASE_VERSION = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__DIAGRAM = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Views</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__VIEWS = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__PROPERTIES = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__REQUIREMEN_TRACABILITY_HANDLE = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__DESCRIPTION = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Swimlanes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__SWIMLANES = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__STEREOTYPES = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Analysis Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__ANALYSIS_MODE = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__ANNOTATIONS = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__CODE_UPDATE_CG_TIME = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__OBJECT_CREATION = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__UML_DEPENDENCY_ID = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__HYPER_LINKS = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__DEPENDENCIES = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__THE_MAIN_DIAGRAM = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__ASSOCIATIONS = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH__TAGS = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 30;

	/**
	 * The number of structural features of the '<em>IActivity Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH_FEATURE_COUNT = NESTED_STATE_CHART_TYPE_FEATURE_COUNT + 31;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH___GET_EANNOTATION__STRING = NESTED_STATE_CHART_TYPE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>IActivity Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTIVITY_GRAPH_OPERATION_COUNT = NESTED_STATE_CHART_TYPE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUnitImpl <em>IUnit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUnitImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIUnit()
	 * @generated
	 */
	int IUNIT = 210;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUNIT__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUNIT__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IUnit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUNIT_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUNIT___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IUnit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUNIT_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassifierImpl <em>IClassifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassifierImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIClassifier()
	 * @generated
	 */
	int ICLASSIFIER = 90;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IClassifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IClassifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IActorImpl <em>IActor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IActorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIActor()
	 * @generated
	 */
	int IACTOR = 73;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__EANNOTATIONS = ICLASSIFIER__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__DISPLAY_NAME = ICLASSIFIER__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__UML_DEPENDENCY_ID = ICLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__OBJECT_CREATION = ICLASSIFIER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__MULTIPLICITY = ICLASSIFIER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__ID = ICLASSIFIER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__MY_STATE = ICLASSIFIER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__NAME = ICLASSIFIER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__THE_MAIN_DIAGRAM = ICLASSIFIER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__DEPENDENCIES = ICLASSIFIER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__LAST_ID = ICLASSIFIER_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__WEAK_CG_TIME = ICLASSIFIER_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__STRONG_CG_TIME = ICLASSIFIER_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__OPERATIONS = ICLASSIFIER_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>State Charts</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__STATE_CHARTS = ICLASSIFIER_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Its State Chart</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__ITS_STATE_CHART = ICLASSIFIER_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__ASSOCIATIONS = ICLASSIFIER_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Class Modifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__CLASS_MODIFIER = ICLASSIFIER_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__HYPER_LINKS = ICLASSIFIER_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__MODIFIED_TIME_WEAK = ICLASSIFIER_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__PORTS = ICLASSIFIER_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Inheritances</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__INHERITANCES = ICLASSIFIER_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Attrs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__ATTRS = ICLASSIFIER_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__REQUIREMEN_TRACABILITY_HANDLE = ICLASSIFIER_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__DESCRIPTION = ICLASSIFIER_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__ANNOTATIONS = ICLASSIFIER_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Component Files</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__COMPONENT_FILES = ICLASSIFIER_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR__PROPERTIES = ICLASSIFIER_FEATURE_COUNT + 25;

	/**
	 * The number of structural features of the '<em>IActor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR_FEATURE_COUNT = ICLASSIFIER_FEATURE_COUNT + 26;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR___GET_EANNOTATION__STRING = ICLASSIFIER___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IActor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IACTOR_OPERATION_COUNT = ICLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_pModelObjectTypeImpl <em>MpModel Object Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_pModelObjectTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getM_pModelObjectType()
	 * @generated
	 */
	int MPMODEL_OBJECT_TYPE = 226;

	/**
	 * The number of structural features of the '<em>MpModel Object Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MPMODEL_OBJECT_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>MpModel Object Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MPMODEL_OBJECT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAnchorImpl <em>IAnchor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAnchorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAnchor()
	 * @generated
	 */
	int IANCHOR = 74;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANCHOR__ID = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANCHOR__MY_STATE = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANCHOR__NAME = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANCHOR__DEPENDS_ON = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANCHOR__MODIFIED_TIME_WEAK = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>IAnchor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANCHOR_FEATURE_COUNT = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>IAnchor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANCHOR_OPERATION_COUNT = MPMODEL_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAnnotationImpl <em>IAnnotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAnnotationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAnnotation()
	 * @generated
	 */
	int IANNOTATION = 75;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION__REQUIREMEN_TRACABILITY_HANDLE = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION__DESCRIPTION = IUNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION__UML_DEPENDENCY_ID = IUNIT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION__OBJECT_CREATION = IUNIT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION__TAGS = IUNIT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION__BODY = IUNIT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>IAnnotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IAnnotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATION_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IVariableImpl <em>IVariable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IVariableImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIVariable()
	 * @generated
	 */
	int IVARIABLE = 215;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVARIABLE__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVARIABLE__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVARIABLE__IS_ORDERED = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My Type Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVARIABLE__MY_TYPE_OF = IUNIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>IVariable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVARIABLE_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVARIABLE___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IVariable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVARIABLE_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IArgumentImpl <em>IArgument</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IArgumentImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIArgument()
	 * @generated
	 */
	int IARGUMENT = 76;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__EANNOTATIONS = IVARIABLE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__DISPLAY_NAME = IVARIABLE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__IS_ORDERED = IVARIABLE__IS_ORDERED;

	/**
	 * The feature id for the '<em><b>My Type Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__MY_TYPE_OF = IVARIABLE__MY_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__ID = IVARIABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__MY_STATE = IVARIABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__PROPERTIES = IVARIABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__NAME = IVARIABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__MODIFIED_TIME_WEAK = IVARIABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Type Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__TYPE_OF = IVARIABLE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Argument Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__ARGUMENT_DIRECTION = IVARIABLE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__DEFAULT_VALUE = IVARIABLE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Value Specifications</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__VALUE_SPECIFICATIONS = IVARIABLE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__DESCRIPTION = IVARIABLE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__CODE_UPDATE_CG_TIME = IVARIABLE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__OBJECT_CREATION = IVARIABLE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT__UML_DEPENDENCY_ID = IVARIABLE_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>IArgument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT_FEATURE_COUNT = IVARIABLE_FEATURE_COUNT + 13;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT___GET_EANNOTATION__STRING = IVARIABLE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IArgument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IARGUMENT_OPERATION_COUNT = IVARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassImpl <em>IClass</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIClass()
	 * @generated
	 */
	int ICLASS = 87;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__EANNOTATIONS = ICLASSIFIER__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__DISPLAY_NAME = ICLASSIFIER__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__UML_DEPENDENCY_ID = ICLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__OBJECT_CREATION = ICLASSIFIER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__MODIFIED_TIME_WEAK = ICLASSIFIER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__ID = ICLASSIFIER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__MY_STATE = ICLASSIFIER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__NAME = ICLASSIFIER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__LAST_ID = ICLASSIFIER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__WEAK_CG_TIME = ICLASSIFIER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__STRONG_CG_TIME = ICLASSIFIER_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__MULTIPLICITY = ICLASSIFIER_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Class Modifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__CLASS_MODIFIER = ICLASSIFIER_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__PROPERTIES = ICLASSIFIER_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__STEREOTYPES = ICLASSIFIER_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__OPERATIONS = ICLASSIFIER_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Inheritances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__INHERITANCES = ICLASSIFIER_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__THE_MAIN_DIAGRAM = ICLASSIFIER_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Attrs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__ATTRS = ICLASSIFIER_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__TAGS = ICLASSIFIER_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__ASSOCIATIONS = ICLASSIFIER_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__DEPENDENCIES = ICLASSIFIER_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__PORTS = ICLASSIFIER_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Object Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__OBJECT_LINKS = ICLASSIFIER_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>State Charts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__STATE_CHARTS = ICLASSIFIER_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Its State Chart</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__ITS_STATE_CHART = ICLASSIFIER_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Triggered Operations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__TRIGGERED_OPERATIONS = ICLASSIFIER_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Receptions</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__RECEPTIONS = ICLASSIFIER_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Primitive Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__PRIMITIVE_OPERATIONS = ICLASSIFIER_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__ANNOTATIONS = ICLASSIFIER_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__DESCRIPTION = ICLASSIFIER_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Declaratives</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__DECLARATIVES = ICLASSIFIER_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Association Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__ASSOCIATION_ELEMENTS = ICLASSIFIER_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__OWNER_HANDLE = ICLASSIFIER_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__HYPER_LINKS = ICLASSIFIER_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__REQUIREMEN_TRACABILITY_HANDLE = ICLASSIFIER_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Component Files</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__COMPONENT_FILES = ICLASSIFIER_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__LINKS = ICLASSIFIER_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Components</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__COMPONENTS = ICLASSIFIER_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Event Handles</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__EVENT_HANDLES = ICLASSIFIER_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Template Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__TEMPLATE_PARAMETERS = ICLASSIFIER_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__CODE_UPDATE_CG_TIME = ICLASSIFIER_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS__CMHEADER = ICLASSIFIER_FEATURE_COUNT + 40;

	/**
	 * The number of structural features of the '<em>IClass</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_FEATURE_COUNT = ICLASSIFIER_FEATURE_COUNT + 41;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS___GET_EANNOTATION__STRING = ICLASSIFIER___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IClass</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_OPERATION_COUNT = ICLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAssociationClassImpl <em>IAssociation Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAssociationClassImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAssociationClass()
	 * @generated
	 */
	int IASSOCIATION_CLASS = 77;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__EANNOTATIONS = ICLASS__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__DISPLAY_NAME = ICLASS__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__UML_DEPENDENCY_ID = ICLASS__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__OBJECT_CREATION = ICLASS__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__MODIFIED_TIME_WEAK = ICLASS__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__ID = ICLASS__ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__MY_STATE = ICLASS__MY_STATE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__NAME = ICLASS__NAME;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__LAST_ID = ICLASS__LAST_ID;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__WEAK_CG_TIME = ICLASS__WEAK_CG_TIME;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__STRONG_CG_TIME = ICLASS__STRONG_CG_TIME;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__MULTIPLICITY = ICLASS__MULTIPLICITY;

	/**
	 * The feature id for the '<em><b>Class Modifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__CLASS_MODIFIER = ICLASS__CLASS_MODIFIER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__PROPERTIES = ICLASS__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__STEREOTYPES = ICLASS__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__OPERATIONS = ICLASS__OPERATIONS;

	/**
	 * The feature id for the '<em><b>Inheritances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__INHERITANCES = ICLASS__INHERITANCES;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__THE_MAIN_DIAGRAM = ICLASS__THE_MAIN_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Attrs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__ATTRS = ICLASS__ATTRS;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__TAGS = ICLASS__TAGS;

	/**
	 * The feature id for the '<em><b>Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__ASSOCIATIONS = ICLASS__ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__DEPENDENCIES = ICLASS__DEPENDENCIES;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__PORTS = ICLASS__PORTS;

	/**
	 * The feature id for the '<em><b>Object Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__OBJECT_LINKS = ICLASS__OBJECT_LINKS;

	/**
	 * The feature id for the '<em><b>State Charts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__STATE_CHARTS = ICLASS__STATE_CHARTS;

	/**
	 * The feature id for the '<em><b>Its State Chart</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__ITS_STATE_CHART = ICLASS__ITS_STATE_CHART;

	/**
	 * The feature id for the '<em><b>Triggered Operations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__TRIGGERED_OPERATIONS = ICLASS__TRIGGERED_OPERATIONS;

	/**
	 * The feature id for the '<em><b>Receptions</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__RECEPTIONS = ICLASS__RECEPTIONS;

	/**
	 * The feature id for the '<em><b>Primitive Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__PRIMITIVE_OPERATIONS = ICLASS__PRIMITIVE_OPERATIONS;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__ANNOTATIONS = ICLASS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__DESCRIPTION = ICLASS__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Declaratives</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__DECLARATIVES = ICLASS__DECLARATIVES;

	/**
	 * The feature id for the '<em><b>Association Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__ASSOCIATION_ELEMENTS = ICLASS__ASSOCIATION_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__OWNER_HANDLE = ICLASS__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__HYPER_LINKS = ICLASS__HYPER_LINKS;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__REQUIREMEN_TRACABILITY_HANDLE = ICLASS__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Component Files</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__COMPONENT_FILES = ICLASS__COMPONENT_FILES;

	/**
	 * The feature id for the '<em><b>Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__LINKS = ICLASS__LINKS;

	/**
	 * The feature id for the '<em><b>Components</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__COMPONENTS = ICLASS__COMPONENTS;

	/**
	 * The feature id for the '<em><b>Event Handles</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__EVENT_HANDLES = ICLASS__EVENT_HANDLES;

	/**
	 * The feature id for the '<em><b>Template Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__TEMPLATE_PARAMETERS = ICLASS__TEMPLATE_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__CODE_UPDATE_CG_TIME = ICLASS__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__CMHEADER = ICLASS__CMHEADER;

	/**
	 * The feature id for the '<em><b>Is Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__IS_CLASS = ICLASS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mend1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__MEND1 = ICLASS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mend2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS__MEND2 = ICLASS_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>IAssociation Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS_FEATURE_COUNT = ICLASS_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS___GET_EANNOTATION__STRING = ICLASS___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IAssociation Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_CLASS_OPERATION_COUNT = ICLASS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAssociationEndImpl <em>IAssociation End</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAssociationEndImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAssociationEnd()
	 * @generated
	 */
	int IASSOCIATION_END = 78;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__UML_DEPENDENCY_ID = ASSOCIATIONS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__OBJECT_CREATION = ASSOCIATIONS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__REQUIREMEN_TRACABILITY_HANDLE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__DESCRIPTION = ASSOCIATIONS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__PROPERTIES = ASSOCIATIONS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Implicit Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__IMPLICIT_CLASS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__EANNOTATIONS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__DISPLAY_NAME = ASSOCIATIONS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__ID = ASSOCIATIONS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__MY_STATE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__NAME = ASSOCIATIONS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__MULTIPLICITY = ASSOCIATIONS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Other Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__OTHER_CLASS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Link Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__LINK_NAME = ASSOCIATIONS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Link Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__LINK_TYPE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Navigability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__NAVIGABILITY = ASSOCIATIONS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__INVERSE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__MODIFIED_TIME_WEAK = ASSOCIATIONS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Qualifiers</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__QUALIFIERS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__STEREOTYPES = ASSOCIATIONS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__CODE_UPDATE_CG_TIME = ASSOCIATIONS_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Qualifier Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__QUALIFIER_TYPE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Massociation Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END__MASSOCIATION_CLASS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 22;

	/**
	 * The number of structural features of the '<em>IAssociation End</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_FEATURE_COUNT = ASSOCIATIONS_TYPE_FEATURE_COUNT + 23;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END___GET_EANNOTATION__STRING = ASSOCIATIONS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>IAssociation End</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_OPERATION_COUNT = ASSOCIATIONS_TYPE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAssociationEndHandleImpl <em>IAssociation End Handle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAssociationEndHandleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAssociationEndHandle()
	 * @generated
	 */
	int IASSOCIATION_END_HANDLE = 79;

	/**
	 * The feature id for the '<em><b>M2 Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_HANDLE__M2_CLASS = 0;

	/**
	 * The feature id for the '<em><b>Filename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_HANDLE__FILENAME = 1;

	/**
	 * The feature id for the '<em><b>Subsystem</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_HANDLE__SUBSYSTEM = 2;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_HANDLE__CLASS = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_HANDLE__NAME = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_HANDLE__ID = 5;

	/**
	 * The number of structural features of the '<em>IAssociation End Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_HANDLE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>IAssociation End Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_END_HANDLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAssociationRoleImpl <em>IAssociation Role</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAssociationRoleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAssociationRole()
	 * @generated
	 */
	int IASSOCIATION_ROLE = 80;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__MY_STATE = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MfAssoc Type1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__MFASSOC_TYPE1 = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MfAssoc Type2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__MFASSOC_TYPE2 = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpSource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__MPSOURCE = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>MpTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__MPTARGET = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MpFormal Assoc1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__MPFORMAL_ASSOC1 = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MpFormal Assoc2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__MPFORMAL_ASSOC2 = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>IAssociation Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IAssociation Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IASSOCIATION_ROLE_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAttributeImpl <em>IAttribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IAttributeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIAttribute()
	 * @generated
	 */
	int IATTRIBUTE = 81;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__EANNOTATIONS = IVARIABLE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__DISPLAY_NAME = IVARIABLE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__IS_ORDERED = IVARIABLE__IS_ORDERED;

	/**
	 * The feature id for the '<em><b>My Type Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__MY_TYPE_OF = IVARIABLE__MY_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__UML_DEPENDENCY_ID = IVARIABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__OBJECT_CREATION = IVARIABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__MODIFIED_TIME_WEAK = IVARIABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__ID = IVARIABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__MY_STATE = IVARIABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__NAME = IVARIABLE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__MULTIPLICITY = IVARIABLE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Type Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__TYPE_OF = IVARIABLE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Protection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__PROTECTION = IVARIABLE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__STATIC = IVARIABLE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__IS_REFERENCE = IVARIABLE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Is Constant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__IS_CONSTANT = IVARIABLE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__STEREOTYPES = IVARIABLE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Value Specifications</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__VALUE_SPECIFICATIONS = IVARIABLE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__PROPERTIES = IVARIABLE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__DESCRIPTION = IVARIABLE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__TAGS = IVARIABLE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__DEFAULT_VALUE = IVARIABLE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__DEPENDENCIES = IVARIABLE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__LAST_ID = IVARIABLE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__ANNOTATIONS = IVARIABLE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__REQUIREMEN_TRACABILITY_HANDLE = IVARIABLE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__CODE_UPDATE_CG_TIME = IVARIABLE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE__THE_MAIN_DIAGRAM = IVARIABLE_FEATURE_COUNT + 23;

	/**
	 * The number of structural features of the '<em>IAttribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE_FEATURE_COUNT = IVARIABLE_FEATURE_COUNT + 24;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE___GET_EANNOTATION__STRING = IVARIABLE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IAttribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IATTRIBUTE_OPERATION_COUNT = IVARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IBlockImpl <em>IBlock</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IBlockImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIBlock()
	 * @generated
	 */
	int IBLOCK = 82;

	/**
	 * The feature id for the '<em><b>Implicit Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__IMPLICIT_CLASS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__MULTIPLICITY = ASSOCIATIONS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__ID = ASSOCIATIONS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__MY_STATE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__NAME = ASSOCIATIONS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__OBJECT_CREATION = ASSOCIATIONS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__UML_DEPENDENCY_ID = ASSOCIATIONS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Other Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__OTHER_CLASS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__INVERSE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Part Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK__PART_KIND = ASSOCIATIONS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>IBlock</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK_FEATURE_COUNT = ASSOCIATIONS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>IBlock</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBLOCK_OPERATION_COUNT = ASSOCIATIONS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IBodyImpl <em>IBody</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IBodyImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIBody()
	 * @generated
	 */
	int IBODY = 83;

	/**
	 * The feature id for the '<em><b>Body Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBODY__BODY_DATA = 0;

	/**
	 * The number of structural features of the '<em>IBody</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBODY_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IBody</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBODY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItsTargetTypeImpl <em>Its Target Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItsTargetTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getItsTargetType()
	 * @generated
	 */
	int ITS_TARGET_TYPE = 220;

	/**
	 * The number of structural features of the '<em>Its Target Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TARGET_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Its Target Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TARGET_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IBranchImpl <em>IBranch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IBranchImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIBranch()
	 * @generated
	 */
	int IBRANCH = 84;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__ID = ITS_TARGET_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__NAME = ITS_TARGET_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__MODIFIED_TIME_WEAK = ITS_TARGET_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__PARENT = ITS_TARGET_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Connector Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__CONNECTOR_TYPE = ITS_TARGET_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__MY_STATE = ITS_TARGET_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__STEREOTYPES = ITS_TARGET_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__CODE_UPDATE_CG_TIME = ITS_TARGET_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__OBJECT_CREATION = ITS_TARGET_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH__UML_DEPENDENCY_ID = ITS_TARGET_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>IBranch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH_FEATURE_COUNT = ITS_TARGET_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>IBranch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IBRANCH_OPERATION_COUNT = ITS_TARGET_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICallActionImpl <em>ICall Action</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICallActionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getICallAction()
	 * @generated
	 */
	int ICALL_ACTION = 85;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_ACTION__ID = 0;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_ACTION__MODIFIED_TIME_WEAK = 1;

	/**
	 * The feature id for the '<em><b>Interface Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_ACTION__INTERFACE_ITEM = 2;

	/**
	 * The feature id for the '<em><b>Argument Names</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_ACTION__ARGUMENT_NAMES = 3;

	/**
	 * The feature id for the '<em><b>Argument Values</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_ACTION__ARGUMENT_VALUES = 4;

	/**
	 * The number of structural features of the '<em>ICall Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_ACTION_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>ICall Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_ACTION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICallOperationImpl <em>ICall Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICallOperationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getICallOperation()
	 * @generated
	 */
	int ICALL_OPERATION = 86;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__EANNOTATIONS = ISTATE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__DISPLAY_NAME = ISTATE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__MODIFIED_TIME_WEAK = ISTATE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__ID = ISTATE__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__DESCRIPTION = ISTATE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__UML_DEPENDENCY_ID = ISTATE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__MY_STATE = ISTATE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__STEREOTYPES = ISTATE__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__OBJECT_CREATION = ISTATE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__NAME = ISTATE__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__PARENT = ISTATE__PARENT;

	/**
	 * The feature id for the '<em><b>State Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__STATE_TYPE = ISTATE__STATE_TYPE;

	/**
	 * The feature id for the '<em><b>Default Trans</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__DEFAULT_TRANS = ISTATE__DEFAULT_TRANS;

	/**
	 * The feature id for the '<em><b>Entry Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__ENTRY_ACTION = ISTATE__ENTRY_ACTION;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__INHERITS_FROM_HANDLE = ISTATE__INHERITS_FROM_HANDLE;

	/**
	 * The feature id for the '<em><b>Exit Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__EXIT_ACTION = ISTATE__EXIT_ACTION;

	/**
	 * The feature id for the '<em><b>Nested State Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__NESTED_STATE_CHART = ISTATE__NESTED_STATE_CHART;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__REQUIREMEN_TRACABILITY_HANDLE = ISTATE__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__ANNOTATIONS = ISTATE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__DEPENDENCIES = ISTATE__DEPENDENCIES;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__THE_MAIN_DIAGRAM = ISTATE__THE_MAIN_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Swimlane</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__SWIMLANE = ISTATE__SWIMLANE;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__CODE_UPDATE_CG_TIME = ISTATE__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__OPERATION = ISTATE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION__TARGET = ISTATE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>ICall Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION_FEATURE_COUNT = ISTATE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION___GET_EANNOTATION__STRING = ISTATE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ICall Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICALL_OPERATION_OPERATION_COUNT = ISTATE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_pBaseTypeImpl <em>MpBase Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_pBaseTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getM_pBaseType()
	 * @generated
	 */
	int MPBASE_TYPE = 224;

	/**
	 * The number of structural features of the '<em>MpBase Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MPBASE_TYPE_FEATURE_COUNT = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>MpBase Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MPBASE_TYPE_OPERATION_COUNT = MPMODEL_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassHandleImpl <em>IClass Handle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassHandleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIClassHandle()
	 * @generated
	 */
	int ICLASS_HANDLE = 88;

	/**
	 * The feature id for the '<em><b>M2 Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_HANDLE__M2_CLASS = MPBASE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_HANDLE__ID = MPBASE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Filename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_HANDLE__FILENAME = MPBASE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Subsystem</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_HANDLE__SUBSYSTEM = MPBASE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_HANDLE__CLASS = MPBASE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_HANDLE__NAME = MPBASE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>IClass Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_HANDLE_FEATURE_COUNT = MPBASE_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>IClass Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_HANDLE_OPERATION_COUNT = MPBASE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.LinksTypeImpl <em>Links Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.LinksTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getLinksType()
	 * @generated
	 */
	int LINKS_TYPE = 222;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINKS_TYPE__ID = 0;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINKS_TYPE__MULTIPLICITY = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINKS_TYPE__NAME = 2;

	/**
	 * The feature id for the '<em><b>Other Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINKS_TYPE__OTHER_CLASS = 3;

	/**
	 * The number of structural features of the '<em>Links Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINKS_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Links Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINKS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassInstanceImpl <em>IClass Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassInstanceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIClassInstance()
	 * @generated
	 */
	int ICLASS_INSTANCE = 89;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_INSTANCE__ID = LINKS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_INSTANCE__MULTIPLICITY = LINKS_TYPE__MULTIPLICITY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_INSTANCE__NAME = LINKS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Other Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_INSTANCE__OTHER_CLASS = LINKS_TYPE__OTHER_CLASS;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_INSTANCE__INVERSE = LINKS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>IClass Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_INSTANCE_FEATURE_COUNT = LINKS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>IClass Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASS_INSTANCE_OPERATION_COUNT = LINKS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassifierRoleImpl <em>IClassifier Role</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IClassifierRoleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIClassifierRole()
	 * @generated
	 */
	int ICLASSIFIER_ROLE = 91;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>MeRole Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__MEROLE_TYPE = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__MY_STATE = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>MpBase</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__MPBASE = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Minstance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__MINSTANCE = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__PROPERTIES = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>MpRef SD</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__MPREF_SD = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__CODE_UPDATE_CG_TIME = IMODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__STEREOTYPES = IMODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>IClassifier Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IClassifier Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICLASSIFIER_ROLE_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICodeGenConfigInfoImpl <em>ICode Gen Config Info</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICodeGenConfigInfoImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getICodeGenConfigInfo()
	 * @generated
	 */
	int ICODE_GEN_CONFIG_INFO = 92;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__ID = DEPENDS_ON_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__MY_STATE = DEPENDS_ON_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__NAME = DEPENDS_ON_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__MODIFIED_TIME_WEAK = DEPENDS_ON_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__HYPER_LINKS = DEPENDS_ON_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Scope Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__SCOPE_TYPE = DEPENDS_ON_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Libraries</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__LIBRARIES = DEPENDS_ON_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Additional Sources</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__ADDITIONAL_SOURCES = DEPENDS_ON_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Standard Headers</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__STANDARD_HEADERS = DEPENDS_ON_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Include Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__INCLUDE_PATH = DEPENDS_ON_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Target Main</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__TARGET_MAIN = DEPENDS_ON_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Instrumentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__INSTRUMENTATION = DEPENDS_ON_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Time Model</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__TIME_MODEL = DEPENDS_ON_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Mgenerate Actors</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__MGENERATE_ACTORS = DEPENDS_ON_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Statechart Implementation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__STATECHART_IMPLEMENTATION = DEPENDS_ON_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Initialization Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__INITIALIZATION_CODE = DEPENDS_ON_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Checks List</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__CHECKS_LIST = DEPENDS_ON_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Scope Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__SCOPE_ELEMENTS = DEPENDS_ON_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Root</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__ROOT = DEPENDS_ON_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__WEAK_CG_TIME = DEPENDS_ON_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__STRONG_CG_TIME = DEPENDS_ON_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Mall In Anim Scope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__MALL_IN_ANIM_SCOPE = DEPENDS_ON_TYPE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Mgenerate Usecases</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__MGENERATE_USECASES = DEPENDS_ON_TYPE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__DEPENDENCIES = DEPENDS_ON_TYPE_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Initial Instances</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__INITIAL_INSTANCES = DEPENDS_ON_TYPE_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__PROPERTIES = DEPENDS_ON_TYPE_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__ANNOTATIONS = DEPENDS_ON_TYPE_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__LAST_ID = DEPENDS_ON_TYPE_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__DESCRIPTION = DEPENDS_ON_TYPE_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__TAGS = DEPENDS_ON_TYPE_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__CMHEADER = DEPENDS_ON_TYPE_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__REQUIREMEN_TRACABILITY_HANDLE = DEPENDS_ON_TYPE_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__STEREOTYPES = DEPENDS_ON_TYPE_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__CODE_UPDATE_CG_TIME = DEPENDS_ON_TYPE_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Anim Scope Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__ANIM_SCOPE_ELEMENTS = DEPENDS_ON_TYPE_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Embeded Files</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__EMBEDED_FILES = DEPENDS_ON_TYPE_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__OBJECT_CREATION = DEPENDS_ON_TYPE_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO__UML_DEPENDENCY_ID = DEPENDS_ON_TYPE_FEATURE_COUNT + 37;

	/**
	 * The number of structural features of the '<em>ICode Gen Config Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO_FEATURE_COUNT = DEPENDS_ON_TYPE_FEATURE_COUNT + 38;

	/**
	 * The number of operations of the '<em>ICode Gen Config Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO_OPERATION_COUNT = DEPENDS_ON_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICodeGenConfigInfoHandleImpl <em>ICode Gen Config Info Handle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICodeGenConfigInfoHandleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getICodeGenConfigInfoHandle()
	 * @generated
	 */
	int ICODE_GEN_CONFIG_INFO_HANDLE = 93;

	/**
	 * The feature id for the '<em><b>M2 Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO_HANDLE__M2_CLASS = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO_HANDLE__ID = 1;

	/**
	 * The number of structural features of the '<em>ICode Gen Config Info Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO_HANDLE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>ICode Gen Config Info Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICODE_GEN_CONFIG_INFO_HANDLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICollaborationImpl <em>ICollaboration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICollaborationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getICollaboration()
	 * @generated
	 */
	int ICOLLABORATION = 94;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Classifier Roles</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__CLASSIFIER_ROLES = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__MESSAGES = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__ANNOTATIONS = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Association Roles</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__ASSOCIATION_ROLES = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Combined Fragments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__COMBINED_FRAGMENTS = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>PMessage Handler</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__PMESSAGE_HANDLER = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Interaction Occurrences</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__INTERACTION_OCCURRENCES = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Execution Occurrences</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__EXECUTION_OCCURRENCES = IMODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>ICollaboration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ICollaboration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDiagramImpl <em>IDiagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIDiagram()
	 * @generated
	 */
	int IDIAGRAM = 113;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__ID = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__LAST_MODIFIED_TIME = IUNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IUNIT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__DEFAULT_SUBSYSTEM = IUNIT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__DESCRIPTION = IUNIT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__UML_DEPENDENCY_ID = IUNIT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__LAST_ID = IUNIT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__MY_STATE = IUNIT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__OWNER_HANDLE = IUNIT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__OBJECT_CREATION = IUNIT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__NAME = IUNIT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__CMHEADER = IUNIT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__PROPERTIES = IUNIT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__STEREOTYPES = IUNIT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__MODIFIED_TIME_WEAK = IUNIT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__GRAPHIC_CHART = IUNIT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__ANNOTATIONS = IUNIT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__CODE_UPDATE_CG_TIME = IUNIT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM__HYPER_LINKS = IUNIT_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>IDiagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 19;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IDiagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDIAGRAM_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICollaborationDiagramImpl <em>ICollaboration Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICollaborationDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getICollaborationDiagram()
	 * @generated
	 */
	int ICOLLABORATION_DIAGRAM = 95;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__EANNOTATIONS = IDIAGRAM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__DISPLAY_NAME = IDIAGRAM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__ID = IDIAGRAM__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__LAST_MODIFIED_TIME = IDIAGRAM__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__DEFAULT_SUBSYSTEM = IDIAGRAM__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__DESCRIPTION = IDIAGRAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__UML_DEPENDENCY_ID = IDIAGRAM__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__LAST_ID = IDIAGRAM__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__MY_STATE = IDIAGRAM__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__OWNER_HANDLE = IDIAGRAM__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__OBJECT_CREATION = IDIAGRAM__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__NAME = IDIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__CMHEADER = IDIAGRAM__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__PROPERTIES = IDIAGRAM__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__STEREOTYPES = IDIAGRAM__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__MODIFIED_TIME_WEAK = IDIAGRAM__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__GRAPHIC_CHART = IDIAGRAM__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__ANNOTATIONS = IDIAGRAM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__CODE_UPDATE_CG_TIME = IDIAGRAM__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__HYPER_LINKS = IDIAGRAM__HYPER_LINKS;

	/**
	 * The feature id for the '<em><b>MpI Collaboration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM__MPI_COLLABORATION = IDIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>ICollaboration Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM_FEATURE_COUNT = IDIAGRAM_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM___GET_EANNOTATION__STRING = IDIAGRAM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ICollaboration Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLLABORATION_DIAGRAM_OPERATION_COUNT = IDIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IColorImpl <em>IColor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IColorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIColor()
	 * @generated
	 */
	int ICOLOR = 96;

	/**
	 * The feature id for the '<em><b>Mfg Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLOR__MFG_COLOR = 0;

	/**
	 * The feature id for the '<em><b>Mbg Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLOR__MBG_COLOR = 1;

	/**
	 * The feature id for the '<em><b>Mbg Flag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLOR__MBG_FLAG = 2;

	/**
	 * The number of structural features of the '<em>IColor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLOR_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>IColor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOLOR_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICombinedFragmentImpl <em>ICombined Fragment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICombinedFragmentImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getICombinedFragment()
	 * @generated
	 */
	int ICOMBINED_FRAGMENT = 97;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT__ID = 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT__MY_STATE = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT__NAME = 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT__MODIFIED_TIME_WEAK = 3;

	/**
	 * The feature id for the '<em><b>Interaction Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT__INTERACTION_OPERATOR = 4;

	/**
	 * The feature id for the '<em><b>Interaction Operands</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT__INTERACTION_OPERANDS = 5;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT__STEREOTYPES = 6;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT__TAGS = 7;

	/**
	 * The number of structural features of the '<em>ICombined Fragment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>ICombined Fragment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMBINED_FRAGMENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICommentImpl <em>IComment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ICommentImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIComment()
	 * @generated
	 */
	int ICOMMENT = 98;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__EANNOTATIONS = IANNOTATION__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__DISPLAY_NAME = IANNOTATION__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__REQUIREMEN_TRACABILITY_HANDLE = IANNOTATION__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__DESCRIPTION = IANNOTATION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__UML_DEPENDENCY_ID = IANNOTATION__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__OBJECT_CREATION = IANNOTATION__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__TAGS = IANNOTATION__TAGS;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__BODY = IANNOTATION__BODY;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__MODIFIED_TIME_WEAK = IANNOTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__ID = IANNOTATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__MY_STATE = IANNOTATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__NAME = IANNOTATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__HYPER_LINKS = IANNOTATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Anchors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__ANCHORS = IANNOTATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__DEPENDENCIES = IANNOTATION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__STEREOTYPES = IANNOTATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__LAST_ID = IANNOTATION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__CODE_UPDATE_CG_TIME = IANNOTATION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__THE_MAIN_DIAGRAM = IANNOTATION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT__PROPERTIES = IANNOTATION_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>IComment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT_FEATURE_COUNT = IANNOTATION_FEATURE_COUNT + 12;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT___GET_EANNOTATION__STRING = IANNOTATION___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IComment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMMENT_OPERATION_COUNT = IANNOTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IComponentImpl <em>IComponent</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IComponentImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIComponent()
	 * @generated
	 */
	int ICOMPONENT = 99;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__WEAK_CG_TIME = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__STRONG_CG_TIME = IUNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__OWNER_HANDLE = IUNIT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__ID = IUNIT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MY_STATE = IUNIT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__NAME = IUNIT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__STEREOTYPES = IUNIT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MODIFIED_TIME_WEAK = IUNIT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mbuild Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MBUILD_TYPE = IUNIT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mlibraries</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MLIBRARIES = IUNIT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Madditional Sources</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MADDITIONAL_SOURCES = IUNIT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Mstandard Headers</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MSTANDARD_HEADERS = IUNIT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Minclude Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MINCLUDE_PATH = IUNIT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Minitialization Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MINITIALIZATION_CODE = IUNIT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Mfolder</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MFOLDER = IUNIT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mconfig Active</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__MCONFIG_ACTIVE = IUNIT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Configs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__CONFIGS = IUNIT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__DEPENDENCIES = IUNIT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Handles In Me</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__HANDLES_IN_ME = IUNIT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__PROPERTIES = IUNIT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__LAST_ID = IUNIT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__DESCRIPTION = IUNIT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__REQUIREMEN_TRACABILITY_HANDLE = IUNIT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__HYPER_LINKS = IUNIT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__CODE_UPDATE_CG_TIME = IUNIT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Declaratives</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__DECLARATIVES = IUNIT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Variation Points</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__VARIATION_POINTS = IUNIT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Selected Variants</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__SELECTED_VARIANTS = IUNIT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__OBJECT_CREATION = IUNIT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__UML_DEPENDENCY_ID = IUNIT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT__CMHEADER = IUNIT_FEATURE_COUNT + 30;

	/**
	 * The number of structural features of the '<em>IComponent</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 31;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IComponent</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IComponentDiagramImpl <em>IComponent Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IComponentDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIComponentDiagram()
	 * @generated
	 */
	int ICOMPONENT_DIAGRAM = 100;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__EANNOTATIONS = IDIAGRAM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__DISPLAY_NAME = IDIAGRAM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__ID = IDIAGRAM__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__LAST_MODIFIED_TIME = IDIAGRAM__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__DEFAULT_SUBSYSTEM = IDIAGRAM__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__DESCRIPTION = IDIAGRAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__UML_DEPENDENCY_ID = IDIAGRAM__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__LAST_ID = IDIAGRAM__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__MY_STATE = IDIAGRAM__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__OWNER_HANDLE = IDIAGRAM__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__OBJECT_CREATION = IDIAGRAM__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__NAME = IDIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__CMHEADER = IDIAGRAM__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__PROPERTIES = IDIAGRAM__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__STEREOTYPES = IDIAGRAM__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__MODIFIED_TIME_WEAK = IDIAGRAM__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__GRAPHIC_CHART = IDIAGRAM__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__ANNOTATIONS = IDIAGRAM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__CODE_UPDATE_CG_TIME = IDIAGRAM__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM__HYPER_LINKS = IDIAGRAM__HYPER_LINKS;

	/**
	 * The number of structural features of the '<em>IComponent Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM_FEATURE_COUNT = IDIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM___GET_EANNOTATION__STRING = IDIAGRAM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IComponent Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_DIAGRAM_OPERATION_COUNT = IDIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IComponentInstanceImpl <em>IComponent Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IComponentInstanceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIComponentInstance()
	 * @generated
	 */
	int ICOMPONENT_INSTANCE = 101;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_INSTANCE__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_INSTANCE__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IComponent Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_INSTANCE_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_INSTANCE___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IComponent Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICOMPONENT_INSTANCE_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IConfigurationImpl <em>IConfiguration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IConfigurationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIConfiguration()
	 * @generated
	 */
	int ICONFIGURATION = 102;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONFIGURATION__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONFIGURATION__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IConfiguration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONFIGURATION_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONFIGURATION___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IConfiguration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONFIGURATION_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IConnectorImpl <em>IConnector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IConnectorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIConnector()
	 * @generated
	 */
	int ICONNECTOR = 103;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__EANNOTATIONS = ISTATE_VERTEX__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__DISPLAY_NAME = ISTATE_VERTEX__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__MODIFIED_TIME_WEAK = ISTATE_VERTEX__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__ID = ISTATE_VERTEX__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__DESCRIPTION = ISTATE_VERTEX__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__UML_DEPENDENCY_ID = ISTATE_VERTEX__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__MY_STATE = ISTATE_VERTEX__MY_STATE;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__STEREOTYPES = ISTATE_VERTEX__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__OBJECT_CREATION = ISTATE_VERTEX__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__NAME = ISTATE_VERTEX__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__PARENT = ISTATE_VERTEX_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Connector Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR__CONNECTOR_TYPE = ISTATE_VERTEX_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>IConnector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR_FEATURE_COUNT = ISTATE_VERTEX_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR___GET_EANNOTATION__STRING = ISTATE_VERTEX___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IConnector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONNECTOR_OPERATION_COUNT = ISTATE_VERTEX_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IConstraintImpl <em>IConstraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IConstraintImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIConstraint()
	 * @generated
	 */
	int ICONSTRAINT = 104;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__EANNOTATIONS = IANNOTATION__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__DISPLAY_NAME = IANNOTATION__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__REQUIREMEN_TRACABILITY_HANDLE = IANNOTATION__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__DESCRIPTION = IANNOTATION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__UML_DEPENDENCY_ID = IANNOTATION__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__OBJECT_CREATION = IANNOTATION__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__TAGS = IANNOTATION__TAGS;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__BODY = IANNOTATION__BODY;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__ID = IANNOTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__MY_STATE = IANNOTATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__NAME = IANNOTATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__MODIFIED_TIME_WEAK = IANNOTATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__STEREOTYPES = IANNOTATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__PROPERTIES = IANNOTATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Anchors</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT__ANCHORS = IANNOTATION_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>IConstraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT_FEATURE_COUNT = IANNOTATION_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT___GET_EANNOTATION__STRING = IANNOTATION___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IConstraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRAINT_OPERATION_COUNT = IANNOTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.OperationsTypeImpl <em>Operations Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.OperationsTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getOperationsType()
	 * @generated
	 */
	int OPERATIONS_TYPE = 232;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATIONS_TYPE__VIRTUAL = 0;

	/**
	 * The number of structural features of the '<em>Operations Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATIONS_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Operations Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATIONS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IConstructorImpl <em>IConstructor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IConstructorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIConstructor()
	 * @generated
	 */
	int ICONSTRUCTOR = 105;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__VIRTUAL = OPERATIONS_TYPE__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__UML_DEPENDENCY_ID = OPERATIONS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__OBJECT_CREATION = OPERATIONS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__ID = OPERATIONS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__MY_STATE = OPERATIONS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__MODIFIED_TIME_WEAK = OPERATIONS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Return Type</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__RETURN_TYPE = OPERATIONS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__ABSTRACT = OPERATIONS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__FINAL = OPERATIONS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Concurrency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__CONCURRENCY = OPERATIONS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Protection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__PROTECTION = OPERATIONS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__STATIC = OPERATIONS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__CONSTANT = OPERATIONS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Its Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__ITS_BODY = OPERATIONS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Initializer</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__INITIALIZER = OPERATIONS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Args</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__ARGS = OPERATIONS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__NAME = OPERATIONS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__DESCRIPTION = OPERATIONS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__REQUIREMEN_TRACABILITY_HANDLE = OPERATIONS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__CODE_UPDATE_CG_TIME = OPERATIONS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__TAGS = OPERATIONS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR__LAST_ID = OPERATIONS_TYPE_FEATURE_COUNT + 20;

	/**
	 * The number of structural features of the '<em>IConstructor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR_FEATURE_COUNT = OPERATIONS_TYPE_FEATURE_COUNT + 21;

	/**
	 * The number of operations of the '<em>IConstructor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONSTRUCTOR_OPERATION_COUNT = OPERATIONS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IValueSpecificationImpl <em>IValue Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IValueSpecificationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIValueSpecification()
	 * @generated
	 */
	int IVALUE_SPECIFICATION = 214;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVALUE_SPECIFICATION__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVALUE_SPECIFICATION__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IValue Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVALUE_SPECIFICATION_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVALUE_SPECIFICATION___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IValue Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVALUE_SPECIFICATION_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IContextSpecificationImpl <em>IContext Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IContextSpecificationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIContextSpecification()
	 * @generated
	 */
	int ICONTEXT_SPECIFICATION = 106;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTEXT_SPECIFICATION__EANNOTATIONS = IVALUE_SPECIFICATION__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTEXT_SPECIFICATION__DISPLAY_NAME = IVALUE_SPECIFICATION__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IContext Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTEXT_SPECIFICATION_FEATURE_COUNT = IVALUE_SPECIFICATION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTEXT_SPECIFICATION___GET_EANNOTATION__STRING = IVALUE_SPECIFICATION___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IContext Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTEXT_SPECIFICATION_OPERATION_COUNT = IVALUE_SPECIFICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IControlledFileImpl <em>IControlled File</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IControlledFileImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIControlledFile()
	 * @generated
	 */
	int ICONTROLLED_FILE = 107;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTROLLED_FILE__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTROLLED_FILE__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IControlled File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTROLLED_FILE_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTROLLED_FILE___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IControlled File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTROLLED_FILE_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDefaultDrvdTransImpl <em>IDefault Drvd Trans</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDefaultDrvdTransImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIDefaultDrvdTrans()
	 * @generated
	 */
	int IDEFAULT_DRVD_TRANS = 108;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__MODIFIED_TIME_WEAK = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Static Reaction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__STATIC_REACTION = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Its Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__ITS_TARGET = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__ID = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__CODE_UPDATE_CG_TIME = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__REQUIREMEN_TRACABILITY_HANDLE = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__DESCRIPTION = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Its Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__ITS_LABEL = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__UML_DEPENDENCY_ID = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__MY_STATE = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__OBJECT_CREATION = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__NAME = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Its Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__ITS_SOURCE = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Of State</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__OF_STATE = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Error Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__ERROR_STATUS = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__INHERITS_FROM_HANDLE = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__ANNOTATIONS = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS__STEREOTYPES = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The number of structural features of the '<em>IDefault Drvd Trans</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS_FEATURE_COUNT = DEFAULT_TRANS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The number of operations of the '<em>IDefault Drvd Trans</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEFAULT_DRVD_TRANS_OPERATION_COUNT = DEFAULT_TRANS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDependencyImpl <em>IDependency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDependencyImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIDependency()
	 * @generated
	 */
	int IDEPENDENCY = 109;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__ID = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__MY_STATE = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__PROPERTIES = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__STEREOTYPES = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__DEPENDS_ON = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__TAGS = IMODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__ANNOTATIONS = IMODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__DEPENDENCIES = IMODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__DESCRIPTION = IMODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__REQUIREMEN_TRACABILITY_HANDLE = IMODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY__CODE_UPDATE_CG_TIME = IMODEL_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The number of structural features of the '<em>IDependency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IDependency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPENDENCY_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDeploymentDiagramImpl <em>IDeployment Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDeploymentDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIDeploymentDiagram()
	 * @generated
	 */
	int IDEPLOYMENT_DIAGRAM = 110;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__EANNOTATIONS = IDIAGRAM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__DISPLAY_NAME = IDIAGRAM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__ID = IDIAGRAM__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__LAST_MODIFIED_TIME = IDIAGRAM__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__DEFAULT_SUBSYSTEM = IDIAGRAM__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__DESCRIPTION = IDIAGRAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__UML_DEPENDENCY_ID = IDIAGRAM__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__LAST_ID = IDIAGRAM__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__MY_STATE = IDIAGRAM__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__OWNER_HANDLE = IDIAGRAM__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__OBJECT_CREATION = IDIAGRAM__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__NAME = IDIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__CMHEADER = IDIAGRAM__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__PROPERTIES = IDIAGRAM__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__STEREOTYPES = IDIAGRAM__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__MODIFIED_TIME_WEAK = IDIAGRAM__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__GRAPHIC_CHART = IDIAGRAM__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__ANNOTATIONS = IDIAGRAM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__CODE_UPDATE_CG_TIME = IDIAGRAM__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM__HYPER_LINKS = IDIAGRAM__HYPER_LINKS;

	/**
	 * The number of structural features of the '<em>IDeployment Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM_FEATURE_COUNT = IDIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM___GET_EANNOTATION__STRING = IDIAGRAM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IDeployment Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEPLOYMENT_DIAGRAM_OPERATION_COUNT = IDIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDescriptionImpl <em>IDescription</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDescriptionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIDescription()
	 * @generated
	 */
	int IDESCRIPTION = 111;

	/**
	 * The feature id for the '<em><b>Text RTF</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESCRIPTION__TEXT_RTF = DESCRIPTION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESCRIPTION__TEXT = DESCRIPTION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Hyperlinks</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESCRIPTION__HYPERLINKS = DESCRIPTION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>IDescription</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESCRIPTION_FEATURE_COUNT = DESCRIPTION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>IDescription</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESCRIPTION_OPERATION_COUNT = DESCRIPTION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDestructorImpl <em>IDestructor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IDestructorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIDestructor()
	 * @generated
	 */
	int IDESTRUCTOR = 112;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__VIRTUAL = OPERATIONS_TYPE__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__UML_DEPENDENCY_ID = OPERATIONS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__OBJECT_CREATION = OPERATIONS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__ID = OPERATIONS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__NAME = OPERATIONS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Args</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__ARGS = OPERATIONS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__ABSTRACT = OPERATIONS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__FINAL = OPERATIONS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Concurrency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__CONCURRENCY = OPERATIONS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Protection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__PROTECTION = OPERATIONS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__STATIC = OPERATIONS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__CONSTANT = OPERATIONS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Its Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__ITS_BODY = OPERATIONS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__MODIFIED_TIME_WEAK = OPERATIONS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__DESCRIPTION = OPERATIONS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__PROPERTIES = OPERATIONS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__MY_STATE = OPERATIONS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Return Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR__RETURN_TYPE = OPERATIONS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>IDestructor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR_FEATURE_COUNT = OPERATIONS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The number of operations of the '<em>IDestructor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDESTRUCTOR_OPERATION_COUNT = OPERATIONS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEmbededFileImpl <em>IEmbeded File</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEmbededFileImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIEmbededFile()
	 * @generated
	 */
	int IEMBEDED_FILE = 114;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEMBEDED_FILE__ID = EMBEDED_FILES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEMBEDED_FILE__NAME = EMBEDED_FILES_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEMBEDED_FILE__MODIFIED_TIME_WEAK = EMBEDED_FILES_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>May Need To Relocate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEMBEDED_FILE__MAY_NEED_TO_RELOCATE = EMBEDED_FILES_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Last Known Full Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEMBEDED_FILE__LAST_KNOWN_FULL_PATH = EMBEDED_FILES_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEMBEDED_FILE__STEREOTYPES = EMBEDED_FILES_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEMBEDED_FILE__TAGS = EMBEDED_FILES_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>IEmbeded File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEMBEDED_FILE_FEATURE_COUNT = EMBEDED_FILES_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>IEmbeded File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEMBEDED_FILE_OPERATION_COUNT = EMBEDED_FILES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEnumerationLiteralImpl <em>IEnumeration Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEnumerationLiteralImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIEnumerationLiteral()
	 * @generated
	 */
	int IENUMERATION_LITERAL = 115;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__VALUE = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__PROPERTIES = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__TAGS = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__CODE_UPDATE_CG_TIME = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL__DESCRIPTION = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>IEnumeration Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IEnumeration Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IENUMERATION_LITERAL_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInterfaceItemImpl <em>IInterface Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInterfaceItemImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInterfaceItem()
	 * @generated
	 */
	int IINTERFACE_ITEM = 142;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM__EANNOTATIONS = ICLASSIFIER__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM__DISPLAY_NAME = ICLASSIFIER__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IInterface Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_FEATURE_COUNT = ICLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM___GET_EANNOTATION__STRING = ICLASSIFIER___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IInterface Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_OPERATION_COUNT = ICLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEventImpl <em>IEvent</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEventImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIEvent()
	 * @generated
	 */
	int IEVENT = 116;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__EANNOTATIONS = IINTERFACE_ITEM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__DISPLAY_NAME = IINTERFACE_ITEM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__UML_DEPENDENCY_ID = IINTERFACE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__OBJECT_CREATION = IINTERFACE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__LAST_ID = IINTERFACE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__ID = IINTERFACE_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__MY_STATE = IINTERFACE_ITEM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__NAME = IINTERFACE_ITEM_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__VIRTUAL = IINTERFACE_ITEM_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__MODIFIED_TIME_WEAK = IINTERFACE_ITEM_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Args</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__ARGS = IINTERFACE_ITEM_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__STEREOTYPES = IINTERFACE_ITEM_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__DESCRIPTION = IINTERFACE_ITEM_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__PROPERTIES = IINTERFACE_ITEM_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__DEPENDENCIES = IINTERFACE_ITEM_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__TAGS = IINTERFACE_ITEM_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Super Event</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__SUPER_EVENT = IINTERFACE_ITEM_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__REQUIREMEN_TRACABILITY_HANDLE = IINTERFACE_ITEM_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT__ANNOTATIONS = IINTERFACE_ITEM_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>IEvent</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_FEATURE_COUNT = IINTERFACE_ITEM_FEATURE_COUNT + 17;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT___GET_EANNOTATION__STRING = IINTERFACE_ITEM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IEvent</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_OPERATION_COUNT = IINTERFACE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEventHandleImpl <em>IEvent Handle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEventHandleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIEventHandle()
	 * @generated
	 */
	int IEVENT_HANDLE = 117;

	/**
	 * The feature id for the '<em><b>M2 Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_HANDLE__M2_CLASS = 0;

	/**
	 * The feature id for the '<em><b>Filename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_HANDLE__FILENAME = 1;

	/**
	 * The feature id for the '<em><b>Subsystem</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_HANDLE__SUBSYSTEM = 2;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_HANDLE__CLASS = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_HANDLE__NAME = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_HANDLE__ID = 5;

	/**
	 * The number of structural features of the '<em>IEvent Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_HANDLE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>IEvent Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_HANDLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEventReceptionImpl <em>IEvent Reception</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IEventReceptionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIEventReception()
	 * @generated
	 */
	int IEVENT_RECEPTION = 118;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_RECEPTION__EANNOTATIONS = IINTERFACE_ITEM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_RECEPTION__DISPLAY_NAME = IINTERFACE_ITEM__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IEvent Reception</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_RECEPTION_FEATURE_COUNT = IINTERFACE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_RECEPTION___GET_EANNOTATION__STRING = IINTERFACE_ITEM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IEvent Reception</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEVENT_RECEPTION_OPERATION_COUNT = IINTERFACE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IExecutionOccurrenceImpl <em>IExecution Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IExecutionOccurrenceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIExecutionOccurrence()
	 * @generated
	 */
	int IEXECUTION_OCCURRENCE = 119;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXECUTION_OCCURRENCE__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXECUTION_OCCURRENCE__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXECUTION_OCCURRENCE__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mstart Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXECUTION_OCCURRENCE__MSTART_MESSAGE = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mend Message</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXECUTION_OCCURRENCE__MEND_MESSAGE = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mlength</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXECUTION_OCCURRENCE__MLENGTH = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>IExecution Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXECUTION_OCCURRENCE_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXECUTION_OCCURRENCE___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IExecution Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXECUTION_OCCURRENCE_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IExternalHyperlinkImpl <em>IExternal Hyperlink</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IExternalHyperlinkImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIExternalHyperlink()
	 * @generated
	 */
	int IEXTERNAL_HYPERLINK = 120;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXTERNAL_HYPERLINK__EANNOTATIONS = HYPER_LINKS_TYPE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXTERNAL_HYPERLINK__DISPLAY_NAME = HYPER_LINKS_TYPE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXTERNAL_HYPERLINK__TARGET = HYPER_LINKS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>IExternal Hyperlink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXTERNAL_HYPERLINK_FEATURE_COUNT = HYPER_LINKS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXTERNAL_HYPERLINK___GET_EANNOTATION__STRING = HYPER_LINKS_TYPE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IExternal Hyperlink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IEXTERNAL_HYPERLINK_OPERATION_COUNT = HYPER_LINKS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFileImpl <em>IFile</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFileImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIFile()
	 * @generated
	 */
	int IFILE = 121;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__MODIFIED_TIME_WEAK = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__ID = IUNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__UML_DEPENDENCY_ID = IUNIT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__LAST_ID = IUNIT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__MY_STATE = IUNIT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mpath</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__MPATH = IUNIT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__OBJECT_CREATION = IUNIT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__NAME = IUNIT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__PROPERTIES = IUNIT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__MTYPE = IUNIT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Fragments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__FRAGMENTS = IUNIT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__DESCRIPTION = IUNIT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE__DEPENDENCIES = IUNIT_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>IFile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 13;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IFile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFileFragmentImpl <em>IFile Fragment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFileFragmentImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIFileFragment()
	 * @generated
	 */
	int IFILE_FRAGMENT = 122;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__MTYPE = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mtext</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__MTEXT = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mstart Row</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__MSTART_ROW = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mstart Col</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__MSTART_COL = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__DESCRIPTION = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mstart Col Short</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__MSTART_COL_SHORT = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mend Row</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__MEND_ROW = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mend Col Short</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__MEND_COL_SHORT = IMODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Msubject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__MSUBJECT = IMODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__TAGS = IMODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Fragments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__FRAGMENTS = IMODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The number of structural features of the '<em>IFile Fragment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IFile Fragment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFILE_FRAGMENT_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFlowImpl <em>IFlow</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFlowImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIFlow()
	 * @generated
	 */
	int IFLOW = 123;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IFlow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IFlow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFlowItemImpl <em>IFlow Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFlowItemImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIFlowItem()
	 * @generated
	 */
	int IFLOW_ITEM = 124;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW_ITEM__EANNOTATIONS = ICLASSIFIER__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW_ITEM__DISPLAY_NAME = ICLASSIFIER__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IFlow Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW_ITEM_FEATURE_COUNT = ICLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW_ITEM___GET_EANNOTATION__STRING = ICLASSIFIER___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IFlow Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOW_ITEM_OPERATION_COUNT = ICLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFlowchartImpl <em>IFlowchart</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFlowchartImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIFlowchart()
	 * @generated
	 */
	int IFLOWCHART = 125;

	/**
	 * The number of structural features of the '<em>IFlowchart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOWCHART_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>IFlowchart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFLOWCHART_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFolderImpl <em>IFolder</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IFolderImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIFolder()
	 * @generated
	 */
	int IFOLDER = 126;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__MODIFIED_TIME_WEAK = FILES_TYPE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__ID = FILES_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__UML_DEPENDENCY_ID = FILES_TYPE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__LAST_ID = FILES_TYPE__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__MY_STATE = FILES_TYPE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Mpath</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__MPATH = FILES_TYPE__MPATH;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__OBJECT_CREATION = FILES_TYPE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__NAME = FILES_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__ELEMENTS = FILES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Files</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__FILES = FILES_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__REQUIREMEN_TRACABILITY_HANDLE = FILES_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER__CODE_UPDATE_CG_TIME = FILES_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>IFolder</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER_FEATURE_COUNT = FILES_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>IFolder</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFOLDER_OPERATION_COUNT = FILES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IForkImpl <em>IFork</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IForkImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIFork()
	 * @generated
	 */
	int IFORK = 127;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK__ID = ITS_TARGET_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK__MY_STATE = ITS_TARGET_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK__NAME = ITS_TARGET_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK__MODIFIED_TIME_WEAK = ITS_TARGET_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK__DESCRIPTION = ITS_TARGET_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK__PARENT = ITS_TARGET_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Connector Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK__CONNECTOR_TYPE = ITS_TARGET_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK__OBJECT_CREATION = ITS_TARGET_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK__UML_DEPENDENCY_ID = ITS_TARGET_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>IFork</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK_FEATURE_COUNT = ITS_TARGET_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>IFork</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFORK_OPERATION_COUNT = ITS_TARGET_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IGeneralizationImpl <em>IGeneralization</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IGeneralizationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIGeneralization()
	 * @generated
	 */
	int IGENERALIZATION = 128;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__DEPENDS_ON = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Inheritance Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__INHERITANCE_TYPE = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Is Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__IS_VIRTUAL = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__STEREOTYPES = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__DESCRIPTION = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Ti</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__TI = IMODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION__ANNOTATIONS = IMODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>IGeneralization</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IGeneralization</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGENERALIZATION_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IGuardImpl <em>IGuard</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IGuardImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIGuard()
	 * @generated
	 */
	int IGUARD = 129;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD__BODY = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>IGuard</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IGuard</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IGUARD_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IHandleWithDataImpl <em>IHandle With Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IHandleWithDataImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIHandleWithData()
	 * @generated
	 */
	int IHANDLE_WITH_DATA = 130;

	/**
	 * The feature id for the '<em><b>M2 Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHANDLE_WITH_DATA__M2_CLASS = 0;

	/**
	 * The feature id for the '<em><b>Filename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHANDLE_WITH_DATA__FILENAME = 1;

	/**
	 * The feature id for the '<em><b>Subsystem</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHANDLE_WITH_DATA__SUBSYSTEM = 2;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHANDLE_WITH_DATA__CLASS = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHANDLE_WITH_DATA__NAME = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHANDLE_WITH_DATA__ID = 5;

	/**
	 * The feature id for the '<em><b>Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHANDLE_WITH_DATA__DATA = 6;

	/**
	 * The number of structural features of the '<em>IHandle With Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHANDLE_WITH_DATA_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>IHandle With Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHANDLE_WITH_DATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IHistoryConnectorImpl <em>IHistory Connector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IHistoryConnectorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIHistoryConnector()
	 * @generated
	 */
	int IHISTORY_CONNECTOR = 131;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR__ID = ITS_TARGET_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR__NAME = ITS_TARGET_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR__PARENT = ITS_TARGET_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Connector Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR__CONNECTOR_TYPE = ITS_TARGET_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR__MY_STATE = ITS_TARGET_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR__MODIFIED_TIME_WEAK = ITS_TARGET_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR__OBJECT_CREATION = ITS_TARGET_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR__UML_DEPENDENCY_ID = ITS_TARGET_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>IHistory Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR_FEATURE_COUNT = ITS_TARGET_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>IHistory Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHISTORY_CONNECTOR_OPERATION_COUNT = ITS_TARGET_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IHyperLinkImpl <em>IHyper Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IHyperLinkImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIHyperLink()
	 * @generated
	 */
	int IHYPER_LINK = 132;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__EANNOTATIONS = IDEPENDENCY__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__DISPLAY_NAME = IDEPENDENCY__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__UML_DEPENDENCY_ID = IDEPENDENCY__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__OBJECT_CREATION = IDEPENDENCY__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__ID = IDEPENDENCY__ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__MY_STATE = IDEPENDENCY__MY_STATE;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__PROPERTIES = IDEPENDENCY__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__NAME = IDEPENDENCY__NAME;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__STEREOTYPES = IDEPENDENCY__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__MODIFIED_TIME_WEAK = IDEPENDENCY__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__DEPENDS_ON = IDEPENDENCY__DEPENDS_ON;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__TAGS = IDEPENDENCY__TAGS;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__ANNOTATIONS = IDEPENDENCY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__DEPENDENCIES = IDEPENDENCY__DEPENDENCIES;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__DESCRIPTION = IDEPENDENCY__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__REQUIREMEN_TRACABILITY_HANDLE = IDEPENDENCY__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK__CODE_UPDATE_CG_TIME = IDEPENDENCY__CODE_UPDATE_CG_TIME;

	/**
	 * The number of structural features of the '<em>IHyper Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK_FEATURE_COUNT = IDEPENDENCY_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK___GET_EANNOTATION__STRING = IDEPENDENCY___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IHyper Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IHYPER_LINK_OPERATION_COUNT = IDEPENDENCY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInformationFlowImpl <em>IInformation Flow</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInformationFlowImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInformationFlow()
	 * @generated
	 */
	int IINFORMATION_FLOW = 133;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__EANNOTATIONS = DECLARATIVES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__DISPLAY_NAME = DECLARATIVES_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__ID = DECLARATIVES_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__MY_STATE = DECLARATIVES_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__NAME = DECLARATIVES_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Conveyed</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__CONVEYED = DECLARATIVES_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>End1 </b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__END1_ = DECLARATIVES_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>End2 </b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__END2_ = DECLARATIVES_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Direction </b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__DIRECTION_ = DECLARATIVES_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__MODIFIED_TIME_WEAK = DECLARATIVES_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__DESCRIPTION = DECLARATIVES_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>End1 Object Port </b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__END1_OBJECT_PORT_ = DECLARATIVES_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>End2 Object Port </b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__END2_OBJECT_PORT_ = DECLARATIVES_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__REQUIREMEN_TRACABILITY_HANDLE = DECLARATIVES_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__HYPER_LINKS = DECLARATIVES_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__DEPENDENCIES = DECLARATIVES_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__ANNOTATIONS = DECLARATIVES_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__OBJECT_CREATION = DECLARATIVES_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__UML_DEPENDENCY_ID = DECLARATIVES_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__STEREOTYPES = DECLARATIVES_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW__TAGS = DECLARATIVES_TYPE_FEATURE_COUNT + 20;

	/**
	 * The number of structural features of the '<em>IInformation Flow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW_FEATURE_COUNT = DECLARATIVES_TYPE_FEATURE_COUNT + 21;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW___GET_EANNOTATION__STRING = DECLARATIVES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>IInformation Flow</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_FLOW_OPERATION_COUNT = DECLARATIVES_TYPE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInformationItemImpl <em>IInformation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInformationItemImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInformationItem()
	 * @generated
	 */
	int IINFORMATION_ITEM = 134;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__LAST_ID = DECLARATIVES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__ID = DECLARATIVES_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__MY_STATE = DECLARATIVES_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__NAME = DECLARATIVES_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__REQUIREMEN_TRACABILITY_HANDLE = DECLARATIVES_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__MODIFIED_TIME_WEAK = DECLARATIVES_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__DESCRIPTION = DECLARATIVES_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Represented</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__REPRESENTED = DECLARATIVES_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__ANNOTATIONS = DECLARATIVES_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__OBJECT_CREATION = DECLARATIVES_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM__UML_DEPENDENCY_ID = DECLARATIVES_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>IInformation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM_FEATURE_COUNT = DECLARATIVES_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of operations of the '<em>IInformation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINFORMATION_ITEM_OPERATION_COUNT = DECLARATIVES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IRelationImpl <em>IRelation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IRelationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIRelation()
	 * @generated
	 */
	int IRELATION = 180;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRELATION__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRELATION__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IRelation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRELATION_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRELATION___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IRelation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRELATION_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInstanceImpl <em>IInstance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInstanceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInstance()
	 * @generated
	 */
	int IINSTANCE = 135;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE__EANNOTATIONS = IRELATION__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE__DISPLAY_NAME = IRELATION__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE__MODIFIED_TIME_WEAK = IRELATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE__ID = IRELATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE__INVERSE = IRELATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE__MY_STATE = IRELATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE__NAME = IRELATION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>IInstance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_FEATURE_COUNT = IRELATION_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE___GET_EANNOTATION__STRING = IRELATION___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IInstance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_OPERATION_COUNT = IRELATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInstanceSlotImpl <em>IInstance Slot</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInstanceSlotImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInstanceSlot()
	 * @generated
	 */
	int IINSTANCE_SLOT = 136;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SLOT__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SLOT__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IInstance Slot</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SLOT_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SLOT___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IInstance Slot</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SLOT_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInstanceSpecificationImpl <em>IInstance Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInstanceSpecificationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInstanceSpecification()
	 * @generated
	 */
	int IINSTANCE_SPECIFICATION = 137;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SPECIFICATION__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SPECIFICATION__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IInstance Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SPECIFICATION_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SPECIFICATION___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IInstance Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_SPECIFICATION_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInstanceValueImpl <em>IInstance Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInstanceValueImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInstanceValue()
	 * @generated
	 */
	int IINSTANCE_VALUE = 138;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_VALUE__EANNOTATIONS = IVALUE_SPECIFICATION__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_VALUE__DISPLAY_NAME = IVALUE_SPECIFICATION__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_VALUE__ID = IVALUE_SPECIFICATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_VALUE__MODIFIED_TIME_WEAK = IVALUE_SPECIFICATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_VALUE__VALUE = IVALUE_SPECIFICATION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>IInstance Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_VALUE_FEATURE_COUNT = IVALUE_SPECIFICATION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_VALUE___GET_EANNOTATION__STRING = IVALUE_SPECIFICATION___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IInstance Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINSTANCE_VALUE_OPERATION_COUNT = IVALUE_SPECIFICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInteractionOccurrenceImpl <em>IInteraction Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInteractionOccurrenceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInteractionOccurrence()
	 * @generated
	 */
	int IINTERACTION_OCCURRENCE = 139;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>MpRef SD</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__MPREF_SD = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__STEREOTYPES = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__TAGS = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>IInteraction Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IInteraction Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OCCURRENCE_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInteractionOperandImpl <em>IInteraction Operand</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInteractionOperandImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInteractionOperand()
	 * @generated
	 */
	int IINTERACTION_OPERAND = 140;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__EANNOTATIONS = ICOLLABORATION__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__DISPLAY_NAME = ICOLLABORATION__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__ID = ICOLLABORATION__ID;

	/**
	 * The feature id for the '<em><b>Classifier Roles</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__CLASSIFIER_ROLES = ICOLLABORATION__CLASSIFIER_ROLES;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__MESSAGES = ICOLLABORATION__MESSAGES;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__ANNOTATIONS = ICOLLABORATION__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Association Roles</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__ASSOCIATION_ROLES = ICOLLABORATION__ASSOCIATION_ROLES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__MODIFIED_TIME_WEAK = ICOLLABORATION__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Combined Fragments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__COMBINED_FRAGMENTS = ICOLLABORATION__COMBINED_FRAGMENTS;

	/**
	 * The feature id for the '<em><b>PMessage Handler</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__PMESSAGE_HANDLER = ICOLLABORATION__PMESSAGE_HANDLER;

	/**
	 * The feature id for the '<em><b>Interaction Occurrences</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__INTERACTION_OCCURRENCES = ICOLLABORATION__INTERACTION_OCCURRENCES;

	/**
	 * The feature id for the '<em><b>Execution Occurrences</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__EXECUTION_OCCURRENCES = ICOLLABORATION__EXECUTION_OCCURRENCES;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__OBJECT_CREATION = ICOLLABORATION__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__UML_DEPENDENCY_ID = ICOLLABORATION__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__MY_STATE = ICOLLABORATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__NAME = ICOLLABORATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Interaction Constraint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND__INTERACTION_CONSTRAINT = ICOLLABORATION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>IInteraction Operand</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND_FEATURE_COUNT = ICOLLABORATION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND___GET_EANNOTATION__STRING = ICOLLABORATION___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IInteraction Operand</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERAND_OPERATION_COUNT = ICOLLABORATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInteractionOperatorImpl <em>IInteraction Operator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInteractionOperatorImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInteractionOperator()
	 * @generated
	 */
	int IINTERACTION_OPERATOR = 141;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERATOR__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERATOR__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IInteraction Operator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERATOR_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERATOR___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IInteraction Operator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERACTION_OPERATOR_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItsTriggerTypeImpl <em>Its Trigger Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItsTriggerTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getItsTriggerType()
	 * @generated
	 */
	int ITS_TRIGGER_TYPE = 221;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TRIGGER_TYPE__MODIFIED_TIME_WEAK = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TRIGGER_TYPE__ID = 1;

	/**
	 * The feature id for the '<em><b>Info</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TRIGGER_TYPE__INFO = 2;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TRIGGER_TYPE__UML_DEPENDENCY_ID = 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TRIGGER_TYPE__MY_STATE = 4;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TRIGGER_TYPE__OBJECT_CREATION = 5;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TRIGGER_TYPE__BODY = 6;

	/**
	 * The number of structural features of the '<em>Its Trigger Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TRIGGER_TYPE_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>Its Trigger Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_TRIGGER_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInterfaceItemTriggerImpl <em>IInterface Item Trigger</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInterfaceItemTriggerImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInterfaceItemTrigger()
	 * @generated
	 */
	int IINTERFACE_ITEM_TRIGGER = 143;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER__MODIFIED_TIME_WEAK = ITS_TRIGGER_TYPE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER__ID = ITS_TRIGGER_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Info</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER__INFO = ITS_TRIGGER_TYPE__INFO;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER__UML_DEPENDENCY_ID = ITS_TRIGGER_TYPE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER__MY_STATE = ITS_TRIGGER_TYPE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER__OBJECT_CREATION = ITS_TRIGGER_TYPE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER__BODY = ITS_TRIGGER_TYPE__BODY;

	/**
	 * The feature id for the '<em><b>Its Interface Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER__ITS_INTERFACE_ITEM = ITS_TRIGGER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER__INHERITS_FROM_HANDLE = ITS_TRIGGER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>IInterface Item Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER_FEATURE_COUNT = ITS_TRIGGER_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>IInterface Item Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERFACE_ITEM_TRIGGER_OPERATION_COUNT = ITS_TRIGGER_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInternalHyperlinkImpl <em>IInternal Hyperlink</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IInternalHyperlinkImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIInternalHyperlink()
	 * @generated
	 */
	int IINTERNAL_HYPERLINK = 144;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERNAL_HYPERLINK__EANNOTATIONS = HYPER_LINKS_TYPE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERNAL_HYPERLINK__DISPLAY_NAME = HYPER_LINKS_TYPE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERNAL_HYPERLINK__TARGET = HYPER_LINKS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>IInternal Hyperlink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERNAL_HYPERLINK_FEATURE_COUNT = HYPER_LINKS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERNAL_HYPERLINK___GET_EANNOTATION__STRING = HYPER_LINKS_TYPE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IInternal Hyperlink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IINTERNAL_HYPERLINK_OPERATION_COUNT = HYPER_LINKS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItsLabelTypeImpl <em>Its Label Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItsLabelTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getItsLabelType()
	 * @generated
	 */
	int ITS_LABEL_TYPE = 218;

	/**
	 * The number of structural features of the '<em>Its Label Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_LABEL_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Its Label Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITS_LABEL_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ILabelImpl <em>ILabel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ILabelImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getILabel()
	 * @generated
	 */
	int ILABEL = 145;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__ID = ITS_LABEL_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Its Trigger</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__ITS_TRIGGER = ITS_LABEL_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Its Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__ITS_ACTION = ITS_LABEL_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Its Guard</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__ITS_GUARD = ITS_LABEL_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__MODIFIED_TIME_WEAK = ITS_LABEL_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__MY_STATE = ITS_LABEL_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__INHERITS_FROM_HANDLE = ITS_LABEL_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__CODE_UPDATE_CG_TIME = ITS_LABEL_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__OBJECT_CREATION = ITS_LABEL_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL__UML_DEPENDENCY_ID = ITS_LABEL_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>ILabel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL_FEATURE_COUNT = ITS_LABEL_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>ILabel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILABEL_OPERATION_COUNT = ITS_LABEL_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ILinkImpl <em>ILink</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ILinkImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getILink()
	 * @generated
	 */
	int ILINK = 146;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__ID = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__MULTIPLICITY = IUNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__NAME = IUNIT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Other Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__OTHER_CLASS = IUNIT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__INVERSE = IUNIT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Link Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__LINK_NAME = IUNIT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Link Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__LINK_TYPE = IUNIT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK__MY_STATE = IUNIT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>ILink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ILink</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ILinkInstanceImpl <em>ILink Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ILinkInstanceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getILinkInstance()
	 * @generated
	 */
	int ILINK_INSTANCE = 147;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK_INSTANCE__ID = COMPONENTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK_INSTANCE__NAME = COMPONENTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>To Link</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK_INSTANCE__TO_LINK = COMPONENTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>From Link</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK_INSTANCE__FROM_LINK = COMPONENTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Instantiates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK_INSTANCE__INSTANTIATES = COMPONENTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>ILink Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK_INSTANCE_FEATURE_COUNT = COMPONENTS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>ILink Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILINK_INSTANCE_OPERATION_COUNT = COMPONENTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ILiteralSpecificationImpl <em>ILiteral Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ILiteralSpecificationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getILiteralSpecification()
	 * @generated
	 */
	int ILITERAL_SPECIFICATION = 148;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION__EANNOTATIONS = IVALUE_SPECIFICATION__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION__DISPLAY_NAME = IVALUE_SPECIFICATION__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION__ID = IVALUE_SPECIFICATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION__MODIFIED_TIME_WEAK = IVALUE_SPECIFICATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION__VALUE = IVALUE_SPECIFICATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION__MY_STATE = IVALUE_SPECIFICATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION__NAME = IVALUE_SPECIFICATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION__CODE_UPDATE_CG_TIME = IVALUE_SPECIFICATION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>ILiteral Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION_FEATURE_COUNT = IVALUE_SPECIFICATION_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION___GET_EANNOTATION__STRING = IVALUE_SPECIFICATION___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ILiteral Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ILITERAL_SPECIFICATION_OPERATION_COUNT = IVALUE_SPECIFICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMHyperLinkImpl <em>IM Hyper Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMHyperLinkImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIMHyperLink()
	 * @generated
	 */
	int IM_HYPER_LINK = 149;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__EANNOTATIONS = HYPER_LINKS_TYPE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__DISPLAY_NAME = HYPER_LINKS_TYPE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__ID = HYPER_LINKS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__PROPERTIES = HYPER_LINKS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__MODIFIED_TIME_WEAK = HYPER_LINKS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__DEPENDS_ON = HYPER_LINKS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Link Disp Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__LINK_DISP_NAME = HYPER_LINKS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Link Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__LINK_TYPE = HYPER_LINKS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Is Configuration File Hyper Link</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__IS_CONFIGURATION_FILE_HYPER_LINK = HYPER_LINKS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Link Target</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__LINK_TARGET = HYPER_LINKS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__DESCRIPTION = HYPER_LINKS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__REQUIREMEN_TRACABILITY_HANDLE = HYPER_LINKS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__OBJECT_CREATION = HYPER_LINKS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK__UML_DEPENDENCY_ID = HYPER_LINKS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>IM Hyper Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK_FEATURE_COUNT = HYPER_LINKS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK___GET_EANNOTATION__STRING = HYPER_LINKS_TYPE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IM Hyper Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IM_HYPER_LINK_OPERATION_COUNT = HYPER_LINKS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMSCImpl <em>IMSC</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMSCImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIMSC()
	 * @generated
	 */
	int IMSC = 150;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__ID = DECLARATIVES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__MY_STATE = DECLARATIVES_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__PROPERTIES = DECLARATIVES_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__NAME = DECLARATIVES_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__LAST_MODIFIED_TIME = DECLARATIVES_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__GRAPHIC_CHART = DECLARATIVES_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__DEFAULT_SUBSYSTEM = DECLARATIVES_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MpI Collaboration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__MPI_COLLABORATION = DECLARATIVES_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__CMHEADER = DECLARATIVES_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__LAST_ID = DECLARATIVES_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__OWNER_HANDLE = DECLARATIVES_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__DESCRIPTION = DECLARATIVES_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__MODIFIED_TIME_WEAK = DECLARATIVES_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__STEREOTYPES = DECLARATIVES_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__TAGS = DECLARATIVES_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__REQUIREMEN_TRACABILITY_HANDLE = DECLARATIVES_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__ANNOTATIONS = DECLARATIVES_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__OBJECT_CREATION = DECLARATIVES_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC__UML_DEPENDENCY_ID = DECLARATIVES_TYPE_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>IMSC</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC_FEATURE_COUNT = DECLARATIVES_TYPE_FEATURE_COUNT + 19;

	/**
	 * The number of operations of the '<em>IMSC</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMSC_OPERATION_COUNT = DECLARATIVES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.MatrixInstancesTypeImpl <em>Matrix Instances Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.MatrixInstancesTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getMatrixInstancesType()
	 * @generated
	 */
	int MATRIX_INSTANCES_TYPE = 229;

	/**
	 * The number of structural features of the '<em>Matrix Instances Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MATRIX_INSTANCES_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Matrix Instances Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MATRIX_INSTANCES_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMatrixInstanceImpl <em>IMatrix Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMatrixInstanceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIMatrixInstance()
	 * @generated
	 */
	int IMATRIX_INSTANCE = 151;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__ID = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__MY_STATE = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__NAME = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__MODIFIED_TIME_WEAK = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Layout Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__LAYOUT_HANDLE = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>From Scope Handles</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__FROM_SCOPE_HANDLES = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>To Scope Handles</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__TO_SCOPE_HANDLES = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__STEREOTYPES = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>MInclude Descendants to</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__MINCLUDE_DESCENDANTS_TO = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE__PROPERTIES = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>IMatrix Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE_FEATURE_COUNT = MATRIX_INSTANCES_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>IMatrix Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_INSTANCE_OPERATION_COUNT = MATRIX_INSTANCES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMatrixLayoutImpl <em>IMatrix Layout</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMatrixLayoutImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIMatrixLayout()
	 * @generated
	 */
	int IMATRIX_LAYOUT = 152;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__ID = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__MY_STATE = IUNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__NAME = IUNIT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__MODIFIED_TIME_WEAK = IUNIT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>From Element Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__FROM_ELEMENT_TYPES = IUNIT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>To Element Types</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__TO_ELEMENT_TYPES = IUNIT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Cell Element Types</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__CELL_ELEMENT_TYPES = IUNIT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT__DESCRIPTION = IUNIT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>IMatrix Layout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IMatrix Layout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_LAYOUT_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMatrixViewImpl <em>IMatrix View</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMatrixViewImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIMatrixView()
	 * @generated
	 */
	int IMATRIX_VIEW = 153;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_VIEW__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_VIEW__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IMatrix View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_VIEW_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_VIEW___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IMatrix View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMATRIX_VIEW_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMessageImpl <em>IMessage</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMessageImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIMessage()
	 * @generated
	 */
	int IMESSAGE = 154;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MY_STATE = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Msz Sequence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MSZ_SEQUENCE = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Msz Actual Args</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MSZ_ACTUAL_ARGS = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Msz Return Val</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MSZ_RETURN_VAL = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>MpReceiver</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MPRECEIVER = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>MpSender</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MPSENDER = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>MpFormal Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MPFORMAL_MESSAGE = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>MeType</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__METYPE = IMODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>MpCommunication Connection</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MPCOMMUNICATION_CONNECTION = IMODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Mfree Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MFREE_TEXT = IMODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__STEREOTYPES = IMODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__TAGS = IMODEL_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__PROPERTIES = IMODEL_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Mtarget Exec</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MTARGET_EXEC = IMODEL_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Msrc Exec</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__MSRC_EXEC = IMODEL_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 19;

	/**
	 * The number of structural features of the '<em>IMessage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 20;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IMessage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMessagePointImpl <em>IMessage Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMessagePointImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIMessagePoint()
	 * @generated
	 */
	int IMESSAGE_POINT = 155;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE_POINT__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE_POINT__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IMessage Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE_POINT_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE_POINT___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IMessage Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMESSAGE_POINT_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMetaLinkHandleImpl <em>IMeta Link Handle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMetaLinkHandleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIMetaLinkHandle()
	 * @generated
	 */
	int IMETA_LINK_HANDLE = 156;

	/**
	 * The feature id for the '<em><b>M2 Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMETA_LINK_HANDLE__M2_CLASS = INVERSE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Filename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMETA_LINK_HANDLE__FILENAME = INVERSE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Subsystem</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMETA_LINK_HANDLE__SUBSYSTEM = INVERSE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMETA_LINK_HANDLE__CLASS = INVERSE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMETA_LINK_HANDLE__NAME = INVERSE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMETA_LINK_HANDLE__ID = INVERSE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>IMeta Link Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMETA_LINK_HANDLE_FEATURE_COUNT = INVERSE_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>IMeta Link Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMETA_LINK_HANDLE_OPERATION_COUNT = INVERSE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IModuleImpl <em>IModule</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IModuleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIModule()
	 * @generated
	 */
	int IMODULE = 158;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__EANNOTATIONS = IINSTANCE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__DISPLAY_NAME = IINSTANCE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__MODIFIED_TIME_WEAK = IINSTANCE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__ID = IINSTANCE__ID;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__INVERSE = IINSTANCE__INVERSE;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__MY_STATE = IINSTANCE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__NAME = IINSTANCE__NAME;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__MULTIPLICITY = IINSTANCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__STEREOTYPES = IINSTANCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__DESCRIPTION = IINSTANCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__HYPER_LINKS = IINSTANCE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Other Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__OTHER_CLASS = IINSTANCE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Implicit Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__IMPLICIT_CLASS = IINSTANCE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__PROPERTIES = IINSTANCE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__REQUIREMEN_TRACABILITY_HANDLE = IINSTANCE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Part Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE__PART_KIND = IINSTANCE_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>IModule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE_FEATURE_COUNT = IINSTANCE_FEATURE_COUNT + 9;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE___GET_EANNOTATION__STRING = IINSTANCE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IModule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMODULE_OPERATION_COUNT = IINSTANCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMultiplicityItemImpl <em>IMultiplicity Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IMultiplicityItemImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIMultiplicityItem()
	 * @generated
	 */
	int IMULTIPLICITY_ITEM = 159;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMULTIPLICITY_ITEM__NAME = 0;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMULTIPLICITY_ITEM__COUNT = 1;

	/**
	 * The number of structural features of the '<em>IMultiplicity Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMULTIPLICITY_ITEM_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>IMultiplicity Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMULTIPLICITY_ITEM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.INodeImpl <em>INode</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.INodeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getINode()
	 * @generated
	 */
	int INODE = 160;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INODE__EANNOTATIONS = ICLASSIFIER__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INODE__DISPLAY_NAME = ICLASSIFIER__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>INode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INODE_FEATURE_COUNT = ICLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INODE___GET_EANNOTATION__STRING = ICLASSIFIER___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>INode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INODE_OPERATION_COUNT = ICLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ObjectLinksTypeImpl <em>Object Links Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ObjectLinksTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getObjectLinksType()
	 * @generated
	 */
	int OBJECT_LINKS_TYPE = 231;

	/**
	 * The number of structural features of the '<em>Object Links Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBJECT_LINKS_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Object Links Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBJECT_LINKS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IObjectLinkImpl <em>IObject Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IObjectLinkImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIObjectLink()
	 * @generated
	 */
	int IOBJECT_LINK = 161;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__MODIFIED_TIME_WEAK = OBJECT_LINKS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__ID = OBJECT_LINKS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__MY_STATE = OBJECT_LINKS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__NAME = OBJECT_LINKS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__EANNOTATIONS = OBJECT_LINKS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__DISPLAY_NAME = OBJECT_LINKS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__STEREOTYPES = OBJECT_LINKS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__TAGS = OBJECT_LINKS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>To Link</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__TO_LINK = OBJECT_LINKS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>From Link</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__FROM_LINK = OBJECT_LINKS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Instantiates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__INSTANTIATES = OBJECT_LINKS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>End1 Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__END1_MULTIPLICITY = OBJECT_LINKS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>End2 Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__END2_MULTIPLICITY = OBJECT_LINKS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>To Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__TO_PORT = OBJECT_LINKS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>From Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__FROM_PORT = OBJECT_LINKS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__DESCRIPTION = OBJECT_LINKS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__REQUIREMEN_TRACABILITY_HANDLE = OBJECT_LINKS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__CODE_UPDATE_CG_TIME = OBJECT_LINKS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__OBJECT_CREATION = OBJECT_LINKS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK__UML_DEPENDENCY_ID = OBJECT_LINKS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The number of structural features of the '<em>IObject Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_FEATURE_COUNT = OBJECT_LINKS_TYPE_FEATURE_COUNT + 20;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK___GET_EANNOTATION__STRING = OBJECT_LINKS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>IObject Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_OPERATION_COUNT = OBJECT_LINKS_TYPE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IObjectLinkHandleImpl <em>IObject Link Handle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IObjectLinkHandleImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIObjectLinkHandle()
	 * @generated
	 */
	int IOBJECT_LINK_HANDLE = 162;

	/**
	 * The feature id for the '<em><b>M2 Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_HANDLE__M2_CLASS = 0;

	/**
	 * The feature id for the '<em><b>Filename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_HANDLE__FILENAME = 1;

	/**
	 * The feature id for the '<em><b>Subsystem</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_HANDLE__SUBSYSTEM = 2;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_HANDLE__CLASS = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_HANDLE__NAME = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_HANDLE__ID = 5;

	/**
	 * The number of structural features of the '<em>IObject Link Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_HANDLE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>IObject Link Handle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_LINK_HANDLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IObjectModelDiagramImpl <em>IObject Model Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IObjectModelDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIObjectModelDiagram()
	 * @generated
	 */
	int IOBJECT_MODEL_DIAGRAM = 163;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__EANNOTATIONS = IDIAGRAM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__DISPLAY_NAME = IDIAGRAM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__ID = IDIAGRAM__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__LAST_MODIFIED_TIME = IDIAGRAM__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__DEFAULT_SUBSYSTEM = IDIAGRAM__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__DESCRIPTION = IDIAGRAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__UML_DEPENDENCY_ID = IDIAGRAM__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__LAST_ID = IDIAGRAM__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__MY_STATE = IDIAGRAM__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__OWNER_HANDLE = IDIAGRAM__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__OBJECT_CREATION = IDIAGRAM__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__NAME = IDIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__CMHEADER = IDIAGRAM__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__PROPERTIES = IDIAGRAM__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__STEREOTYPES = IDIAGRAM__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__MODIFIED_TIME_WEAK = IDIAGRAM__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__GRAPHIC_CHART = IDIAGRAM__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__ANNOTATIONS = IDIAGRAM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__CODE_UPDATE_CG_TIME = IDIAGRAM__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM__HYPER_LINKS = IDIAGRAM__HYPER_LINKS;

	/**
	 * The number of structural features of the '<em>IObject Model Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM_FEATURE_COUNT = IDIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM___GET_EANNOTATION__STRING = IDIAGRAM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IObject Model Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_MODEL_DIAGRAM_OPERATION_COUNT = IDIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IObjectNodeImpl <em>IObject Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IObjectNodeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIObjectNode()
	 * @generated
	 */
	int IOBJECT_NODE = 164;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__EANNOTATIONS = ISTATE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__DISPLAY_NAME = ISTATE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__MODIFIED_TIME_WEAK = ISTATE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__ID = ISTATE__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__DESCRIPTION = ISTATE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__UML_DEPENDENCY_ID = ISTATE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__MY_STATE = ISTATE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__STEREOTYPES = ISTATE__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__OBJECT_CREATION = ISTATE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__NAME = ISTATE__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__PARENT = ISTATE__PARENT;

	/**
	 * The feature id for the '<em><b>State Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__STATE_TYPE = ISTATE__STATE_TYPE;

	/**
	 * The feature id for the '<em><b>Default Trans</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__DEFAULT_TRANS = ISTATE__DEFAULT_TRANS;

	/**
	 * The feature id for the '<em><b>Entry Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__ENTRY_ACTION = ISTATE__ENTRY_ACTION;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__INHERITS_FROM_HANDLE = ISTATE__INHERITS_FROM_HANDLE;

	/**
	 * The feature id for the '<em><b>Exit Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__EXIT_ACTION = ISTATE__EXIT_ACTION;

	/**
	 * The feature id for the '<em><b>Nested State Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__NESTED_STATE_CHART = ISTATE__NESTED_STATE_CHART;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__REQUIREMEN_TRACABILITY_HANDLE = ISTATE__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__ANNOTATIONS = ISTATE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__DEPENDENCIES = ISTATE__DEPENDENCIES;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__THE_MAIN_DIAGRAM = ISTATE__THE_MAIN_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Swimlane</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__SWIMLANE = ISTATE__SWIMLANE;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__CODE_UPDATE_CG_TIME = ISTATE__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Represents</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__REPRESENTS = ISTATE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>The In State</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__THE_IN_STATE = ISTATE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>In State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE__IN_STATE = ISTATE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>IObject Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE_FEATURE_COUNT = ISTATE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE___GET_EANNOTATION__STRING = ISTATE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IObject Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOBJECT_NODE_OPERATION_COUNT = ISTATE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IOperationImpl <em>IOperation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IOperationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIOperation()
	 * @generated
	 */
	int IOPERATION = 165;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOPERATION__EANNOTATIONS = IINTERFACE_ITEM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOPERATION__DISPLAY_NAME = IINTERFACE_ITEM__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>IOperation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOPERATION_FEATURE_COUNT = IINTERFACE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOPERATION___GET_EANNOTATION__STRING = IINTERFACE_ITEM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IOperation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IOPERATION_OPERATION_COUNT = IINTERFACE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPackageImpl <em>IPackage</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPackageImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIPackage()
	 * @generated
	 */
	int IPACKAGE = 166;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__MODIFIED_TIME_WEAK = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__ID = IUNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__DESCRIPTION = IUNIT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__UML_DEPENDENCY_ID = IUNIT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__LAST_ID = IUNIT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__MY_STATE = IUNIT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__ANNOTATIONS = IUNIT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__OBJECT_CREATION = IUNIT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__STEREOTYPES = IUNIT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__NAME = IUNIT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__PROPERTIES = IUNIT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE__CMHEADER = IUNIT_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>IPackage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 12;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IPackage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPACKAGE_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPanelDiagramImpl <em>IPanel Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPanelDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIPanelDiagram()
	 * @generated
	 */
	int IPANEL_DIAGRAM = 167;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__EANNOTATIONS = IDIAGRAM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__DISPLAY_NAME = IDIAGRAM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__ID = IDIAGRAM__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__LAST_MODIFIED_TIME = IDIAGRAM__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__DEFAULT_SUBSYSTEM = IDIAGRAM__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__DESCRIPTION = IDIAGRAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__UML_DEPENDENCY_ID = IDIAGRAM__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__LAST_ID = IDIAGRAM__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__MY_STATE = IDIAGRAM__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__OWNER_HANDLE = IDIAGRAM__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__OBJECT_CREATION = IDIAGRAM__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__NAME = IDIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__CMHEADER = IDIAGRAM__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__PROPERTIES = IDIAGRAM__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__STEREOTYPES = IDIAGRAM__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__MODIFIED_TIME_WEAK = IDIAGRAM__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__GRAPHIC_CHART = IDIAGRAM__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__ANNOTATIONS = IDIAGRAM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__CODE_UPDATE_CG_TIME = IDIAGRAM__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM__HYPER_LINKS = IDIAGRAM__HYPER_LINKS;

	/**
	 * The number of structural features of the '<em>IPanel Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM_FEATURE_COUNT = IDIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM___GET_EANNOTATION__STRING = IDIAGRAM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IPanel Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPANEL_DIAGRAM_OPERATION_COUNT = IDIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPartImpl <em>IPart</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPartImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIPart()
	 * @generated
	 */
	int IPART = 168;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__UML_DEPENDENCY_ID = ASSOCIATIONS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__OBJECT_CREATION = ASSOCIATIONS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__MODIFIED_TIME_WEAK = ASSOCIATIONS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__ID = ASSOCIATIONS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__MY_STATE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__NAME = ASSOCIATIONS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__REQUIREMEN_TRACABILITY_HANDLE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__DESCRIPTION = ASSOCIATIONS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__PROPERTIES = ASSOCIATIONS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Implicit Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__IMPLICIT_CLASS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__LAST_ID = ASSOCIATIONS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__MULTIPLICITY = ASSOCIATIONS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__EANNOTATIONS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__DISPLAY_NAME = ASSOCIATIONS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__STEREOTYPES = ASSOCIATIONS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Other Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__OTHER_CLASS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__INVERSE = ASSOCIATIONS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__DEPENDENCIES = ASSOCIATIONS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__TAGS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Initial Call Action</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__INITIAL_CALL_ACTION = ASSOCIATIONS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__CODE_UPDATE_CG_TIME = ASSOCIATIONS_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__THE_MAIN_DIAGRAM = ASSOCIATIONS_TYPE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Slots</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__SLOTS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART__HYPER_LINKS = ASSOCIATIONS_TYPE_FEATURE_COUNT + 23;

	/**
	 * The number of structural features of the '<em>IPart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART_FEATURE_COUNT = ASSOCIATIONS_TYPE_FEATURE_COUNT + 24;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART___GET_EANNOTATION__STRING = ASSOCIATIONS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>IPart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPART_OPERATION_COUNT = ASSOCIATIONS_TYPE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPinImpl <em>IPin</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPinImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIPin()
	 * @generated
	 */
	int IPIN = 169;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__EANNOTATIONS = ICONNECTOR__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__DISPLAY_NAME = ICONNECTOR__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__MODIFIED_TIME_WEAK = ICONNECTOR__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__ID = ICONNECTOR__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__DESCRIPTION = ICONNECTOR__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__UML_DEPENDENCY_ID = ICONNECTOR__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__MY_STATE = ICONNECTOR__MY_STATE;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__STEREOTYPES = ICONNECTOR__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__OBJECT_CREATION = ICONNECTOR__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__NAME = ICONNECTOR__NAME;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__PARENT = ICONNECTOR__PARENT;

	/**
	 * The feature id for the '<em><b>Connector Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__CONNECTOR_TYPE = ICONNECTOR__CONNECTOR_TYPE;

	/**
	 * The feature id for the '<em><b>Mtype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__MTYPE = ICONNECTOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mis Parameter Pin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__MIS_PARAMETER_PIN = ICONNECTOR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mcore Pin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN__MCORE_PIN = ICONNECTOR_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>IPin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN_FEATURE_COUNT = ICONNECTOR_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN___GET_EANNOTATION__STRING = ICONNECTOR___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IPin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPIN_OPERATION_COUNT = ICONNECTOR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPortImpl <em>IPort</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPortImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIPort()
	 * @generated
	 */
	int IPORT = 170;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__EANNOTATIONS = IINSTANCE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__DISPLAY_NAME = IINSTANCE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__MODIFIED_TIME_WEAK = IINSTANCE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__ID = IINSTANCE__ID;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__INVERSE = IINSTANCE__INVERSE;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__MY_STATE = IINSTANCE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__NAME = IINSTANCE__NAME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__REQUIREMEN_TRACABILITY_HANDLE = IINSTANCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__DESCRIPTION = IINSTANCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__PROPERTIES = IINSTANCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Implicit Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__IMPLICIT_CLASS = IINSTANCE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__MULTIPLICITY = IINSTANCE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Other Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__OTHER_CLASS = IINSTANCE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Behavioral</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__BEHAVIORAL = IINSTANCE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Reversed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__REVERSED = IINSTANCE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__STEREOTYPES = IINSTANCE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__TAGS = IINSTANCE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__OBJECT_CREATION = IINSTANCE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__UML_DEPENDENCY_ID = IINSTANCE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__LAST_ID = IINSTANCE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__DEPENDENCIES = IINSTANCE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT__ANNOTATIONS = IINSTANCE_FEATURE_COUNT + 14;

	/**
	 * The number of structural features of the '<em>IPort</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT_FEATURE_COUNT = IINSTANCE_FEATURE_COUNT + 15;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT___GET_EANNOTATION__STRING = IINSTANCE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IPort</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPORT_OPERATION_COUNT = IINSTANCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPrimitiveOperationImpl <em>IPrimitive Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPrimitiveOperationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIPrimitiveOperation()
	 * @generated
	 */
	int IPRIMITIVE_OPERATION = 171;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__VIRTUAL = OPERATIONS_TYPE__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__UML_DEPENDENCY_ID = OPERATIONS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__OBJECT_CREATION = OPERATIONS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__MODIFIED_TIME_WEAK = OPERATIONS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__ID = OPERATIONS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__MY_STATE = OPERATIONS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__NAME = OPERATIONS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__EANNOTATIONS = OPERATIONS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__DISPLAY_NAME = OPERATIONS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__PROPERTIES = OPERATIONS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__LAST_ID = OPERATIONS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Args</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__ARGS = OPERATIONS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Return Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__RETURN_TYPE = OPERATIONS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__ABSTRACT = OPERATIONS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__FINAL = OPERATIONS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Concurrency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__CONCURRENCY = OPERATIONS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Protection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__PROTECTION = OPERATIONS_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__STATIC = OPERATIONS_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__CONSTANT = OPERATIONS_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Its Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__ITS_BODY = OPERATIONS_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__TAGS = OPERATIONS_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__ANNOTATIONS = OPERATIONS_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__DEPENDENCIES = OPERATIONS_TYPE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__STEREOTYPES = OPERATIONS_TYPE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>My Return Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__MY_RETURN_TYPE = OPERATIONS_TYPE_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__DESCRIPTION = OPERATIONS_TYPE_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__REQUIREMEN_TRACABILITY_HANDLE = OPERATIONS_TYPE_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Declaratives</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__DECLARATIVES = OPERATIONS_TYPE_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Its Activity Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__ITS_ACTIVITY_GRAPH = OPERATIONS_TYPE_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Embeded Files</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__EMBEDED_FILES = OPERATIONS_TYPE_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__CODE_UPDATE_CG_TIME = OPERATIONS_TYPE_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Template Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION__TEMPLATE_PARAMETERS = OPERATIONS_TYPE_FEATURE_COUNT + 30;

	/**
	 * The number of structural features of the '<em>IPrimitive Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION_FEATURE_COUNT = OPERATIONS_TYPE_FEATURE_COUNT + 31;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION___GET_EANNOTATION__STRING = OPERATIONS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>IPrimitive Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRIMITIVE_OPERATION_OPERATION_COUNT = OPERATIONS_TYPE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IProfileImpl <em>IProfile</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IProfileImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIProfile()
	 * @generated
	 */
	int IPROFILE = 172;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__EANNOTATIONS = IPACKAGE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__DISPLAY_NAME = IPACKAGE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__MODIFIED_TIME_WEAK = IPACKAGE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__ID = IPACKAGE__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__DESCRIPTION = IPACKAGE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__UML_DEPENDENCY_ID = IPACKAGE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__LAST_ID = IPACKAGE__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__MY_STATE = IPACKAGE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__ANNOTATIONS = IPACKAGE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__OBJECT_CREATION = IPACKAGE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__STEREOTYPES = IPACKAGE__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__NAME = IPACKAGE__NAME;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__PROPERTIES = IPACKAGE__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__CMHEADER = IPACKAGE__CMHEADER;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__WEAK_CG_TIME = IPACKAGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__STRONG_CG_TIME = IPACKAGE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Declaratives</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__DECLARATIVES = IPACKAGE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Default Composite</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__DEFAULT_COMPOSITE = IPACKAGE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Events Base ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__EVENTS_BASE_ID = IPACKAGE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__CLASSES = IPACKAGE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Configuration Related Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__CONFIGURATION_RELATED_TIME = IPACKAGE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__TAGS = IPACKAGE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__TYPES = IPACKAGE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Matrix Layouts</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__MATRIX_LAYOUTS = IPACKAGE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>License</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE__LICENSE = IPACKAGE_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>IProfile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE_FEATURE_COUNT = IPACKAGE_FEATURE_COUNT + 11;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE___GET_EANNOTATION__STRING = IPACKAGE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IProfile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROFILE_OPERATION_COUNT = IPACKAGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IProjectImpl <em>IProject</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IProjectImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIProject()
	 * @generated
	 */
	int IPROJECT = 173;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__EANNOTATIONS = IPACKAGE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__DISPLAY_NAME = IPACKAGE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__MODIFIED_TIME_WEAK = IPACKAGE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__ID = IPACKAGE__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__DESCRIPTION = IPACKAGE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__UML_DEPENDENCY_ID = IPACKAGE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__LAST_ID = IPACKAGE__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__MY_STATE = IPACKAGE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__ANNOTATIONS = IPACKAGE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__OBJECT_CREATION = IPACKAGE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__STEREOTYPES = IPACKAGE__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__NAME = IPACKAGE__NAME;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__PROPERTIES = IPACKAGE__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__CMHEADER = IPACKAGE__CMHEADER;

	/**
	 * The feature id for the '<em><b>User Colors</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__USER_COLORS = IPACKAGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__DEFAULT_SUBSYSTEM = IPACKAGE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__COMPONENT = IPACKAGE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Multiplicities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__MULTIPLICITIES = IPACKAGE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Subsystems</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__SUBSYSTEMS = IPACKAGE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Diagrams</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__DIAGRAMS = IPACKAGE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Components</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__COMPONENTS = IPACKAGE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Panel Diagrams</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__PANEL_DIAGRAMS = IPACKAGE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__HYPER_LINKS = IPACKAGE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>MSCS</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__MSCS = IPACKAGE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>UC Diagrams</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__UC_DIAGRAMS = IPACKAGE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Collaboration Diagrams</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__COLLABORATION_DIAGRAMS = IPACKAGE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Declaratives</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__DECLARATIVES = IPACKAGE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Component Diagrams</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__COMPONENT_DIAGRAMS = IPACKAGE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Unit Scc Proj Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__UNIT_SCC_PROJ_NAME = IPACKAGE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Unit Scc Proj Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__UNIT_SCC_PROJ_PATH = IPACKAGE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__DEPENDENCIES = IPACKAGE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__CODE_UPDATE_CG_TIME = IPACKAGE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT__VERSION = IPACKAGE_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>IProject</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT_FEATURE_COUNT = IPACKAGE_FEATURE_COUNT + 19;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT___GET_EANNOTATION__STRING = IPACKAGE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IProject</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROJECT_OPERATION_COUNT = IPACKAGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPropertyImpl <em>IProperty</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPropertyImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIProperty()
	 * @generated
	 */
	int IPROPERTY = 174;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY__VALUE = 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY__TYPE = 2;

	/**
	 * The feature id for the '<em><b>Extra Type Info</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY__EXTRA_TYPE_INFO = 3;

	/**
	 * The number of structural features of the '<em>IProperty</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>IProperty</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.PropertiesTypeImpl <em>Properties Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.PropertiesTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getPropertiesType()
	 * @generated
	 */
	int PROPERTIES_TYPE = 236;

	/**
	 * The number of structural features of the '<em>Properties Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTIES_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Properties Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTIES_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPropertyContainerImpl <em>IProperty Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPropertyContainerImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIPropertyContainer()
	 * @generated
	 */
	int IPROPERTY_CONTAINER = 175;

	/**
	 * The feature id for the '<em><b>Subjects</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_CONTAINER__SUBJECTS = PROPERTIES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>IProperty Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_CONTAINER_FEATURE_COUNT = PROPERTIES_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>IProperty Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_CONTAINER_OPERATION_COUNT = PROPERTIES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPropertyMetaclassImpl <em>IProperty Metaclass</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPropertyMetaclassImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIPropertyMetaclass()
	 * @generated
	 */
	int IPROPERTY_METACLASS = 176;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_METACLASS__NAME = 0;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_METACLASS__PROPERTIES = 1;

	/**
	 * The number of structural features of the '<em>IProperty Metaclass</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_METACLASS_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>IProperty Metaclass</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_METACLASS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPropertySubjectImpl <em>IProperty Subject</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IPropertySubjectImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIPropertySubject()
	 * @generated
	 */
	int IPROPERTY_SUBJECT = 177;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_SUBJECT__NAME = 0;

	/**
	 * The feature id for the '<em><b>Metaclasses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_SUBJECT__METACLASSES = 1;

	/**
	 * The number of structural features of the '<em>IProperty Subject</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_SUBJECT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>IProperty Subject</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPROPERTY_SUBJECT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IReceptionImpl <em>IReception</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IReceptionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIReception()
	 * @generated
	 */
	int IRECEPTION = 178;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__VIRTUAL = OPERATIONS_TYPE__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__ID = OPERATIONS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__MY_STATE = OPERATIONS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Args</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__ARGS = OPERATIONS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__EVENT = OPERATIONS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__MODIFIED_TIME_WEAK = OPERATIONS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__DEPENDENCIES = OPERATIONS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__LAST_ID = OPERATIONS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__REQUIREMEN_TRACABILITY_HANDLE = OPERATIONS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__DESCRIPTION = OPERATIONS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__OBJECT_CREATION = OPERATIONS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION__UML_DEPENDENCY_ID = OPERATIONS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>IReception</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION_FEATURE_COUNT = OPERATIONS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of operations of the '<em>IReception</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IRECEPTION_OPERATION_COUNT = OPERATIONS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IReferenceActivityImpl <em>IReference Activity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IReferenceActivityImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIReferenceActivity()
	 * @generated
	 */
	int IREFERENCE_ACTIVITY = 179;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__ID = DEPENDS_ON_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__NAME = DEPENDS_ON_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__STEREOTYPES = DEPENDS_ON_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__MODIFIED_TIME_WEAK = DEPENDS_ON_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__PARENT = DEPENDS_ON_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>State Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__STATE_TYPE = DEPENDS_ON_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Default Trans</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__DEFAULT_TRANS = DEPENDS_ON_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Swimlane</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__SWIMLANE = DEPENDS_ON_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Referenced Activity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__REFERENCED_ACTIVITY = DEPENDS_ON_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY__MY_STATE = DEPENDS_ON_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>IReference Activity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY_FEATURE_COUNT = DEPENDS_ON_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>IReference Activity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERENCE_ACTIVITY_OPERATION_COUNT = DEPENDS_ON_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IRequirementImpl <em>IRequirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IRequirementImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIRequirement()
	 * @generated
	 */
	int IREQUIREMENT = 181;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__EANNOTATIONS = IANNOTATION__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__DISPLAY_NAME = IANNOTATION__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__REQUIREMEN_TRACABILITY_HANDLE = IANNOTATION__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__DESCRIPTION = IANNOTATION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__UML_DEPENDENCY_ID = IANNOTATION__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__OBJECT_CREATION = IANNOTATION__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__TAGS = IANNOTATION__TAGS;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__BODY = IANNOTATION__BODY;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__ID = IANNOTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__NAME = IANNOTATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__ANNOTATIONS = IANNOTATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__MY_STATE = IANNOTATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__LAST_ID = IANNOTATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__STEREOTYPES = IANNOTATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__MODIFIED_TIME_WEAK = IANNOTATION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Req ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__REQ_ID = IANNOTATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__DEPENDENCIES = IANNOTATION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Anchors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__ANCHORS = IANNOTATION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__HYPER_LINKS = IANNOTATION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT__THE_MAIN_DIAGRAM = IANNOTATION_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>IRequirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT_FEATURE_COUNT = IANNOTATION_FEATURE_COUNT + 12;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT___GET_EANNOTATION__STRING = IANNOTATION___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IRequirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREQUIREMENT_OPERATION_COUNT = IANNOTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISendActionImpl <em>ISend Action</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISendActionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getISendAction()
	 * @generated
	 */
	int ISEND_ACTION = 182;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__EANNOTATIONS = IACTION__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__DISPLAY_NAME = IACTION__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__ID = IACTION__ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__MY_STATE = IACTION__MY_STATE;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__BODY = IACTION__BODY;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__MODIFIED_TIME_WEAK = IACTION__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__OBJECT_CREATION = IACTION__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__UML_DEPENDENCY_ID = IACTION__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>MhTarget</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__MHTARGET = IACTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>MhEvent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__MHEVENT = IACTION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Arg Val Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__ARG_VAL_COUNT = IACTION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Graph Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION__GRAPH_ELEMENTS = IACTION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>ISend Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION_FEATURE_COUNT = IACTION_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION___GET_EANNOTATION__STRING = IACTION___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ISend Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEND_ACTION_OPERATION_COUNT = IACTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISequenceDiagramImpl <em>ISequence Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISequenceDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getISequenceDiagram()
	 * @generated
	 */
	int ISEQUENCE_DIAGRAM = 183;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__EANNOTATIONS = IDIAGRAM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__DISPLAY_NAME = IDIAGRAM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__ID = IDIAGRAM__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__LAST_MODIFIED_TIME = IDIAGRAM__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__DEFAULT_SUBSYSTEM = IDIAGRAM__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__DESCRIPTION = IDIAGRAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__UML_DEPENDENCY_ID = IDIAGRAM__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__LAST_ID = IDIAGRAM__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__MY_STATE = IDIAGRAM__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__OWNER_HANDLE = IDIAGRAM__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__OBJECT_CREATION = IDIAGRAM__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__NAME = IDIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__CMHEADER = IDIAGRAM__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__PROPERTIES = IDIAGRAM__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__STEREOTYPES = IDIAGRAM__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__MODIFIED_TIME_WEAK = IDIAGRAM__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__GRAPHIC_CHART = IDIAGRAM__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__ANNOTATIONS = IDIAGRAM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__CODE_UPDATE_CG_TIME = IDIAGRAM__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM__HYPER_LINKS = IDIAGRAM__HYPER_LINKS;

	/**
	 * The number of structural features of the '<em>ISequence Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM_FEATURE_COUNT = IDIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM___GET_EANNOTATION__STRING = IDIAGRAM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ISequence Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISEQUENCE_DIAGRAM_OPERATION_COUNT = IDIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISlotImpl <em>ISlot</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISlotImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getISlot()
	 * @generated
	 */
	int ISLOT = 184;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISLOT__ID = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISLOT__NAME = 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISLOT__VALUE = 2;

	/**
	 * The feature id for the '<em><b>Defining Var</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISLOT__DEFINING_VAR = 3;

	/**
	 * The number of structural features of the '<em>ISlot</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISLOT_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>ISlot</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISLOT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStateChartImpl <em>IState Chart</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStateChartImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIStateChart()
	 * @generated
	 */
	int ISTATE_CHART = 186;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__EANNOTATIONS = ICLASS__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__DISPLAY_NAME = ICLASS__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__UML_DEPENDENCY_ID = ICLASS__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__OBJECT_CREATION = ICLASS__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__MODIFIED_TIME_WEAK = ICLASS__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__ID = ICLASS__ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__MY_STATE = ICLASS__MY_STATE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__NAME = ICLASS__NAME;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__LAST_ID = ICLASS__LAST_ID;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__WEAK_CG_TIME = ICLASS__WEAK_CG_TIME;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__STRONG_CG_TIME = ICLASS__STRONG_CG_TIME;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__MULTIPLICITY = ICLASS__MULTIPLICITY;

	/**
	 * The feature id for the '<em><b>Class Modifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__CLASS_MODIFIER = ICLASS__CLASS_MODIFIER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__PROPERTIES = ICLASS__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__STEREOTYPES = ICLASS__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__OPERATIONS = ICLASS__OPERATIONS;

	/**
	 * The feature id for the '<em><b>Inheritances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__INHERITANCES = ICLASS__INHERITANCES;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__THE_MAIN_DIAGRAM = ICLASS__THE_MAIN_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Attrs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__ATTRS = ICLASS__ATTRS;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__TAGS = ICLASS__TAGS;

	/**
	 * The feature id for the '<em><b>Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__ASSOCIATIONS = ICLASS__ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__DEPENDENCIES = ICLASS__DEPENDENCIES;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__PORTS = ICLASS__PORTS;

	/**
	 * The feature id for the '<em><b>Object Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__OBJECT_LINKS = ICLASS__OBJECT_LINKS;

	/**
	 * The feature id for the '<em><b>State Charts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__STATE_CHARTS = ICLASS__STATE_CHARTS;

	/**
	 * The feature id for the '<em><b>Its State Chart</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__ITS_STATE_CHART = ICLASS__ITS_STATE_CHART;

	/**
	 * The feature id for the '<em><b>Triggered Operations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__TRIGGERED_OPERATIONS = ICLASS__TRIGGERED_OPERATIONS;

	/**
	 * The feature id for the '<em><b>Receptions</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__RECEPTIONS = ICLASS__RECEPTIONS;

	/**
	 * The feature id for the '<em><b>Primitive Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__PRIMITIVE_OPERATIONS = ICLASS__PRIMITIVE_OPERATIONS;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__ANNOTATIONS = ICLASS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__DESCRIPTION = ICLASS__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Declaratives</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__DECLARATIVES = ICLASS__DECLARATIVES;

	/**
	 * The feature id for the '<em><b>Association Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__ASSOCIATION_ELEMENTS = ICLASS__ASSOCIATION_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__OWNER_HANDLE = ICLASS__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__HYPER_LINKS = ICLASS__HYPER_LINKS;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__REQUIREMEN_TRACABILITY_HANDLE = ICLASS__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Component Files</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__COMPONENT_FILES = ICLASS__COMPONENT_FILES;

	/**
	 * The feature id for the '<em><b>Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__LINKS = ICLASS__LINKS;

	/**
	 * The feature id for the '<em><b>Components</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__COMPONENTS = ICLASS__COMPONENTS;

	/**
	 * The feature id for the '<em><b>Event Handles</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__EVENT_HANDLES = ICLASS__EVENT_HANDLES;

	/**
	 * The feature id for the '<em><b>Template Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__TEMPLATE_PARAMETERS = ICLASS__TEMPLATE_PARAMETERS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__CODE_UPDATE_CG_TIME = ICLASS__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__CMHEADER = ICLASS__CMHEADER;

	/**
	 * The feature id for the '<em><b>Def Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__DEF_NUMBER = ICLASS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__GRAPHIC_CHART = ICLASS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__LAST_MODIFIED_TIME = ICLASS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Transitions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__TRANSITIONS = ICLASS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Connectors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__CONNECTORS = ICLASS_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__VERSION = ICLASS_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>States</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__STATES = ICLASS_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Base Version</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__BASE_VERSION = ICLASS_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__DIAGRAM = ICLASS_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Views</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__VIEWS = ICLASS_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART__INHERITS_FROM_HANDLE = ICLASS_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>IState Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_FEATURE_COUNT = ICLASS_FEATURE_COUNT + 11;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART___GET_EANNOTATION__STRING = ICLASS___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IState Chart</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_OPERATION_COUNT = ICLASS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStateChartDiagramImpl <em>IState Chart Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStateChartDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIStateChartDiagram()
	 * @generated
	 */
	int ISTATE_CHART_DIAGRAM = 187;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__EANNOTATIONS = IDIAGRAM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__DISPLAY_NAME = IDIAGRAM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__ID = IDIAGRAM__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__LAST_MODIFIED_TIME = IDIAGRAM__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__DEFAULT_SUBSYSTEM = IDIAGRAM__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__DESCRIPTION = IDIAGRAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__UML_DEPENDENCY_ID = IDIAGRAM__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__LAST_ID = IDIAGRAM__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__MY_STATE = IDIAGRAM__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__OWNER_HANDLE = IDIAGRAM__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__OBJECT_CREATION = IDIAGRAM__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__NAME = IDIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__CMHEADER = IDIAGRAM__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__PROPERTIES = IDIAGRAM__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__STEREOTYPES = IDIAGRAM__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__MODIFIED_TIME_WEAK = IDIAGRAM__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__GRAPHIC_CHART = IDIAGRAM__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__ANNOTATIONS = IDIAGRAM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__CODE_UPDATE_CG_TIME = IDIAGRAM__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM__HYPER_LINKS = IDIAGRAM__HYPER_LINKS;

	/**
	 * The number of structural features of the '<em>IState Chart Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM_FEATURE_COUNT = IDIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM___GET_EANNOTATION__STRING = IDIAGRAM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IState Chart Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTATE_CHART_DIAGRAM_OPERATION_COUNT = IDIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStereotypeImpl <em>IStereotype</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStereotypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIStereotype()
	 * @generated
	 */
	int ISTEREOTYPE = 189;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__EANNOTATIONS = ICLASSIFIER__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__DISPLAY_NAME = ICLASSIFIER__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__MODIFIED_TIME_WEAK = ICLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__ID = ICLASSIFIER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__MY_STATE = ICLASSIFIER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__NAME = ICLASSIFIER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__PROPERTIES = ICLASSIFIER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>M2 Classes</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__M2_CLASSES = ICLASSIFIER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>New Term</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__NEW_TERM = ICLASSIFIER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__DESCRIPTION = ICLASSIFIER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__TAGS = ICLASSIFIER_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__LAST_ID = ICLASSIFIER_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Inheritances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__INHERITANCES = ICLASSIFIER_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__DEPENDENCIES = ICLASSIFIER_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__REQUIREMEN_TRACABILITY_HANDLE = ICLASSIFIER_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__OBJECT_CREATION = ICLASSIFIER_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__UML_DEPENDENCY_ID = ICLASSIFIER_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__THE_MAIN_DIAGRAM = ICLASSIFIER_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE__ANNOTATIONS = ICLASSIFIER_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>IStereotype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE_FEATURE_COUNT = ICLASSIFIER_FEATURE_COUNT + 17;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE___GET_EANNOTATION__STRING = ICLASSIFIER___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IStereotype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTEREOTYPE_OPERATION_COUNT = ICLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStructureDiagramImpl <em>IStructure Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IStructureDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIStructureDiagram()
	 * @generated
	 */
	int ISTRUCTURE_DIAGRAM = 190;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__EANNOTATIONS = IDIAGRAM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__DISPLAY_NAME = IDIAGRAM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__ID = IDIAGRAM__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__LAST_MODIFIED_TIME = IDIAGRAM__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__DEFAULT_SUBSYSTEM = IDIAGRAM__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__DESCRIPTION = IDIAGRAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__UML_DEPENDENCY_ID = IDIAGRAM__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__LAST_ID = IDIAGRAM__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__MY_STATE = IDIAGRAM__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__OWNER_HANDLE = IDIAGRAM__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__OBJECT_CREATION = IDIAGRAM__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__NAME = IDIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__CMHEADER = IDIAGRAM__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__PROPERTIES = IDIAGRAM__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__STEREOTYPES = IDIAGRAM__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__MODIFIED_TIME_WEAK = IDIAGRAM__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__GRAPHIC_CHART = IDIAGRAM__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__ANNOTATIONS = IDIAGRAM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__CODE_UPDATE_CG_TIME = IDIAGRAM__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM__HYPER_LINKS = IDIAGRAM__HYPER_LINKS;

	/**
	 * The number of structural features of the '<em>IStructure Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM_FEATURE_COUNT = IDIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM___GET_EANNOTATION__STRING = IDIAGRAM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IStructure Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISTRUCTURE_DIAGRAM_OPERATION_COUNT = IDIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.OwnerHandleTypeImpl <em>Owner Handle Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.OwnerHandleTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getOwnerHandleType()
	 * @generated
	 */
	int OWNER_HANDLE_TYPE = 233;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWNER_HANDLE_TYPE__EANNOTATIONS = DEFAULT_SUBSYSTEM_TYPE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWNER_HANDLE_TYPE__DISPLAY_NAME = DEFAULT_SUBSYSTEM_TYPE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWNER_HANDLE_TYPE__WEAK_CG_TIME = DEFAULT_SUBSYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWNER_HANDLE_TYPE__STRONG_CG_TIME = DEFAULT_SUBSYSTEM_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Owner Handle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWNER_HANDLE_TYPE_FEATURE_COUNT = DEFAULT_SUBSYSTEM_TYPE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWNER_HANDLE_TYPE___GET_EANNOTATION__STRING = DEFAULT_SUBSYSTEM_TYPE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>Owner Handle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OWNER_HANDLE_TYPE_OPERATION_COUNT = DEFAULT_SUBSYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISubsystemImpl <em>ISubsystem</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISubsystemImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getISubsystem()
	 * @generated
	 */
	int ISUBSYSTEM = 191;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__EANNOTATIONS = OWNER_HANDLE_TYPE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__DISPLAY_NAME = OWNER_HANDLE_TYPE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__WEAK_CG_TIME = OWNER_HANDLE_TYPE__WEAK_CG_TIME;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__STRONG_CG_TIME = OWNER_HANDLE_TYPE__STRONG_CG_TIME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__ID = OWNER_HANDLE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__MY_STATE = OWNER_HANDLE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__NAME = OWNER_HANDLE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__MODIFIED_TIME_WEAK = OWNER_HANDLE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Default Composite</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__DEFAULT_COMPOSITE = OWNER_HANDLE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Events Base ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__EVENTS_BASE_ID = OWNER_HANDLE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__CLASSES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Configuration Related Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__CONFIGURATION_RELATED_TIME = OWNER_HANDLE_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__PROPERTIES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__LAST_ID = OWNER_HANDLE_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__CMHEADER = OWNER_HANDLE_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Declaratives</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__DECLARATIVES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__TYPES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__STEREOTYPES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Predefined Types</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__PREDEFINED_TYPES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__EVENTS = OWNER_HANDLE_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__ANNOTATIONS = OWNER_HANDLE_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Use Cases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__USE_CASES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Actors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__ACTORS = OWNER_HANDLE_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__DESCRIPTION = OWNER_HANDLE_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__TAGS = OWNER_HANDLE_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__DEPENDENCIES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__OWNER_HANDLE = OWNER_HANDLE_TYPE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__THE_MAIN_DIAGRAM = OWNER_HANDLE_TYPE_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__HYPER_LINKS = OWNER_HANDLE_TYPE_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Table Layouts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__TABLE_LAYOUTS = OWNER_HANDLE_TYPE_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Matrix Layouts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__MATRIX_LAYOUTS = OWNER_HANDLE_TYPE_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Table Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__TABLE_INSTANCES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Matrix Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__MATRIX_INSTANCES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Embeded Files</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__EMBEDED_FILES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Component Files</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__COMPONENT_FILES = OWNER_HANDLE_TYPE_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__REQUIREMEN_TRACABILITY_HANDLE = OWNER_HANDLE_TYPE_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__CODE_UPDATE_CG_TIME = OWNER_HANDLE_TYPE_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__OBJECT_CREATION = OWNER_HANDLE_TYPE_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__UML_DEPENDENCY_ID = OWNER_HANDLE_TYPE_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Association Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM__ASSOCIATION_ELEMENTS = OWNER_HANDLE_TYPE_FEATURE_COUNT + 35;

	/**
	 * The number of structural features of the '<em>ISubsystem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM_FEATURE_COUNT = OWNER_HANDLE_TYPE_FEATURE_COUNT + 36;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM___GET_EANNOTATION__STRING = OWNER_HANDLE_TYPE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ISubsystem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISUBSYSTEM_OPERATION_COUNT = OWNER_HANDLE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISwimlaneImpl <em>ISwimlane</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISwimlaneImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getISwimlane()
	 * @generated
	 */
	int ISWIMLANE = 192;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__ID = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__DESCRIPTION = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Represents</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__REPRESENTS = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__MY_STATE = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Swimlanes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__SWIMLANES = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE__STEREOTYPES = IMODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>ISwimlane</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ISwimlane</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISWIMLANE_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISysMLPortImpl <em>ISys ML Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ISysMLPortImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getISysMLPort()
	 * @generated
	 */
	int ISYS_ML_PORT = 193;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__EANNOTATIONS = IINSTANCE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__DISPLAY_NAME = IINSTANCE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__MODIFIED_TIME_WEAK = IINSTANCE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__ID = IINSTANCE__ID;

	/**
	 * The feature id for the '<em><b>Inverse</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__INVERSE = IINSTANCE__INVERSE;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__MY_STATE = IINSTANCE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__NAME = IINSTANCE__NAME;

	/**
	 * The feature id for the '<em><b>Implicit Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__IMPLICIT_CLASS = IINSTANCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__MULTIPLICITY = IINSTANCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__DEPENDENCIES = IINSTANCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__STEREOTYPES = IINSTANCE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__TAGS = IINSTANCE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Other Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__OTHER_CLASS = IINSTANCE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__DIRECTION = IINSTANCE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__DESCRIPTION = IINSTANCE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__LAST_ID = IINSTANCE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Reversed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT__REVERSED = IINSTANCE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>ISys ML Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT_FEATURE_COUNT = IINSTANCE_FEATURE_COUNT + 10;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT___GET_EANNOTATION__STRING = IINSTANCE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ISys ML Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYS_ML_PORT_OPERATION_COUNT = IINSTANCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TableInstancesTypeImpl <em>Table Instances Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TableInstancesTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getTableInstancesType()
	 * @generated
	 */
	int TABLE_INSTANCES_TYPE = 238;

	/**
	 * The number of structural features of the '<em>Table Instances Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCES_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Table Instances Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_INSTANCES_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITableInstanceImpl <em>ITable Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITableInstanceImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITableInstance()
	 * @generated
	 */
	int ITABLE_INSTANCE = 194;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE__ID = TABLE_INSTANCES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE__MY_STATE = TABLE_INSTANCES_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE__PROPERTIES = TABLE_INSTANCES_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE__NAME = TABLE_INSTANCES_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE__MODIFIED_TIME_WEAK = TABLE_INSTANCES_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Layout Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE__LAYOUT_HANDLE = TABLE_INSTANCES_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Scope Handles</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE__SCOPE_HANDLES = TABLE_INSTANCES_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE__STEREOTYPES = TABLE_INSTANCES_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>ITable Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE_FEATURE_COUNT = TABLE_INSTANCES_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>ITable Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_INSTANCE_OPERATION_COUNT = TABLE_INSTANCES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITableLayoutImpl <em>ITable Layout</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITableLayoutImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITableLayout()
	 * @generated
	 */
	int ITABLE_LAYOUT = 195;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__MODIFIED_TIME_WEAK = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__ID = IUNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__MY_STATE = IUNIT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__NAME = IUNIT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__PROPERTIES = IUNIT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__STEREOTYPES = IUNIT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__TAGS = IUNIT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Table Element Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__TABLE_ELEMENT_TYPES = IUNIT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Data Columns</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__DATA_COLUMNS = IUNIT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT__DESCRIPTION = IUNIT_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>ITable Layout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 10;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ITable Layout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_LAYOUT_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITableViewImpl <em>ITable View</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITableViewImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITableView()
	 * @generated
	 */
	int ITABLE_VIEW = 196;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_VIEW__EANNOTATIONS = IUNIT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_VIEW__DISPLAY_NAME = IUNIT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>ITable View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_VIEW_FEATURE_COUNT = IUNIT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_VIEW___GET_EANNOTATION__STRING = IUNIT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ITable View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITABLE_VIEW_OPERATION_COUNT = IUNIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITagImpl <em>ITag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITagImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITag()
	 * @generated
	 */
	int ITAG = 197;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__EANNOTATIONS = IVARIABLE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__DISPLAY_NAME = IVARIABLE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__IS_ORDERED = IVARIABLE__IS_ORDERED;

	/**
	 * The feature id for the '<em><b>My Type Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__MY_TYPE_OF = IVARIABLE__MY_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__ID = IVARIABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__NAME = IVARIABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__MODIFIED_TIME_WEAK = IVARIABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Value Specifications</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__VALUE_SPECIFICATIONS = IVARIABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Type Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__TYPE_OF = IVARIABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__MY_STATE = IVARIABLE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__MULTIPLICITY = IVARIABLE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__PROPERTIES = IVARIABLE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__DESCRIPTION = IVARIABLE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__HYPER_LINKS = IVARIABLE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Base</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__BASE = IVARIABLE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Meta Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__META_CLASS = IVARIABLE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__DEFAULT_VALUE = IVARIABLE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG__CODE_UPDATE_CG_TIME = IVARIABLE_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>ITag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG_FEATURE_COUNT = IVARIABLE_FEATURE_COUNT + 14;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG___GET_EANNOTATION__STRING = IVARIABLE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ITag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAG_OPERATION_COUNT = IVARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstImpl <em>ITemplate Inst</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITemplateInst()
	 * @generated
	 */
	int ITEMPLATE_INST = 198;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST__ID = 0;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST__MODIFIED_TIME_WEAK = 1;

	/**
	 * The feature id for the '<em><b>Template Inst Params</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST__TEMPLATE_INST_PARAMS = 2;

	/**
	 * The feature id for the '<em><b>Of Template</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST__OF_TEMPLATE = 3;

	/**
	 * The number of structural features of the '<em>ITemplate Inst</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>ITemplate Inst</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstParamImpl <em>ITemplate Inst Param</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstParamImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITemplateInstParam()
	 * @generated
	 */
	int ITEMPLATE_INST_PARAM = 199;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_PARAM__ID = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_PARAM__NAME = 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_PARAM__MODIFIED_TIME_WEAK = 2;

	/**
	 * The feature id for the '<em><b>Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_PARAM__VALUE = 3;

	/**
	 * The feature id for the '<em><b>Arg Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_PARAM__ARG_VALUE = 4;

	/**
	 * The feature id for the '<em><b>On The Fly Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_PARAM__ON_THE_FLY_VALUE = 5;

	/**
	 * The number of structural features of the '<em>ITemplate Inst Param</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_PARAM_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>ITemplate Inst Param</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INST_PARAM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstantiationImpl <em>ITemplate Instantiation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstantiationImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITemplateInstantiation()
	 * @generated
	 */
	int ITEMPLATE_INSTANTIATION = 200;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>ITemplate Instantiation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ITemplate Instantiation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstantiationParameterImpl <em>ITemplate Instantiation Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstantiationParameterImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITemplateInstantiationParameter()
	 * @generated
	 */
	int ITEMPLATE_INSTANTIATION_PARAMETER = 201;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION_PARAMETER__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION_PARAMETER__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>ITemplate Instantiation Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION_PARAMETER_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION_PARAMETER___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ITemplate Instantiation Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_INSTANTIATION_PARAMETER_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateParameterImpl <em>ITemplate Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateParameterImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITemplateParameter()
	 * @generated
	 */
	int ITEMPLATE_PARAMETER = 202;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER__EANNOTATIONS = IVARIABLE__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER__DISPLAY_NAME = IVARIABLE__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER__IS_ORDERED = IVARIABLE__IS_ORDERED;

	/**
	 * The feature id for the '<em><b>My Type Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER__MY_TYPE_OF = IVARIABLE__MY_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER__ID = IVARIABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER__NAME = IVARIABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER__MY_STATE = IVARIABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER__MODIFIED_TIME_WEAK = IVARIABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Representative</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER__REPRESENTATIVE = IVARIABLE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>ITemplate Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER_FEATURE_COUNT = IVARIABLE_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER___GET_EANNOTATION__STRING = IVARIABLE___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ITemplate Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMPLATE_PARAMETER_OPERATION_COUNT = IVARIABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITimeEventImpl <em>ITime Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITimeEventImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITimeEvent()
	 * @generated
	 */
	int ITIME_EVENT = 203;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT__ID = ITS_TARGET_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT__MY_STATE = ITS_TARGET_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT__NAME = ITS_TARGET_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT__MODIFIED_TIME_WEAK = ITS_TARGET_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT__PARENT = ITS_TARGET_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>State Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT__STATE_TYPE = ITS_TARGET_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Default Trans</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT__DEFAULT_TRANS = ITS_TARGET_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Duration Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT__DURATION_TIME = ITS_TARGET_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Swimlane</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT__SWIMLANE = ITS_TARGET_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>ITime Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT_FEATURE_COUNT = ITS_TARGET_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>ITime Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_EVENT_OPERATION_COUNT = ITS_TARGET_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITimeoutImpl <em>ITimeout</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITimeoutImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITimeout()
	 * @generated
	 */
	int ITIMEOUT = 204;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT__MODIFIED_TIME_WEAK = ITS_TRIGGER_TYPE__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT__ID = ITS_TRIGGER_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Info</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT__INFO = ITS_TRIGGER_TYPE__INFO;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT__UML_DEPENDENCY_ID = ITS_TRIGGER_TYPE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT__MY_STATE = ITS_TRIGGER_TYPE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT__OBJECT_CREATION = ITS_TRIGGER_TYPE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT__BODY = ITS_TRIGGER_TYPE__BODY;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT__TIME = ITS_TRIGGER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT__INHERITS_FROM_HANDLE = ITS_TRIGGER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>ITimeout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT_FEATURE_COUNT = ITS_TRIGGER_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>ITimeout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIMEOUT_OPERATION_COUNT = ITS_TRIGGER_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITransitionImpl <em>ITransition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITransitionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITransition()
	 * @generated
	 */
	int ITRANSITION = 205;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__MODIFIED_TIME_WEAK = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Static Reaction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__STATIC_REACTION = IMODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Its Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__ITS_TARGET = IMODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__ID = IMODEL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__CODE_UPDATE_CG_TIME = IMODEL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__REQUIREMEN_TRACABILITY_HANDLE = IMODEL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__DESCRIPTION = IMODEL_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Its Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__ITS_LABEL = IMODEL_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__UML_DEPENDENCY_ID = IMODEL_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__MY_STATE = IMODEL_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__OBJECT_CREATION = IMODEL_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__NAME = IMODEL_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Its Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__ITS_SOURCE = IMODEL_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Inherits From Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__INHERITS_FROM_HANDLE = IMODEL_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__DEPENDENCIES = IMODEL_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION__STEREOTYPES = IMODEL_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The number of structural features of the '<em>ITransition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ITransition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRANSITION_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITriggerImpl <em>ITrigger</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITriggerImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITrigger()
	 * @generated
	 */
	int ITRIGGER = 206;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGER__EANNOTATIONS = IMODEL_ELEMENT__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGER__DISPLAY_NAME = IMODEL_ELEMENT__DISPLAY_NAME;

	/**
	 * The number of structural features of the '<em>ITrigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGER_FEATURE_COUNT = IMODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGER___GET_EANNOTATION__STRING = IMODEL_ELEMENT___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>ITrigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGER_OPERATION_COUNT = IMODEL_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITriggeredImpl <em>ITriggered</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITriggeredImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getITriggered()
	 * @generated
	 */
	int ITRIGGERED = 207;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__VIRTUAL = OPERATIONS_TYPE__VIRTUAL;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__EANNOTATIONS = OPERATIONS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__DISPLAY_NAME = OPERATIONS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__ID = OPERATIONS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__NAME = OPERATIONS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Args</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__ARGS = OPERATIONS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Return Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__RETURN_TYPE = OPERATIONS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__ABSTRACT = OPERATIONS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__FINAL = OPERATIONS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Concurrency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__CONCURRENCY = OPERATIONS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Protection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__PROTECTION = OPERATIONS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__MODIFIED_TIME_WEAK = OPERATIONS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED__MY_STATE = OPERATIONS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>ITriggered</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED_FEATURE_COUNT = OPERATIONS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED___GET_EANNOTATION__STRING = OPERATIONS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>ITriggered</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITRIGGERED_OPERATION_COUNT = OPERATIONS_TYPE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITypeImpl <em>IType</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIType()
	 * @generated
	 */
	int ITYPE = 208;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__EANNOTATIONS = ICLASSIFIER__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__DISPLAY_NAME = ICLASSIFIER__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__UML_DEPENDENCY_ID = ICLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__OBJECT_CREATION = ICLASSIFIER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__MODIFIED_TIME_WEAK = ICLASSIFIER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__ID = ICLASSIFIER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__MY_STATE = ICLASSIFIER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__NAME = ICLASSIFIER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__LAST_ID = ICLASSIFIER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Literals</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__LITERALS = ICLASSIFIER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__KIND = ICLASSIFIER_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__PROPERTIES = ICLASSIFIER_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__DESCRIPTION = ICLASSIFIER_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Declaration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__DECLARATION = ICLASSIFIER_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__STEREOTYPES = ICLASSIFIER_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Attrs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__ATTRS = ICLASSIFIER_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Association Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__ASSOCIATION_ELEMENTS = ICLASSIFIER_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__TAGS = ICLASSIFIER_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Typedef Base Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__TYPEDEF_BASE_TYPE = ICLASSIFIER_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Typedef Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__TYPEDEF_MULTIPLICITY = ICLASSIFIER_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Typedef Is Ordered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__TYPEDEF_IS_ORDERED = ICLASSIFIER_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Typedef Is Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__TYPEDEF_IS_REFERENCE = ICLASSIFIER_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Typedef Is Constant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__TYPEDEF_IS_CONSTANT = ICLASSIFIER_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__REQUIREMEN_TRACABILITY_HANDLE = ICLASSIFIER_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__CODE_UPDATE_CG_TIME = ICLASSIFIER_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE__THE_MAIN_DIAGRAM = ICLASSIFIER_FEATURE_COUNT + 23;

	/**
	 * The number of structural features of the '<em>IType</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE_FEATURE_COUNT = ICLASSIFIER_FEATURE_COUNT + 24;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE___GET_EANNOTATION__STRING = ICLASSIFIER___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IType</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITYPE_OPERATION_COUNT = ICLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TheMainDiagramTypeImpl <em>The Main Diagram Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TheMainDiagramTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getTheMainDiagramType()
	 * @generated
	 */
	int THE_MAIN_DIAGRAM_TYPE = 240;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__ID = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__LAST_MODIFIED_TIME = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__REQUIREMEN_TRACABILITY_HANDLE = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__DEFAULT_SUBSYSTEM = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__DESCRIPTION = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__UML_DEPENDENCY_ID = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__LAST_ID = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__MY_STATE = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__OWNER_HANDLE = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__OBJECT_CREATION = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__NAME = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE__CMHEADER = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>The Main Diagram Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE_FEATURE_COUNT = MPMODEL_OBJECT_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of operations of the '<em>The Main Diagram Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THE_MAIN_DIAGRAM_TYPE_OPERATION_COUNT = MPMODEL_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUCDiagramImpl <em>IUC Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUCDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIUCDiagram()
	 * @generated
	 */
	int IUC_DIAGRAM = 209;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__ID = THE_MAIN_DIAGRAM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__LAST_MODIFIED_TIME = THE_MAIN_DIAGRAM_TYPE__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = THE_MAIN_DIAGRAM_TYPE__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__DEFAULT_SUBSYSTEM = THE_MAIN_DIAGRAM_TYPE__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__DESCRIPTION = THE_MAIN_DIAGRAM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__UML_DEPENDENCY_ID = THE_MAIN_DIAGRAM_TYPE__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__LAST_ID = THE_MAIN_DIAGRAM_TYPE__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__MY_STATE = THE_MAIN_DIAGRAM_TYPE__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__OWNER_HANDLE = THE_MAIN_DIAGRAM_TYPE__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__OBJECT_CREATION = THE_MAIN_DIAGRAM_TYPE__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__NAME = THE_MAIN_DIAGRAM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__CMHEADER = THE_MAIN_DIAGRAM_TYPE__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__PROPERTIES = THE_MAIN_DIAGRAM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__GRAPHIC_CHART = THE_MAIN_DIAGRAM_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM__MODIFIED_TIME_WEAK = THE_MAIN_DIAGRAM_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>IUC Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM_FEATURE_COUNT = THE_MAIN_DIAGRAM_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>IUC Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUC_DIAGRAM_OPERATION_COUNT = THE_MAIN_DIAGRAM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUseCaseImpl <em>IUse Case</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUseCaseImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIUseCase()
	 * @generated
	 */
	int IUSE_CASE = 211;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__EANNOTATIONS = ICLASSIFIER__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__DISPLAY_NAME = ICLASSIFIER__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__MULTIPLICITY = ICLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__ID = ICLASSIFIER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__MY_STATE = ICLASSIFIER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__NAME = ICLASSIFIER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>The Main Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__THE_MAIN_DIAGRAM = ICLASSIFIER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__HYPER_LINKS = ICLASSIFIER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Weak CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__WEAK_CG_TIME = ICLASSIFIER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Strong CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__STRONG_CG_TIME = ICLASSIFIER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Class Modifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__CLASS_MODIFIER = ICLASSIFIER_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__DESCRIPTION = ICLASSIFIER_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Inheritances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__INHERITANCES = ICLASSIFIER_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Associations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__ASSOCIATIONS = ICLASSIFIER_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Use Case Stereo Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__USE_CASE_STEREO_TYPES = ICLASSIFIER_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Entry Points</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__ENTRY_POINTS = ICLASSIFIER_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Dependencies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__DEPENDENCIES = ICLASSIFIER_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__LAST_ID = ICLASSIFIER_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Diagrams</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__DIAGRAMS = ICLASSIFIER_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__MODIFIED_TIME_WEAK = ICLASSIFIER_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__REQUIREMEN_TRACABILITY_HANDLE = ICLASSIFIER_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__CMHEADER = ICLASSIFIER_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__OWNER_HANDLE = ICLASSIFIER_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Declaratives</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__DECLARATIVES = ICLASSIFIER_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__OPERATIONS = ICLASSIFIER_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>State Charts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__STATE_CHARTS = ICLASSIFIER_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Its State Chart</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__ITS_STATE_CHART = ICLASSIFIER_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Attrs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__ATTRS = ICLASSIFIER_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__ANNOTATIONS = ICLASSIFIER_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Embeded Files</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__EMBEDED_FILES = ICLASSIFIER_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__OBJECT_CREATION = ICLASSIFIER_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__UML_DEPENDENCY_ID = ICLASSIFIER_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Object Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__OBJECT_LINKS = ICLASSIFIER_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE__PROPERTIES = ICLASSIFIER_FEATURE_COUNT + 31;

	/**
	 * The number of structural features of the '<em>IUse Case</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_FEATURE_COUNT = ICLASSIFIER_FEATURE_COUNT + 32;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE___GET_EANNOTATION__STRING = ICLASSIFIER___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IUse Case</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_OPERATION_COUNT = ICLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUseCaseDiagramImpl <em>IUse Case Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUseCaseDiagramImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIUseCaseDiagram()
	 * @generated
	 */
	int IUSE_CASE_DIAGRAM = 212;

	/**
	 * The feature id for the '<em><b>EAnnotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__EANNOTATIONS = IDIAGRAM__EANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__DISPLAY_NAME = IDIAGRAM__DISPLAY_NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__ID = IDIAGRAM__ID;

	/**
	 * The feature id for the '<em><b>Last Modified Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__LAST_MODIFIED_TIME = IDIAGRAM__LAST_MODIFIED_TIME;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__REQUIREMEN_TRACABILITY_HANDLE = IDIAGRAM__REQUIREMEN_TRACABILITY_HANDLE;

	/**
	 * The feature id for the '<em><b>Default Subsystem</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__DEFAULT_SUBSYSTEM = IDIAGRAM__DEFAULT_SUBSYSTEM;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__DESCRIPTION = IDIAGRAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__UML_DEPENDENCY_ID = IDIAGRAM__UML_DEPENDENCY_ID;

	/**
	 * The feature id for the '<em><b>Last ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__LAST_ID = IDIAGRAM__LAST_ID;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__MY_STATE = IDIAGRAM__MY_STATE;

	/**
	 * The feature id for the '<em><b>Owner Handle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__OWNER_HANDLE = IDIAGRAM__OWNER_HANDLE;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__OBJECT_CREATION = IDIAGRAM__OBJECT_CREATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__NAME = IDIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Cmheader</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__CMHEADER = IDIAGRAM__CMHEADER;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__PROPERTIES = IDIAGRAM__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stereotypes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__STEREOTYPES = IDIAGRAM__STEREOTYPES;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__MODIFIED_TIME_WEAK = IDIAGRAM__MODIFIED_TIME_WEAK;

	/**
	 * The feature id for the '<em><b>Graphic Chart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__GRAPHIC_CHART = IDIAGRAM__GRAPHIC_CHART;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__ANNOTATIONS = IDIAGRAM__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__CODE_UPDATE_CG_TIME = IDIAGRAM__CODE_UPDATE_CG_TIME;

	/**
	 * The feature id for the '<em><b>Hyper Links</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM__HYPER_LINKS = IDIAGRAM__HYPER_LINKS;

	/**
	 * The number of structural features of the '<em>IUse Case Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM_FEATURE_COUNT = IDIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get EAnnotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM___GET_EANNOTATION__STRING = IDIAGRAM___GET_EANNOTATION__STRING;

	/**
	 * The number of operations of the '<em>IUse Case Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_DIAGRAM_OPERATION_COUNT = IDIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUseCaseStereoTypeImpl <em>IUse Case Stereo Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.IUseCaseStereoTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getIUseCaseStereoType()
	 * @generated
	 */
	int IUSE_CASE_STEREO_TYPE = 213;

	/**
	 * The feature id for the '<em><b>Use Case</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_STEREO_TYPE__USE_CASE = 0;

	/**
	 * The feature id for the '<em><b>Stereo Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_STEREO_TYPE__STEREO_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Entry Point</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_STEREO_TYPE__ENTRY_POINT = 2;

	/**
	 * The number of structural features of the '<em>IUse Case Stereo Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_STEREO_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>IUse Case Stereo Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IUSE_CASE_STEREO_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItemsTypeImpl <em>Items Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ItemsTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getItemsType()
	 * @generated
	 */
	int ITEMS_TYPE = 217;

	/**
	 * The number of structural features of the '<em>Items Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMS_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Items Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITEMS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_hTargetTypeImpl <em>MhTarget Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_hTargetTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getM_hTargetType()
	 * @generated
	 */
	int MHTARGET_TYPE = 223;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MHTARGET_TYPE__REQUIREMEN_TRACABILITY_HANDLE = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MHTARGET_TYPE__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MHTARGET_TYPE__PROPERTIES = 2;

	/**
	 * The number of structural features of the '<em>MhTarget Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MHTARGET_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>MhTarget Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MHTARGET_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_pFormalMessageTypeImpl <em>MpFormal Message Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_pFormalMessageTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getM_pFormalMessageType()
	 * @generated
	 */
	int MPFORMAL_MESSAGE_TYPE = 225;

	/**
	 * The number of structural features of the '<em>MpFormal Message Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MPFORMAL_MESSAGE_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>MpFormal Message Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MPFORMAL_MESSAGE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_subjectTypeImpl <em>Msubject Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.M_subjectTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getM_subjectType()
	 * @generated
	 */
	int MSUBJECT_TYPE = 228;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MSUBJECT_TYPE__UML_DEPENDENCY_ID = 0;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MSUBJECT_TYPE__OBJECT_CREATION = 1;

	/**
	 * The number of structural features of the '<em>Msubject Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MSUBJECT_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Msubject Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MSUBJECT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ParentTypeImpl <em>Parent Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ParentTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getParentType()
	 * @generated
	 */
	int PARENT_TYPE = 235;

	/**
	 * The number of structural features of the '<em>Parent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Parent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TableDataDefinitionImpl <em>Table Data Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TableDataDefinitionImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getTableDataDefinition()
	 * @generated
	 */
	int TABLE_DATA_DEFINITION = 237;

	/**
	 * The feature id for the '<em><b>My Table</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_DATA_DEFINITION__MY_TABLE = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_DATA_DEFINITION__NAME = 1;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_DATA_DEFINITION__DATA_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Column Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_DATA_DEFINITION__COLUMN_NAME = 3;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_DATA_DEFINITION__MODEL_ELEMENT = 4;

	/**
	 * The number of structural features of the '<em>Table Data Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_DATA_DEFINITION_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Table Data Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TABLE_DATA_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TargetTypeImpl <em>Target Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TargetTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getTargetType()
	 * @generated
	 */
	int TARGET_TYPE = 239;

	/**
	 * The number of structural features of the '<em>Target Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Target Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ToLinkTypeImpl <em>To Link Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ToLinkTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getToLinkType()
	 * @generated
	 */
	int TO_LINK_TYPE = 241;

	/**
	 * The feature id for the '<em><b>Implicit Class</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_LINK_TYPE__IMPLICIT_CLASS = FROM_LINK_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>To Link Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_LINK_TYPE_FEATURE_COUNT = FROM_LINK_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>To Link Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_LINK_TYPE_OPERATION_COUNT = FROM_LINK_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TransitionsTypeImpl <em>Transitions Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.TransitionsTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getTransitionsType()
	 * @generated
	 */
	int TRANSITIONS_TYPE = 242;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__MODIFIED_TIME_WEAK = 0;

	/**
	 * The feature id for the '<em><b>Static Reaction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__STATIC_REACTION = 1;

	/**
	 * The feature id for the '<em><b>Its Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__ITS_TARGET = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__ID = 3;

	/**
	 * The feature id for the '<em><b>Code Update CG Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__CODE_UPDATE_CG_TIME = 4;

	/**
	 * The feature id for the '<em><b>Requiremen Tracability Handle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__REQUIREMEN_TRACABILITY_HANDLE = 5;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__DESCRIPTION = 6;

	/**
	 * The feature id for the '<em><b>Its Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__ITS_LABEL = 7;

	/**
	 * The feature id for the '<em><b>Uml Dependency ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__UML_DEPENDENCY_ID = 8;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__MY_STATE = 9;

	/**
	 * The feature id for the '<em><b>Object Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__OBJECT_CREATION = 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE__NAME = 11;

	/**
	 * The number of structural features of the '<em>Transitions Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Transitions Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITIONS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UnknownTypeImpl <em>Unknown Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UnknownTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getUnknownType()
	 * @generated
	 */
	int UNKNOWN_TYPE = 243;

	/**
	 * The number of structural features of the '<em>Unknown Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNKNOWN_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Unknown Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNKNOWN_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ValueTypeImpl <em>Value Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ValueTypeImpl
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyPackageImpl#getValueType()
	 * @generated
	 */
	int VALUE_TYPE = 244;

	/**
	 * The feature id for the '<em><b>Modified Time Weak</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_TYPE__MODIFIED_TIME_WEAK = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_TYPE__ID = 1;

	/**
	 * The feature id for the '<em><b>My State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_TYPE__MY_STATE = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_TYPE__NAME = 3;

	/**
	 * The number of structural features of the '<em>Value Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Value Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_TYPE_OPERATION_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.AssociationsType <em>Associations Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Associations Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.AssociationsType
	 * @generated
	 */
	EClass getAssociationsType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart <em>CCollaboration Chart</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CCollaboration Chart</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart
	 * @generated
	 */
	EClass getCCollaborationChart();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart#getM_pModelObject()
	 * @see #getCCollaborationChart()
	 * @generated
	 */
	EReference getCCollaborationChart_M_pModelObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart#getM_pRoot <em>MpRoot</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpRoot</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart#getM_pRoot()
	 * @see #getCCollaborationChart()
	 * @generated
	 */
	EReference getCCollaborationChart_M_pRoot();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState <em>CGI Action State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Action State</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState
	 * @generated
	 */
	EClass getCGIActionState();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getProperties()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EReference getCGIActionState_Properties();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_pModelObject()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EReference getCGIActionState_M_pModelObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_pParent()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EReference getCGIActionState_M_pParent();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_transform <em>Mtransform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mtransform</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_transform()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_M_transform();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_AdditionalLabel <em>MAdditional Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>MAdditional Label</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_AdditionalLabel()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EReference getCGIActionState_M_AdditionalLabel();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_polygon <em>Mpolygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mpolygon</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_polygon()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_M_polygon();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_nNameFormat <em>MnName Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnName Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_nNameFormat()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_M_nNameFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_nIsNameFormat <em>MnIs Name Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnIs Name Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_nIsNameFormat()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_M_nIsNameFormat();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getCompartments <em>Compartments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Compartments</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getCompartments()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EReference getCGIActionState_Compartments();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getNAndLineCount <em>NAnd Line Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>NAnd Line Count</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getNAndLineCount()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_NAndLineCount();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_pInheritsFrom <em>MpInherits From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>MpInherits From</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_pInheritsFrom()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EReference getCGIActionState_M_pInheritsFrom();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_nInheritanceMask <em>MnInheritance Mask</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnInheritance Mask</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_nInheritanceMask()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_M_nInheritanceMask();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_pDefaultComponentRelation <em>MpDefault Component Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MpDefault Component Relation</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_pDefaultComponentRelation()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_M_pDefaultComponentRelation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_NameDisplayMode <em>MName Display Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MName Display Mode</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_NameDisplayMode()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_M_NameDisplayMode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_ActDescLablDiaplayMode <em>MAct Desc Labl Diaplay Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MAct Desc Labl Diaplay Mode</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_ActDescLablDiaplayMode()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_M_ActDescLablDiaplayMode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_moveAndLineTimeStamp <em>Mmove And Line Time Stamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mmove And Line Time Stamp</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState#getM_moveAndLineTimeStamp()
	 * @see #getCGIActionState()
	 * @generated
	 */
	EAttribute getCGIActionState_M_moveAndLineTimeStamp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX <em>CGI Active X</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Active X</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX
	 * @generated
	 */
	EClass getCGIActiveX();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getProperties()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EReference getCGIActiveX_Properties();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_pModelObject()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EReference getCGIActiveX_M_pModelObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_pParent()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EReference getCGIActiveX_M_pParent();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_transform <em>Mtransform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mtransform</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_transform()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EAttribute getCGIActiveX_M_transform();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_polygon <em>Mpolygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mpolygon</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_polygon()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EAttribute getCGIActiveX_M_polygon();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_nNameFormat <em>MnName Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnName Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_nNameFormat()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EAttribute getCGIActiveX_M_nNameFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_nIsNameFormat <em>MnIs Name Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnIs Name Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_nIsNameFormat()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EAttribute getCGIActiveX_M_nIsNameFormat();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getCompartments <em>Compartments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Compartments</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getCompartments()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EReference getCGIActiveX_Compartments();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_csModelObjPath <em>Mcs Model Obj Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mcs Model Obj Path</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_csModelObjPath()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EAttribute getCGIActiveX_M_csModelObjPath();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_csName <em>Mcs Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mcs Name</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_csName()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EAttribute getCGIActiveX_M_csName();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_PartsArray <em>MParts Array</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>MParts Array</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX#getM_PartsArray()
	 * @see #getCGIActiveX()
	 * @generated
	 */
	EReference getCGIActiveX_M_PartsArray();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor <em>CGI Anchor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Anchor</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor
	 * @generated
	 */
	EClass getCGIAnchor();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_pModelObject()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EReference getCGIAnchor_M_pModelObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_pParent()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_pParent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_pSource <em>MpSource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpSource</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_pSource()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EReference getCGIAnchor_M_pSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_sourceType <em>Msource Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Msource Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_sourceType()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_sourceType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_pTarget <em>MpTarget</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpTarget</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_pTarget()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EReference getCGIAnchor_M_pTarget();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_targetType <em>Mtarget Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mtarget Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_targetType()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_targetType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_direction <em>Mdirection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mdirection</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_direction()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_direction();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_rpn <em>Mrpn</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mrpn</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_rpn()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EReference getCGIAnchor_M_rpn();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_anglePoint1 <em>Mangle Point1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mangle Point1</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_anglePoint1()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_anglePoint1();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_anglePoint2 <em>Mangle Point2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mangle Point2</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_anglePoint2()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_anglePoint2();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_line_style <em>Mline style</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mline style</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_line_style()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_line_style();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_SourcePort <em>MSource Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>MSource Port</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_SourcePort()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_SourcePort();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_TargetPort <em>MTarget Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>MTarget Port</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_TargetPort()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_TargetPort();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getProperties()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EReference getCGIAnchor_Properties();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_color <em>Mcolor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mcolor</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_color()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EReference getCGIAnchor_M_color();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_lineWidth <em>Mline Width</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mline Width</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_lineWidth()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_lineWidth();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_arrow <em>Marrow</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Marrow</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor#getM_arrow()
	 * @see #getCGIAnchor()
	 * @generated
	 */
	EAttribute getCGIAnchor_M_arrow();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation <em>CGI Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Annotation</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation
	 * @generated
	 */
	EClass getCGIAnnotation();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getProperties()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EReference getCGIAnnotation_Properties();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_pParent()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EReference getCGIAnnotation_M_pParent();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_transform <em>Mtransform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mtransform</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_transform()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_M_transform();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_AdditionalLabel <em>MAdditional Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>MAdditional Label</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_AdditionalLabel()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EReference getCGIAnnotation_M_AdditionalLabel();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_polygon <em>Mpolygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mpolygon</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_polygon()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_M_polygon();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_nNameFormat <em>MnName Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnName Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_nNameFormat()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_M_nNameFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_nIsNameFormat <em>MnIs Name Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnIs Name Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_nIsNameFormat()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_M_nIsNameFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getITempdisplayTextFlag <em>ITempdisplay Text Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>ITempdisplay Text Flag</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getITempdisplayTextFlag()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_ITempdisplayTextFlag();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_bIsBoxStyle <em>MbIs Box Style</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbIs Box Style</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_bIsBoxStyle()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_M_bIsBoxStyle();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_pModelObject()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EReference getCGIAnnotation_M_pModelObject();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_color <em>Mcolor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mcolor</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_color()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EReference getCGIAnnotation_M_color();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_lineWidth <em>Mline Width</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mline Width</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_lineWidth()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_M_lineWidth();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getFrameset <em>Frameset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Frameset</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getFrameset()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_Frameset();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getCompartments <em>Compartments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Compartments</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getCompartments()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EReference getCGIAnnotation_Compartments();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_bIsStructured <em>MbIs Structured</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbIs Structured</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_bIsStructured()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_M_bIsStructured();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_bFramesetModified <em>MbFrameset Modified</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbFrameset Modified</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation#getM_bFramesetModified()
	 * @see #getCGIAnnotation()
	 * @generated
	 */
	EAttribute getCGIAnnotation_M_bFramesetModified();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow <em>CGI Arrow</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Arrow</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow
	 * @generated
	 */
	EClass getCGIArrow();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_pModelObject()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EReference getCGIArrow_M_pModelObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_pParent()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EAttribute getCGIArrow_M_pParent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_pSource <em>MpSource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpSource</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_pSource()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EReference getCGIArrow_M_pSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_sourceType <em>Msource Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Msource Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_sourceType()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EAttribute getCGIArrow_M_sourceType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_pTarget <em>MpTarget</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpTarget</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_pTarget()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EReference getCGIArrow_M_pTarget();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_targetType <em>Mtarget Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mtarget Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_targetType()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EAttribute getCGIArrow_M_targetType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_direction <em>Mdirection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mdirection</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_direction()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EAttribute getCGIArrow_M_direction();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_rpn <em>Mrpn</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mrpn</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_rpn()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EReference getCGIArrow_M_rpn();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_anglePoint1 <em>Mangle Point1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mangle Point1</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_anglePoint1()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EAttribute getCGIArrow_M_anglePoint1();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_anglePoint2 <em>Mangle Point2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mangle Point2</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_anglePoint2()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EAttribute getCGIArrow_M_anglePoint2();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_line_style <em>Mline style</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mline style</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_line_style()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EAttribute getCGIArrow_M_line_style();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_SourcePort <em>MSource Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>MSource Port</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_SourcePort()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EAttribute getCGIArrow_M_SourcePort();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_TargetPort <em>MTarget Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>MTarget Port</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow#getM_TargetPort()
	 * @see #getCGIArrow()
	 * @generated
	 */
	EAttribute getCGIArrow_M_TargetPort();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd <em>CGI Association End</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Association End</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd
	 * @generated
	 */
	EClass getCGIAssociationEnd();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getProperties()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_Properties();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pModelObject()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_pModelObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pParent()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_pParent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pSource <em>MpSource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpSource</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pSource()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_pSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_sourceType <em>Msource Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Msource Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_sourceType()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_sourceType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pTarget <em>MpTarget</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpTarget</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pTarget()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_pTarget();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_targetType <em>Mtarget Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mtarget Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_targetType()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_targetType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_direction <em>Mdirection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mdirection</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_direction()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_direction();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_rpn <em>Mrpn</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mrpn</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_rpn()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_rpn();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_anglePoint1 <em>Mangle Point1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mangle Point1</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_anglePoint1()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_anglePoint1();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_anglePoint2 <em>Mangle Point2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mangle Point2</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_anglePoint2()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_anglePoint2();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_line_style <em>Mline style</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mline style</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_line_style()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_line_style();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_SourcePort <em>MSource Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>MSource Port</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_SourcePort()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_SourcePort();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_TargetPort <em>MTarget Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>MTarget Port</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_TargetPort()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_TargetPort();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pInverseModelObject <em>MpInverse Model Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>MpInverse Model Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pInverseModelObject()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_pInverseModelObject();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pInstance <em>MpInstance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>MpInstance</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pInstance()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_pInstance();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pInverseInstance <em>MpInverse Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>MpInverse Instance</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_pInverseInstance()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_pInverseInstance();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowSourceMultiplicity <em>MbShow Source Multiplicity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbShow Source Multiplicity</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowSourceMultiplicity()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_bShowSourceMultiplicity();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowSourceRole <em>MbShow Source Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbShow Source Role</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowSourceRole()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_bShowSourceRole();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowTargetMultiplicity <em>MbShow Target Multiplicity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbShow Target Multiplicity</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowTargetMultiplicity()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_bShowTargetMultiplicity();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowTargetRole <em>MbShow Target Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbShow Target Role</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowTargetRole()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_bShowTargetRole();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowLinkName <em>MbShow Link Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbShow Link Name</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowLinkName()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_bShowLinkName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowSpecificType <em>MbShow Specific Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbShow Specific Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowSpecificType()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_bShowSpecificType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bInstance <em>MbInstance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbInstance</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bInstance()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_bInstance();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowQualifier1 <em>MbShow Qualifier1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbShow Qualifier1</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowQualifier1()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_bShowQualifier1();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowQualifier2 <em>MbShow Qualifier2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MbShow Qualifier2</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_bShowQualifier2()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_bShowQualifier2();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_sourceRole <em>Msource Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Msource Role</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_sourceRole()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_sourceRole();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_targetRole <em>Mtarget Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mtarget Role</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_targetRole()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_targetRole();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_sourceMultiplicity <em>Msource Multiplicity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Msource Multiplicity</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_sourceMultiplicity()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_sourceMultiplicity();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_targetMultiplicity <em>Mtarget Multiplicity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mtarget Multiplicity</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_targetMultiplicity()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_targetMultiplicity();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_sourceQualifier <em>Msource Qualifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Msource Qualifier</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_sourceQualifier()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_sourceQualifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_targetQualifier <em>Mtarget Qualifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mtarget Qualifier</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_targetQualifier()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EReference getCGIAssociationEnd_M_targetQualifier();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_specificType <em>Mspecific Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mspecific Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_specificType()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_specificType();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_arrow <em>Marrow</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Marrow</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd#getM_arrow()
	 * @see #getCGIAssociationEnd()
	 * @generated
	 */
	EAttribute getCGIAssociationEnd_M_arrow();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole <em>CGI Association Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Association Role</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole
	 * @generated
	 */
	EClass getCGIAssociationRole();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_pModelObject()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EReference getCGIAssociationRole_M_pModelObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_pParent()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_pParent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_pSource <em>MpSource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpSource</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_pSource()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EReference getCGIAssociationRole_M_pSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_sourceType <em>Msource Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Msource Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_sourceType()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_sourceType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_pTarget <em>MpTarget</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpTarget</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_pTarget()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EReference getCGIAssociationRole_M_pTarget();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_targetType <em>Mtarget Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mtarget Type</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_targetType()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_targetType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_direction <em>Mdirection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mdirection</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_direction()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_direction();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_rpn <em>Mrpn</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mrpn</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_rpn()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EReference getCGIAssociationRole_M_rpn();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_anglePoint1 <em>Mangle Point1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mangle Point1</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_anglePoint1()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_anglePoint1();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_anglePoint2 <em>Mangle Point2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mangle Point2</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_anglePoint2()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_anglePoint2();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_line_style <em>Mline style</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mline style</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_line_style()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_line_style();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_SourcePort <em>MSource Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>MSource Port</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_SourcePort()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_SourcePort();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_TargetPort <em>MTarget Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>MTarget Port</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_TargetPort()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_TargetPort();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_arrow <em>Marrow</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Marrow</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getM_arrow()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EAttribute getCGIAssociationRole_M_arrow();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole#getProperties()
	 * @see #getCGIAssociationRole()
	 * @generated
	 */
	EReference getCGIAssociationRole_Properties();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass <em>CGI Basic Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Basic Class</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass
	 * @generated
	 */
	EClass getCGIBasicClass();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_pModelObject()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EReference getCGIBasicClass_M_pModelObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_pParent()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EReference getCGIBasicClass_M_pParent();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_transform <em>Mtransform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mtransform</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_transform()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EAttribute getCGIBasicClass_M_transform();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_AdditionalLabel <em>MAdditional Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>MAdditional Label</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_AdditionalLabel()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EReference getCGIBasicClass_M_AdditionalLabel();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_polygon <em>Mpolygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mpolygon</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_polygon()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EAttribute getCGIBasicClass_M_polygon();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_nNameFormat <em>MnName Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnName Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_nNameFormat()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EAttribute getCGIBasicClass_M_nNameFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_nIsNameFormat <em>MnIs Name Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnIs Name Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_nIsNameFormat()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EAttribute getCGIBasicClass_M_nIsNameFormat();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getCompartments <em>Compartments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Compartments</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getCompartments()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EReference getCGIBasicClass_Compartments();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getProperties()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EReference getCGIBasicClass_Properties();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_pImageViewData <em>MpImage View Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpImage View Data</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass#getM_pImageViewData()
	 * @see #getCGIBasicClass()
	 * @generated
	 */
	EReference getCGIBasicClass_M_pImageViewData();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState <em>CGI Block State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Block State</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState
	 * @generated
	 */
	EClass getCGIBlockState();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_pModelObject()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EReference getCGIBlockState_M_pModelObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_pParent()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EReference getCGIBlockState_M_pParent();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_transform <em>Mtransform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mtransform</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_transform()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_M_transform();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_polygon <em>Mpolygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mpolygon</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_polygon()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_M_polygon();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_nNameFormat <em>MnName Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnName Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_nNameFormat()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_M_nNameFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_nIsNameFormat <em>MnIs Name Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnIs Name Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_nIsNameFormat()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_M_nIsNameFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getNAndLineCount <em>NAnd Line Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>NAnd Line Count</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getNAndLineCount()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_NAndLineCount();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_pInheritsFrom <em>MpInherits From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>MpInherits From</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_pInheritsFrom()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EReference getCGIBlockState_M_pInheritsFrom();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_nInheritanceMask <em>MnInheritance Mask</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnInheritance Mask</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_nInheritanceMask()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_M_nInheritanceMask();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_pDefaultComponentRelation <em>MpDefault Component Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MpDefault Component Relation</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_pDefaultComponentRelation()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_M_pDefaultComponentRelation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_NameDisplayMode <em>MName Display Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MName Display Mode</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_NameDisplayMode()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_M_NameDisplayMode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_ActDescLablDiaplayMode <em>MAct Desc Labl Diaplay Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MAct Desc Labl Diaplay Mode</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_ActDescLablDiaplayMode()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_M_ActDescLablDiaplayMode();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getProperties()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EReference getCGIBlockState_Properties();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_AdditionalLabel <em>MAdditional Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>MAdditional Label</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_AdditionalLabel()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EReference getCGIBlockState_M_AdditionalLabel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_moveAndLineTimeStamp <em>Mmove And Line Time Stamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mmove And Line Time Stamp</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getM_moveAndLineTimeStamp()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_M_moveAndLineTimeStamp();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getCompartments <em>Compartments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Compartments</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getCompartments()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EReference getCGIBlockState_Compartments();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getFrameset <em>Frameset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Frameset</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState#getFrameset()
	 * @see #getCGIBlockState()
	 * @generated
	 */
	EAttribute getCGIBlockState_Frameset();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox <em>CGI Box</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Box</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox
	 * @generated
	 */
	EClass getCGIBox();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_pModelObject()
	 * @see #getCGIBox()
	 * @generated
	 */
	EReference getCGIBox_M_pModelObject();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_polygon <em>Mpolygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mpolygon</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_polygon()
	 * @see #getCGIBox()
	 * @generated
	 */
	EAttribute getCGIBox_M_polygon();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_nNameFormat <em>MnName Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnName Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_nNameFormat()
	 * @see #getCGIBox()
	 * @generated
	 */
	EAttribute getCGIBox_M_nNameFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_nIsNameFormat <em>MnIs Name Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>MnIs Name Format</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_nIsNameFormat()
	 * @see #getCGIBox()
	 * @generated
	 */
	EAttribute getCGIBox_M_nIsNameFormat();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getCompartments <em>Compartments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Compartments</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getCompartments()
	 * @see #getCGIBox()
	 * @generated
	 */
	EReference getCGIBox_Compartments();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_pParent()
	 * @see #getCGIBox()
	 * @generated
	 */
	EReference getCGIBox_M_pParent();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_transform <em>Mtransform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mtransform</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getM_transform()
	 * @see #getCGIBox()
	 * @generated
	 */
	EAttribute getCGIBox_M_transform();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox#getProperties()
	 * @see #getCGIBox()
	 * @generated
	 */
	EReference getCGIBox_Properties();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray <em>CGI Button Array</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CGI Button Array</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray
	 * @generated
	 */
	EClass getCGIButtonArray();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getProperties()
	 * @see #getCGIButtonArray()
	 * @generated
	 */
	EReference getCGIButtonArray_Properties();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getM_pModelObject <em>MpModel Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpModel Object</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getM_pModelObject()
	 * @see #getCGIButtonArray()
	 * @generated
	 */
	EReference getCGIButtonArray_M_pModelObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getM_pParent <em>MpParent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>MpParent</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getM_pParent()
	 * @see #getCGIButtonArray()
	 * @generated
	 */
	EReference getCGIButtonArray_M_pParent();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getM_transform <em>Mtransform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mtransform</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getM_transform()
	 * @see #getCGIButtonArray()
	 * @generated
	 */
	EAttribute getCGIButtonArray_M_transform();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getM_polygon <em>Mpolygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mpolygon</em>'.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray#getM_polygon()
	 * @see #getCGIButtonArray()
	 * @generated
	 */
	EAttribute getCGIButtonArray_M_polygon();

	/