/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClass;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstParam;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>ITemplate Inst Param</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstParamImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstParamImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstParamImpl#getModifiedTimeWeak <em>Modified Time Weak</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstParamImpl#getValue <em>Value</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstParamImpl#getArgValue <em>Arg Value</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.ITemplateInstParamImpl#getOnTheFlyValue <em>On The Fly Value</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ITemplateInstParamImpl extends MinimalEObjectImpl.Container implements ITemplateInstParam {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getModifiedTimeWeak() <em>Modified Time Weak</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModifiedTimeWeak()
	 * @generated
	 * @ordered
	 */
	protected static final String MODIFIED_TIME_WEAK_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getModifiedTimeWeak() <em>Modified Time Weak</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModifiedTimeWeak()
	 * @generated
	 * @ordered
	 */
	protected String modifiedTimeWeak = MODIFIED_TIME_WEAK_EDEFAULT;

	/**
	 * The cached value of the '{@link #getValue() <em>Value</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected IClass value;

	/**
	 * The default value of the '{@link #getArgValue() <em>Arg Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArgValue()
	 * @generated
	 * @ordered
	 */
	protected static final String ARG_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getArgValue() <em>Arg Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArgValue()
	 * @generated
	 * @ordered
	 */
	protected String argValue = ARG_VALUE_EDEFAULT;

	/**
	 * The default value of the '{@link #getOnTheFlyValue() <em>On The Fly Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOnTheFlyValue()
	 * @generated
	 * @ordered
	 */
	protected static final String ON_THE_FLY_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOnTheFlyValue() <em>On The Fly Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOnTheFlyValue()
	 * @generated
	 * @ordered
	 */
	protected String onTheFlyValue = ON_THE_FLY_VALUE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITemplateInstParamImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLRpyPackage.eINSTANCE.getITemplateInstParam();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, UMLRpyPackage.ITEMPLATE_INST_PARAM__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, UMLRpyPackage.ITEMPLATE_INST_PARAM__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getModifiedTimeWeak() {
		return modifiedTimeWeak;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setModifiedTimeWeak(String newModifiedTimeWeak) {
		String oldModifiedTimeWeak = modifiedTimeWeak;
		modifiedTimeWeak = newModifiedTimeWeak;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, UMLRpyPackage.ITEMPLATE_INST_PARAM__MODIFIED_TIME_WEAK, oldModifiedTimeWeak, modifiedTimeWeak));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IClass getValue() {
		if (value != null && value.eIsProxy()) {
			InternalEObject oldValue = (InternalEObject)value;
			value = (IClass)eResolveProxy(oldValue);
			if (value != oldValue) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, UMLRpyPackage.ITEMPLATE_INST_PARAM__VALUE, oldValue, value));
			}
		}
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IClass basicGetValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue(IClass newValue) {
		IClass oldValue = value;
		value = newValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, UMLRpyPackage.ITEMPLATE_INST_PARAM__VALUE, oldValue, value));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getArgValue() {
		return argValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setArgValue(String newArgValue) {
		String oldArgValue = argValue;
		argValue = newArgValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, UMLRpyPackage.ITEMPLATE_INST_PARAM__ARG_VALUE, oldArgValue, argValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOnTheFlyValue() {
		return onTheFlyValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOnTheFlyValue(String newOnTheFlyValue) {
		String oldOnTheFlyValue = onTheFlyValue;
		onTheFlyValue = newOnTheFlyValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, UMLRpyPackage.ITEMPLATE_INST_PARAM__ON_THE_FLY_VALUE, oldOnTheFlyValue, onTheFlyValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ID:
				return getId();
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__NAME:
				return getName();
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__MODIFIED_TIME_WEAK:
				return getModifiedTimeWeak();
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__VALUE:
				if (resolve) return getValue();
				return basicGetValue();
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ARG_VALUE:
				return getArgValue();
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ON_THE_FLY_VALUE:
				return getOnTheFlyValue();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ID:
				setId((String)newValue);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__NAME:
				setName((String)newValue);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__MODIFIED_TIME_WEAK:
				setModifiedTimeWeak((String)newValue);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__VALUE:
				setValue((IClass)newValue);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ARG_VALUE:
				setArgValue((String)newValue);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ON_THE_FLY_VALUE:
				setOnTheFlyValue((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ID:
				setId(ID_EDEFAULT);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__NAME:
				setName(NAME_EDEFAULT);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__MODIFIED_TIME_WEAK:
				setModifiedTimeWeak(MODIFIED_TIME_WEAK_EDEFAULT);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__VALUE:
				setValue((IClass)null);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ARG_VALUE:
				setArgValue(ARG_VALUE_EDEFAULT);
				return;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ON_THE_FLY_VALUE:
				setOnTheFlyValue(ON_THE_FLY_VALUE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__MODIFIED_TIME_WEAK:
				return MODIFIED_TIME_WEAK_EDEFAULT == null ? modifiedTimeWeak != null : !MODIFIED_TIME_WEAK_EDEFAULT.equals(modifiedTimeWeak);
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__VALUE:
				return value != null;
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ARG_VALUE:
				return ARG_VALUE_EDEFAULT == null ? argValue != null : !ARG_VALUE_EDEFAULT.equals(argValue);
			case UMLRpyPackage.ITEMPLATE_INST_PARAM__ON_THE_FLY_VALUE:
				return ON_THE_FLY_VALUE_EDEFAULT == null ? onTheFlyValue != null : !ON_THE_FLY_VALUE_EDEFAULT.equals(onTheFlyValue);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: "); //$NON-NLS-1$
		result.append(id);
		result.append(", name: "); //$NON-NLS-1$
		result.append(name);
		result.append(", modifiedTimeWeak: "); //$NON-NLS-1$
		result.append(modifiedTimeWeak);
		result.append(", argValue: "); //$NON-NLS-1$
		result.append(argValue);
		result.append(", onTheFlyValue: "); //$NON-NLS-1$
		result.append(onTheFlyValue);
		result.append(')');
		return result.toString();
	}

} //ITemplateInstParamImpl
