/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.importer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.interoperability.rpy.Activator;
import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyFileHandler;
import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyProjectHandler;
import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyUtil;
import org.eclipse.papyrus.interoperability.rpy.messages.Messages;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyContent;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyFeature;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyFeatureValue;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyFile;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyNode;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyNodeList;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpySimpleValueElement;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.SimpleValueList;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProject;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyFactory;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage;

public class UMLRpyImporter {
    private RpyProjectHandler projectHandler;
    private ResourceSet resSet = new ResourceSetImpl();
    private IProject rootProject = null;
    private String targetPath;
    Map<EObject, EObject> transformedObjectMap = new HashMap<EObject, EObject>();
    Map<RpyFileHandler, Resource> fileToResourceMap = new HashMap<RpyFileHandler, Resource>();

    public UMLRpyImporter(String rpyPath, String targetPath) {
        this.projectHandler = new RpyProjectHandler(rpyPath);
        this.targetPath = targetPath;
    }

    public IProject getRootProject() {
        if (this.rootProject == null) {
            this.doTransformation();
        }
        return this.rootProject;
    }

    public void save() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ESCAPE_USING_CDATA", true);
        options.put("XML_VERSION", "1.1");
        for (Resource res : this.resSet.getResources()) {
            try {
                res.save(options);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    private void doTransformation() {
        RpyFileHandler projectFileHandler = this.projectHandler.getProjectFile();
        EObject rootTransformedObject = this.transform(projectFileHandler);
        if (rootTransformedObject instanceof IProject) {
            this.rootProject = (IProject)rootTransformedObject;
            if (projectFileHandler.getRpyFile() != null && projectFileHandler.getRpyFile().getVersion() != null) {
                this.rootProject.setVersion(projectFileHandler.getRpyFile().getVersion());
            }
            for (RpyNode proxyNode : this.projectHandler.getAllProxies()) {
                EObject transformedProxy = this.transformedObjectMap.get(proxyNode);
                if (transformedProxy == null) continue;
                this.rootProject.eResource().getContents().add((Object)transformedProxy);
            }
        }
    }

    private EObject transform(RpyFileHandler rpyFileHandler) {
        Resource outputRes = this.getResource(rpyFileHandler);
        if (outputRes.getContents().isEmpty() || outputRes.getContents().get(0) instanceof EAnnotation) {
            RpyFile rpyFile = rpyFileHandler.getRpyFile();
            ArrayList<EObject> roots = new ArrayList<EObject>();
            for (RpyContent fileContent : rpyFile.getContents()) {
                EObject ret;
                if (!(fileContent instanceof RpyNode) || (ret = this.transformNode((RpyNode)fileContent)) == null) continue;
                roots.add(ret);
            }
            outputRes.getContents().addAll(0, roots);
        }
        if (outputRes.getContents().isEmpty()) {
            return null;
        }
        return (EObject)outputRes.getContents().get(0);
    }

    private EObject transformNode(RpyNode node) {
        String nodeName;
        EClass targetEClass;
        EObject ret = this.transformedObjectMap.get(node);
        if (ret == null && (targetEClass = (EClass)UMLRpyPackage.eINSTANCE.getEClassifier(nodeName = node.getName())) != null) {
            EStructuralFeature graphicalElementsFeature;
            ret = UMLRpyFactory.eINSTANCE.create(targetEClass);
            this.transformedObjectMap.put((EObject)node, ret);
            ArrayList<EObject> subNodes = new ArrayList<EObject>();
            for (RpyContent nodeContent : node.getContents()) {
                EObject transformedNode;
                if (nodeContent instanceof RpyFeature) {
                    this.transformFeature(ret, (RpyFeature)nodeContent);
                    continue;
                }
                if (!(nodeContent instanceof RpyNode) || (transformedNode = this.transformNode((RpyNode)nodeContent)) == null) continue;
                subNodes.add(transformedNode);
            }
            if (!subNodes.isEmpty() && (graphicalElementsFeature = targetEClass.getEStructuralFeature("graphElements")) != null) {
                this.setEReferenceValue(ret, graphicalElementsFeature, subNodes);
            }
        }
        return ret;
    }

    private void transformFeature(EObject receiver, RpyFeature rpyFeature) {
        EStructuralFeature targetFeature = receiver.eClass().getEStructuralFeature(rpyFeature.getName().replaceAll("^_", ""));
        if (targetFeature != null) {
            RpyFeatureValue rpyFeatureValue = RpyUtil.getFeatureValue(rpyFeature);
            if (rpyFeatureValue instanceof SimpleValueList) {
                if (RpyUtil.isDirectReference(rpyFeature)) {
                    RpyNode referencedNode = this.projectHandler.getSimpleFeatureReferencedNode(rpyFeature);
                    this.transformOwningHandlerIfDifferent(referencedNode, rpyFeature);
                    EObject value = this.transformNode(referencedNode);
                    if (value != null && targetFeature instanceof EReference && this.isCompatibleType((EReference)targetFeature, value)) {
                        this.setEReferenceValue(receiver, targetFeature, value);
                    }
                } else if (targetFeature instanceof EAttribute) {
                    if (targetFeature.isMany()) {
                        List featValueList = (List)receiver.eGet(targetFeature);
                        for (RpySimpleValueElement valueElement : ((SimpleValueList)rpyFeatureValue).getValueElements()) {
                            for (String value : valueElement.getValues()) {
                                featValueList.add(value.replaceAll("^\"", "").replaceAll("\"$", ""));
                            }
                        }
                    } else {
                        receiver.eSet(targetFeature, (Object)RpyUtil.getStringValue((SimpleValueList)rpyFeatureValue).replaceAll("^\"", "").replaceAll("\"$", ""));
                    }
                }
            } else if (rpyFeatureValue instanceof RpyNodeList) {
                RpyNodeList nodeList = (RpyNodeList)rpyFeatureValue;
                ArrayList<EObject> transformedObjects = new ArrayList<EObject>();
                for (RpyNode rpyNode : this.projectHandler.getNodes(nodeList)) {
                    this.transformOwningHandlerIfDifferent(rpyNode, rpyFeature);
                    EObject targetObject = this.transformNode(rpyNode);
                    if (targetObject == null) continue;
                    transformedObjects.add(targetObject);
                }
                if (targetFeature instanceof EReference && this.isCompatibleType((EReference)targetFeature, transformedObjects)) {
                    this.setEReferenceValue(receiver, targetFeature, transformedObjects);
                }
            }
        } else {
            RpyNode sourceNode = (RpyNode)rpyFeature.eContainer();
            if ("_filename".equals(rpyFeature.getName())) {
                EAnnotation eannotation = EcoreFactory.eINSTANCE.createEAnnotation();
                String fileName = (String)((RpySimpleValueElement)((SimpleValueList)rpyFeature.getValue()).getValueElements().get(0)).getValues().get(0);
                if (fileName.startsWith("\"")) {
                    fileName = fileName.substring(1);
                }
                if (fileName.endsWith("\"")) {
                    fileName = fileName.substring(0, fileName.length() - 1);
                }
                eannotation.getDetails().put((Object)"fileName", (Object)fileName);
                eannotation.setSource("Rpy Filename");
                if (receiver instanceof EModelElement) {
                    ((EModelElement)receiver).getEAnnotations().add((Object)eannotation);
                }
            } else {
                Activator.log.error(NLS.bind((String)Messages.UMLRpyImporter_FeatureNotFound, (Object[])new String[]{rpyFeature.getName(), receiver.eClass().getName(), RpyUtil.getNodeIndexInFile(sourceNode), this.projectHandler.getOwningFileHandler(sourceNode).getURI().toFileString()}), null);
            }
        }
    }

    private void transformOwningHandlerIfDifferent(RpyNode referencedNode, RpyFeature rpyFeature) {
        RpyFileHandler referencedNodeHandler = this.projectHandler.getOwningFileHandler(referencedNode);
        if (referencedNodeHandler != null && referencedNodeHandler != this.projectHandler.getOwningFileHandler((RpyNode)rpyFeature.eContainer())) {
            this.transform(referencedNodeHandler);
        }
    }

    private void setEReferenceValue(EObject receiver, EStructuralFeature targetFeature, Object value) {
        if (targetFeature.isMany()) {
            List receiverList = (List)receiver.eGet(targetFeature);
            if (value instanceof List) {
                receiverList.addAll((List)value);
            } else {
                receiverList.add(value);
            }
        } else if (value instanceof List) {
            if (!((List)value).isEmpty()) {
                receiver.eSet(targetFeature, ((List)value).get(0));
            }
        } else {
            receiver.eSet(targetFeature, value);
        }
    }

    private boolean isCompatibleType(EReference targetReference, Object value) {
        boolean result = true;
        EClass containingEClass = targetReference.getEContainingClass();
        EClass eType = targetReference.getEReferenceType();
        if (value instanceof Collection) {
            for (Object valueElement : (Collection)value) {
                if (eType.isInstance(valueElement)) continue;
                result = false;
                value = valueElement;
                break;
            }
        } else {
            result = eType.isInstance(value);
        }
        if (!result) {
            Activator.log.warn("Object " + value + " has an incompatible type with " + eType.getName() + " of feature " + targetReference.getName() + " of EClass " + containingEClass.getName() + ".\n This element won't be imported. RpyMetamodel implementation in Papyrus should be updated");
        }
        return result;
    }

    private Resource getResource(RpyFileHandler rpyFileHandler) {
        URI inURI;
        Resource ret = this.fileToResourceMap.get(rpyFileHandler);
        if (ret == null && (inURI = rpyFileHandler.getURI()) != null) {
            URI outURI = URI.createFileURI((String)this.targetPath).appendSegment(inURI.trimFileExtension().lastSegment()).appendFileExtension("umlrpy");
            ret = this.resSet.createResource(outURI);
            this.fileToResourceMap.put(rpyFileHandler, ret);
        }
        return ret;
    }
}

