/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.transformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.papyrus.infra.internationalization.resource.InternationalizationResource;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.interoperability.rpy.Activator;
import org.eclipse.papyrus.interoperability.rpy.xmi.PreserveRpySemanticIDHelper;
import org.eclipse.papyrus.uml.internationalization.utils.UMLInternationalizationKeyResolver;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.concurrent.ResourceAccessHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.AbstractImportTransformation;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IDependencyAnalysisHelper;

public class RpyImportTransformation
extends AbstractImportTransformation {
    private InternationalizationResource propertiesResource;
    private ModelExtent inRpyModel;
    private ModelExtent umlPrimitivesTypes;
    private ModelExtent labels;

    public RpyImportTransformation(URI sourceURI, ThreadConfig config, IDependencyAnalysisHelper analysisHelper) {
        super(sourceURI, config, analysisHelper);
        DEBUG = true;
    }

    public RpyImportTransformation(URI sourceURI) {
        super(sourceURI);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.subTask("Loading source model " + this.getModelName());
        long startLoad = System.nanoTime();
        this.initResourceSet(monitor);
        int numberOfElements = this.countSupportedElements();
        monitor.beginTask("Importing " + this.getModelName(), numberOfElements);
        monitor.subTask("Loading transformations (This may take a few seconds for the first import)...");
        this.loadTransformations(monitor);
        List<ModelExtent> extents = this.getModelExtents();
        String statusMessage = String.format("Import %s", this.getModelName());
        MultiStatus generationStatus = new MultiStatus("org.eclipse.papyrus.interoperability.rpy", 0, statusMessage, null);
        this.context = this.createExecutionContext(monitor, generationStatus);
        this.getInPapyrusProfiles();
        long endLoad = System.nanoTime();
        this.loadingTime = endLoad - startLoad;
        this.prepareExtensions();
        long startExtensions = System.nanoTime();
        IStatus result = this.importExtensions(this.context, monitor, AbstractImportTransformation.ExtensionFunction::executeBefore);
        long endExtensions = System.nanoTime();
        this.importExtensionsTime = endExtensions - startExtensions;
        generationStatus.add(result);
        monitor.subTask("Importing semantic model...");
        URI semanticTransformationURI = this.getSemanticTransformationURI();
        if (semanticTransformationURI != null) {
            result = this.runTransformation(semanticTransformationURI, extents, monitor);
            generationStatus.add(result);
        }
        Collection<URI> transformations = this.getDiagramTransformationURIs();
        monitor.subTask("Importing diagrams...");
        Iterator<URI> iterator = transformations.iterator();
        while (iterator.hasNext()) {
            URI transformationURI = iterator.next();
            result = this.runTransformation(transformationURI, extents, monitor);
            generationStatus.add(result);
        }
        Collection additional = this.getAdditionalTransformationURIs();
        if (!additional.isEmpty()) {
            monitor.subTask("Additional transformations...");
            for (URI transformationURI : additional) {
                result = this.runTransformation(transformationURI, extents, monitor);
                generationStatus.add(result);
            }
        }
        long startExtensionsAfter = System.nanoTime();
        result = this.importExtensions(this.context, monitor, AbstractImportTransformation.ExtensionFunction::executeAfter);
        long endExtensionsAfter = System.nanoTime();
        this.importExtensionsTime += endExtensionsAfter - startExtensionsAfter;
        if (generationStatus.getSeverity() <= 2) {
            monitor.subTask("Cleaning-up target model...");
            URI notationModelURI = null;
            URI sashModelURI = null;
            this.targetURI = this.convertToPapyrus(this.sourceURI, "uml");
            notationModelURI = this.convertToPapyrus(this.sourceURI, "notation");
            sashModelURI = this.convertToPapyrus(this.sourceURI, "di");
            if ("epx".equals(this.sourceURI.fileExtension())) {
                this.profileURIMappings.put(this.sourceURI, this.targetURI);
            }
            this.uriMappings.put(this.sourceURI, this.targetURI);
            this.umlResource = this.createUMLResource((ResourceSet)this.resourceSet, this.sourceURI, this.targetURI);
            List outUMLObjects = this.getInOutUMLModel().getContents();
            this.umlResource.getContents().addAll((Collection)outUMLObjects);
            PreserveRpySemanticIDHelper helper = new PreserveRpySemanticIDHelper(new Context(this.context));
            helper.keepIdForUMLResource((XMIResource)this.umlResource);
            this.context = null;
            GMFResource notationResource = new GMFResource(notationModelURI);
            this.resourceSet.getResources().add((Object)notationResource);
            List outNotationObjects = this.getInoutNotationModel().getContents();
            notationResource.getContents().addAll((Collection)outNotationObjects);
            LinkedList contentsCopy = new LinkedList(notationResource.getContents());
            for (EObject next : contentsCopy) {
                Diagram diagram;
                if (!(next instanceof Diagram) || (diagram = (Diagram)next).getType() != null && !"".equals(diagram.getType())) continue;
                this.delete((EObject)diagram);
            }
            URI propertyURI = this.convertToPapyrus(this.sourceURI, "properties");
            this.propertiesResource = this.createAndConfigureInternationalizationResource(propertyURI);
            this.resourceSet.getResources().add((Object)this.propertiesResource);
            this.propertiesResource.getContents().addAll((Collection)this.getInOutInternationalizationModel().getContents());
            XMIResourceImpl sashResource = new XMIResourceImpl(sashModelURI);
            this.resourceSet.getResources().add((Object)sashResource);
            List sashModelObjects = this.getOutSashModel().getContents();
            sashResource.getContents().addAll((Collection)sashModelObjects);
            this.configureResource((XMIResource)sashResource);
            this.configureResource((XMIResource)notationResource);
            this.configureResource((XMIResource)this.umlResource);
            LinkedList notationRootElements = new LinkedList(notationResource.getContents());
            for (EObject rootElement : notationRootElements) {
                if (rootElement instanceof View) {
                    View rootView = (View)rootElement;
                    if (rootView instanceof Diagram) continue;
                    if (DEBUG) {
                        String objectType = rootView.getElement() == null ? "None" : rootView.getElement().eClass().getName();
                        String viewType = rootView.getType() == null ? "None" : rootView.getType();
                        generationStatus.add((IStatus)new Status(2, "org.eclipse.papyrus.interoperability.rpy", "An orphaned view has been found after the migration. It will be removed. View Type: " + viewType + ", semantic type: " + objectType));
                    }
                    this.delete(rootElement);
                    continue;
                }
                if (!(rootElement instanceof Style)) continue;
                if (DEBUG) {
                    String styleType = rootElement.eClass().getName();
                    generationStatus.add((IStatus)new Status(2, "org.eclipse.papyrus.interoperability.rpy", "An orphaned style has been found after the migration. It will be removed. Style Type: " + styleType));
                }
                this.delete(rootElement);
            }
            monitor.subTask("Handling fragments...");
            Collection resourcesToSave = this.handleFragments(this.umlResource, (Resource)notationResource, (Resource)sashResource);
            resourcesToSave.add(this.propertiesResource);
            monitor.subTask("Deleting source diagrams...");
            for (Diagram diagram : this.diagramsToDelete) {
                EAnnotation annotation;
                EObject container = diagram.eContainer();
                this.delete((EObject)diagram);
                if (!(container instanceof EAnnotation) || !(annotation = (EAnnotation)container).getContents().isEmpty()) continue;
                this.delete((EObject)annotation);
            }
            this.diagramsToDelete.clear();
            monitor.subTask("Analyzing dangling references...");
            long startDangling = System.nanoTime();
            this.handleDanglingURIs(resourcesToSave);
            long endDangling = System.nanoTime();
            this.danglingRefTime = endDangling - startDangling;
            monitor.subTask("Saving models...");
            for (Resource resource : resourcesToSave) {
                try {
                    this.cleanMetadataAnnotations(resource);
                    ResourceAccessHelper.INSTANCE.saveResource(resource, null);
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                    generationStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.interoperability.rpy", "An exception occurred during save", (Throwable)ex));
                }
            }
        }
        monitor.subTask("Releasing memory...");
        this.unloadResourceSet((ResourceSet)this.resourceSet);
        this.resourceSet = null;
        this.umlResource = null;
        this.outUML = null;
        this.outSashModel = null;
        this.inParameters = null;
        this.outNotation = null;
        monitor.done();
        return generationStatus;
    }

    protected InternationalizationResource createAndConfigureInternationalizationResource(URI propertyURI) {
        if (this.propertiesResource == null) {
            this.propertiesResource = new InternationalizationResource(propertyURI);
            this.propertiesResource.getDefaultSaveOptions().put("internationalizationSort", Boolean.TRUE);
            this.propertiesResource.getDefaultSaveOptions().put("internationalizationKeyResolver", new UMLInternationalizationKeyResolver());
        }
        return this.propertiesResource;
    }

    protected Diagnostic loadInPapyrusProfiles() {
        return null;
    }

    protected int countSupportedElements() {
        return 1000;
    }

    protected Collection<URI> getDiagramTransformationURIs() {
        return ListHelper.asList((Object[])new URI[]{this.getTransformationURI("Rpy2PapyrusNotation", "org.eclipse.papyrus.interoperability.rpy")});
    }

    protected URI getSemanticTransformationURI() {
        return null;
    }

    protected Collection<URI> getProfilesTransformationURI() {
        return Collections.emptyList();
    }

    protected Collection<URI> getAllTransformationURIs() {
        Collection additionalTransformationURIs;
        Collection<URI> profilesTransformationURI;
        Collection<URI> diagramTransformationURI;
        ArrayList<URI> allTransformations = new ArrayList<URI>();
        URI semanticTransformationURI = this.getSemanticTransformationURI();
        if (semanticTransformationURI != null) {
            allTransformations.add(semanticTransformationURI);
        }
        if ((diagramTransformationURI = this.getDiagramTransformationURIs()) != null) {
            allTransformations.addAll(diagramTransformationURI);
        }
        if ((profilesTransformationURI = this.getProfilesTransformationURI()) != null) {
            allTransformations.addAll(profilesTransformationURI);
        }
        if ((additionalTransformationURIs = this.getAdditionalTransformationURIs()) != null) {
            allTransformations.addAll(additionalTransformationURIs);
        }
        return allTransformations;
    }

    protected List<ModelExtent> getModelExtents() {
        LinkedList<ModelExtent> allExtents = new LinkedList<ModelExtent>();
        allExtents.add(this.getInRpyModel());
        allExtents.add(this.getInoutNotationModel());
        allExtents.add(this.getInOutUMLModel());
        allExtents.add(this.getSysML1_1Profile());
        allExtents.add(this.getInUMLPrimitivesTypes());
        allExtents.add(this.getInOutInternationalizationModel());
        return allExtents;
    }

    public ModelExtent getInUMLPrimitivesTypes() {
        URI umlPrimitivesTypesURI = URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
        Resource umlPrimitivesTypesResource = this.resourceSet.getResource(umlPrimitivesTypesURI, true);
        this.umlPrimitivesTypes = new BasicModelExtent((List)umlPrimitivesTypesResource.getContents());
        return this.umlPrimitivesTypes;
    }

    public ModelExtent getInRpyModel() {
        if (this.inRpyModel == null) {
            Resource resource = this.resourceSet.getResource(this.sourceURI, true);
            this.inRpyModel = new BasicModelExtent((List)resource.getContents());
        }
        return this.inRpyModel;
    }

    public ModelExtent getSysML1_1Profile() {
        URI sysMLProfile = URI.createURI((String)"pathmap://SysML_PROFILES/SysML.profile.uml");
        Resource fCMProfile = this.resourceSet.getResource(sysMLProfile, true);
        this.sysML11Profile = new BasicModelExtent((List)fCMProfile.getContents());
        return this.sysML11Profile;
    }

    public ModelExtent getInOutInternationalizationModel() {
        if (this.labels == null) {
            this.labels = new BasicModelExtent();
        }
        return this.labels;
    }

    protected void initTransformationProperties(ExecutionContextImpl context) {
    }

    protected URI convertToPapyrus(URI initialModelURI, String extension) {
        return initialModelURI.trimFileExtension().appendFileExtension(extension);
    }

    protected Resource createUMLResource(ResourceSet resourceSet, URI sourceResourceURI, URI targetResourceURI) {
        Resource resource = resourceSet.createResource(targetResourceURI, "org.eclipse.uml2.uml_5_0_0");
        return resource;
    }

    public ModelExtent getInOutUMLModel() {
        if (this.outUML == null) {
            this.outUML = new BasicModelExtent();
        }
        return this.outUML;
    }
}

