/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.commands.switchrepresentation;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.ConstraintBlockPropertyCompositeEditPart;
import org.eclipse.papyrus.sysml.diagram.common.figure.ConstraintBlockPropertyCompositeFigure;
import org.eclipse.papyrus.sysml.diagram.parametric.edit.part.CustomConstraintBlockPropertyCompositeEditPart;

public class SwitchConstraintPropertyRepresentationCommand
extends Command {
    private final GraphicalEditPart editPartToSwitch;

    public SwitchConstraintPropertyRepresentationCommand(GraphicalEditPart editPartToRefresh) {
        this.editPartToSwitch = editPartToRefresh;
    }

    public GraphicalEditPart getEditPartToSwitch() {
        return this.editPartToSwitch;
    }

    public void execute() {
        CustomConstraintBlockPropertyCompositeEditPart constraintBlockPropertyCompositeEditPart;
        ConstraintBlockPropertyCompositeFigure figure;
        if (this.getEditPartToSwitch() instanceof CustomConstraintBlockPropertyCompositeEditPart && (figure = (constraintBlockPropertyCompositeEditPart = (CustomConstraintBlockPropertyCompositeEditPart)this.getEditPartToSwitch()).getPrimaryShape()) instanceof ConstraintBlockPropertyCompositeFigure) {
            if (figure.getCorner() != 0) {
                this.switchToSquareRepresentationWithStructure(constraintBlockPropertyCompositeEditPart, (IFigure)figure);
            } else {
                this.switchToRoundedRepresentationWithoutStructure(constraintBlockPropertyCompositeEditPart, (IFigure)figure);
            }
        }
    }

    private void switchToSquareRepresentationWithStructure(CustomConstraintBlockPropertyCompositeEditPart editPart, IFigure figure) {
        int newCorner = 0;
        ((ConstraintBlockPropertyCompositeFigure)figure).setCorner(newCorner);
        View structureCompartment = editPart.getChildViewBySemanticHint("compartment_sysml_blockproperty_structure");
        if (structureCompartment != null) {
            structureCompartment.setVisible(true);
        } else {
            structureCompartment = ViewService.createNode((View)((View)editPart.getModel()), (String)"compartment_sysml_blockproperty_structure", (PreferencesHint)new PreferencesHint("org.eclipse.papyrus.sysml.diagram.parametric"));
            if (structureCompartment != null) {
                structureCompartment.setElement(editPart.resolveSemanticElement());
            }
        }
        editPart.getPrimaryShape().setTagLabel(String.valueOf(String.valueOf("\u00ab")) + "constraint" + String.valueOf("\u00bb"));
        StringValueStyle style = (StringValueStyle)((View)editPart.getModel()).getStyle(NotationPackage.eINSTANCE.getStringValueStyle());
        if (style == null) {
            ((View)editPart.getModel()).getStyles().add((Object)NotationFactory.eINSTANCE.createStringValueStyle());
        }
        style = (StringValueStyle)((View)editPart.getModel()).getStyle(NotationPackage.eINSTANCE.getStringValueStyle());
        style.setName("representation_mode_style");
        style.setStringValue("square_representation_with_structure");
        ConstraintBlockPropertyCompositeEditPart.setLastRepresentation((String)"square_representation_with_structure");
        editPart.setCornerLocators(newCorner);
    }

    private void switchToRoundedRepresentationWithoutStructure(CustomConstraintBlockPropertyCompositeEditPart editPart, IFigure figure) {
        int newCorner = 50;
        ((ConstraintBlockPropertyCompositeFigure)figure).setCorner(newCorner);
        View structureCompartmentFigure = editPart.getChildViewBySemanticHint("compartment_sysml_blockproperty_structure");
        if (structureCompartmentFigure != null) {
            structureCompartmentFigure.setVisible(false);
        }
        editPart.getPrimaryShape().setTagLabel("");
        StringValueStyle style = (StringValueStyle)((View)editPart.getModel()).getStyle(NotationPackage.eINSTANCE.getStringValueStyle());
        if (style == null) {
            ((View)editPart.getModel()).getStyles().add((Object)NotationFactory.eINSTANCE.createStringValueStyle());
        }
        style = (StringValueStyle)((View)editPart.getModel()).getStyle(NotationPackage.eINSTANCE.getStringValueStyle());
        style.setName("representation_mode_style");
        style.setStringValue("rounded_representation");
        ConstraintBlockPropertyCompositeEditPart.setLastRepresentation((String)"rounded_representation");
        editPart.setCornerLocators(newCorner);
    }

    public void undo() {
        this.execute();
    }

    public void redo() {
        this.execute();
    }
}

