/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rsa.wizard.pages;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.util.PropertiesDisplayHelper;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.Config;
import org.eclipse.papyrus.interoperability.rsa.messages.Messages;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class ImportConfigComposite
extends Composite {
    protected Config config;
    protected Collection<Object> transformationFiles;
    protected CheckboxTableViewer listViewer;
    protected ISelectionChangedListener listListener;
    protected DisplayEngine displayEngine;
    protected Collection<Object> uncheckedFiles;

    public ImportConfigComposite(Composite parent, int style, Config config) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.config = config;
        Composite filesComposite = new Composite((Composite)this, 2048);
        filesComposite.setLayout((Layout)new FillLayout());
        filesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite configComposite = new Composite((Composite)this, 2048);
        configComposite.setLayout((Layout)new FillLayout());
        configComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createFilesComposite(filesComposite);
        this.createParamComposite(configComposite);
    }

    protected void createFilesComposite(Composite parent) {
        Composite listComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        listComposite.setLayout((Layout)gridLayout);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)listComposite, (int)2818);
        GridData viewerGrid = new GridData(4, 4, true, true);
        this.listViewer.getTable().setLayoutData((Object)viewerGrid);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IFile) {
                    return FileUtil.getPath((IFile)((IFile)element), (boolean)true);
                }
                if (element instanceof File) {
                    return ((File)element).getAbsolutePath();
                }
                return Messages.WrongFileType;
            }
        });
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportConfigComposite.this.fireSelectionEvent(event);
            }
        };
        this.listViewer.addSelectionChangedListener(this.listListener);
        this.setTransformationFiles();
        this.createSelectionButtons(listComposite);
    }

    abstract void setViewerInput(Collection<Object> var1);

    abstract void createSelectionButtons(Composite var1);

    abstract void fireSelectionEvent(SelectionChangedEvent var1);

    public void setTransformationFiles() {
        this.transformationFiles = new LinkedList<Object>(Arrays.asList(this.listViewer.getCheckedElements()));
    }

    public void createParamComposite(Composite parent) {
        this.displayEngine = PropertiesDisplayHelper.display((Object)this.config, (Composite)parent);
    }

    public void dispose() {
        if (this.displayEngine != null) {
            this.displayEngine.dispose();
        }
        if (this.listListener != null) {
            this.listViewer.removeSelectionChangedListener(this.listListener);
        }
        super.dispose();
    }
}

