/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.edit.policy;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.provider.IGraphicalTypeRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.provider.CustomGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.provider.ElementTypes;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.provider.GraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.common.utils.SysMLCreateOrShowExistingElementHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.CreateOrShowExistingElementHelper;
import org.eclipse.papyrus.uml.service.types.command.CommentAnnotatedElementsCreateCommand;
import org.eclipse.papyrus.uml.service.types.command.CommentAnnotatedElementsReorientCommand;
import org.eclipse.papyrus.uml.service.types.command.ConstraintConstrainedElementsCreateCommand;
import org.eclipse.papyrus.uml.service.types.command.ConstraintConstrainedElementsReorientCommand;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomDefaultSemanticEditPolicy
extends DefaultSemanticEditPolicy {
    private IGraphicalTypeRegistry registry = new CustomGraphicalTypeRegistry();
    private IGraphicalTypeRegistry inheritedRegistry = new GraphicalTypeRegistry();
    private CreateOrShowExistingElementHelper existingElementHelper = new SysMLCreateOrShowExistingElementHelper();

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (ElementTypes.COMMENT_ANNOTATED_ELEMENT == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new CommentAnnotatedElementsCreateCommand(req));
        }
        if (ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementsCreateCommand(req));
        }
        String newEdgeGraphicalType = this.registry.getEdgeGraphicalType(req.getElementType());
        if (this.inheritedRegistry.isKnownEdgeType(newEdgeGraphicalType)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!this.registry.isKnownEdgeType(newEdgeGraphicalType)) {
            return UnexecutableCommand.INSTANCE;
        }
        Command defaultCommand = super.getCreateRelationshipCommand(req);
        if (defaultCommand.canExecute() && req.getSource() != null && req.getTarget() != null) {
            EClass eClass = req.getElementType().getEClass();
            IElementType elementType = req.getElementType();
            if (UMLPackage.eINSTANCE.getInterfaceRealization() == eClass) {
                return this.existingElementHelper.getCreateOrRestoreElementCommand(req, defaultCommand, elementType);
            }
            if (elementType.getEClass() == UMLPackage.eINSTANCE.getAssociation()) {
                return this.existingElementHelper.getCreateOrRestoreElementCommand(req, defaultCommand, elementType);
            }
            if (eClass == UMLPackage.eINSTANCE.getDependency()) {
                return this.existingElementHelper.getCreateOrRestoreElementCommand(req, defaultCommand, elementType);
            }
            if (eClass == UMLPackage.eINSTANCE.getGeneralization()) {
                return this.existingElementHelper.getCreateOrRestoreElementCommand(req, defaultCommand, elementType);
            }
            if (eClass == UMLPackage.eINSTANCE.getUsage()) {
                return this.existingElementHelper.getCreateOrRestoreElementCommand(req, defaultCommand, elementType);
            }
        }
        return defaultCommand;
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        String reconnectedViewType;
        View reconnectedView = (View)req.getParameter("graphical_edge");
        String string = reconnectedViewType = reconnectedView != null ? reconnectedView.getType() : "undefined_type";
        if (ElementTypes.COMMENT_ANNOTATED_ELEMENT.getSemanticHint().equals(reconnectedViewType)) {
            return this.getGEFWrapper((ICommand)new CommentAnnotatedElementsReorientCommand(req));
        }
        if (ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT.getSemanticHint().equals(reconnectedViewType)) {
            return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementsReorientCommand(req));
        }
        return super.getReorientReferenceRelationshipCommand(req);
    }
}

