/**
 * Copyright (c) 2015 CEA LIST.
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.sysml14.portsandflows.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.papyrus.sysml14.portsandflows.util.PortsandflowsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class PortsandflowsItemProviderAdapterFactory extends PortsandflowsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PortsandflowsItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.AcceptChangeStructuralFeatureEventAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AcceptChangeStructuralFeatureEventActionItemProvider acceptChangeStructuralFeatureEventActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.AcceptChangeStructuralFeatureEventAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAcceptChangeStructuralFeatureEventActionAdapter() {
		if (acceptChangeStructuralFeatureEventActionItemProvider == null) {
			acceptChangeStructuralFeatureEventActionItemProvider = new AcceptChangeStructuralFeatureEventActionItemProvider(this);
		}

		return acceptChangeStructuralFeatureEventActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.ChangeStructuralFeatureEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChangeStructuralFeatureEventItemProvider changeStructuralFeatureEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.ChangeStructuralFeatureEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChangeStructuralFeatureEventAdapter() {
		if (changeStructuralFeatureEventItemProvider == null) {
			changeStructuralFeatureEventItemProvider = new ChangeStructuralFeatureEventItemProvider(this);
		}

		return changeStructuralFeatureEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.DirectedFeature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DirectedFeatureItemProvider directedFeatureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.DirectedFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDirectedFeatureAdapter() {
		if (directedFeatureItemProvider == null) {
			directedFeatureItemProvider = new DirectedFeatureItemProvider(this);
		}

		return directedFeatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.FlowProperty} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FlowPropertyItemProvider flowPropertyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.FlowProperty}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFlowPropertyAdapter() {
		if (flowPropertyItemProvider == null) {
			flowPropertyItemProvider = new FlowPropertyItemProvider(this);
		}

		return flowPropertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.FullPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FullPortItemProvider fullPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.FullPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFullPortAdapter() {
		if (fullPortItemProvider == null) {
			fullPortItemProvider = new FullPortItemProvider(this);
		}

		return fullPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.InterfaceBlock} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceBlockItemProvider interfaceBlockItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.InterfaceBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterfaceBlockAdapter() {
		if (interfaceBlockItemProvider == null) {
			interfaceBlockItemProvider = new InterfaceBlockItemProvider(this);
		}

		return interfaceBlockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.InvocationOnNestedPortAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvocationOnNestedPortActionItemProvider invocationOnNestedPortActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.InvocationOnNestedPortAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvocationOnNestedPortActionAdapter() {
		if (invocationOnNestedPortActionItemProvider == null) {
			invocationOnNestedPortActionItemProvider = new InvocationOnNestedPortActionItemProvider(this);
		}

		return invocationOnNestedPortActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.ItemFlow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ItemFlowItemProvider itemFlowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.ItemFlow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createItemFlowAdapter() {
		if (itemFlowItemProvider == null) {
			itemFlowItemProvider = new ItemFlowItemProvider(this);
		}

		return itemFlowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.ProxyPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProxyPortItemProvider proxyPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.ProxyPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProxyPortAdapter() {
		if (proxyPortItemProvider == null) {
			proxyPortItemProvider = new ProxyPortItemProvider(this);
		}

		return proxyPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.sysml14.portsandflows.TriggerOnNestedPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TriggerOnNestedPortItemProvider triggerOnNestedPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.sysml14.portsandflows.TriggerOnNestedPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTriggerOnNestedPortAdapter() {
		if (triggerOnNestedPortItemProvider == null) {
			triggerOnNestedPortItemProvider = new TriggerOnNestedPortItemProvider(this);
		}

		return triggerOnNestedPortItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (acceptChangeStructuralFeatureEventActionItemProvider != null) acceptChangeStructuralFeatureEventActionItemProvider.dispose();
		if (changeStructuralFeatureEventItemProvider != null) changeStructuralFeatureEventItemProvider.dispose();
		if (directedFeatureItemProvider != null) directedFeatureItemProvider.dispose();
		if (flowPropertyItemProvider != null) flowPropertyItemProvider.dispose();
		if (fullPortItemProvider != null) fullPortItemProvider.dispose();
		if (interfaceBlockItemProvider != null) interfaceBlockItemProvider.dispose();
		if (invocationOnNestedPortActionItemProvider != null) invocationOnNestedPortActionItemProvider.dispose();
		if (itemFlowItemProvider != null) itemFlowItemProvider.dispose();
		if (proxyPortItemProvider != null) proxyPortItemProvider.dispose();
		if (triggerOnNestedPortItemProvider != null) triggerOnNestedPortItemProvider.dispose();
	}

}
