/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.sysml14.portsandflows;


import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.sysml14.portsandflows.internal.impl.FlowPropertyImpl;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.util.UMLUtil;

/**
 * 
 *
 */
public class FlowPropertyCustomImpl extends FlowPropertyImpl implements FlowProperty{

	/**
	 * Icons for displaying flow property orientation
	 */
	private static EList<Image> icons;


	/**
	 * @return the icons for flow property orientation
	 */
	public static EList<Image> getIcons(FlowProperty flowProperty) {
		if (icons == null){// for PERFORMANCE we call UMLUtil.getStereotype only once
			icons = UMLUtil.getStereotype(flowProperty).getIcons();
		}
		return icons;
	}
	
	
	/**
	 * Images registered in Profile are :
	 * 0 - FlowPort IN
	 * 1 - FlowPort OUT
	 * 2 - FlowPort INOUT
	 * 3 (other) - FlowPort (default, similar to INOUT)
	 */
	@Override
	public Image getIcon() {
		Image image = null;
		if (getBase_Property() != null) {
			EList<Image> iconList = getIcons(this);
			switch (getDirection()) {
			case IN:
				image = iconList.get(FlowDirection.IN.getValue());
				break;
			case OUT:
				image = iconList.get(FlowDirection.OUT.getValue());
				break;
			case INOUT:
				image = iconList.get(FlowDirection.INOUT.getValue());
				break;
			default:
				image = iconList.get(FlowDirection.INOUT.getValue());
				break;
			}
		}
		return image;
	}
}
