/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.iotml.hardware.actuator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EnergyKind implements Enumerator
{
    ELECTRICAL(0, "Electrical", "Electrical"),
    MECHANICAL(1, "Mechanical", "Mechanical"),
    PNEUMATICAL(2, "Pneumatical", "Pneumatical"),
    HYDRAULIC(3, "Hydraulic", "Hydraulic"),
    NONE(4, "None", "None");

    public static final int ELECTRICAL_VALUE = 0;
    public static final int MECHANICAL_VALUE = 1;
    public static final int PNEUMATICAL_VALUE = 2;
    public static final int HYDRAULIC_VALUE = 3;
    public static final int NONE_VALUE = 4;
    private static final EnergyKind[] VALUES_ARRAY;
    public static final List<EnergyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EnergyKind[]{ELECTRICAL, MECHANICAL, PNEUMATICAL, HYDRAULIC, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EnergyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EnergyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EnergyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EnergyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EnergyKind get(int value) {
        switch (value) {
            case 0: {
                return ELECTRICAL;
            }
            case 1: {
                return MECHANICAL;
            }
            case 2: {
                return PNEUMATICAL;
            }
            case 3: {
                return HYDRAULIC;
            }
            case 4: {
                return NONE;
            }
        }
        return null;
    }

    private EnergyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

