/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.sensor;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Hw RFID Reader Sensor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.HwRFIDReaderSensor#getTag <em>Tag</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#getHwRFIDReaderSensor()
 * @model
 * @generated
 */
public interface HwRFIDReaderSensor extends HwCommonSensor {
	/**
	 * Returns the value of the '<em><b>Tag</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.papyrus.iotml.hardware.sensor.HwTag}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Tag</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Tag</em>' reference list.
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#getHwRFIDReaderSensor_Tag()
	 * @model ordered="false"
	 * @generated
	 */
	EList<HwTag> getTag();

} // HwRFIDReaderSensor
