/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.sensor;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.HWSensor;

import org.eclipse.papyrus.sysml14.blocks.ValueType;

import org.eclipse.uml2.uml.Behavior;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Hw Common Sensor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getInputValueType <em>Input Value Type</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getOutputValueType <em>Output Value Type</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getHwcommonsensor <em>Hwcommonsensor</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getTransferFunction <em>Transfer Function</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#getHwCommonSensor()
 * @model
 * @generated
 */
public interface HwCommonSensor extends HWSensor {
	/**
	 * Returns the value of the '<em><b>Input Value Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Input Value Type</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Input Value Type</em>' reference.
	 * @see #setInputValueType(ValueType)
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#getHwCommonSensor_InputValueType()
	 * @model ordered="false"
	 * @generated
	 */
	ValueType getInputValueType();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getInputValueType <em>Input Value Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Input Value Type</em>' reference.
	 * @see #getInputValueType()
	 * @generated
	 */
	void setInputValueType(ValueType value);

	/**
	 * Returns the value of the '<em><b>Output Value Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Output Value Type</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Output Value Type</em>' reference.
	 * @see #setOutputValueType(ValueType)
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#getHwCommonSensor_OutputValueType()
	 * @model ordered="false"
	 * @generated
	 */
	ValueType getOutputValueType();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getOutputValueType <em>Output Value Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Output Value Type</em>' reference.
	 * @see #getOutputValueType()
	 * @generated
	 */
	void setOutputValueType(ValueType value);

	/**
	 * Returns the value of the '<em><b>Hwcommonsensor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Hwcommonsensor</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Hwcommonsensor</em>' reference.
	 * @see #setHwcommonsensor(HwCommonSensor)
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#getHwCommonSensor_Hwcommonsensor()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	HwCommonSensor getHwcommonsensor();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getHwcommonsensor <em>Hwcommonsensor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Hwcommonsensor</em>' reference.
	 * @see #getHwcommonsensor()
	 * @generated
	 */
	void setHwcommonsensor(HwCommonSensor value);

	/**
	 * Returns the value of the '<em><b>Transfer Function</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Transfer Function</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Transfer Function</em>' reference.
	 * @see #setTransferFunction(Behavior)
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#getHwCommonSensor_TransferFunction()
	 * @model ordered="false"
	 * @generated
	 */
	Behavior getTransferFunction();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor#getTransferFunction <em>Transfer Function</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Transfer Function</em>' reference.
	 * @see #getTransferFunction()
	 * @generated
	 */
	void setTransferFunction(Behavior value);

} // HwCommonSensor
