/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements;

import java.util.List;
import org.eclipse.aas.api.reference.Key;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.File;
import org.eclipse.aas.basyx.codegen.generator.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileGenerator {
    private static final Logger logger = LoggerFactory.getLogger(FileGenerator.class);
    private File fileInstance;
    private List<Key> semanticKeys;
    private String parent;
    private ConceptDescription conceptDesc;

    public FileGenerator(File fileInstance) {
        this.fileInstance = fileInstance;
        try {
            this.semanticKeys = fileInstance.getSemanticIdentifier().getKeys();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception in Semantic ID Declaration while initialising " + this.getClass().getSimpleName());
        }
        try {
            this.conceptDesc = this.fileInstance.getSemanticDescription();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception while fetching ConceptDescription for the semantic Id definition of the File: " + this.getClass().getSimpleName());
        }
        if (fileInstance.getParentSEC() != null) {
            this.parent = fileInstance.getParentSEC().getIdShort();
        } else if (fileInstance.getParentSub() != null) {
            this.parent = fileInstance.getParentSub().getIdShort();
        } else {
            logger.error("File: " + fileInstance.getIdShort() + "has no Parent defined");
        }
        logger.info("FileGenerator Initialised for File : " + this.fileInstance.getIdShort());
    }

    public String generateFile() {
        String fileText = "\t\tFile " + this.parent + "_" + this.fileInstance.getIdShort() + "= new File();\r\n" + "\t\t" + this.parent + "_" + this.fileInstance.getIdShort() + ".setIdShort(\"" + this.fileInstance.getIdShort() + "\");\r\n" + this.generateMimeType() + this.generateModelingInfo() + this.generateSemanticReference() + this.generateParentalRelation() + this.generateValueDelegates() + "\r\n\r\n";
        logger.info("File Code generated for File: " + this.fileInstance.getIdShort());
        return fileText;
    }

    private String generateModelingInfo() {
        String setModelingKind = "";
        if (this.fileInstance.getKind() != null) {
            setModelingKind = "\t\t" + this.parent + "_" + this.fileInstance.getIdShort() + ".setModelingKind(ModelingKind." + this.fileInstance.getKind() + ");\r\n";
            logger.info("Generated ModelingKind Info for File: " + this.fileInstance.getIdShort());
        } else {
            logger.info("Generated ModelingKind Info for File: " + this.fileInstance.getIdShort() + " not generated.");
        }
        return setModelingKind;
    }

    private String generateParentalRelation() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isSubModelFile = true;
        if (stackTraceElements[3].getMethodName() == "generateSubModelElementCollection") {
            isSubModelFile = false;
        }
        String addFile = "";
        if (isSubModelFile) {
            addFile = "\t\taddSubmodelElement(" + this.parent + "_" + this.fileInstance.getIdShort() + ");\r\n";
            logger.info("File " + this.fileInstance.getIdShort() + " added to Submodel: " + this.fileInstance.getParentSub().getIdShort());
        } else {
            SubModelElementCollection parentSEC = this.fileInstance.getParentSEC();
            String immediateParent = "";
            if (parentSEC.getParentSEC() != null) {
                immediateParent = parentSEC.getParentSEC().getIdShort();
            } else if (parentSEC.getParentSub() != null) {
                immediateParent = parentSEC.getParentSub().getIdShort();
            } else {
                logger.error("File: " + parentSEC.getIdShort() + "has no Parent defined");
            }
            addFile = "\t\t" + immediateParent + "_" + parentSEC.getIdShort() + "value.add(" + this.parent + "_" + this.fileInstance.getIdShort() + ");\r\n\r\n";
            logger.info("File " + this.fileInstance.getIdShort() + " added to SubmodelElementCollection: " + this.fileInstance.getParentSEC().getIdShort());
        }
        return addFile;
    }

    private String generateSemanticReference() {
        String semanticStr = "";
        if (this.semanticKeys != null && this.conceptDesc == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\tList<IKey> " + this.parent + "_" + this.fileInstance.getIdShort().toLowerCase() + "Keys= new ArrayList<IKey>();\r\n";
            for (Key key : this.semanticKeys) {
                String basyxKeyElement = FileUtils.removeUnderScore(key.getType().toString());
                semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.fileInstance.getIdShort().toLowerCase() + "Keys.add(" + "new Key(KeyElements." + basyxKeyElement + ", " + key.isLocal() + ", " + "\"" + key.getValue() + "\"" + ", " + "KeyType." + key.getIdType() + ")); \r\n";
            }
            semanticStr = String.valueOf(semanticStr) + "\t\tReference " + this.parent + "_" + this.fileInstance.getIdShort() + "Ref = new Reference(" + this.parent + "_" + this.fileInstance.getIdShort().toLowerCase() + "Keys" + ");\r\n" + "\t\t" + this.parent + "_" + this.fileInstance.getIdShort() + ".setSemanticId(" + this.parent + "_" + this.fileInstance.getIdShort() + "Ref); \r\n \r\n";
            logger.info("Semantic Id reference for File: " + this.fileInstance.getIdShort() + "generated.");
        } else if (this.conceptDesc != null && this.semanticKeys == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.fileInstance.getIdShort() + ".setSemanticId(conceptDescriptions." + this.conceptDesc.getIdShort() + ".getReference()); \r\n \r\n";
        } else {
            logger.debug("No Semantic Id reference for File: " + this.fileInstance.getIdShort() + "found. Thus, not generated.");
        }
        return semanticStr;
    }

    private String generateMimeType() {
        String setMimeType = "";
        if (this.fileInstance.getMimeType() != null) {
            setMimeType = "\t\t" + this.parent + "_" + this.fileInstance.getIdShort() + ".setMimeType(\"" + this.fileInstance.getMimeType() + "\");\r\n";
            logger.info("Generated MimeType Info for File: " + this.fileInstance.getIdShort());
        } else {
            logger.info("MimeType Info for File: " + this.fileInstance.getIdShort() + " not generated.");
        }
        return setMimeType;
    }

    private String generateValueCode() {
        String setValue = "";
        if (this.fileInstance.getValue() != null) {
            setValue = "\t\t" + this.parent + "_" + this.fileInstance.getIdShort() + ".setValue(\"" + this.fileInstance.getValue() + "\");\r\n";
            logger.info("Generated Value Info for File: " + this.fileInstance.getIdShort());
        } else {
            logger.info("Value Info for File: " + this.fileInstance.getIdShort() + " not generated.");
        }
        return setValue;
    }

    private String generateValueDelegates() {
        String valueDelegate = "";
        String valueCode = "";
        String getterCode = "";
        String setterCode = "";
        if (this.fileInstance.isDynamic()) {
            valueDelegate = String.valueOf(valueDelegate) + "\t\tValueDelegate<String> valDel" + this.parent + "_" + this.fileInstance.getIdShort() + " = ValueDelegate.installOn(" + this.parent + "_" + this.fileInstance.getIdShort() + "); \r\n";
            getterCode = String.valueOf(getterCode) + "\t\tvalDel" + this.parent + "_" + this.fileInstance.getIdShort() + ".setGetHandler(dew::get_" + this.parent + "_" + this.fileInstance.getIdShort() + "); \r\n";
            setterCode = String.valueOf(setterCode);
            valueDelegate = String.valueOf(valueDelegate) + getterCode + setterCode;
            return valueDelegate;
        }
        valueCode = String.valueOf(valueCode) + this.generateValueCode();
        return valueCode;
    }
}

