/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LangEnum implements Enumerator
{
    EN(0, "en", "en"),
    AR(1, "ar", "ar"),
    CS(2, "cs", "cs"),
    DA(3, "da", "da"),
    DE(4, "de", "de"),
    ES(5, "es", "es"),
    FR(6, "fr", "fr"),
    HI(7, "hi", "hi"),
    ID(8, "id", "id"),
    IT(9, "it", "it"),
    JA(10, "ja", "ja"),
    KO(11, "ko", "ko"),
    ML(12, "ml", "ml"),
    NL(13, "nl", "nl"),
    NO(14, "no", "no"),
    PL(15, "pl", "pl"),
    PT(16, "pt", "pt"),
    RO(17, "ro", "ro"),
    RU(18, "ru", "ru"),
    SR(19, "sr", "sr"),
    SV(20, "sv", "sv"),
    TH(21, "th", "th"),
    TR(22, "tr", "tr"),
    ZH(23, "zh", "zh");

    public static final int EN_VALUE = 0;
    public static final int AR_VALUE = 1;
    public static final int CS_VALUE = 2;
    public static final int DA_VALUE = 3;
    public static final int DE_VALUE = 4;
    public static final int ES_VALUE = 5;
    public static final int FR_VALUE = 6;
    public static final int HI_VALUE = 7;
    public static final int ID_VALUE = 8;
    public static final int IT_VALUE = 9;
    public static final int JA_VALUE = 10;
    public static final int KO_VALUE = 11;
    public static final int ML_VALUE = 12;
    public static final int NL_VALUE = 13;
    public static final int NO_VALUE = 14;
    public static final int PL_VALUE = 15;
    public static final int PT_VALUE = 16;
    public static final int RO_VALUE = 17;
    public static final int RU_VALUE = 18;
    public static final int SR_VALUE = 19;
    public static final int SV_VALUE = 20;
    public static final int TH_VALUE = 21;
    public static final int TR_VALUE = 22;
    public static final int ZH_VALUE = 23;
    private static final LangEnum[] VALUES_ARRAY;
    public static final List<LangEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LangEnum[]{EN, AR, CS, DA, DE, ES, FR, HI, ID, IT, JA, KO, ML, NL, NO, PL, PT, RO, RU, SR, SV, TH, TR, ZH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LangEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LangEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LangEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LangEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LangEnum get(int value) {
        switch (value) {
            case 0: {
                return EN;
            }
            case 1: {
                return AR;
            }
            case 2: {
                return CS;
            }
            case 3: {
                return DA;
            }
            case 4: {
                return DE;
            }
            case 5: {
                return ES;
            }
            case 6: {
                return FR;
            }
            case 7: {
                return HI;
            }
            case 8: {
                return ID;
            }
            case 9: {
                return IT;
            }
            case 10: {
                return JA;
            }
            case 11: {
                return KO;
            }
            case 12: {
                return ML;
            }
            case 13: {
                return NL;
            }
            case 14: {
                return NO;
            }
            case 15: {
                return PL;
            }
            case 16: {
                return PT;
            }
            case 17: {
                return RO;
            }
            case 18: {
                return RU;
            }
            case 19: {
                return SR;
            }
            case 20: {
                return SV;
            }
            case 21: {
                return TH;
            }
            case 22: {
                return TR;
            }
            case 23: {
                return ZH;
            }
        }
        return null;
    }

    private LangEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

