/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;

public class ParameterUtils {
    protected static final String WRONG_ARGUMENT = "Passed element is neither a behavioral feauture nor a behavior";
    public static final String RET = "out";

    public static List<Parameter> getOwnedParameters(NamedElement opOrBehavior) {
        if (opOrBehavior instanceof BehavioralFeature) {
            return ((BehavioralFeature)opOrBehavior).getOwnedParameters();
        }
        if (opOrBehavior instanceof Behavior) {
            return ((Behavior)opOrBehavior).getOwnedParameters();
        }
        throw new IllegalArgumentException(WRONG_ARGUMENT);
    }

    public static List<Parameter> getOwnedParametersCopy(NamedElement opOrBehavior) {
        ArrayList<Parameter> paramListCopy = new ArrayList<Parameter>();
        List<Parameter> ownedParameters = ParameterUtils.getOwnedParameters(opOrBehavior);
        if (ownedParameters != null) {
            paramListCopy.addAll(ownedParameters);
        }
        return paramListCopy;
    }

    public static Parameter createOwnedParameter(NamedElement opOrBehavior, String paramName, Type type) {
        if (opOrBehavior instanceof BehavioralFeature) {
            return ((BehavioralFeature)opOrBehavior).createOwnedParameter(paramName, type);
        }
        if (opOrBehavior instanceof Behavior) {
            return ((Behavior)opOrBehavior).createOwnedParameter(paramName, type);
        }
        return null;
    }

    public static Parameter createReturnResult(NamedElement opOrBehavior, Type type) {
        Parameter parameter = ParameterUtils.createOwnedParameter(opOrBehavior, RET, type);
        parameter.setDirection(ParameterDirectionKind.OUT_LITERAL);
        return parameter;
    }

    public static Parameter createUnKownReturnResult(NamedElement opOrBehavior, Type type, String typeName) {
        String paramName = "out::" + typeName;
        Parameter parameter = ParameterUtils.createOwnedParameter(opOrBehavior, paramName, type);
        parameter.setDirection(ParameterDirectionKind.OUT_LITERAL);
        return parameter;
    }

    public static void resetParameters(NamedElement opOrBehavior, List<Parameter> paramList) {
        ParameterUtils.getOwnedParameters(opOrBehavior).clear();
        ParameterUtils.getOwnedParameters(opOrBehavior).addAll(paramList);
    }

    public static Parameter getParameterViaName(List<Parameter> paramList, String parameterName) {
        for (Parameter existingParameter : paramList) {
            if (!(parameterName == null ? existingParameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL : existingParameter.getName().equals(parameterName))) continue;
            return existingParameter;
        }
        return null;
    }

    public static Parameter getOutParameterViaName(List<Parameter> paramList, String parameterName) {
        for (Parameter existingParameter : paramList) {
            if (!(parameterName == null ? existingParameter.getDirection() == ParameterDirectionKind.OUT_LITERAL : existingParameter.getName().equals(parameterName))) continue;
            return existingParameter;
        }
        return null;
    }

    public static Parameter getOutParameter(EList<Parameter> ownedParameters) {
        for (Parameter existingParameter : ownedParameters) {
            if (existingParameter.getDirection() != ParameterDirectionKind.OUT_LITERAL) continue;
            return existingParameter;
        }
        return null;
    }
}

