/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator.modulefiles;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aas.api.aas.AssetAdministrationShell;
import org.eclipse.aas.api.aas.parts.ConceptDictionary;
import org.eclipse.aas.api.reference.IReference;
import org.eclipse.aas.api.reference.Key;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.basyx.codegen.generator.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptDescriptionCreator {
    private static final Logger logger = LoggerFactory.getLogger(ConceptDescriptionCreator.class);
    private ConceptDictionary conceptDict;
    private String namespace;
    private List<ConceptDescription> conceptDescriptions;

    public ConceptDescriptionCreator(AssetAdministrationShell aas, String namespace) {
        this.namespace = namespace;
        try {
            this.conceptDict = aas.getConceptDictionary();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Asset Administration Shell does not contain a ConceptDictionary");
        }
        try {
            this.conceptDescriptions = this.conceptDict.getConceptDescriptions();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("ConceptDictionary does not contain any ConceptDescriptions.");
        }
        logger.info("ConceptDescriptionCreator Initialised for AAS: " + aas.getIdShort() + " and namespace: " + this.namespace);
    }

    public String createConceptDescriptions() {
        String licenseHeader = "/*******************************************************************************\n * Copyright (c) 2022 DFKI.\n *\n * This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License 2.0\n * which accompanies this distribution, and is available at\n * https://www.eclipse.org/legal/epl-2.0/\n *\n * SPDX-License-Identifier: EPL-2.0\n *\n * Contributors:\n *     DFKI - Tapanta Bhanja <tapanta.bhanja@dfki.de>\n *******************************************************************************/\r\n";
        String conceptFields = "";
        String conceptDescriptions = "";
        for (ConceptDescription conceptDesc : this.conceptDescriptions) {
            conceptFields = String.valueOf(conceptFields) + this.generateConceptField(conceptDesc);
            conceptDescriptions = String.valueOf(conceptDescriptions) + this.generateConceptDescription(conceptDesc);
        }
        String conceptDescriptionBody = "package " + this.namespace + ".module;\r\n" + "import java.util.ArrayList;\r\n" + "import java.util.Collection; \r\n" + "import java.util.List;\r\n" + "import org.eclipse.basyx.aas.metamodel.map.parts.ConceptDictionary;\r\n" + "import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;\r\n" + "import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.parts.ConceptDescription;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.reference.Key; \r\n" + "import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements; \r\n" + "import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;\r\n" + "import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;\r\n" + "\r\n" + "\r\n" + "/** Holds all concept descriptions known to this AAS. */\r\n" + "public class ConceptDescriptions extends ConceptDictionary {\r\n" + "\r\n" + conceptFields + "    \n" + "    /**\n" + "     * Creates all concept descriptions and stores references to them in fields.\n" + "     */\n" + "    public ConceptDescriptions() {\n" + "        super();\n" + "        \r\n" + conceptDescriptions + "\r\n" + "   }\r\n" + "}\r\n";
        String conceptDescription = String.valueOf(licenseHeader) + conceptDescriptionBody;
        return conceptDescription;
    }

    private String generateConceptField(ConceptDescription conceptDesc) {
        String conceptField = "";
        conceptField = String.valueOf(conceptField) + "    public final ConceptDescription " + conceptDesc.getIdShort() + "; \r\n";
        return conceptField;
    }

    private String generateConceptDescription(ConceptDescription conceptDesc) {
        String conceptDescription = "";
        String isCaseOfText = "";
        if (!conceptDesc.getIsCaseOf().isEmpty()) {
            isCaseOfText = String.valueOf(isCaseOfText) + this.generateIsCaseOf(conceptDesc);
        }
        conceptDescription = String.valueOf(conceptDescription) + "        " + conceptDesc.getIdShort() + " = new ConceptDescription(\"" + conceptDesc.getIdShort() + "\", new Identifier(IdentifierType." + conceptDesc.getIdentification().getIdType() + ", \"" + conceptDesc.getIdentification().getIdentifier() + "\"));\r\n" + "        " + conceptDesc.getIdShort() + ".setCategory(\"" + conceptDesc.getCategory() + "\");\n" + isCaseOfText + "        " + "addConceptDescription(" + conceptDesc.getIdShort() + ");\r\n" + "        \r\n";
        return conceptDescription;
    }

    private String generateReferences(ConceptDescription conceptDesc) {
        List isCaseofReferences = new ArrayList();
        String referenceText = "";
        int countRef = 1;
        try {
            isCaseofReferences = conceptDesc.getIsCaseOf();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("This ConceptDescription: " + conceptDesc.getIdShort() + "is not a CaseOf any Reference.");
        }
        for (IReference isCaseofReference : isCaseofReferences) {
            List referenceKeys = isCaseofReference.getKeys();
            String keyText = "";
            keyText = String.valueOf(keyText) + "        List<IKey> " + conceptDesc.getIdShort().toLowerCase() + "Keys" + countRef + " = new ArrayList<IKey>();\r\n";
            for (Key referenceKey : referenceKeys) {
                String basyxKeyElement = FileUtils.removeUnderScore(referenceKey.getType().toString());
                keyText = String.valueOf(keyText) + "\t\t" + conceptDesc.getIdShort().toLowerCase() + "Keys" + countRef + ".add(" + "new Key(KeyElements." + basyxKeyElement + ", " + referenceKey.isLocal() + ", " + "\"" + referenceKey.getValue() + "\"" + ", " + "KeyType." + referenceKey.getIdType() + ")); \r\n";
            }
            referenceText = String.valueOf(referenceText) + keyText + "        Reference " + conceptDesc.getIdShort().toLowerCase() + "Ref" + countRef + " = new Reference(" + conceptDesc.getIdShort().toLowerCase() + "Keys" + countRef + ");\r\n" + "\r\n";
            ++countRef;
        }
        return referenceText;
    }

    private String generateIsCaseOf(ConceptDescription conceptDesc) {
        List isCaseofReferences = new ArrayList();
        String text = "";
        try {
            isCaseofReferences = conceptDesc.getIsCaseOf();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("This ConceptDescription: " + conceptDesc.getIdShort() + "is not a CaseOf any Reference.");
        }
        int numberOfReferences = isCaseofReferences.size();
        text = String.valueOf(text) + "        Collection<Reference> " + conceptDesc.getIdShort() + "Collection = new ArrayList<Reference>();\r\n";
        int i = 1;
        while (i <= numberOfReferences) {
            text = String.valueOf(text) + "        " + conceptDesc.getIdShort() + "Collection.add(" + conceptDesc.getIdShort().toLowerCase() + "Ref" + i + ");\r\n";
            ++i;
        }
        text = String.valueOf(text) + "        " + conceptDesc.getIdShort() + ".setIsCaseOf(" + conceptDesc.getIdShort() + "Collection);\r\n";
        return String.valueOf(this.generateReferences(conceptDesc)) + text;
    }
}

