/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.uml.template2structure.internal.mappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Paragraph;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Title;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.CommentAsParagraph;
import org.eclipse.papyrus.model2doc.uml.template2structure.internal.mappers.AbstractUMLTemplateToStructureMapper;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;

public class CommentAsParagraphMapper
extends AbstractUMLTemplateToStructureMapper<CommentAsParagraph> {
    public CommentAsParagraphMapper() {
        super(TEMPLATE_EPACKAGE.getCommentAsParagraph(), BodyPart.class);
    }

    protected <T> List<T> doMap(IMappingService mappingService, CommentAsParagraph commentAsParagraph, EObject semanticModelElement, Class<T> returnedClassType) {
        if (!commentAsParagraph.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        if (!commentAsParagraph.isGenerate() || !(semanticModelElement instanceof Element)) {
            return Collections.emptyList();
        }
        ArrayList<T> returnedValue = new ArrayList<T>();
        Iterator commentIter = commentAsParagraph.getMatchingComments(semanticModelElement).iterator();
        Title title = null;
        if (commentIter.hasNext() && commentAsParagraph.isGenerateTitle()) {
            title = STRUCTURE_EFACTORY.createTitle();
            title.setTitle(commentAsParagraph.buildPartTemplateTitle(null));
            returnedValue.add(returnedClassType.cast(title));
        }
        while (commentIter.hasNext()) {
            Paragraph paragraph = STRUCTURE_EFACTORY.createParagraph();
            paragraph.setText(((Comment)commentIter.next()).getBody());
            if (title == null) {
                returnedValue.add(returnedClassType.cast(paragraph));
                continue;
            }
            title.getSubBodyParts().add((Object)paragraph);
        }
        return returnedValue;
    }
}

