/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.operations;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.EClassPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.EReferencePartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.EReferenceTableView;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.InsertFileTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.TreeListView;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.providers.DelegatingToEMFLabelProvider;

public class BodySectionPartTemplateTitleOperations {
    public static final BodySectionPartTemplateTitleOperations INSTANCE = new BodySectionPartTemplateTitleOperations();

    protected BodySectionPartTemplateTitleOperations() {
    }

    public final String buildPartTemplateTitle(IBodySectionPartTemplate partTemplate, EObject parameter) {
        if (!partTemplate.isGenerateTitle()) {
            return null;
        }
        String customTitle = partTemplate.getCustomTitle();
        if (customTitle != null && !customTitle.isEmpty()) {
            return customTitle;
        }
        return this.internalBuildPartTemplateTitle(partTemplate, parameter);
    }

    protected String internalBuildPartTemplateTitle(IBodySectionPartTemplate partTemplate, EObject parameter) {
        if (partTemplate instanceof EReferencePartTemplate) {
            return this.buildEReferencePartTemplateTitle((EReferencePartTemplate)partTemplate, null);
        }
        if (partTemplate instanceof EClassPartTemplate) {
            return this.buildEClassPartTemplateTitle((EClassPartTemplate)partTemplate, parameter);
        }
        if (partTemplate instanceof EReferenceTableView) {
            return this.buildEReferenceTableViewTitle((EReferenceTableView)partTemplate, null);
        }
        if (partTemplate instanceof TreeListView) {
            return this.buildTreeListViewTitle((TreeListView)partTemplate, parameter);
        }
        if (partTemplate instanceof InsertFileTemplate) {
            return this.buildInsertFileTemplateTitle((InsertFileTemplate)partTemplate, parameter);
        }
        return "";
    }

    private String buildInsertFileTemplateTitle(InsertFileTemplate insertFileTemplate, EObject parameter) {
        return NLS.bind((String)"Inserted File {0}", (Object)insertFileTemplate.getFilePath());
    }

    private String buildTreeListViewTitle(TreeListView treeListView, EObject parameter) {
        String contextLabel = this.getLabel(parameter);
        return NLS.bind((String)"A List of sub properties for {0}", (Object)contextLabel);
    }

    protected final String buildEReferencePartTemplateTitle(EReferencePartTemplate partTemplate, EObject parameter) {
        if (partTemplate.getEReference() != null) {
            return partTemplate.getEReference().getName();
        }
        return "No EReference";
    }

    protected final String buildEReferenceTableViewTitle(EReferenceTableView partTemplate, EObject parameter) {
        if (partTemplate.getEReference() != null) {
            return partTemplate.getEReference().getName();
        }
        return "No EReference";
    }

    protected final String buildEClassPartTemplateTitle(EClassPartTemplate eClassPartTemplate, EObject parameter) {
        EClass eClass = eClassPartTemplate.getEClass();
        if (parameter != null) {
            return this.getLabel(parameter);
        }
        if (parameter == null && eClass != null) {
            return eClass.getName();
        }
        return "No EClass";
    }

    protected String getLabel(EObject eobject) {
        return DelegatingToEMFLabelProvider.INSTANCE.getText(eobject);
    }
}

