/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.builtintypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CellLocation implements Enumerator
{
    CORNER(0, "CORNER", "CORNER"),
    COLUMN_HEADER(1, "COLUMN_HEADER", "COLUMN_HEADER"),
    ROW_HEADER(2, "ROW_HEADER", "ROW_HEADER"),
    BODY(3, "BODY", "BODY");

    public static final int CORNER_VALUE = 0;
    public static final int COLUMN_HEADER_VALUE = 1;
    public static final int ROW_HEADER_VALUE = 2;
    public static final int BODY_VALUE = 3;
    private static final CellLocation[] VALUES_ARRAY;
    public static final List<CellLocation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CellLocation[]{CORNER, COLUMN_HEADER, ROW_HEADER, BODY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CellLocation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CellLocation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CellLocation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CellLocation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CellLocation get(int value) {
        switch (value) {
            case 0: {
                return CORNER;
            }
            case 1: {
                return COLUMN_HEADER;
            }
            case 2: {
                return ROW_HEADER;
            }
            case 3: {
                return BODY;
            }
        }
        return null;
    }

    private CellLocation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

