/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.ieee.requirements.odt.ui.handler;

import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.DefaultDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.GeneratorConfigurationFactory;
import org.eclipse.papyrus.model2doc.documentview.ui.menu.handler.CreateDocumentViewEditorHandler;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.odt.transcriber.IEEERequirementsTranscriber;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.odt.ui.Activator;
import org.eclipse.papyrus.model2doc.odt.transcription.ODTTranscriptionFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class GeneratorIEEERequirements2ODTHandler
extends CreateDocumentViewEditorHandler {
    private String generatedDocumentFileURI;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return null;
    }

    public boolean generateDocument(String name) {
        Element selectedElement = this.getSelection();
        if (selectedElement == null || selectedElement.eResource() == null) {
            return false;
        }
        URI uri = selectedElement.eResource().getURI();
        uri = uri.trimFileExtension();
        uri = uri.trimSegments(uri.segmentsList().size() - 2);
        String projectFolder = uri.toString();
        DefaultDocumentGeneratorConfiguration generatorConfig = GeneratorConfigurationFactory.eINSTANCE.createDefaultDocumentGeneratorConfiguration();
        generatorConfig.setDocumentFolder(projectFolder);
        generatorConfig.setDocumentName(name);
        String templatePath = "platform:/plugin/org.eclipse.papyrus.model2doc.integration.ieee.requirements.odt/template/srs_template-ieee.ott";
        generatorConfig.setTemplateFile("platform:/plugin/org.eclipse.papyrus.model2doc.integration.ieee.requirements.odt/template/srs_template-ieee.ott");
        try {
            IEEERequirementsTranscriber ieeeRequirementsTranscriber = new IEEERequirementsTranscriber((Package)this.getSelection(), ODTTranscriptionFactory.INSTANCE.getDefaultODTTranscription(null, generatorConfig));
            ieeeRequirementsTranscriber.transcribe();
            StringBuilder uriBuilder = new StringBuilder();
            uriBuilder.append(projectFolder);
            uriBuilder.append(File.separator);
            uriBuilder.append(generatorConfig.getDocumentName());
            uriBuilder.append(".odt");
            Path path = new Path(uriBuilder.toString());
            this.generatedDocumentFileURI = path.toString();
            this.getWorkspaceResourceService().refreshWorkspace(generatorConfig.getDocumentFolder());
            return true;
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            return false;
        }
    }

    public String getGeneratedDocumentFileURI() {
        return this.generatedDocumentFileURI;
    }
}

