/*****************************************************************************
 * Copyright (c) 2019 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Yupanqui Munoz (CEA LIST) yupanqui.munozjulho@cea.fr - Initial API and implementation
 *	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.model2doc.odt.service;

import org.eclipse.papyrus.model2doc.core.service.TemplateResourceServiceImpl;
import org.eclipse.papyrus.model2doc.odt.Activator;

/**
 * Implement of service for management of Writer (LibreOffice) template resource.
 *
 */
public class ODTTemplateResourceService extends TemplateResourceServiceImpl {
	@Override
	public String[] getTemplateFileExtensions() {
		return new String [] {"odt", "ott"}; //$NON-NLS-1$ //$NON-NLS-2$
	}

	@Override
	public String getTemplatePlugInID() {
		return Activator.PLUGIN_ID;
	}

	@Override
	public String getTemplatePathInPlugIn() {
		return "/template/PapyrusTemplate.ott"; //$NON-NLS-1$
	}

}
