/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.awt.Size;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextDocument;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.util.StyleUtil;

public class PageUtil {
    private PageUtil() {
    }

    public static Size getWritableSize(XTextDocument xTextDocument, String familyStyleName, String propertySetName) {
        XPropertySet propertySet = StyleUtil.getStylePropertySet(xTextDocument, familyStyleName, propertySetName);
        if (propertySet != null) {
            try {
                int width = (Integer)propertySet.getPropertyValue("Width");
                int height = (Integer)propertySet.getPropertyValue("Height");
                int leftMargin = (Integer)propertySet.getPropertyValue("LeftMargin");
                int rightMargin = (Integer)propertySet.getPropertyValue("RightMargin");
                int topMargin = (Integer)propertySet.getPropertyValue("TopMargin");
                int bottomMargin = (Integer)propertySet.getPropertyValue("BottomMargin");
                return new Size(width - (leftMargin + rightMargin), height - (topMargin + bottomMargin));
            }
            catch (UnknownPropertyException | WrappedTargetException e) {
                Activator.log.error(e);
            }
        }
        return null;
    }
}

