/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.editor;

import java.lang.reflect.Constructor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.AbstractPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.ui.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.Activator;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.editor.NestedDocumentStructureTemplateViewEditor;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.provider.DocumentTemplateLabelProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

public class DocumentStructureTemplateEditorFactory
extends AbstractEditorFactory {
    public DocumentStructureTemplateEditorFactory() {
        super(NestedDocumentStructureTemplateViewEditor.class, "");
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        ServicesRegistry services = this.getServiceRegistry();
        ILabelProvider labels = ServiceUtils.getInstance().tryService((Object)services, LabelProviderService.class).map(lps -> lps.getLabelProvider(pageIdentifier)).orElseGet(DocumentTemplateLabelProvider::new);
        return new DocumentViewEditorModel(pageIdentifier, services, labels);
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        return pageIdentifier instanceof DocumentTemplate;
    }

    private class DocumentViewEditorModel
    extends AbstractPageModel
    implements IEditorModel {
        private ServicesRegistry servicesRegistry;
        private IEditorPart editor;
        private DocumentTemplate rawModel;

        public DocumentViewEditorModel(Object pageIdentifier, ServicesRegistry servicesRegistry, ILabelProvider labels) {
            super(labels);
            this.rawModel = (DocumentTemplate)pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                IEditorPart newEditor;
                Constructor c = DocumentStructureTemplateEditorFactory.this.getDiagramClass().getConstructor(ServicesRegistry.class, DocumentTemplate.class);
                this.editor = newEditor = (IEditorPart)c.newInstance(this.servicesRegistry, this.rawModel);
                return this.editor;
            }
            catch (Exception e) {
                throw new PartInitException("Can't create DocumentStructureTemplateView", (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = DocumentStructureTemplateEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public Object getRawModel() {
            return this.rawModel;
        }
    }
}

