/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.docx.internal.poi;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.docx.Activator;

public class CustomXWPFPart
extends POIXMLDocumentPart {
    private String filePath;
    private String id;

    public CustomXWPFPart(PackagePart part, String id, String filePath) {
        super(part);
        this.filePath = filePath;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    protected void commit() throws IOException {
        try {
            FileInputStream originalFile = new FileInputStream(this.filePath);
            PackagePart part = this.getPackagePart();
            if (part != null) {
                OutputStream partOutputStream = part.getOutputStream();
                byte[] array = new byte[originalFile.available()];
                originalFile.read(array);
                partOutputStream.write(array);
                partOutputStream.close();
            }
            originalFile.close();
        }
        catch (FileNotFoundException e) {
            Activator.log.warn(NLS.bind((String)"The {0} file has not been found", (Object)this.filePath));
        }
    }
}

