/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.core.builtintypes.BasicRow;
import org.eclipse.papyrus.model2doc.core.builtintypes.BuiltInTypesFactory;
import org.eclipse.papyrus.model2doc.core.builtintypes.CellLocation;
import org.eclipse.papyrus.model2doc.core.builtintypes.TextCell;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.ExtendedBasicTable;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.EReferenceTableView;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IColumn;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.ITableView;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractBodyPartTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public class EReferenceTableViewMapper
extends AbstractBodyPartTemplateToStructureMapper<EReferenceTableView> {
    public EReferenceTableViewMapper() {
        super(DocumentStructureTemplatePackage.eINSTANCE.getEReferenceTableView(), BodyPart.class);
    }

    @Override
    protected <T> List<T> doMap(IMappingService mappingService, EReferenceTableView eReferenceTableView, EObject semanticModelElement, Class<T> expectedReturnedClass) {
        ArrayList<T> returnedElements = new ArrayList<T>();
        if (!eReferenceTableView.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        if (eReferenceTableView.isGenerate()) {
            EList rows = eReferenceTableView.getRows(semanticModelElement);
            EList columns = eReferenceTableView.getColumns();
            if (!rows.isEmpty() && !columns.isEmpty()) {
                ExtendedBasicTable table = STRUCTURE_EFACTORY.createExtendedBasicTable();
                if (eReferenceTableView.isGenerateColumnHeader()) {
                    BasicRow columnHeader = BuiltInTypesFactory.eINSTANCE.createBasicRow();
                    table.getRows().add((Object)columnHeader);
                    if (eReferenceTableView.isGenerateRowHeader()) {
                        TextCell cornerCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
                        cornerCell.setLocation(CellLocation.CORNER);
                        columnHeader.getCells().add((Object)cornerCell);
                    }
                    for (IColumn column : columns) {
                        TextCell colHeaderCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
                        colHeaderCell.setLocation(CellLocation.COLUMN_HEADER);
                        colHeaderCell.setText(column.buildColumnHeaderLabel());
                        columnHeader.getCells().add((Object)colHeaderCell);
                    }
                }
                for (EObject rowElement : rows) {
                    BasicRow bodyRow = BuiltInTypesFactory.eINSTANCE.createBasicRow();
                    table.getRows().add((Object)bodyRow);
                    if (eReferenceTableView.isGenerateRowHeader()) {
                        TextCell rowHeaderCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
                        rowHeaderCell.setLocation(CellLocation.ROW_HEADER);
                        rowHeaderCell.setText(eReferenceTableView.buildRowHeaderLabel(rowElement));
                        bodyRow.getCells().add((Object)rowHeaderCell);
                    }
                    for (IColumn column : columns) {
                        TextCell bodyCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
                        bodyCell.setLocation(CellLocation.BODY);
                        bodyCell.setText(column.buildCellLabel(column.getCellValue(rowElement)));
                        bodyRow.getCells().add((Object)bodyCell);
                    }
                }
                if (!this.isEmptyTable(table, (ITableView)eReferenceTableView)) {
                    returnedElements.add(expectedReturnedClass.cast(table));
                    returnedElements.add(expectedReturnedClass.cast(STRUCTURE_EFACTORY.createEmptyLine()));
                }
            }
        }
        return this.buildMapperResult(eReferenceTableView, semanticModelElement, expectedReturnedClass, returnedElements);
    }

    private boolean isEmptyTable(ExtendedBasicTable table, ITableView tableView) {
        return table.getRowsNumber() == 0 && !tableView.isGenerateColumnHeader() || table.getRowsNumber() == 1 && tableView.isGenerateColumnHeader();
    }
}

