/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine.animators;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.animation.engine.animators.Animator;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_InteractionPoint;
import org.eclipse.papyrus.moka.composites.interfaces.extensions.Semantics.CompositeStructures.StructuredClasses.ICS_ConnectorLink;
import org.eclipse.papyrus.moka.fuml.Profiling.Semantics.Kernel.Classes.IFeatureValueWrapper;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IReference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Type;

public class StructuralAnimator
extends Animator {
    @Override
    public void nodeVisited_(ISemanticVisitor nodeVisitor) {
        if (nodeVisitor instanceof ICS_InteractionPoint) {
            this.engine.renderAs((EObject)((ICS_InteractionPoint)nodeVisitor).getDefiningPort(), ((ICS_InteractionPoint)nodeVisitor).getOwner().getReferent(), AnimationKind.ANIMATED, AnimationKind.VISITED, MokaConstants.MOKA_ANIMATION_DELAY);
        } else if (nodeVisitor instanceof ICS_ConnectorLink) {
            this.engine.renderAs((EObject)((ICS_ConnectorLink)nodeVisitor).getConnector(), null, AnimationKind.ANIMATED, AnimationKind.VISITED, MokaConstants.MOKA_ANIMATION_DELAY);
        } else if (nodeVisitor instanceof IFeatureValueWrapper) {
            IFeatureValueWrapper featureValue = (IFeatureValueWrapper)nodeVisitor;
            this.engine.renderAs((EObject)featureValue.getFeature(), featureValue.getContext(), AnimationKind.VISITED);
        }
    }

    @Override
    public void stepStart(IReference context) {
        IObject_ referent = context.getReferent();
        if (referent != null) {
            for (Type type : referent.getTypes()) {
                if (!(type instanceof Class) || !((Class)type).isActive()) continue;
                this.engine.renderAs((EObject)type, referent, AnimationKind.ANIMATED);
            }
            ILocus locus = referent.getLocus();
            if (locus != null) {
                for (IExtensionalValue extensionalValue : locus.getExtensionalValues()) {
                    if (!(extensionalValue instanceof IObject_) || referent.getFeatureValues().isEmpty()) continue;
                    for (IFeatureValue featureValue : ((IObject_)extensionalValue).getFeatureValues()) {
                        Iterator valueIterator = featureValue.getValues().iterator();
                        boolean found = false;
                        while (!found && valueIterator.hasNext()) {
                            found = ((IValue)valueIterator.next()).equals((IValue)context);
                        }
                        if (!found) continue;
                        this.engine.renderAs((EObject)featureValue.getFeature(), (IObject_)extensionalValue, AnimationKind.ANIMATED);
                    }
                }
            }
        }
    }

    @Override
    public void stepEnd(IReference context) {
        IObject_ referent = context.getReferent();
        if (referent != null) {
            for (Type type : referent.getTypes()) {
                if (!(type instanceof Class) || !((Class)type).isActive()) continue;
                this.engine.renderAs((EObject)type, referent, AnimationKind.VISITED);
            }
            ILocus locus = referent.getLocus();
            if (locus != null) {
                for (IExtensionalValue extensionalValue : locus.getExtensionalValues()) {
                    if (!(extensionalValue instanceof IObject_) || referent.getFeatureValues().isEmpty()) continue;
                    for (IFeatureValue featureValue : ((IObject_)extensionalValue).getFeatureValues()) {
                        Iterator valueIterator = featureValue.getValues().iterator();
                        boolean found = false;
                        while (!found && valueIterator.hasNext()) {
                            found = ((IValue)valueIterator.next()).equals((IValue)context);
                        }
                        if (!found) continue;
                        this.engine.renderAs((EObject)featureValue.getFeature(), (IObject_)extensionalValue, AnimationKind.VISITED);
                    }
                }
            }
        }
    }

    @Override
    public void valueCreated(IValue value) {
        if (value instanceof IObject_) {
            for (Classifier classifier : ((IObject_)value).getTypes()) {
                this.engine.renderAs((EObject)classifier, (IObject_)value, AnimationKind.VISITED);
            }
        }
    }

    @Override
    public void valueDestroyed(IValue value) {
        if (value instanceof IObject_) {
            for (Classifier classifier : ((IObject_)value).getTypes()) {
                ILocus locus = ((IObject_)value).getLocus();
                if (locus == null || !locus.getExtent(classifier).isEmpty()) continue;
                this.engine.removeRenderingRules((EObject)classifier);
            }
        }
    }

    @Override
    public void nodeLeft_(ISemanticVisitor nodeVisitor) {
    }

    @Override
    public boolean accept(ISemanticVisitor visitor) {
        if (visitor instanceof ICS_InteractionPoint) {
            return true;
        }
        if (visitor instanceof ICS_ConnectorLink) {
            return true;
        }
        if (visitor instanceof IFeatureValue) {
            return true;
        }
        if (visitor instanceof IObject_) {
            return true;
        }
        return visitor instanceof IReference;
    }
}

