/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.engine;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.debug.engine.DebugServiceHelper;
import org.eclipse.papyrus.moka.debug.engine.IMokaDebugTarget;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.CompleteActions.IAcceptEventActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IStateMachineSemanticVisitor;
import org.eclipse.papyrus.moka.service.AbstractMokaService;
import org.eclipse.papyrus.moka.service.IMokaExecutionListener;

public class DebugService
extends AbstractMokaService
implements IMokaExecutionListener {
    protected IMokaDebugTarget debugTarget;

    public void init(ILaunch launcher, EObject modelElement) {
        this.debugTarget = (IMokaDebugTarget)launcher.getDebugTarget();
    }

    public void nodeVisited(ISemanticVisitor nodeVisitor) {
        if (!this.debugTarget.isDisconnected() && (nodeVisitor instanceof IActivityNodeActivation || nodeVisitor instanceof IActivityEdgeInstance || nodeVisitor instanceof IStateMachineSemanticVisitor)) {
            IObject_ object = null;
            if (nodeVisitor instanceof IStateMachineSemanticVisitor) {
                object = ((IStateMachineSemanticVisitor)nodeVisitor).getExecutionContext();
            } else if (nodeVisitor instanceof IActivityNodeActivation && !(nodeVisitor instanceof IAcceptEventActionActivation) && ((IActivityNodeActivation)nodeVisitor).getGroup() != null) {
                object = ((IActivityNodeActivation)nodeVisitor).getExecutionContext();
            } else if (nodeVisitor instanceof IActivityEdgeInstance && ((IActivityEdgeInstance)nodeVisitor).getSource().getGroup() != null) {
                object = ((IActivityEdgeInstance)nodeVisitor).getSource().getExecutionContext();
            }
            if (object != null) {
                this.debugTarget.update(object, nodeVisitor);
                if (this.debugTarget.isSuspensionRequired(object, nodeVisitor)) {
                    this.debugTarget.suspend(object, nodeVisitor);
                }
            }
        }
    }

    public void nodeLeft(ISemanticVisitor nodeVisitor) {
        if (!this.debugTarget.isDisconnected()) {
            IObject_ object = null;
            if (nodeVisitor instanceof IAcceptEventActionActivation && ((IAcceptEventActionActivation)nodeVisitor).getGroup() != null) {
                object = ((IAcceptEventActionActivation)nodeVisitor).getExecutionContext();
            }
            if (object != null) {
                this.debugTarget.update(object, nodeVisitor);
                if (this.debugTarget.isSuspensionRequired(object, nodeVisitor)) {
                    this.debugTarget.suspend(object, nodeVisitor);
                }
            }
        }
    }

    public void valueCreated(IValue value) {
        IObject_ object;
        if (!this.debugTarget.isDisconnected() && value instanceof IObject_ && this.debugTarget.isNewThread(object = (IObject_)value)) {
            if (object instanceof IExecution && ((IExecution)object).getContext() == object) {
                this.debugTarget.registerThread(object);
            } else if (DebugServiceHelper.INSTANCE.isActive(object)) {
                this.debugTarget.registerThread(object);
            }
        }
    }

    public void valueDestroyed(IValue value) {
        IObject_ object;
        if (!this.debugTarget.isDisconnected() && value instanceof IObject_ && !this.debugTarget.isNewThread(object = (IObject_)value)) {
            this.debugTarget.unregisterThread(object);
        }
    }

    public void dispose() {
        if (this.debugTarget != null && !this.debugTarget.isTerminated()) {
            try {
                this.debugTarget.terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            this.debugTarget = null;
        }
    }
}

