/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.async.fuml.debug;

import java.io.IOException;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.CompleteActions.IAcceptEventActionEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.ObjectActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.SignalEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.SignalInstance;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Trigger;

public class AsyncDebug
extends Debug {
    public static void println(String message) {
    }

    public static void printLostSignal(IEventOccurrence eventOccurrence, final ObjectActivation objectActivation, final IOConsoleOutputStream outstream) {
        String expectedSignals = "";
        for (IEventAccepter eventAccepter : objectActivation.waitingEventAccepters) {
            if (!(eventAccepter instanceof IAcceptEventActionEventAccepter)) continue;
            IAcceptEventActionEventAccepter acceptEventAccepter = (IAcceptEventActionEventAccepter)eventAccepter;
            AcceptEventAction acceptEventAction = (AcceptEventAction)acceptEventAccepter.getActionActivation().getNode();
            for (Trigger trigger : acceptEventAction.getTriggers()) {
                if (!(trigger.getEvent() instanceof SignalEvent)) continue;
                SignalEvent signalEvent = (SignalEvent)trigger.getEvent();
                Signal signal = signalEvent.getSignal();
                if (!expectedSignals.isEmpty()) {
                    expectedSignals = String.valueOf(expectedSignals) + ", ";
                }
                expectedSignals = String.valueOf(expectedSignals) + signal.getName();
            }
        }
        if (eventOccurrence instanceof SignalEventOccurrence) {
            final SignalInstance finalSignalInstance = ((SignalEventOccurrence)eventOccurrence).signalInstance;
            final String finalExpectedSignals = expectedSignals;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        outstream.setColor(new Color(null, new RGB(200, 120, 10)));
                        outstream.write("[ WARNING : Lost signal " + ((Classifier)finalSignalInstance.getTypes().get(0)).getName() + " (classifier behavior of " + objectActivation.object + " was waiting for " + finalExpectedSignals + ") ]\n");
                        outstream.flush();
                    }
                    catch (IOException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            });
        }
    }
}

