/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.papyrus.moka.datavisualization.profile.BooleanSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.DataSource;
import org.eclipse.papyrus.moka.datavisualization.profile.DoubleSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.IntegerSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.StringSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.ValueSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.VisualizationPackage;
import org.eclipse.papyrus.moka.datavisualization.util.VisualizationUtil;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CSVResource
extends ResourceImpl {
    private String separator = ";";
    public static final String OPTION_SEPARATOR = "separator";
    public static final String OPTION_TARGET_PACKAGE = "TARGET_PACKAGE";
    private static final String VALUES_FEATURE_NAME = "values";
    private UMLFactory eFactory = (UMLFactory)UMLPackage.eINSTANCE.getEFactoryInstance();
    private Package rootModel;
    private DataType dataType;
    private DataSource dataSource;
    private ArrayList<ValueSeries> seriesList = new ArrayList();
    private String DEFAULT_SOURCE_NAME = "CSVFile";

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        this.initializeOptions(options);
        URI uri = this.getURI();
        String sourceName = this.DEFAULT_SOURCE_NAME;
        if (uri != null) {
            sourceName = uri.trimFileExtension().lastSegment();
        }
        if (this.rootModel == null) {
            this.rootModel = this.eFactory.createModel();
            this.rootModel.setName(String.valueOf(sourceName) + "Model");
            this.getContents().add((Object)this.rootModel);
        }
        VisualizationUtil.applyVisualizationProfileIfNeeded(this.rootModel);
        this.dataType = (DataType)this.rootModel.createOwnedType(sourceName, UMLPackage.eINSTANCE.getDataType());
        this.dataType.setName(sourceName);
        this.dataType.applyStereotype(VisualizationUtil.getDataSourceStereotype((EObject)this.rootModel));
        this.dataType.eSetDeliver(false);
        this.rootModel.getPackagedElements().add((Object)this.dataType);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String line = bufferedReader.readLine();
        while (line != null && line.trim().isEmpty()) {
            line = bufferedReader.readLine();
        }
        if (line != null) {
            this.initializeProperties(line);
            line = bufferedReader.readLine();
            while (line != null && line.trim().isEmpty()) {
                line = bufferedReader.readLine();
            }
            this.initializeSeries(line);
            while ((line = bufferedReader.readLine()) != null) {
                this.populateValues(line);
            }
        }
        bufferedReader.close();
        this.rootModel.eSetDeliver(true);
        for (ValueSeries serie : this.seriesList) {
            serie.eSetDeliver(true);
        }
    }

    private void initializeOptions(Map<?, ?> options) {
        if (options != null) {
            Object optionTargetPackage;
            Object optionSeparator = options.get(OPTION_SEPARATOR);
            if (optionSeparator instanceof String) {
                this.separator = (String)optionSeparator;
            }
            if ((optionTargetPackage = options.get(OPTION_TARGET_PACKAGE)) instanceof Package) {
                this.rootModel = (Package)optionTargetPackage;
            }
        }
    }

    private void initializeSeries(String line) {
        String[] tokens = line.split(this.separator);
        if (tokens != null) {
            int i = 0;
            while (i < tokens.length) {
                String token = tokens[i];
                ValueSeries serie = this.getValueSeries(this.guessType(token), (Property)this.dataType.getOwnedAttributes().get(i));
                this.addInSeries(serie, token);
                ++i;
            }
        }
    }

    private void initializeProperties(String line) {
        String[] tokens = line.split(this.separator);
        if (tokens != null) {
            int i = 0;
            while (i < tokens.length) {
                this.dataType.createOwnedAttribute(tokens[i], null);
                ++i;
            }
        }
    }

    private int computeAlternateType(String token, int unSuccessfulID) {
        switch (unSuccessfulID) {
            case 5: {
                return 50;
            }
            case 4: {
                if (this.isDouble(token)) {
                    return 31;
                }
                return 50;
            }
            case 3: {
                return 50;
            }
        }
        return 50;
    }

    private int guessType(String token) {
        if (this.isBoolean(token)) {
            return 22;
        }
        if (this.isInteger(token)) {
            return 39;
        }
        if (this.isDouble(token)) {
            return 31;
        }
        return 50;
    }

    private boolean isDouble(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isInteger(String token) {
        try {
            Integer.decode(token);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isBoolean(String token) {
        return "TRUE".equalsIgnoreCase(token) || "FALSE".equalsIgnoreCase(token);
    }

    private boolean parseBoolean(String token) throws NumberFormatException {
        if ("TRUE".equalsIgnoreCase(token)) {
            return true;
        }
        if ("FALSE".equalsIgnoreCase(token)) {
            return false;
        }
        throw new NumberFormatException();
    }

    private ValueSeries getValueSeries(int dataTypeID, Property property) {
        ValueSeries ret = null;
        switch (dataTypeID) {
            case 31: {
                ret = (ValueSeries)property.applyStereotype(VisualizationUtil.getStereotype(VisualizationPackage.eINSTANCE.getDoubleSeries(), (EObject)property));
                property.setType((Type)VisualizationUtil.getUMLPrimitiveType((EObject)property, "Real"));
                break;
            }
            case 22: {
                ret = (ValueSeries)property.applyStereotype(VisualizationUtil.getStereotype(VisualizationPackage.eINSTANCE.getBooleanSeries(), (EObject)property));
                property.setType((Type)VisualizationUtil.getUMLPrimitiveType((EObject)property, "Boolean"));
                break;
            }
            case 39: {
                ret = (ValueSeries)property.applyStereotype(VisualizationUtil.getStereotype(VisualizationPackage.eINSTANCE.getIntegerSeries(), (EObject)property));
                property.setType((Type)VisualizationUtil.getUMLPrimitiveType((EObject)property, "Integer"));
                break;
            }
            default: {
                ret = (ValueSeries)property.applyStereotype(VisualizationUtil.getStereotype(VisualizationPackage.eINSTANCE.getStringSeries(), (EObject)property));
                property.setType((Type)VisualizationUtil.getUMLPrimitiveType((EObject)property, "String"));
            }
        }
        ret.eSetDeliver(false);
        this.seriesList.add(ret);
        return ret;
    }

    private void addInSeries(ValueSeries serie, String token) {
        try {
            int id = serie.eClass().getClassifierID();
            if (3 == id) {
                ((DoubleSeries)serie).getValues().add((Object)Double.parseDouble(token));
            } else if (2 == id) {
                ((StringSeries)serie).getValues().add((Object)token);
            } else if (4 == id) {
                ((IntegerSeries)serie).getValues().add((Object)Integer.decode(token));
            } else {
                ((BooleanSeries)serie).getValues().add((Object)this.parseBoolean(token));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.reinitializeSeries(serie, token);
        }
    }

    private void reinitializeSeries(ValueSeries serie, String token) {
        ValueSeries newSerie = this.getValueSeries(this.computeAlternateType(token, serie.eClass().getClassifierID()), serie.getBase_Property());
        int index = this.seriesList.indexOf(serie);
        this.seriesList.remove(index);
        this.seriesList.add(index, newSerie);
        List values = (List)serie.eGet(serie.eClass().getEStructuralFeature(VALUES_FEATURE_NAME));
        for (Object value : values) {
            this.addInSeries(newSerie, value.toString());
        }
        this.addInSeries(newSerie, token);
        serie.getBase_Property().unapplyStereotype(UMLUtil.getStereotype((EObject)serie));
    }

    private void populateValues(String line) throws IOException {
        String[] tokens = line.split(this.separator);
        int i = 0;
        while (i < tokens.length) {
            if (tokens.length == this.dataType.getOwnedAttributes().size()) {
                this.addInSeries(this.seriesList.get(i), tokens[i]);
            }
            ++i;
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        this.initializeOptions(options);
        this.updateDataType();
        if (this.dataType != null) {
            BufferedWriter writter = new BufferedWriter(new PrintWriter(outputStream));
            if (this.dataSource != null) {
                EList<ValueSeries> series = this.dataSource.getSeries();
                int seriesNumber = series.size();
                int i = 0;
                while (i < seriesNumber) {
                    writter.append(((ValueSeries)series.get(i)).getBase_Property().getName());
                    if (i < seriesNumber - 1) {
                        writter.append(this.separator);
                    }
                    ++i;
                }
                writter.newLine();
                int lineNumber = ((ValueSeries)this.dataSource.getSeries().get(0)).getSize();
                int lineIndex = 0;
                while (lineIndex < lineNumber) {
                    int serieIndex = 0;
                    while (serieIndex < seriesNumber) {
                        writter.append(((ValueSeries)this.dataSource.getSeries().get(serieIndex)).getStringValue(lineIndex));
                        if (serieIndex < seriesNumber - 1) {
                            writter.append(this.separator);
                        }
                        ++serieIndex;
                    }
                    if (lineIndex < lineNumber - 1) {
                        writter.newLine();
                    }
                    ++lineIndex;
                }
            }
            writter.close();
        }
    }

    private void updateDataType() {
        for (EObject content : this.getContents()) {
            if (!(content instanceof DataSource) || ((DataSource)content).getBase_DataType() == null) continue;
            this.dataSource = (DataSource)content;
            this.dataType = ((DataSource)content).getBase_DataType();
            return;
        }
    }
}

