/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.common.ui;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.AbstractPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.EditorDescriptor;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.IPluggableEditorFactory;
import org.eclipse.papyrus.infra.ui.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.moka.xygraph.common.Activator;
import org.eclipse.papyrus.moka.xygraph.common.ui.XYGraphEditorPart;
import org.eclipse.papyrus.moka.xygraph.common.ui.XYGraphLabelProvider;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphCoordinator;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

public abstract class AbstractXYGraphPageFactory
implements IPluggableEditorFactory {
    protected ServicesRegistry servicesRegistry;
    protected EditorDescriptor editorDescriptor;
    private Image iconImage;

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        return pageIdentifier instanceof XYGraphDescriptor;
    }

    public void init(ServicesRegistry serviceRegistry, EditorDescriptor editorDescriptor) {
        this.editorDescriptor = editorDescriptor;
        this.servicesRegistry = serviceRegistry;
    }

    protected Image getTabIcon() {
        if (this.iconImage == null) {
            try {
                Image image;
                InputStream imgStream = Activator.getDefault().getBundle().getEntry("/icons/full/obj16/xygraph16.gif").openStream();
                this.iconImage = image = new Image((Device)Display.getCurrent(), imgStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.iconImage;
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        XYGraphLabelProvider lblProv = new XYGraphLabelProvider(this.getTabIcon());
        XYGraphCoordinator coordinator = this.getXYGraphCoordinator((XYGraphDescriptor)pageIdentifier);
        return new XYGraphEditorModel(lblProv, coordinator);
    }

    public abstract XYGraphCoordinator getXYGraphCoordinator(XYGraphDescriptor var1);

    class XYGraphEditorModel
    extends AbstractPageModel
    implements IEditorModel {
        private XYGraphCoordinator coordinator;
        private XYGraphLabelProvider lblProvider;

        public XYGraphEditorModel(XYGraphLabelProvider lblProvider, XYGraphCoordinator coordinator) {
            super((ILabelProvider)lblProvider);
            this.coordinator = coordinator;
            this.lblProvider = lblProvider;
        }

        public Object getRawModel() {
            return this.coordinator.getXYGraphDescriptor();
        }

        public void dispose() {
            this.coordinator.dispose();
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            return new XYGraphEditorPart(this.coordinator, this.lblProvider);
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = AbstractXYGraphPageFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)AbstractXYGraphPageFactory.this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }
    }
}

