/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.service;

import java.util.Set;
import org.eclipse.papyrus.moka.datavisualization.service.DataPort;
import org.eclipse.papyrus.moka.datavisualization.service.VariableEntryTable;
import org.eclipse.papyrus.moka.xygraph.mapping.common.Variable;
import org.eclipse.papyrus.moka.xygraph.mapping.util.DataBatch;

interface LocalDataPort
extends DataPort {
    public VariableEntryTable getVariablesTable();

    @Override
    default public Set<Variable.VariableID> getSupportedVariableIDs() {
        return this.getVariablesTable().getRegisteredVariableIDs();
    }

    @Override
    default public boolean isVariableSupported(Variable.VariableID variableID) {
        return this.getVariablesTable().hasVariable(variableID);
    }

    @Override
    default public long getLastUpdate(Variable.VariableID variableID) {
        if (!this.isVariableSupported(variableID)) {
            return -1L;
        }
        return this.getVariablesTable().getEntry(variableID).getLastUpdate();
    }

    public void doAddNewVariable(Variable.VariableID var1);

    @Override
    default public boolean removeVariable(Variable.VariableID variableID) {
        if (!this.isVariableSupported(variableID)) {
            return false;
        }
        this.getVariablesTable().remove(variableID);
        this.doRemoveVariable(variableID);
        return true;
    }

    public void doRemoveVariable(Variable.VariableID var1);

    @Override
    default public boolean addNewSample(Variable.VariableID variableID, Double x, Double y) {
        if (!this.isVariableSupported(variableID)) {
            return false;
        }
        this.getVariablesTable().getEntry(variableID).markUpdate();
        this.doAddNewSample(variableID, x, y);
        return true;
    }

    public void doAddNewSample(Variable.VariableID var1, Double var2, Double var3);

    @Override
    default public boolean resetValues(Variable.VariableID variableID, DataBatch x, DataBatch y) {
        if (!this.isVariableSupported(variableID)) {
            return false;
        }
        this.getVariablesTable().getEntry(variableID).markUpdate();
        this.doResetValues(variableID, x, y);
        return true;
    }

    public void doResetValues(Variable.VariableID var1, DataBatch var2, DataBatch var3);
}

