/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.moka.datavisualization.Activator;
import org.eclipse.papyrus.moka.datavisualization.csv.CSVResource;
import org.eclipse.papyrus.moka.datavisualization.profile.BooleanSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.DataSource;
import org.eclipse.papyrus.moka.datavisualization.profile.DoubleSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.IntegerSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.StringSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.ValueSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.VisualizationPackage;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class VisualizationUtil {
    public static final String VISUALIZATION_PROFILE_URI = "pathmap://PAPYRUS_MOKA_DATA_VISUALIZATION/datavisualization.profile.uml";
    public static final String DATA_SOURCE_STEREO_NAME = "DataSource";
    public static final String VISUALIZATION_PROFILE_NAME = "DataVisualizationProfile";
    public static final String DATA_SOURCE_STEREO_QUALIFIED_NAME = "DataVisualizationProfile::DataSource";
    public static final String PRIMITIVE_TYPE_URI = "pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml";
    public static final String REAL_NAME = "Real";
    public static final String BOOLEAN_NAME = "Boolean";
    public static final String INTEGER_NAME = "Integer";
    public static final String STRING_NAME = "String";
    public static final byte BINARY_STRING_SEPARATOR = 59;
    public static final String BINARY_STRING_ZIP_ENTRY_NAME = "entry";

    public static Type getUMLTypeForValueSeries(ValueSeries serie) {
        switch (serie.eClass().getClassifierID()) {
            case 5: {
                return VisualizationUtil.getUMLPrimitiveType(serie, BOOLEAN_NAME);
            }
            case 4: {
                return VisualizationUtil.getUMLPrimitiveType(serie, INTEGER_NAME);
            }
            case 3: {
                return VisualizationUtil.getUMLPrimitiveType(serie, REAL_NAME);
            }
        }
        return VisualizationUtil.getUMLPrimitiveType(serie, STRING_NAME);
    }

    public static Stereotype getStereotype(EClass stereoEClass, EObject context) {
        Profile profile = UMLUtil.getProfile((EPackage)stereoEClass.getEPackage(), (EObject)context);
        if (profile != null) {
            return profile.getOwnedStereotype(stereoEClass.getName());
        }
        return null;
    }

    public static void applyVisualizationProfileIfNeeded(Package owningPackage) {
        Profile visualizationProfile = VisualizationUtil.getVisualizationProfile((EObject)owningPackage);
        Iterator profileIter = owningPackage.getAllAppliedProfiles().iterator();
        Profile appliedProfile = null;
        while (profileIter.hasNext() && appliedProfile != visualizationProfile) {
            appliedProfile = (Profile)profileIter.next();
        }
        if (appliedProfile != visualizationProfile) {
            Model rootPackage = owningPackage.getModel();
            if (rootPackage != null && rootPackage.eResource() == owningPackage.eResource()) {
                rootPackage.applyProfile(visualizationProfile);
            } else {
                owningPackage.applyProfile(visualizationProfile);
            }
        }
    }

    public ResourceSet getResourceSet(EObject context) {
        if (context != null && context.eResource() != null && context.eResource().getResourceSet() != null) {
            return context.eResource().getResourceSet();
        }
        return new ResourceSetImpl();
    }

    public static Profile getVisualizationProfile(EObject context) {
        return UMLUtil.getProfile((EPackage)VisualizationPackage.eINSTANCE, (EObject)context);
    }

    public static PrimitiveType getUMLPrimitiveType(EObject context, String typeName) {
        ResourceSet resSet = UMLUtil.getResourceSet((EObject)context);
        if (resSet == null) {
            resSet = new ResourceSetImpl();
        }
        return (PrimitiveType)resSet.getEObject(URI.createURI((String)PRIMITIVE_TYPE_URI).appendFragment(typeName), true);
    }

    public static Stereotype getDataSourceStereotype(EObject context) {
        Profile visualizationProfile = VisualizationUtil.getVisualizationProfile(context);
        if (visualizationProfile != null) {
            return visualizationProfile.getOwnedStereotype(DATA_SOURCE_STEREO_NAME);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getBinaryString(ValueSeries series) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                ByteArrayOutputStream outputStringStream = new ByteArrayOutputStream();
                try {
                    String string;
                    block22: {
                        ZipOutputStream zipStream = new ZipOutputStream(outputStringStream);
                        try {
                            zipStream.putNextEntry(new ZipEntry(BINARY_STRING_ZIP_ENTRY_NAME));
                            switch (series.eClass().getClassifierID()) {
                                case 5: {
                                    VisualizationUtil.encodeBooleanSeries((BooleanSeries)series, zipStream);
                                    break;
                                }
                                case 3: {
                                    VisualizationUtil.encodeDoubleSeries((DoubleSeries)series, zipStream);
                                    break;
                                }
                                case 4: {
                                    VisualizationUtil.encodeIntegerSeries((IntegerSeries)series, zipStream);
                                    break;
                                }
                                case 2: {
                                    VisualizationUtil.encodeStringSeries((StringSeries)series, zipStream);
                                    break;
                                }
                            }
                            zipStream.closeEntry();
                            zipStream.close();
                            string = Base64.getEncoder().encodeToString(outputStringStream.toByteArray());
                            return string;
                        }
                        finally {
                            if (zipStream == null) break block22;
                            zipStream.close();
                        }
                    }
                    if (outputStringStream != null) {
                        outputStringStream.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (outputStringStream == null) throw throwable;
                    outputStringStream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void encodeBooleanSeries(BooleanSeries series, ZipOutputStream zipStream) throws IOException {
        for (Boolean value : series.getValues()) {
            if (value.booleanValue()) {
                zipStream.write(1);
                continue;
            }
            zipStream.write(0);
        }
    }

    public static void initValuesFromBinaryString(ValueSeries series, String newBinaryString) {
        if (newBinaryString != null) {
            byte[] array = Base64.getDecoder().decode(newBinaryString);
            boolean previousDeliver = series.eDeliver();
            series.eSetDeliver(false);
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (ZipInputStream zipInput = new ZipInputStream(new ByteArrayInputStream(array));){
                    zipInput.getNextEntry();
                    switch (series.eClass().getClassifierID()) {
                        case 5: {
                            VisualizationUtil.decodeBooleanSeries((BooleanSeries)series, zipInput);
                            break;
                        }
                        case 3: {
                            VisualizationUtil.decodeDoubleSeries((DoubleSeries)series, zipInput);
                            break;
                        }
                        case 4: {
                            VisualizationUtil.decodeIntegerSeries((IntegerSeries)series, zipInput);
                            break;
                        }
                        case 2: {
                            VisualizationUtil.decodeStringSeries((StringSeries)series, zipInput);
                        }
                    }
                    zipInput.closeEntry();
                    zipInput.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            series.eSetDeliver(previousDeliver);
        }
    }

    private static void encodeStringSeries(StringSeries series, ZipOutputStream zipStream) throws IOException {
        for (String value : series.getValues()) {
            zipStream.write(value.getBytes());
            zipStream.write(59);
        }
    }

    private static void decodeStringSeries(StringSeries series, ZipInputStream zipInput) throws IOException {
        int readByte;
        ByteArrayOutputStream outputStringStream = new ByteArrayOutputStream();
        while ((readByte = zipInput.read()) != -1) {
            if (readByte == 59) {
                series.getValues().add((Object)outputStringStream.toString());
                outputStringStream.reset();
                continue;
            }
            outputStringStream.write(readByte);
        }
    }

    private static void encodeIntegerSeries(IntegerSeries series, ZipOutputStream zipStream) throws IOException {
        for (Integer value : series.getValues()) {
            zipStream.write(value.toString().getBytes());
            zipStream.write(59);
        }
    }

    private static void decodeIntegerSeries(IntegerSeries series, ZipInputStream zipInput) throws NumberFormatException, IOException {
        int readByte;
        ByteArrayOutputStream outputStringStream = new ByteArrayOutputStream();
        while ((readByte = zipInput.read()) != -1) {
            if (readByte == 59) {
                series.getValues().add((Object)Integer.parseInt(outputStringStream.toString()));
                outputStringStream.reset();
                continue;
            }
            outputStringStream.write(readByte);
        }
    }

    private static void encodeDoubleSeries(DoubleSeries series, ZipOutputStream zipStream) throws IOException {
        for (Double value : series.getValues()) {
            zipStream.write(value.toString().getBytes());
            zipStream.write(59);
        }
    }

    private static void decodeDoubleSeries(DoubleSeries series, ZipInputStream zipInput) throws IOException {
        int readByte;
        ByteArrayOutputStream outputStringStream = new ByteArrayOutputStream();
        while ((readByte = zipInput.read()) != -1) {
            if (readByte == 59) {
                series.getValues().add((Object)Double.parseDouble(outputStringStream.toString()));
                outputStringStream.reset();
                continue;
            }
            outputStringStream.write(readByte);
        }
    }

    private static void decodeBooleanSeries(BooleanSeries series, ZipInputStream zipInput) throws IOException {
        int readByte;
        while ((readByte = zipInput.read()) != -1) {
            if (1 == readByte) {
                series.getValues().add((Object)true);
                continue;
            }
            series.getValues().add((Object)false);
        }
    }

    public static void importCSV(Package targetPackage, String csvFile, String separator) {
        URI targetURI = URI.createFileURI((String)csvFile);
        CSVResource csvRes = new CSVResource();
        csvRes.setURI(targetURI);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("separator", separator);
        options.put("TARGET_PACKAGE", (String)targetPackage);
        try {
            csvRes.load(options);
        }
        catch (IOException e) {
            Activator.log(4, "Failed to load csv file", e);
        }
    }

    public static void exportCSV(DataSource dataSource, String targetFile, String separator) {
        URI targetURI = URI.createFileURI((String)targetFile);
        CSVResource csvRes = new CSVResource();
        csvRes.setURI(targetURI);
        csvRes.getContents().add((Object)EcoreUtil.copy((EObject)dataSource));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("separator", separator);
        try {
            csvRes.save(options);
        }
        catch (IOException e) {
            Activator.log(4, "Failed to save csv file", e);
        }
    }
}

