/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping.variables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapterFactory;
import org.eclipse.papyrus.moka.debug.model.data.mapping.variables.MokaVariableAdapter;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.ILink;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IReference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IStructuredValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.VisibilityKind;

public class FeatureValueVariableAdapter
extends MokaVariableAdapter {
    protected IFeatureValue featureValue;
    protected IStructuredValue featureValueOwner;

    public FeatureValueVariableAdapter(MokaDebugTarget debugTarget, IStructuredValue owner, IFeatureValue featureValue) {
        super(debugTarget);
        this.featureValue = featureValue;
        this.featureValueOwner = owner;
        this.value = null;
    }

    public IValue getValue() throws DebugException {
        int upperBound;
        if (this.value == null && (upperBound = this.featureValue.getFeature().getUpper()) == 1) {
            StructuralFeature feature;
            Association association = null;
            if (this.featureValueOwner instanceof IExtensionalValue && (feature = this.featureValue.getFeature()) instanceof Property) {
                association = ((Property)feature).getAssociation();
            }
            org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue fumlValue = null;
            if (association != null) {
                List<ILink> links = this.getMatchingLinks(association, this.featureValue.getFeature(), (org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue)this.featureValueOwner, ((IExtensionalValue)this.featureValueOwner).getLocus());
                ArrayList<org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue> resultValues = new ArrayList<org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue>();
                int i = 0;
                while (i < links.size()) {
                    ILink link = links.get(i);
                    resultValues.add((org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue)link.getFeatureValue(this.featureValue.getFeature()).getValues().iterator().next());
                    ++i;
                }
                Iterator valuesIterator = resultValues.iterator();
                if (valuesIterator.hasNext()) {
                    fumlValue = (org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue)valuesIterator.next();
                }
            } else {
                Iterator valuesIterator = this.featureValue.getValues().iterator();
                if (valuesIterator.hasNext()) {
                    fumlValue = (org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue)valuesIterator.next();
                }
            }
            this.value = MokaValueAdapterFactory.getInstance().instantiate(fumlValue, this.debugTarget);
        }
        return this.value;
    }

    public String getName() throws DebugException {
        StructuralFeature feature = this.featureValue.getFeature();
        if (feature != null) {
            return feature.getName();
        }
        return "";
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public boolean isFeaturePublic() {
        if (this.featureValue != null) {
            return this.featureValue.getFeature().getVisibility() == VisibilityKind.PUBLIC_LITERAL;
        }
        return false;
    }

    public boolean isFeatureProtected() {
        if (this.featureValue != null) {
            return this.featureValue.getFeature().getVisibility() == VisibilityKind.PROTECTED_LITERAL;
        }
        return false;
    }

    public boolean isFeaturePrivate() {
        if (this.featureValue != null) {
            return this.featureValue.getFeature().getVisibility() == VisibilityKind.PRIVATE_LITERAL;
        }
        return false;
    }

    protected List<ILink> getMatchingLinks(Association association, StructuralFeature end, org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue oppositeValue, ILocus locus) {
        return this.getMatchingLinksForEndValue(association, end, oppositeValue, null, locus);
    }

    private List<ILink> getMatchingLinksForEndValue(Association association, StructuralFeature end, org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue oppositeValue, org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue endValue, ILocus locus) {
        Property oppositeEnd = this.getOppositeEnd(association, end);
        List extent = locus.getExtent((Classifier)association);
        ArrayList<ILink> links = new ArrayList<ILink>();
        int i = 0;
        while (i < extent.size()) {
            IExtensionalValue link = (IExtensionalValue)extent.get(i);
            org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue value = (org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue)link.getFeatureValue((StructuralFeature)oppositeEnd).getValues().get(0);
            if (value instanceof IReference) {
                value = ((IReference)value).getReferent();
            }
            if (value.equals(oppositeValue).booleanValue()) {
                boolean matches = true;
                if (endValue != null) {
                    matches = ((org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue)link.getFeatureValue(end).getValues().get(0)).equals(endValue);
                }
                if (matches) {
                    if (!end.isOrdered() | links.size() == 0) {
                        links.add((ILink)link);
                    } else {
                        int n = link.getFeatureValue(end).getPosition();
                        boolean continueSearching = true;
                        int j = 0;
                        while (continueSearching & j < links.size()) {
                            continueSearching = ((ILink)links.get(++j - 1)).getFeatureValue(end).getPosition() < n;
                        }
                        if (continueSearching) {
                            links.add((ILink)link);
                        } else {
                            links.add(j - 1, (ILink)link);
                        }
                    }
                }
            }
            ++i;
        }
        return links;
    }

    private Property getOppositeEnd(Association association, StructuralFeature end) {
        Property oppositeEnd = (Property)association.getMemberEnds().get(0);
        if (oppositeEnd == end) {
            oppositeEnd = (Property)association.getMemberEnds().get(1);
        }
        return oppositeEnd;
    }
}

