/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.ui.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;
import org.eclipse.papyrus.moka.fmi.fmi2uml.FMI2UML;
import org.eclipse.papyrus.moka.fmi.fmu.FMUResource;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.FMUBundle;
import org.eclipse.papyrus.moka.fmi.modeldescription.CoSimulationType;
import org.eclipse.papyrus.moka.fmi.modeldescription.FmiModelDescriptionType;
import org.eclipse.papyrus.moka.fmi.ui.Activator;
import org.eclipse.papyrus.moka.fmi.ui.dialogs.ImportFMUDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;

public class ImportFMULibHandler
extends AbstractCommandHandler {
    private static final String DEFAULT_LIBRARY_NAME = "FMULibrary";

    public String getLibraryName() {
        String defaultModelLibName = DEFAULT_LIBRARY_NAME;
        ImportFMUDialog dialog = new ImportFMUDialog(Display.getCurrent().getActiveShell(), defaultModelLibName);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        dialog.setPreferenceStore(store);
        dialog.open();
        if (dialog.getReturnCode() != 1) {
            return dialog.getImportedModelName();
        }
        return null;
    }

    public List<String> getFMUFiles() {
        ArrayList<String> fmuFiles = new ArrayList<String>();
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        FileDialog fd = new FileDialog(shell, 2);
        fd.setText("Select FMU to be imported");
        String[] filterExt = new String[]{"*.fmu"};
        fd.setFilterExtensions(filterExt);
        if (fd.open() != null) {
            String folder = fd.getFilterPath();
            String[] stringArray = fd.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                fmuFiles.add(String.valueOf(folder) + File.separator + name);
                ++n2;
            }
        }
        return fmuFiles;
    }

    protected void unloadOpenedFMUs(List<FMUBundle> fmuBundles) {
        for (FMUBundle fmuBundle : fmuBundles) {
            fmuBundle.eResource().unload();
        }
    }

    private void cleanFolder(IFolder libFolder) {
        try {
            libFolder.delete(false, null);
        }
        catch (CoreException coreException) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.moka.fmi.ui", "failed to delete folder " + libFolder.getFullPath().toPortableString()));
        }
    }

    private void errorDialog(Exception e, String message) {
        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"SpiderML Error", (String)message, (IStatus)new Status(4, "org.eclipse.papyrus.moka.fmi.ui", message, (Throwable)e));
    }

    private void errorPopup(String message) {
        MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 1);
        messageBox.setMessage(message);
        messageBox.open();
    }

    private boolean libExists(Package targetPackage, String libName) {
        for (Package pack : targetPackage.getNestedPackages()) {
            if (!libName.equals(pack.getName())) continue;
            return true;
        }
        return false;
    }

    protected Command getCommand(IEvaluationContext context) {
        EObject selection = this.getSelectedElement();
        if (selection instanceof Package) {
            final Package target = (Package)selection;
            return new RecordingCommand(this.getEditingDomain(context)){

                protected void doExecute() {
                    boolean canContinue = false;
                    String libName = null;
                    while (!canContinue) {
                        libName = ImportFMULibHandler.this.getLibraryName();
                        if (libName == null) {
                            return;
                        }
                        boolean bl = canContinue = !ImportFMULibHandler.this.libExists(target, libName);
                        if (canContinue) continue;
                        ImportFMULibHandler.this.errorPopup("A library named " + libName + " already exists! Please choose another name");
                    }
                    URI modelURI = target.eResource().getURI();
                    IFile modelIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(modelURI.toPlatformString(true)));
                    IProject project = modelIFile.getProject();
                    IFolder libFolder = project.getFolder(libName);
                    if (libFolder.exists()) {
                        ImportFMULibHandler.this.errorPopup("A folder with name " + libName + " already exists in the project " + libFolder.getName() + " Aborting.");
                        return;
                    }
                    try {
                        libFolder.create(false, true, null);
                    }
                    catch (CoreException e) {
                        ImportFMULibHandler.this.errorDialog((Exception)((Object)e), "Could not create library folder" + libFolder.getName());
                        return;
                    }
                    List<String> fmuAndSlxPaths = ImportFMULibHandler.this.getFMUFiles();
                    ArrayList<FMUBundle> fmuBundles = new ArrayList<FMUBundle>();
                    ResourceSet papyResourceSet = target.eResource().getResourceSet();
                    for (String filePath : fmuAndSlxPaths) {
                        File sourceFile = new File(filePath);
                        IFile targetIFile = libFolder.getFile(sourceFile.getName());
                        try {
                            targetIFile.create((InputStream)new FileInputStream(sourceFile), true, null);
                        }
                        catch (CoreException e) {
                            ImportFMULibHandler.this.errorDialog((Exception)((Object)e), "Could not FMU File " + targetIFile.getName() + " in");
                            ImportFMULibHandler.this.cleanFolder(libFolder);
                            return;
                        }
                        catch (FileNotFoundException e) {
                            ImportFMULibHandler.this.errorDialog(e, "Could not create FMU file " + libFolder.getFullPath().toOSString() + " in workspace");
                        }
                        URI fmuURI = URI.createPlatformResourceURI((String)targetIFile.getFullPath().toPortableString(), (boolean)true);
                        FMUResource resource = null;
                        try {
                            resource = (FMUResource)papyResourceSet.getResource(fmuURI, true);
                        }
                        catch (Exception e) {
                            ImportFMULibHandler.this.errorDialog(e, "Error importing fmu " + filePath);
                            ImportFMULibHandler.this.unloadOpenedFMUs(fmuBundles);
                            ImportFMULibHandler.this.cleanFolder(libFolder);
                            return;
                        }
                        if (resource == null || resource.getFmuParser() == null) continue;
                        if (resource.getFmuParser().getModelDescription() != null) {
                            fmuBundles.add((FMUBundle)resource.getContents().get(0));
                            continue;
                        }
                        ImportFMULibHandler.this.errorPopup("Ignoring FMU " + filePath + " since it doesn't contain a modelDescription.xml file.");
                    }
                    Package libPackage = target.createNestedPackage(libName);
                    for (FMUBundle fmuBundle : fmuBundles) {
                        FmiModelDescriptionType modelDescription = fmuBundle.getModelDescription();
                        if (modelDescription != null && !modelDescription.getCoSimulation().isEmpty()) {
                            String name = ((CoSimulationType)modelDescription.getCoSimulation().get(0)).getModelIdentifier();
                            Package targetPackage = libPackage.createNestedPackage(name);
                            FMI2UML.getFMUClass((FMUBundle)fmuBundle, (Package)targetPackage);
                            continue;
                        }
                        ImportFMULibHandler.this.errorPopup("Ignoring FMU " + modelDescription.eResource().getURI().toPlatformString(true) + " since it doesn't contain a  Cosimulation section.");
                    }
                }
            };
        }
        return null;
    }
}

