/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.InvocationActions.ICS_EventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.ICallEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.EventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Loci.LociL1.ChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.CompletionEventOccurrence;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.DoActivityExecutionEventAccepter;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.StateActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.StateMachineExecution;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IStateConfiguration;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IStateMachineEventAccepter;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.ITransitionActivation;

public class StateMachineEventAccepter
extends EventAccepter
implements IStateMachineEventAccepter {
    public StateMachineExecution registrationContext;

    public StateMachineEventAccepter(StateMachineExecution execution) {
        this.registrationContext = execution;
    }

    public void accept(IEventOccurrence eventOccurrence) {
        if (this.isDeferred(eventOccurrence)) {
            this.defer(eventOccurrence);
        } else {
            List<ITransitionActivation> fireableTransitionActivations = this.select(eventOccurrence);
            if (!fireableTransitionActivations.isEmpty()) {
                Iterator<ITransitionActivation> fireableTransitionsIterator = fireableTransitionActivations.iterator();
                while (fireableTransitionsIterator.hasNext()) {
                    fireableTransitionsIterator.next().fire(eventOccurrence);
                }
                ICallEventOccurrence callEventOccurrence = null;
                if (eventOccurrence instanceof ICS_EventOccurrence) {
                    IEventOccurrence wrappedEventOccurrence = ((ICS_EventOccurrence)eventOccurrence).getWrappedEventOccurrence();
                    if (wrappedEventOccurrence instanceof ICallEventOccurrence) {
                        callEventOccurrence = (ICallEventOccurrence)wrappedEventOccurrence;
                    }
                } else if (eventOccurrence instanceof ICallEventOccurrence) {
                    callEventOccurrence = (ICallEventOccurrence)eventOccurrence;
                }
                if (callEventOccurrence != null) {
                    callEventOccurrence.returnFromCall();
                }
            }
        }
        IObject_ context = this.registrationContext.context;
        if (context != null && context.getObjectActivation() != null) {
            context.register((IEventAccepter)new StateMachineEventAccepter(this.registrationContext));
        }
    }

    public Boolean match(IEventOccurrence eventOccurrence) {
        return this.isDeferred(eventOccurrence) | this.isTriggering(eventOccurrence);
    }

    public boolean isDeferred(IEventOccurrence eventOccurrence) {
        IObject_ context;
        boolean deferred = false;
        if (!(eventOccurrence instanceof CompletionEventOccurrence)) {
            deferred = this._isDeferred(eventOccurrence, this.registrationContext.getConfiguration().getRoot());
        }
        if (deferred && (context = this.registrationContext.context) != null && context.getObjectActivation() != null) {
            int i = 1;
            while (deferred && i <= context.getObjectActivation().getWaitingEventAccepters().size()) {
                IEventAccepter currentEventAccepter = (IEventAccepter)context.getObjectActivation().getWaitingEventAccepters().get(i - 1);
                if (currentEventAccepter != this && currentEventAccepter instanceof DoActivityExecutionEventAccepter && currentEventAccepter.match(eventOccurrence).booleanValue()) {
                    deferred = false;
                }
                ++i;
            }
        }
        return deferred;
    }

    protected boolean _isDeferred(IEventOccurrence eventOccurrence, IStateConfiguration stateConfiguration) {
        int i = 0;
        boolean deferred = false;
        while (!deferred && i < stateConfiguration.getChildren().size()) {
            deferred = this._isDeferred(eventOccurrence, (IStateConfiguration)stateConfiguration.getChildren().get(i));
            ++i;
        }
        if (!deferred && stateConfiguration.getVertexActivation() != null && ((StateActivation)stateConfiguration.getVertexActivation()).canDefer(eventOccurrence) && this._select(eventOccurrence, stateConfiguration).isEmpty()) {
            deferred = true;
        }
        return deferred;
    }

    protected void defer(IEventOccurrence eventOccurrence) {
        this._defer(eventOccurrence, this.registrationContext.getConfiguration().getRoot());
    }

    protected boolean _defer(IEventOccurrence eventOccurrence, IStateConfiguration stateConfiguration) {
        int i = 0;
        boolean deferred = false;
        while (!deferred && i < stateConfiguration.getChildren().size()) {
            deferred = this._defer(eventOccurrence, (IStateConfiguration)stateConfiguration.getChildren().get(i));
            ++i;
        }
        if (!deferred && stateConfiguration.getVertexActivation() != null && ((StateActivation)stateConfiguration.getVertexActivation()).canDefer(eventOccurrence)) {
            ((StateActivation)stateConfiguration.getVertexActivation()).defer(eventOccurrence);
            deferred = true;
        }
        return deferred;
    }

    public boolean isTriggering(IEventOccurrence eventOccurrence) {
        return !this.select(eventOccurrence).isEmpty();
    }

    protected List<ITransitionActivation> select(IEventOccurrence eventOccurrence) {
        return this._select(eventOccurrence, this.registrationContext.getConfiguration().getRoot());
    }

    protected List<ITransitionActivation> _select(IEventOccurrence eventOccurrence, IStateConfiguration stateConfiguration) {
        ArrayList<ITransitionActivation> selectedTransitions = new ArrayList<ITransitionActivation>();
        int i = 0;
        while (i < stateConfiguration.getChildren().size()) {
            selectedTransitions.addAll(this._select(eventOccurrence, (IStateConfiguration)stateConfiguration.getChildren().get(i)));
            ++i;
        }
        if (selectedTransitions.isEmpty() && stateConfiguration.getVertexActivation() != null) {
            i = 0;
            while (i < stateConfiguration.getVertexActivation().getOutgoingTransitions().size()) {
                ITransitionActivation transitionActivation = (ITransitionActivation)stateConfiguration.getVertexActivation().getOutgoingTransitions().get(i);
                if (transitionActivation.canFireOn(eventOccurrence)) {
                    selectedTransitions.add(transitionActivation);
                }
                ++i;
            }
            if (selectedTransitions.size() > 1) {
                ChoiceStrategy choiceStrategy = (ChoiceStrategy)this.registrationContext.locus.getFactory().getStrategy("choice");
                ITransitionActivation electedTransition = (ITransitionActivation)selectedTransitions.get(choiceStrategy.choose(Integer.valueOf(selectedTransitions.size())) - 1);
                selectedTransitions.clear();
                selectedTransitions.add(electedTransition);
            }
        }
        return selectedTransitions;
    }
}

