/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.profiling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.service.IMokaExecutionListener;
import org.eclipse.papyrus.moka.service.IMokaService;
import org.eclipse.papyrus.moka.service.MokaServiceRegistry;

public abstract class MokaObservable {
    protected List<IMokaExecutionListener> listeners = new ArrayList<IMokaExecutionListener>();

    public MokaObservable() {
        this.initialize();
    }

    public void initialize() {
        for (IMokaService service : MokaServiceRegistry.getInstance().getAllServices()) {
            if (!(service instanceof IMokaExecutionListener)) continue;
            this.addListener((IMokaExecutionListener)service);
        }
    }

    public void addListener(IMokaExecutionListener service) {
        this.listeners.add(service);
    }

    public void removeListener(IMokaExecutionListener service) {
        this.listeners.remove(service);
    }

    public void finalize() {
        this.listeners.clear();
    }
}

