/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.util;

import java.util.ArrayList;
import java.util.List;

public class DataBatch {
    private List<Double> values;

    private DataBatch(int size) {
        this.values = new ArrayList<Double>(size);
    }

    public static DataBatch fromDouble(List<Double> values) {
        DataBatch batch = new DataBatch(values.size());
        batch.values.addAll(values);
        return batch;
    }

    public static DataBatch fromBoolean(List<Boolean> values) {
        DataBatch batch = new DataBatch(values.size());
        int i = 0;
        while (i < values.size()) {
            batch.values.add(values.get(i) != false ? 1.0 : 0.0);
            ++i;
        }
        return batch;
    }

    public static DataBatch fromInteger(List<Integer> values) {
        DataBatch batch = new DataBatch(values.size());
        int i = 0;
        while (i < values.size()) {
            batch.values.add((double)values.get(i));
            ++i;
        }
        return batch;
    }

    public static DataBatch dummy() {
        DataBatch batch = new DataBatch(1);
        return batch;
    }

    public List<Double> getValues() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    public void addValue(double value) {
        this.values.add(value);
    }

    public void clean() {
        this.values.clear();
    }
}

