/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.writing;

import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphMappingHelper;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphWidgetBinder;
import org.eclipse.papyrus.moka.xygraph.model.reflection.TraceStructuralFeature;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.TraceDescriptor;

public interface TraceUpdateStrategy {
    public void commitUpdate();

    public void updateTraceDescriptor(Trace var1, XYGraphWidgetBinder var2);

    public <T> void updateTraceFeature(TraceDescriptor var1, TraceStructuralFeature var2, T var3);

    default public void updateAllFeatures(Trace trace, XYGraphWidgetBinder map) {
        TraceDescriptor tDesc = map.getDescriptorFor(trace);
        this.updateTraceFeature(tDesc, TraceStructuralFeature.AreaAlpha, trace.getAreaAlpha());
        this.updateTraceFeature(tDesc, TraceStructuralFeature.BaseLine, XYGraphMappingHelper.descTraceBaseLine(trace.getBaseLine()));
        this.updateTraceFeature(tDesc, TraceStructuralFeature.ErrorBarCapWidth, tDesc.getErrorBarCapWidth());
        this.updateTraceFeature(tDesc, TraceStructuralFeature.ErrorBarColor, XYGraphMappingHelper.mapColor(trace.getErrorBarColor()));
        this.updateTraceFeature(tDesc, TraceStructuralFeature.LineWidth, trace.getLineWidth());
        this.updateTraceFeature(tDesc, TraceStructuralFeature.PointSize, trace.getPointSize());
        this.updateTraceFeature(tDesc, TraceStructuralFeature.PointStyle, XYGraphMappingHelper.descPointStyle(trace.getPointStyle()));
        this.updateTraceFeature(tDesc, TraceStructuralFeature.TraceColor, XYGraphMappingHelper.mapColor(trace.getTraceColor()));
        this.updateTraceFeature(tDesc, TraceStructuralFeature.TraceType, XYGraphMappingHelper.descTraceType(trace.getTraceType()));
        this.updateTraceFeature(tDesc, TraceStructuralFeature.XErrorBarType, XYGraphMappingHelper.descErrorBarType(trace.getXErrorBarType()));
        this.updateTraceFeature(tDesc, TraceStructuralFeature.YErrorBarType, XYGraphMappingHelper.descErrorBarType(trace.getYErrorBarType()));
        this.updateTraceFeature(tDesc, TraceStructuralFeature.AntiAliasing, trace.isAntiAliasing());
        this.updateTraceFeature(tDesc, TraceStructuralFeature.DrawYErrorInArea, trace.isDrawYErrorInArea());
        this.updateTraceFeature(tDesc, TraceStructuralFeature.ErrorBarEnabled, trace.isErrorBarEnabled());
        this.updateTraceFeature(tDesc, TraceStructuralFeature.Name, trace.getName());
        this.updateTraceFeature(tDesc, TraceStructuralFeature.XAxis, map.getDescriptorFor(trace.getXAxis()));
        this.updateTraceFeature(tDesc, TraceStructuralFeature.YAxis, map.getDescriptorFor(trace.getYAxis()));
    }
}

