/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.ui.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.papyrus.moka.datavisualization.ui.Activator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportImportCSVDialog
extends Dialog {
    private static final String SEPARATOR_SETTING = "CSV_EXPORT_SEPARATOR";
    private static final String TARGET_DIR_SETTING = "CSV_EXPORT_TARGET_DIR";
    private static final String PREVIOUS_CSV_FILE = "CSV_IMPORT_CSV_FILE";
    protected String previousDir;
    private String selectedPath;
    protected String separator = ";";
    private String csvFileName;
    private String previousImportedFile;
    protected Button selectTargetDirButton;
    protected Text selectedPathText;
    protected Text separatorText;
    boolean save = false;

    public ExportImportCSVDialog(Shell parentShell, String defaultName, boolean save) {
        super(parentShell);
        this.csvFileName = defaultName;
        this.save = save;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings != null) {
            String previousDir;
            String previousSep = settings.get(SEPARATOR_SETTING);
            if (previousSep != null) {
                this.separator = previousSep;
            }
            if ((previousDir = settings.get(TARGET_DIR_SETTING)) != null) {
                this.previousDir = previousDir;
            }
            this.previousImportedFile = settings.get(PREVIOUS_CSV_FILE);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createSetSeparator(container);
        this.createSelectDir(container);
        return container;
    }

    private void createSetSeparator(Composite container) {
        Label label = new Label(container, 0);
        label.setText("CSV separator : ");
        this.separatorText = new Text(container, 2052);
        GridData dataDirText = new GridData();
        this.separatorText.setText(this.separator);
        this.separatorText.setLayoutData((Object)dataDirText);
        this.separatorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportImportCSVDialog.this.separator = ExportImportCSVDialog.this.separatorText.getText();
                ExportImportCSVDialog.this.checkInformation();
            }
        });
    }

    private void createSelectDir(final Composite container) {
        this.selectTargetDirButton = new Button(container, 8);
        if (this.save) {
            this.selectTargetDirButton.setText("Select target file");
        } else {
            this.selectTargetDirButton.setText("Select file to import");
        }
        GridData dataDirText = new GridData();
        dataDirText.grabExcessHorizontalSpace = true;
        dataDirText.horizontalAlignment = 4;
        this.selectedPathText = new Text(container, 2056);
        this.selectedPathText.setText("");
        this.selectedPathText.setLayoutData((Object)dataDirText);
        this.selectTargetDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog;
                Shell shell = container.getShell();
                if (ExportImportCSVDialog.this.save) {
                    fileDialog = new FileDialog(shell, 8192);
                    fileDialog.setOverwrite(true);
                    fileDialog.setText("Select target folder");
                    fileDialog.setFileName(String.valueOf(ExportImportCSVDialog.this.csvFileName) + ".csv");
                    fileDialog.setFilterPath(ExportImportCSVDialog.this.previousDir);
                } else {
                    fileDialog = new FileDialog(shell);
                    fileDialog.setText("Select target CSV file");
                    if (ExportImportCSVDialog.this.previousImportedFile != null) {
                        File previousFile = new File(ExportImportCSVDialog.this.previousImportedFile);
                        fileDialog.setFileName(previousFile.getName());
                        fileDialog.setFilterPath(previousFile.getParent());
                    }
                }
                fileDialog.setFilterExtensions(new String[]{"*.csv"});
                ExportImportCSVDialog.this.selectedPath = fileDialog.open();
                if (ExportImportCSVDialog.this.selectedPath != null) {
                    ExportImportCSVDialog.this.selectedPathText.setText(ExportImportCSVDialog.this.selectedPath);
                    IDialogSettings settings = Activator.getDefault().getDialogSettings();
                    if (settings != null) {
                        settings.put(ExportImportCSVDialog.TARGET_DIR_SETTING, ExportImportCSVDialog.this.selectedPath);
                    }
                } else {
                    ExportImportCSVDialog.this.selectedPath = "";
                }
                ExportImportCSVDialog.this.checkInformation();
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Export CSV");
    }

    protected Point getInitialSize() {
        return new Point(600, 230);
    }

    protected void checkInformation() {
        boolean validSeparator;
        boolean validSelectedDir = !"".equals(this.selectedPath);
        boolean bl = validSeparator = this.separator != null && !this.separator.isEmpty();
        if (validSelectedDir && validSeparator) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public String getSeparator() {
        return this.separator;
    }

    protected void okPressed() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings != null) {
            settings.put(SEPARATOR_SETTING, this.separator);
            File selectedPathFile = new File(this.selectedPath);
            settings.put(TARGET_DIR_SETTING, selectedPathFile.getParent());
        }
        super.okPressed();
    }

    public void setDefaultPath(String defaultPath) {
        this.previousDir = defaultPath;
    }
}

