/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.modeldescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InitialType implements Enumerator
{
    EXACT(0, "exact", "exact"),
    APPROX(1, "approx", "approx"),
    CALCULATED(2, "calculated", "calculated");

    public static final int EXACT_VALUE = 0;
    public static final int APPROX_VALUE = 1;
    public static final int CALCULATED_VALUE = 2;
    private static final InitialType[] VALUES_ARRAY;
    public static final List<InitialType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InitialType[]{EXACT, APPROX, CALCULATED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InitialType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InitialType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InitialType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InitialType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InitialType get(int value) {
        switch (value) {
            case 0: {
                return EXACT;
            }
            case 1: {
                return APPROX;
            }
            case 2: {
                return CALCULATED;
            }
        }
        return null;
    }

    private InitialType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

