/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.cosimulation.semantics;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Object;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Reference;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2ScalarVariable;
import org.eclipse.papyrus.moka.fmi.master.fmuproxy.Fmu2ProxyService;
import org.eclipse.papyrus.moka.fmi.profile.util.FMIProfileUtil;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IBooleanValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IIntegerValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IRealValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IStringValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.BooleanValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.DataValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.EnumerationValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.InstanceValueEvaluation;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.IntegerValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.RealValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.Reference;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;

public class CosimulationInstanceValueEvaluation
extends InstanceValueEvaluation {
    public IValue evaluate() {
        EnumerationValue value;
        InstanceSpecification instance = ((InstanceValue)this.specification).getInstance();
        EList types = instance.getClassifiers();
        Classifier myType = (Classifier)types.get(0);
        Object object = null;
        Debug.println((String)("[evaluate] type = " + myType.getName()));
        if (instance instanceof EnumerationLiteral) {
            EnumerationValue enumerationValue = new EnumerationValue();
            enumerationValue.setType((Enumeration)myType);
            enumerationValue.setLiteral((EnumerationLiteral)instance);
            value = enumerationValue;
        } else {
            int i;
            DataValue structuredValue = null;
            if (myType instanceof DataType) {
                DataValue dataValue = new DataValue();
                dataValue.setType((DataType)myType);
                structuredValue = dataValue;
            } else {
                CS_Reference reference;
                if (myType instanceof Behavior) {
                    object = this.locus.getFactory().createExecution((Behavior)myType, null);
                } else {
                    Class fmuClassifier = this.getFMUClassifier(instance);
                    object = fmuClassifier != null ? new Fmu2ProxyService(fmuClassifier) : new CS_Object();
                    i = 0;
                    while (i < types.size()) {
                        Classifier type = (Classifier)types.get(i);
                        object.addType((Class)type);
                        ++i;
                    }
                }
                this.locus.add((IExtensionalValue)object);
                if (object instanceof CS_Object) {
                    reference = new CS_Reference();
                    reference.compositeReferent = (CS_Object)object;
                } else {
                    reference = new Reference();
                }
                reference.setReferent((IObject_)object);
                structuredValue = reference;
            }
            structuredValue.createFeatureValues();
            EList instanceSlots = instance.getSlots();
            i = 0;
            while (i < instanceSlots.size()) {
                Slot slot = (Slot)instanceSlots.get(i);
                ArrayList<IValue> values = new ArrayList<IValue>();
                EList slotValues = slot.getValues();
                int j = 0;
                while (j < slotValues.size()) {
                    ValueSpecification slotValue = (ValueSpecification)slotValues.get(j);
                    IValue runtimeValue = this.locus.getExecutor().evaluate(slotValue);
                    values.add(runtimeValue);
                    if (object instanceof Fmu2ProxyService) {
                        Fmi2ScalarVariable variable = ((Fmu2ProxyService)object).getVariable((Property)slot.getDefiningFeature());
                        Object actualRuntimeValue = null;
                        actualRuntimeValue = runtimeValue instanceof IntegerValue ? ((IIntegerValue)runtimeValue).getValue() : (runtimeValue instanceof BooleanValue ? ((IBooleanValue)runtimeValue).getValue() : (runtimeValue instanceof RealValue ? ((IRealValue)runtimeValue).getValue() : ((IStringValue)runtimeValue).getValue()));
                        if (variable != null) {
                            variable.setRuntimeValue(actualRuntimeValue);
                        }
                    }
                    ++j;
                }
                structuredValue.setFeatureValue(slot.getDefiningFeature(), values, Integer.valueOf(0));
                ++i;
            }
            value = structuredValue;
        }
        return value;
    }

    private Class getFMUClassifier(InstanceSpecification instance) {
        EList types = instance.getClassifiers();
        int i = 0;
        while (i < types.size()) {
            Classifier type = (Classifier)types.get(i);
            if (type instanceof Class && FMIProfileUtil.isCS_FMU((Class)((Class)type)) != null) {
                return (Class)type;
            }
            ++i;
        }
        return null;
    }
}

