/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.table.instancespecification;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.utils.Activator;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.utils.commands.ValueSpecificationSetCommand;
import org.eclipse.papyrus.uml.xtext.integration.XtextFakeResourceContext;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;

public class CustomSpecificationSetCommand
extends ValueSpecificationSetCommand {
    private static ValueSpecificationSetCommand instance = new CustomSpecificationSetCommand();

    public static ValueSpecificationSetCommand getInstance() {
        return instance;
    }

    public CompositeCommand createSetCommand(Injector injector, EObject objectToEdit, EStructuralFeature structuralFeature, String xtextStringValue, Collection<String> defaultLanguages) {
        Object initialValueSpecification = null;
        if (structuralFeature != null) {
            Collection valueList;
            initialValueSpecification = structuralFeature.isMany() ? ((valueList = (Collection)objectToEdit.eGet(structuralFeature)) != null && !valueList.isEmpty() ? (ValueSpecification)valueList.iterator().next() : null) : (ValueSpecification)objectToEdit.eGet(structuralFeature);
        }
        CompositeCommand result = new CompositeCommand("validation");
        ContextElementAdapter.IContextElementProvider provider = this.getContextProvider(objectToEdit);
        XtextFakeResourceContext context = new XtextFakeResourceContext(injector);
        context.getFakeResource().eAdapters().add((Object)new ContextElementAdapter(provider));
        try {
            context.getFakeResource().load((InputStream)new StringInputStream(xtextStringValue), Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        if (provider instanceof ContextElementAdapter.IContextElementProviderWithInit) {
            ((ContextElementAdapter.IContextElementProviderWithInit)provider).initResource(context.getFakeResource());
        }
        EcoreUtil2.resolveLazyCrossReferences((Resource)context.getFakeResource(), (CancelIndicator)CancelIndicator.NullImpl);
        if (!context.getFakeResource().getParseResult().hasSyntaxErrors() && context.getFakeResource().getErrors().size() == 0) {
            EObject xtextObject = context.getFakeResource().getParseResult().getRootASTElement();
            ICommand cmd = this.getParseCommand(objectToEdit, (ValueSpecification)initialValueSpecification, structuralFeature, xtextObject, xtextStringValue, defaultLanguages);
            if (cmd != null) {
                result.add((IUndoableOperation)cmd);
            }
        } else {
            result.add((IUndoableOperation)this.manageOpaqueExpression(objectToEdit, structuralFeature, (ValueSpecification)initialValueSpecification, xtextStringValue, defaultLanguages));
        }
        return result;
    }

    protected ICommand createCommand(EObject objectToEdit, EStructuralFeature structuralFeature, ValueSpecification valueSpecification) {
        CompositeCommand setValueCommand = new CompositeCommand("Set Value Specification Command");
        Object value = structuralFeature.isMany() ? Arrays.asList(valueSpecification) : valueSpecification;
        SetRequest request = new SetRequest(objectToEdit, structuralFeature, value);
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)objectToEdit);
        ICommand setDefaultValueCommand = commandProvider.getEditCommand((IEditCommandRequest)request);
        if (setDefaultValueCommand != null && setDefaultValueCommand.canExecute()) {
            setValueCommand.add((IUndoableOperation)setDefaultValueCommand);
        } else {
            setValueCommand.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
        }
        return setValueCommand.isEmpty() ? null : setValueCommand;
    }
}

