/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.engine;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.moka.kernel.engine.IExecutionEngine;

public class EngineRegistry {
    public static String MOKA_ENGINE_EXTENSION_POINT_ID = "org.eclipse.papyrus.moka.kernel.engine";
    protected static final String ENGINE_ID_ATTRIBUTE = "id";
    protected static final String ENGINE_CLASS_ATTRIBUTE = "class";
    protected HashMap<String, IExecutionEngine> registry = new HashMap();
    private boolean loaded = false;
    private static EngineRegistry INSTANCE;

    private EngineRegistry() {
    }

    public static EngineRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EngineRegistry();
        }
        return INSTANCE;
    }

    public void loadEngines() {
        if (!this.loaded) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurations = extensionRegistry.getConfigurationElementsFor(MOKA_ENGINE_EXTENSION_POINT_ID);
            int i = 0;
            while (i < configurations.length) {
                String identifier = configurations[i].getAttribute(ENGINE_ID_ATTRIBUTE);
                if (!this.registry.containsKey(identifier)) {
                    Object instance = null;
                    try {
                        instance = configurations[i].createExecutableExtension(ENGINE_CLASS_ATTRIBUTE);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (instance != null && instance instanceof IExecutionEngine) {
                        ((IExecutionEngine)instance).setID(identifier);
                        this.registry.put(identifier, (IExecutionEngine)instance);
                    }
                }
                ++i;
            }
            this.loaded = true;
        }
    }

    public IExecutionEngine getEngine(String engineID) {
        this.loadEngines();
        return this.registry.get(engineID);
    }

    public Collection<IExecutionEngine> getAllEngines() {
        this.loadEngines();
        return this.registry.values();
    }

    public void clear() {
        this.registry.clear();
    }
}

