/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.tests;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.testutils.FileComparison;
import org.eclipse.papyrus.designer.languages.common.testutils.RecursiveCopy;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.junit.utils.rules.AbstractHouseKeeperRule;
import org.eclipse.uml2.uml.Package;
import org.hamcrest.MatcherAssert;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class LwTransformationTestSupport {
    protected AbstractHouseKeeperRule houseKeeper;
    protected IProject modelProject;
    Class<?> testClass;

    static {
        System.setProperty("papyrus.run-headless", Boolean.TRUE.toString());
    }

    public LwTransformationTestSupport(Class<?> testClass, AbstractHouseKeeperRule houseKeeper, IProject modelProject) {
        this.testClass = testClass;
        this.houseKeeper = houseKeeper;
        this.modelProject = modelProject;
    }

    public void runTransformation(Package nePkg) {
        boolean genOptions = false;
        new ExecuteTransformationChain(nePkg, this.modelProject).executeTransformation((IProgressMonitor)new NullProgressMonitor(), 0);
    }

    public void validateResults(IProject genProject, String folderInTestBundle, String srcGen) {
        RecursiveCopy copier = new RecursiveCopy(this.houseKeeper);
        Bundle srcBundle = FrameworkUtil.getBundle(this.testClass);
        copier.copy(srcBundle, folderInTestBundle, this.modelProject, "expectedResult");
        IFolder expectedSrcGen = this.modelProject.getFolder("expectedResult");
        MatcherAssert.assertThat((String)"expected source folder must exist", (boolean)expectedSrcGen.exists());
        IProject generatedSrcGen = srcGen.equals(".") ? genProject : genProject.getFolder(srcGen);
        MatcherAssert.assertThat((String)"generated source folder must exist", (boolean)generatedSrcGen.exists());
        FileComparison.assertGeneratedMatchesExpected((IContainer)generatedSrcGen, (IContainer)expectedSrcGen);
    }
}

