/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml.lib;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.robotics.bt.profile.bt.BlackBoardEntry;
import org.eclipse.papyrus.robotics.bt.profile.bt.DataFlowEdge;
import org.eclipse.papyrus.robotics.bt.profile.bt.OutFlowPort;
import org.eclipse.papyrus.robotics.bt.profile.bt.Parameter;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.ValueSpecificationAction;
import org.eclipse.uml2.uml.util.UMLUtil;

public class Utils {
    protected EClass cls;

    @Operation(contextual=true)
    public FeatureMap.Entry createFeatureMapEntry(InputPin ip) throws ExecutionException {
        this.setTmpModel(ip.getName());
        return FeatureMapUtil.createEntry((EStructuralFeature)this.getFlowPort(), (Object)this.generateFlowDirective(ip));
    }

    @Operation(contextual=true)
    public FeatureMap.Entry createFeatureMapEntry(OutputPin op) throws ExecutionException {
        this.setTmpModel(op.getName());
        return FeatureMapUtil.createEntry((EStructuralFeature)this.getFlowPort(), (Object)this.generateFlowDirective(op));
    }

    @Operation(contextual=true)
    public FeatureMap.Entry createFeatureMapEntry(Activity act, String entryName) throws ExecutionException {
        this.setTmpModel(entryName);
        return FeatureMapUtil.createEntry((EStructuralFeature)this.getFlowPort(), (Object)this.generateBlackBoardDirective(entryName, act.getQualifiedName()));
    }

    @Operation(contextual=true)
    public List<Diagram> getDiagrams(Activity act) throws ServiceException {
        ModelSet modelSet = ServiceUtilsForResource.getInstance().getModelSet((Object)act.eResource());
        URI act_notationuri = act.getModel().eResource().getURI().trimFileExtension().appendFileExtension("notation");
        Resource notationResource = this.getNotationResource(modelSet, act_notationuri);
        return NotationUtils.getDiagrams((Resource)notationResource, (EObject)act);
    }

    protected void setTmpModel(String name) {
        EAttribute flowport = EcoreFactory.eINSTANCE.createEAttribute();
        flowport.setName(name);
        flowport.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        this.cls = EcoreFactory.eINSTANCE.createEClass();
        this.cls.getEStructuralFeatures().add((Object)flowport);
    }

    protected EStructuralFeature getFlowPort() {
        return this.cls.getEStructuralFeature(0);
    }

    protected String generateFlowDirective(InputPin ip) throws ExecutionException {
        DataFlowEdge dfe = (DataFlowEdge)UMLUtil.getStereotypeApplication((Element)((Element)ip.getIncomings().get(0)), DataFlowEdge.class);
        if (dfe != null) {
            Parameter param;
            OutFlowPort srcFlowport = dfe.getOutPort();
            if (srcFlowport != null && (param = (Parameter)UMLUtil.getStereotypeApplication((Element)srcFlowport.getBase_OutputPin().getOwner(), Parameter.class)) != null) {
                ValueSpecification vs;
                ValueSpecificationAction vsa = param.getBase_ValueSpecificationAction();
                if (vsa != null && (vs = vsa.getValue()) != null && vs instanceof LiteralString) {
                    return vs.stringValue();
                }
                throw new ExecutionException("Parameter '" + param.getBase_ValueSpecificationAction().getQualifiedName() + "' has no string value");
            }
            return this.generateBlackBoardDirective(dfe);
        }
        return null;
    }

    protected String generateFlowDirective(OutputPin op) throws ExecutionException {
        DataFlowEdge dfe = (DataFlowEdge)UMLUtil.getStereotypeApplication((Element)((Element)op.getOutgoings().get(0)), DataFlowEdge.class);
        if (dfe != null) {
            return this.generateBlackBoardDirective(dfe);
        }
        return null;
    }

    protected String generateBlackBoardDirective(DataFlowEdge dfe) throws ExecutionException {
        BlackBoardEntry bbe = dfe.getBbEntry();
        String bbkey = null;
        String associated_elem_uid = null;
        if (bbe == null) {
            associated_elem_uid = dfe.getInstance_uid();
            bbkey = dfe.getBase_ObjectFlow().getName();
        } else {
            associated_elem_uid = bbe.getInstance_uid();
            if (bbe.getBase_ActivityParameterNode() != null) {
                bbkey = bbe.getBase_ActivityParameterNode().getName();
            } else if (bbe.getBase_CentralBufferNode() != null) {
                bbkey = bbe.getBase_CentralBufferNode().getName();
            }
        }
        return this.generateBlackBoardDirective(bbkey, associated_elem_uid);
    }

    protected String generateBlackBoardDirective(String bbkey, String associated_elem_uid) throws ExecutionException {
        if (bbkey == null) {
            throw new ExecutionException("Inconsistent model! Cannot find the element associated to BlackBoardEntry '" + associated_elem_uid + "'");
        }
        return "{" + bbkey + "}";
    }

    protected Resource getNotationResource(ModelSet ms, URI notationuri) {
        Resource notationResource = null;
        for (Resource r : ms.getResources()) {
            if (!r.getURI().equals(notationuri)) continue;
            notationResource = r;
            break;
        }
        return notationResource;
    }
}

