/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.cdteditor.sync;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.designer.infra.ui.UIProjectManagement;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.ros2.cdteditor.TextEditorConstants;
import org.eclipse.papyrus.robotics.ros2.codegen.cpp.jobs.CppGenJob;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class SyncRoboticsModelToCDT {
    public static boolean syncFromEditor;

    public static IFile syncModelToCDT(Classifier classifier, String generatorID) {
        if (!(classifier instanceof Class) || classifier.eResource() == null) {
            return null;
        }
        Package pkg = PackageUtil.getRootPackage((Element)((Class)classifier));
        CppGenJob job = new CppGenJob(pkg, UIProjectManagement.getCurrentProject());
        job.setUser(true);
        job.schedule();
        ILangCodegen codegen = LanguageCodegen.getGenerator((Pattern)TextEditorConstants.CPP, (String)generatorID);
        String projectName = PackageTools.getProjectName((Package)pkg);
        IProject targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        Object srcPkg = null;
        IFile cppFile = null;
        try {
            String suffix = codegen.getSuffix(ILangCodegen.FILE_KIND.BODY);
            cppFile = targetProject.getFile((IPath)new Path(String.valueOf(codegen.getFileName(targetProject, (NamedElement)classifier)) + "." + suffix));
        }
        finally {
            try {
                if (srcPkg != null) {
                    srcPkg.refreshLocal(2, null);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return cppFile;
    }
}

